
local SysUtils = {}

local lDirectorySeparator = nil

function SysUtils.WindowsOS()
-- https://stackoverflow.com/questions/295052/how-can-i-determine-the-os-of-the-system-from-within-a-lua-script
-- You can try package.config:sub(1,1). It returns the path separator, which is '\\' on Windows and '/' on Unixes...
  return package.config:sub(1, 1) == '\\'
end

function SysUtils.SetDirectorySeparator(aDirectorySeparator)
  if aDirectorySeparator == nil then
    lDirectorySeparator = package.config:sub(1, 1)
  else
    lDirectorySeparator = aDirectorySeparator
  end
end

function SysUtils.ExtractFileDir(aFileName)
  local result = ''
  if string.find(aFileName, lDirectorySeparator) then
    result = aFileName
    while string.sub(result, #result) ~= lDirectorySeparator do
      result = string.sub(result, 1, -2)
    end
    result = string.sub(result, 1, -2)
  end
  return result
end

function SysUtils.ExtractFileExt(aFileName)
  local result = ''
  local vStart, vEnd = string.find(aFileName, '%.')
  
  if vStart then
    result = aFileName
    repeat
      result = string.sub(result, vStart + 1)
      vStart, vEnd = string.find(result, '%.')
    until vStart == nil
    result = '.' .. result
  end
  
  return result
end

function SysUtils.ExtractFileName(aFileName, aWithoutExt)
  local result = aFileName
  local vStart, vEnd = string.find(result, lDirectorySeparator)
  while vStart do
    result = string.sub(result, vStart + 1)
    vStart, vEnd = string.find(result, lDirectorySeparator)
  end
  if aWithoutExt then
    while string.find(result, '%.') do
      result = string.sub(result, 1, -2)
    end
  end
  return result
end

function SysUtils.ExtractFilePath(aFileName)
  local result = ''
  if string.find(aFileName, lDirectorySeparator) then
    result = aFileName
    while string.sub(result, #result) ~= lDirectorySeparator do
      result = string.sub(result, 1, -2)
    end
  end
  return result
end

function SysUtils.FileExists(aFileName)
  local file = io.open(aFileName, 'r')
  local result = file ~= nil
  if result then
    io.close(file)
  end
  return result
end

function SysUtils.System(aCommand)
  local i, result = 0, {}
  for line in io.popen(aCommand):lines() do
    i = i + 1
    result[i] = line
  end
  return result
end

SysUtils.SetDirectorySeparator()

return SysUtils
