{
   p2dencrypt.pas

   Copyright 2013 Markus Mangold <markus@markus-Kubuntu>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
   MA 02110-1301, USA.


}

program P2DEncrypt;

uses
  SysUtils,
  UEncrypt;

const
  my_key = 30189;
  
var
  linesum, i: integer;
  tempstr, basicfile: string;
  prg: array of string;
  UserFile: text;

begin

  if ParamCount < 1 then
  begin
    writeln('PulsarEncrypter v 0.1 alpha');
    writeln('Usage: p2dencrypt sourcefile.lua');
    halt(0);
  end;

  basicfile := paramstr(1);

  linesum := 1;

  if fileexists(basicfile) then
  begin
    Assign(UserFile, basicfile);
    Reset(UserFile); {'Reset(x)' - means open the file x}
    repeat
      tempstr := '';
      setlength(prg, linesum + 1);
      Readln(UserFile, prg[linesum]);
      inc(linesum);
    until Eof(UserFile);
    Close(UserFile);
  end
  else
  begin
    writeln('?File not found error');
    halt(0);
  end;

  i := 1;
  Assign(Userfile, 'encrypted' + basicfile);
  Rewrite(Userfile);
  repeat

    writeln(Userfile, Encrypt(prg[i], my_key));

    inc(i);
  until i >= linesum;

  Close(Userfile);

end.
