{
   p2dhelper.pas

   Copyright 2013 Markus Mangold <info@retrogamecoding.org>


  This software is provided 'as-is', without any express or implied
  warranty. In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

   1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.

   2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

   3. This notice may not be removed or altered from any source
   distribution.

}

unit P2DHelper;

interface

uses
  SysUtils,
  P2DInput;

function ostype: string;
function rnd: real;
function chrstr(code: integer): char;
function asc(ch: ansistring): integer;
function val(strnumb: ansistring): real;
function left(chars: ansistring; len: integer): ansistring;
function right(chars: ansistring; len: integer): ansistring;
function mid(chars: ansistring; start: integer; len: integer): ansistring;
function insertstr(chars1, chars2: ansistring; pos: integer): ansistring;
function len(chars: ansistring): integer;
function upper(chars: ansistring): ansistring;
function lower(chars: ansistring): ansistring;

implementation

//returns the OS

function ostype: string;
begin
{$IFDEF Windows}
  Result := 'Windows';
{$ENDIF}
{$IFDEF LINUX}
{$IFDEF CPU64}
  result := 'Linux64';
{$ENDIF}
{$ENDIF}
{$IFDEF LINUX}
{$IFDEF CPU32}
  result := 'Linux32';
{$ENDIF}
{$ENDIF}
{$IFDEF Darwin}
  Result := 'MacOS';
{$ENDIF}
{$IFDEF Haiku}
  Result := 'Haiku';
{$ENDIF}

end;

//C64 like rnd function

function rnd: real;
var
  number: real;
begin
  number := random();
  result := number;
end;

function chrstr(code: integer): char;
var
  ch: char;
begin
  try
    ch := chr(code);
  except
    ch := #0;
  end;
  result := ch;
end;

function asc(ch: ansistring): integer;
var
  code: integer;
begin
  try
    code := ord(ch[1]);
  except
    code := 0;
  end;
  result := code;
end;

function val(strnumb: ansistring): real;
var
  number: real;
begin
  try
    number := StrToFloat(strnumb);
  except
    number := 0;
  end;
  result := number;
end;

function left(chars: ansistring; len: integer): ansistring;
var
  returnstr: ansistring;
begin
  try
    returnstr := leftstr(chars, len);
  except
    returnstr := '';
  end;
  result := returnstr;
end;

function right(chars: ansistring; len: integer): ansistring;
var
  returnstr: ansistring;
begin
  try
    returnstr := rightstr(chars, len);
  except
    returnstr := '';
  end;
  result := returnstr;
end;

function mid(chars: ansistring; start: integer; len: integer): ansistring;
var
  returnstr: ansistring;
begin
  try
    returnstr := copy(chars, start, len);
  except
    returnstr := '';
  end;
  result := returnstr;
end;

function insertstr(chars1, chars2: ansistring; pos: integer): ansistring;
var
  returnstr: ansistring;
begin
  try
    insert(chars2, chars1, pos);
    returnstr := chars1;
  except
    returnstr := '';
  end;
  result := returnstr;
end;

function len(chars: ansistring): integer;
var
  numbers: integer;
begin
  try
    numbers := length(chars);
  except
    numbers := 0;
  end;
  result := numbers;
end;

function upper(chars: ansistring): ansistring;
var
  returnstr: ansistring;
begin
  try
    returnstr := ansiuppercase(chars);
  except
    returnstr := '';
  end;
  result := returnstr;

end;

function lower(chars: ansistring): ansistring;
var
  returnstr: ansistring;
begin
  try
    returnstr := ansilowercase(chars);
  except
    returnstr := '';
  end;
  result := returnstr;

end;

begin
  randomize;
end.
