{
   p2daudio.pas

   Copyright 2013 Markus Mangold <info@retrogamecoding.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
   MA 02110-1301, USA.


}

unit P2DAudio;

interface

uses
  SysUtils,
  SDL2_mixer,
  P2DVideo,
  SDL2;

type
  p2dsound = pMIX_CHUNK;
type
  p2dmusic = pMIX_MUSIC;

const
  AUDIO_FREQUENCY: INTEGER = 22050;
  AUDIO_FORMAT: WORD = MIX_DEFAULT_FORMAT;
  AUDIO_CHANNELS: INTEGER = 2;
  AUDIO_CHUNKSIZE: INTEGER = 1024;

function loadsound(soundfile: string): pMIX_CHUNK;
procedure playsound(soundname: pMIX_CHUNK; volume, channel, loop: integer);
procedure playmusic(music: pMIX_MUSIC; volume: integer; loop: integer);
function loadmusic(musicfile: string): pMIX_MUSIC;
procedure pausemusic;
procedure resumemusic;
procedure freesound(sound: pMIX_CHUNK);
procedure freemusic(music: pMIX_MUSIC);
procedure fademusic(ms: integer);
procedure haltmusic;

implementation

//loads a sound file

function loadsound(soundfile: string): pMIX_CHUNK;
var
  sound: pMIX_CHUNK = nil;
begin
  if fileexists(soundfile) then
  begin
    sound := MIX_LOADWAV(pCHar(soundfile));
    result := sound;
  end
  else
  begin
    SDL_ShowSimpleMessageBox(SDL_MESSAGEBOX_ERROR, 'File not found', PCHAR('Can''t find sound file: ' + soundfile),
      nil);
    closeapplication;
    halt;
  end;
end;

//plays a sound file

procedure playsound(soundname: pMIX_CHUNK; volume, channel, loop: integer);
begin
  try
    MIX_VOLUMECHUNK(soundname, volume);
    //channel=-1 means next free channel, otherwise there are channels form 0-7
    MIX_PLAYCHANNEL(channel, soundname, loop);
  except
    Messagebox(1, 'Error', 'Error playing sound file.');
    closeapplication;
    halt;
  end;
end;

//loads a music file

function loadmusic(musicfile: string): pMIX_MUSIC;
var
  music: pMIX_MUSIC = nil;
begin
  if fileexists(musicfile) then
  begin
    music := MIX_LOADMUS(PChar(musicfile));
    Result := music;
  end
  else
  begin
    SDL_ShowSimpleMessageBox(SDL_MESSAGEBOX_ERROR, 'File not found', PCHAR('Can''t find music file: ' + musicfile),
      nil);
    closeapplication;
    halt;
  end;
end;

//plays a music file

procedure playmusic(music: pMIX_MUSIC; volume: integer; loop: integer);
begin
  MIX_VOLUMEMUSIC(volume);
  //loop means: -1 = infinite, 0 = once, 1 = twice,...
  MIX_PLAYMUSIC(music, loop);
end;

//try to guess...

procedure pausemusic;
begin
  MIX_PAUSEMUSIC;
end;

//...

procedure resumemusic;
begin
  MIX_RESUMEMUSIC;
end;

procedure fademusic(ms: integer);
begin
  Mix_FadeOutMusic(ms);
end;

procedure haltmusic;
begin
  Mix_HaltMusic();
end;

//free memory

procedure freesound(sound: pMIX_CHUNK);
begin
  MIX_FREECHUNK(sound);
end;

//free memory

procedure freemusic(music: pMIX_MUSIC);
begin
  MIX_FREEMUSIC(music);
end;

//init sound
begin
  if MIX_OPENAUDIO(AUDIO_FREQUENCY, AUDIO_FORMAT, AUDIO_CHANNELS, AUDIO_CHUNKSIZE) <> 0 then
  begin
    Messagebox(1, 'Error', 'Could not initialize sound system: ' + SDL_GetError);
    Halt;
  end;
end.
