/'
'  pulsar2d.bi
'   
'   Copyright 2013-2015 Markus Mangold <info@retrogamecoding.org>
'   
'   
'		This software is provided 'as-is', without any express or implied
'		warranty. In no event will the authors be held liable for any damages
'		arising from the use of this software.
'
'		Permission is granted to anyone to use this software for any purpose,
'		including commercial applications, and to alter it and redistribute it
'		freely, subject to the following restrictions:
'
'			1. The origin of this software must not be misrepresented; you must not
'			claim that you wrote the original software. If you use this software
'			in a product, an acknowledgment in the product documentation would be
'			appreciated but is not required.
'
'			2. Altered source versions must be plainly marked as such, and must not be
'			misrepresented as being the original software.
'
'			3. This notice may not be removed or altered from any source
'			distribution.
'  
'/
#define useaudio

#include once "SDL2/SDL.bi"
#include once "SDL2/SDL_image.bi"
#ifdef useaudio
 #include once "SDL2/SDL_mixer.bi"
#endif

#include once "file.bi"

#ifdef __FB_WIN32__
#undef LoadImage
#undef SetActiveWindow
#undef DRAWTEXT
#undef CLOSEWINDOW
#undef RECTANGLE
#undef messagebox
#endif

#undef circle
#undef color
#undef line
randomize (timer)
namespace p2d

type window as integer
type sprite as SDL_Texture ptr
type image as SDL_Surface ptr
type font as integer
type anim as integer

#ifdef useaudio
type sound as MIX_CHUNK ptr
type music as MIX_MUSIC ptr
#endif

#ifndef bool
enum bool
    false = 0
    true = not false
end enum
#endif

#include once "p2dvideo.bi"
#include once "p2dinput.bi"
#ifdef useaudio
 #include once "p2daudio.bi"
#endif
#include once "p2danimation.bi"
#include once "p2dcollision.bi"
#include once "p2dparticles.bi"

end namespace

p2d.ParticleSize=2
p2d.SizeFlag=p2d.ptRandom
p2d.ParticleType = p2d.ptFillcircle

#ifdef useaudio
const AUDIO_FREQUENCY as INTEGER=22050
const AUDIO_FORMAT as UShort=MIX_DEFAULT_FORMAT
const AUDIO_CHANNELS as INTEGER=2
const AUDIO_CHUNKSIZE as INTEGER=1024
#endif 

p2d.bmpfont.index = 0
p2d.spriteanim.index = 0
p2d.ResetParticles

' init SDL
if (SDL_Init(SDL_INIT_EVERYTHING) <> 0) then 
		print "SDL_Init Error: " & SDL_GetError
        SDL_Quit
		end
	end if
if ( SDL_NumJoysticks > 0 ) then
        p2d.joystick = SDL_JoystickOpen( 0 )
end if

#ifdef useaudio
if MIX_OPENAUDIO(AUDIO_FREQUENCY, AUDIO_FORMAT, AUDIO_CHANNELS, AUDIO_CHUNKSIZE)<>0 THEN 
	p2d.messagebox(1,"Error","Could not initialize sound system: "& SDL_GetError)
	end
end if
#endif
