' p2dparticles.pas
'   
'   Copyright 2012 Markus Mangold <info@retrogamecoding.org>
'   
'   
'		This software is provided 'as-is', without any express or implied
'		warranty. In no event will the authors be held liable for any damages
'		arising from the use of this software.
'
'		Permission is granted to anyone to use this software for any purpose,
'		including commercial applications, and to alter it and redistribute it
'		freely, subject to the following restrictions:
'
'			1. The origin of this software must not be misrepresented; you must not
'			claim that you wrote the original software. If you use this software
'			in a product, an acknowledgment in the product documentation would be
'			appreciated but is not required.
'
'			2. Altered source versions must be plainly marked as such, and must not be
'			misrepresented as being the original software.
'
'			3. This notice may not be removed or altered from any source
'			distribution.
'  
enum pparticles
  ptDot
  ptFillcircle
  ptCircle
  ptFillbox
  ptBox
  ptImage
end enum

enum psize
ptRandom
ptNormal
end enum
 
TYPE TPType as pparticles
Type TSize as psize

Type TParticle 
    PosX as double
    PosY as double
    VelX as double
    VelY as double
    life as integer
    ssize as integer
    colorRed as integer
    colorGreen as integer
    colorBlue as integer
    colorAlpha as integer
End type 

dim shared  ParticleQuantity as integer, NewParticle as integer, ParticleCounter as integer,ParticleSize as integer
dim	shared ParticleType as TPType
dim	 shared ParticleKilledCounter as integer = 0
dim  shared SingleParticle (any) as TParticle
dim	 shared ParticleImage as p2d.sprite
dim	 shared SizeFlag as TSize

declare sub CreateParticles (px as integer,py as integer,nnumber as integer,cycle as integer, rred as integer,ggreen as integer,bblue as integer,alpha as integer)
declare sub UpdateParticles
declare sub SetParticleSize (ssize as integer,ranflag as TSize)
declare sub SetParticleType (ptype as TPType)
declare sub SetParticleImage (pimage as p2d.sprite)
declare sub ResetParticles

' implementation

sub CreateParticles (px as integer,py as integer,nnumber as integer,cycle as integer, rred as integer,ggreen as integer,bblue as integer,alpha as integer)

NewParticle = nnumber
 ParticleQuantity = ParticleQuantity + NewParticle
 redim preserve SingleParticle (ParticleQuantity+1)
 For ParticleCounter = (ParticleQuantity-(NewParticle-1)) to ParticleQuantity 
	with SingleParticle (ParticleCounter)
		.PosX = px
		.PosY = py
		.Life = int (rnd()*cycle)
 		.VelX = ((rnd()*2)-1)/0.90
		.VelY = ((rnd()*2)-1)/0.90
				
		select case SizeFlag
		case ptRandom 
		 .ssize = int (rnd()*ParticleSize)+1
		case ptNormal
		 .ssize = ParticleSize
		end select
		.colorRed = rred
		.colorGreen = ggreen
		.colorBlue = bblue
		.colorAlpha=alpha
   end with
 next
end sub

sub UpdateParticles

ParticleKilledCounter =0 

For ParticleCounter = 1 to ParticleQuantity 
	with SingleParticle (ParticleCounter)
		if .life > 0 then 
			.PosX = .PosX + .VelX
			.PosY = .PosY + .VelY
			.VelX = .VelX * 1.001
			.VelY = .VelY * 1.001
			.life = .life - 1
		else 
		 .PosX = SingleParticle (ParticleQuantity-ParticleKilledCounter).PosX
         .PosY = SingleParticle (ParticleQuantity-ParticleKilledCounter).PosY
         .life = SingleParticle (ParticleQuantity-ParticleKilledCounter).life
         .VelX = SingleParticle (ParticleQuantity-ParticleKilledCounter).VelX
         .VelY = SingleParticle (ParticleQuantity-ParticleKilledCounter).VelY
         ParticleKilledCounter = ParticleKilledCounter +1
		end if
	  color (.colorRed,.colorGreen,.colorBlue,.colorAlpha)
	  select case ParticleType 
	  case ptFillcircle 
	    fillcircle (int (.PosX),int (.PosY),.ssize)
	  case ptCircle 
	   circle (int (.PosX),int (.PosY),.ssize)
	  case ptDot
	   dot (int (.PosX),int (.PosY))
	  case ptBox 
	   rectangle (int (.PosX),int (.PosY),.ssize,.ssize)
	  case ptFillbox
	   fillrectangle (int (.PosX),int (.PosY),.ssize,.ssize)
	  case ptImage
	   drawsprite (ParticleImage,int (.PosX),int (.PosY),0.9+.ssize/10,0.9+.ssize/10,0,false,false)
	  end select
	 end with
next
ParticleQuantity = ParticleQuantity - ParticleKilledCounter
redim preserve SingleParticle (ParticleQuantity+1)
end sub

sub SetParticleSize (ssize as integer,ranflag as TSize)
	ParticleSize=ssize
	SizeFlag=ranflag
end sub

sub SetParticleType (ptype as TPType)
  ParticleType = ptype
end sub

sub SetParticleImage (pimage as p2d.sprite)
 ParticleImage =pimage
end sub

sub ResetParticles
ParticleQuantity = 0
redim preserve SingleParticle (ParticleQuantity+1)
end sub
