'
'   p2daudio.pas
'   
'   Copyright 2015 Markus Mangold <info@retrogamecoding.org>
'   
'   This program is free software; you can redistribute it and/or modify
'   it under the terms of the GNU General Public License as published by
'   the Free Software Foundation; either version 2 of the License, or
'   (at your option) any later version.
'   
'   This program is distributed in the hope that it will be useful,
'   but WITHOUT ANY WARRANTY; without even the implied warranty of
'   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'   GNU General Public License for more details.
'   
'   You should have received a copy of the GNU General Public License
'   along with this program; if not, write to the Free Software
'   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
'   MA 02110-1301, USA.
'   
'   

declare function loadsound (soundfile as String) as MIX_CHUNK ptr
declare sub playsound (soundname as MIX_CHUNK ptr,volume as long,channel as long,loops as long)
declare sub playmusic (music as MIX_MUSIC ptr,volume as integer,loops as integer)
declare function loadmusic (musicfile as String) as MIX_MUSIC ptr
declare sub pausemusic
declare sub resumemusic
declare sub freesound (sound as MIX_CHUNK ptr)
declare sub freemusic (music as MIX_MUSIC ptr)
declare sub fademusic (ms as integer)
declare sub haltmusic

'loads a sound file
function loadsound (soundfile as String) as MIX_CHUNK ptr
dim sound as MIX_CHUNK ptr = null
  if fileexists (soundfile) then
  	sound=MIX_LOADWAV (soundfile)
  	
	return sound
  else 
    SDL_ShowSimpleMessageBox (SDL_MESSAGEBOX_ERROR, "File not found", "Can''t find sound file: "&soundfile,null)
    closeapplication
    end
  end if
end function

'plays a sound file
sub playsound (soundname as MIX_CHUNK ptr,volume as long,channel as long,loops as long)
   MIX_VOLUMECHUNK (soundname,volume) 
       'channel=-1 means next free channel, otherwise there are channels form 0-7
   MIX_PLAYCHANNEL(channel,soundname,loops) 
end sub

'free memory
sub freesound (sound as MIX_CHUNK ptr)
MIX_FREECHUNK(sound)
end sub


'loads a music file
function loadmusic (musicfile as String) as MIX_MUSIC ptr
dim	music as MIX_MUSIC ptr = null
  if fileexists (musicfile) then
      music=MIX_LOADMUS(musicfile)
      return music
    else 
     SDL_ShowSimpleMessageBox (SDL_MESSAGEBOX_ERROR, "File not found", "Can''t find music file: " & musicfile,null)
    closeapplication
    end
   end if
end function

'plays a music file
sub playmusic (music as MIX_MUSIC ptr,volume as integer,loops as integer)
  MIX_VOLUMEMUSIC(volume)
  'loop means: -1 = infinite, 0 = once, 1 = twice,...
  MIX_PLAYMUSIC (music,loops)
end sub

'try to guess...
sub  pausemusic
  MIX_PAUSEMUSIC
end sub

'...
sub resumemusic
  MIX_RESUMEMUSIC
end sub

'fades out in ms
sub fademusic (ms as integer)
Mix_FadeOutMusic (ms)
end sub

' ...
sub haltmusic
Mix_HaltMusic()
end sub

'free memory
sub freemusic (music as MIX_MUSIC ptr)
MIX_FREEMUSIC(music)
end sub
