/'
'   p2danimation.bi
'   
'   Copyright 2013-2015 Markus Mangold <info@retrogamecoding.org>
'   
'   
'		This software is provided 'as-is', without any express or implied
'		warranty. In no event will the authors be held liable for any damages
'		arising from the use of this software.
'
'		Permission is granted to anyone to use this software for any purpose,
'		including commercial applications, and to alter it and redistribute it
'		freely, subject to the following restrictions:
'
'			1. The origin of this software must not be misrepresented; you must not
'			claim that you wrote the original software. If you use this software
'			in a product, an acknowledgment in the product documentation would be
'			appreciated but is not required.
'
'			2. Altered source versions must be plainly marked as such, and must not be
'			misrepresented as being the original software.
'
'			3. This notice may not be removed or altered from any source
'			distribution.
'  
'/

dim shared animnow as integer

TYPE animation
lines (any) as integer
rows (any) as integer
width (any) as integer
height (any) as integer
timer (any) as integer
frame (any) as integer
direction (any) as integer
index as integer
image (any) as p2d.sprite
ticker (any) as integer
nexttime (any) as integer
loop (any) as integer
startframe (any) as integer
endframe (any) as integer
end type

dim shared spriteanim as animation

declare function createanimation (srcimage as p2d.sprite,w as integer,h as integer,startframe as integer,endframe as integer,ttimer as integer,direction as integer,loops as integer) as integer
declare function framenumber (spriteanimation as integer) as integer
declare function animationstopped (spriteanimation as integer) as integer
declare sub setanimationspeed (spriteanimation as integer,speed as integer)
declare sub setanimationloop (spriteanimation as integer,loopa as integer)
declare sub haltanimation (spriteanimation as integer)
declare function animationwidth (spriteanimation as integer) as integer
declare function animationheight (spriteanimation as integer) as integer
declare sub drawanimation (spriteanimation as integer,xscreen as integer,yscreen as integer,xw as double,yw as double,angle as double,vflip as integer,hflip as integer)

' implementation

'create an animation 
function createanimation (srcimage as p2d.sprite,w as integer,h as integer,startframe as integer,endframe as integer,ttimer as integer,direction as integer,loops as integer) as integer

	spriteanim.index=spriteanim.index+1
	redim preserve spriteanim.image(spriteanim.index)
	redim preserve spriteanim.width(spriteanim.index)
	redim preserve spriteanim.height(spriteanim.index)
	redim preserve spriteanim.lines(spriteanim.index)
	redim preserve spriteanim.rows(spriteanim.index)
	redim preserve spriteanim.timer(spriteanim.index)
	redim preserve spriteanim.ticker(spriteanim.index)
	redim preserve spriteanim.frame(spriteanim.index)
	redim preserve spriteanim.direction(spriteanim.index)
	redim preserve spriteanim.nexttime(spriteanim.index)
	redim preserve spriteanim.loop(spriteanim.index)
	redim preserve spriteanim.startframe(spriteanim.index)
	redim preserve spriteanim.endframe(spriteanim.index)
	
	spriteanim.image(spriteanim.index-1) = srcimage
	
	spriteanim.width(spriteanim.index-1) = w
	spriteanim.height(spriteanim.index-1) = h
	spriteanim.lines(spriteanim.index-1) = int (spriteheight (spriteanim.image(spriteanim.index-1))/h)
	spriteanim.rows(spriteanim.index-1) =  int (spritewidth (spriteanim.image(spriteanim.index-1))/w)
	spriteanim.timer(spriteanim.index-1) = ttimer
	spriteanim.direction(spriteanim.index-1) = direction
	spriteanim.startframe(spriteanim.index-1) = startframe
	spriteanim.endframe(spriteanim.index-1) = endframe
	if spriteanim.direction(spriteanim.index-1) > 0 then 
	 spriteanim.frame (spriteanim.index-1) = startframe	
	end if 
    if spriteanim.direction(spriteanim.index-1)  < 0 then 
	spriteanim.frame (spriteanim.index-1) = endframe 
	end if
	spriteanim.ticker(spriteanim.index-1) = timerticks()
	spriteanim.nexttime(spriteanim.index-1) = 0	
	spriteanim.loop(spriteanim.index-1)= loops
	if spriteanim.loop(spriteanim.index-1) >=0 then 
			spriteanim.loop(spriteanim.index-1)=spriteanim.loop(spriteanim.index-1)+1
	end if
	
    return spriteanim.index-1
end function

'returns the actual frame number
function framenumber (spriteanimation as integer) as integer
dim i as integer
if spriteanimation < spriteanim.index then 
	i =spriteanim.frame(spriteanimation)
	return i
else 
 Messagebox (1,"Error","No animation available.")
  closeapplication
  end
 end if
end function

'checks if animation has stopped
function animationstopped (spriteanimation as integer) as integer
if spriteanimation < spriteanim.index then 
	if spriteanim.loop(spriteanimation)=0 then 
		return true
	 else
		return false
	end if
else 
  Messagebox (1,"Error","No animation available.")
  closeapplication
  end
 end if
end function

' sets the animation speed
sub setanimationspeed (spriteanimation as integer,speed as integer)
if spriteanimation < spriteanim.index then 
	spriteanim.timer(spriteanimation)=speed
else 
  Messagebox (1,"Error","No animation available.")
  closeapplication
  end
end if
end sub

'sets the loop direction
sub setanimationloop (spriteanimation as integer,loops as integer)
if spriteanimation < spriteanim.index then 
	spriteanim.loop(spriteanimation)=loops
	if spriteanim.loop(spriteanimation) >=0 then
			spriteanim.loop(spriteanimation)=spriteanim.loop(spriteanimation)+1
	end if
    if spriteanim.direction(spriteanimation) > 0 then 
	spriteanim.frame (spriteanimation) = spriteanim.startframe(spriteanimation)
	end if
    if spriteanim.direction(spriteanimation)  < 0 then 
	spriteanim.frame (spriteanimation) = spriteanim.endframe(spriteanimation)
	end if
else 
  Messagebox (1,"Error","No animation available.")
  closeapplication
  end
end if
end sub

'halts the animation
sub haltanimation (spriteanimation as integer)
if spriteanimation < spriteanim.index then 
	spriteanim.loop(spriteanimation)=0
	if spriteanim.direction(spriteanimation) > 0 then 
	spriteanim.frame (spriteanimation) = spriteanim.startframe(spriteanimation)
	end if
    if spriteanim.direction(spriteanimation)  < 0 then 
	spriteanim.frame (spriteanimation) = spriteanim.endframe(spriteanimation)
	end if
else 
  Messagebox (1,"Error","No animation available.")
  closeapplication
  end
end if
end sub

'width of sprite in pixels
function animationwidth (spriteanimation as integer) as integer
if spriteanimation < spriteanim.index then 
	return spriteanim.width(spriteanimation)
else 
  Messagebox (1,"Error","No animation available.")
  closeapplication
  end
end if 
end function

'height of sprite in pixels
function animationheight (spriteanimation as integer) as integer
if spriteanimation < spriteanim.index then 
	return spriteanim.height(spriteanimation)
else 
  Messagebox (1,"Error","No animation available.")
  closeapplication
  end
end if
end function

'draws the animation
sub drawanimation (spriteanimation as integer,xscreen as integer,yscreen as integer,xw as double,yw as double,angle as double,vflip as integer,hflip as integer)
dim as integer x,i,xline,yrow
if spriteanimation < spriteanim.index then 
  i =spriteanim.frame(spriteanimation)
  xline=1
  yrow=0
  x=0
  do
   yrow=yrow + 1
      
   if yrow > spriteanim.rows(spriteanimation) then
     xline=xline+1
     yrow=1
   end if
   
   if xline > spriteanim.lines(spriteanimation) then
    xline=1
    yrow=yrow + 1
   end if
     
   x=x+1
   loop until x>= i
   
  if spriteanim.loop (spriteanimation) <> 0 then 
   drawspritepart (spriteanim.image(spriteanimation),xscreen,yscreen,(yrow-1)*spriteanim.width(spriteanimation),(xline-1)*spriteanim.height(spriteanimation),spriteanim.width(spriteanimation),spriteanim.height(spriteanimation),xw,yw,angle,vflip,hflip)
  end if
else 
  Messagebox (1,"Error","No animation available.")
  closeapplication
  end
 end if
end sub

' update all animations
sub updateanimations
dim i as integer
if spriteanim.index > 0 then

 for i= 0 to spriteanim.index-1 
 animnow = spriteanim.ticker(i)
 spriteanim.nexttime(i)=spriteanim.nexttime(i) +1 
		 
 if animnow >= spriteanim.nexttime(i) + spriteanim.timer (i)  then 
 	spriteanim.nexttime(i)=animnow
     if spriteanim.direction(i) > 0 then 
	   spriteanim.frame(i)=spriteanim.frame(i) +  spriteanim.direction(i)
	   if spriteanim.frame(i) > spriteanim.endframe(i) then 
	     spriteanim.frame(i)=spriteanim.startframe(i)
         if spriteanim.loop(i)>0 then 
	       spriteanim.loop(i)=spriteanim.loop(i)-1
	     end if
       end if 
     end if
    if spriteanim.direction(i) < 0 then 
	  spriteanim.frame(i)=spriteanim.frame(i) +  spriteanim.direction(i)
      if spriteanim.frame(i) < spriteanim.startframe(i) then 
	    spriteanim.frame(i)=spriteanim.endframe(i)
	    if spriteanim.loop(i)>0 then 
	       spriteanim.loop(i)=spriteanim.loop(i)-1
        end if
      end if
    end if
 end if
		spriteanim.ticker(i) = timerticks()
 next
else
  Messagebox (1,"Error","No animation available.")
  closeapplication
  end
end if
end sub
