// shows how to load an image and turn that into a sprite
program SpriteExample;

uses
  P2DVideo,
  P2DInput,
  SDL2,
  SysUtils;

type
  player = record
    x: integer;
    y: integer;
    image: p2dsprite;
  end;

var
  win: p2dwindow;
  image: p2dimage;
  grass: p2dsprite;
  key, i, j: integer;
  knight: player;

begin

  win := openwindow('Simple Sprite Example', -1, -1, 800, 600);
  setactivewindow(win);
  setframetimer(100);
  image := loadimage('media/sprite.bmp');
  knight.image := createsprite(image);
  freeimage(image);

  image := loadimage('media/grass.bmp');
  grass := createsprite(image);
  freeimage(image);
  knight.x := windowwidth() div 2;
  knight.y := windowheight() div 2;
  textsize(2);
  repeat
    key := getkey;
    clearwindow;

    if keystate(SDL_SCANCODE_RIGHT) then
    begin
      knight.x := knight.x + 1;
    end;
    if keystate(SDL_SCANCODE_LEFT) then
    begin
      knight.x := knight.x - 1;
    end;
    if keystate(SDL_SCANCODE_UP) then
    begin
      knight.y := knight.y - 1;
    end;
    if keystate(SDL_SCANCODE_DOWN) then
    begin
      knight.y := knight.y + 1;
    end;
    for i := 0 to windowwidth() div spritewidth(grass) do
    begin
      for j := 0 to windowheight() div spriteheight(grass) do
      begin
        drawsprite(grass, i * spritewidth(grass), j * spriteheight(grass), 1, 1, 0, false, false);
      end;
    end;

    drawsprite(knight.image, knight.x, knight.y, 1, 1, 0, false, false);

    color(255, 255, 255, 255);
    drawtext('Cursor keys to move knight, ESC to quit', 0, 0);

    sync;
  until key = SDL_SCANCODE_ESCAPE;
  freesprite(knight.image);
  freesprite(grass);
  closewindow(win);
  closeapplication();

end.
