
{$IFDEF windows}
{$APPTYPE GUI}
{$ENDIF}

program Mandelbrot;

uses
  P2DVideo,
  P2DInput,
  SDL2,
  SysUtils;

var
  x, y, i, timer1, timer2: integer;
  zm: integer = 120;
  miter: integer = 128;
  zx, zy, cx, cy, tmp: real;
  win: p2dwindow;

begin
  win := openwindow('Mandelbrot', -1, -1, 640, 480);
  setactivewindow(win);
  backcolor(255, 255, 255, 255);
  clearwindow();

  timer1 := timerticks();
  for y := 0 to 479 do
  begin
    for x := 0 to 639 do
    begin
      zx := 0;
      zy := 0;
      cx := (x - 320) / zm;
      cy := (y - 240) / zm;
      i := miter;
      while (zx * zx + zy * zy < 4) and (i > 0) do
      begin
        tmp := zx * zx - zy * zy + cx;
        zy := 2 * zx * zy + cy;
        zx := tmp;
        i := i - 1;
      end;
      color(i * 12, i * 8, i * 4, 255);
      dot(x, y);
    end;
  end;
  color(0, 0, 0, 255);
  timer2 := timerticks();
  Drawtext('Time:' + FloatToStr(timer2 - timer1) + ' ms', 0, 0);
  sync;
  inkey;

  closewindow(win);
  closeapplication;

end.
