--' Mandelbrotfraktale (c) Markus Hoffmann
--' Simple and direct drawing algorithm.
--' X11-Basic, adapted for Pulsar2D


local bx,by,bw,bh
local sx,sy,sw,sh
local t0, t1
local gx,gy,zx,zy,nzx
local col,r,v,b

bx=0
by=0
bw=256*2
bh=256*2

sx=-2.2
sy=-1.7
sw=3.4
sh=3.4

win = openwindow("Mandel simple - Pulsar2D (adapted from X11-Basic)",-1,-1,bw,bh)
setactivewindow (win)

cls()

t0=timerticks()
for x=bx,bx+bw do
	for y=by,by+bh do
		gx=(x-bx)/bw*sw+sx
		gy=(y-by)/bh*sh+sy
		zx=gx
		zy=gy
		for c=0,255 do
			col = c
			nzx=zx*zx - zy*zy + gx
			zy=2*zx*zy+gy
			zx=nzx
			if zx*zx + zy*zy > 4 then
				col = c
				break
			end
		end
	r = col*256+col
	v = col*256+col*32
	b = col*256+col*64
	color(v,b,r,255)
	dot(x,y)
	end
redraw()	
end

t1=timerticks()
temps = (t1-t0)/1000
color(255,255,0,255)
textsize (2)
drawtext("Time needed: "..temps.." seconds.",1,1)
redraw()
x=inkey()
closewindow(win)
closeapplication()

