-- analog clock
-- converted to PulsarLua by Cybermonkey
require "scancodes"

win = openwindow ("Analog Clock",-1,-1,350,350)
setactivewindow (win)
setframetimer (60)
page = 0
xcenter = windowwidth()/2
ycenter = windowheight()/2

backcolor  (0,90,82,255)
textsize (2)
texttype (2)

repeat
cls()
key = getkey()

color (0,0,0,255)

fillcircle (xcenter, ycenter, 150)

color  (50,255,50,255)

for i=1, 11 do
	if (i~=3) and (i~=6) and (i~=9) then
		fillcircle (round(math.cos((i * 30) * math.pi / 180 - math.pi / 2) * 140 + xcenter), round(math.sin((i * 30) * math.pi / 180 - math.pi / 2) * 140 + ycenter), 3)
	end
end

color  (255,0,0,255)

drawtext ("9",xcenter - 145, ycenter - 5)
drawtext ("3",xcenter + 135, ycenter - 5)
drawtext ("12",xcenter - 15, ycenter - 145)
drawtext ("6",xcenter - 5, ycenter + 130)

color (0,255,0,255)
drawtext (time(),xcenter-60 , ycenter -70)

second = os.date ("%S")
minute = os.date ("%M")
hour = os.date ("%H")
xsecond = round(math.cos(second * math.pi / 30 - math.pi / 2) * 120 + xcenter)
ysecond = round(math.sin(second * math.pi / 30 - math.pi / 2) * 120 + ycenter)
xminute = round(math.cos(minute * math.pi / 30 - math.pi / 2) * 100 + xcenter)
yminute = round(math.sin(minute * math.pi / 30 - math.pi / 2) * 100 + ycenter)
xhour = round(math.cos((hour * 30 + minute / 2) * math.pi / 180 - math.pi / 2) * 80 + xcenter)
yhour = round(math.sin((hour * 30 + minute / 2) * math.pi / 180 - math.pi / 2) * 80 + ycenter)

color (0,255,0,255)
line (xcenter, ycenter, xsecond, ysecond)
color (0,0,255,255)
line (xcenter, ycenter - 1, xminute, yminute)
line (xcenter - 1, ycenter, xminute, yminute)
color (255,0,0,255)
line (xcenter, ycenter - 1, xhour, yhour)
line (xcenter - 1, ycenter, xhour, yhour)

sync()
until key == SCANCODE_ESCAPE
closewindow (win)
closeapplication()
