
' https://www.freebasic.net/forum/viewtopic.php?p=261928#p261928

#include once "pulsar2d.bi"

Using p2d

Type pt
    As Long x,y
End Type
#define mx mousex
#define my mousey

#define onscreen (mx>0) and (mx<xres) and (my>0) and (my<yres)
#define incircle(cx,cy,radius,x,y) (cx-x)*(cx-x) +(cy-y)*(cy-y)<= radius*radius


Function dotproduct(v1 As pt,v2 As pt) As Single 'dot product |v1| * |v2| *cos(angle between v1 and v2)
    Dim As Single d1=Sqr(v1.x*v1.x + v1.y*v1.y),d2=Sqr(v2.x*v2.x + v2.y*v2.y)
    Dim As Single v1x=v1.x/d1,v1y=v1.y/d1 'normalize
    Dim As Single v2x=v2.x/d2,v2y=v2.y/d2 'normalize
    Return (v1x*v2x+v1y*v2y) '1 * 1 *cos(angle between v1 and v2)
End Function

#macro display
'legs meet at p(2)
Dim As pt L1=(p(1).x-p(2).x,p(1).y-p(2).y)'leg 1
Dim As pt L2=(p(3).x-p(2).x,p(3).y-p(2).y)'leg 2
Dim As Single angle=Acos(dotproduct(L1,L2))*(180/pi)'angle between legs in degrees
clearwindow
Color (00,00,00,255)
drawtext ("framerate = "&fps,10,10)
key=p2d.getkey()
drawtext("dot product = "+Str(dotproduct(L1,L2)),10,40)
drawtext("Drag circles by left click on and pull",10,70)
drawtext("Angle between the lines in degrees",10,100)
For z As Long=1 To 3
    Circle (p(z).x,p(z).y,10)
Next
Line(p(2).x,p(2).y,p(1).x,p(1).y)
Line(p(2).x,p(2).y,p(3).x,p(3).y)
drawtext(Str(angle),p(2).x+20,p(2).y)
sync
#endmacro

#macro mouse(m)
Dim As Long x=mousex,y=mousey,dx,dy
While mousebutton = 1
    Display():Sleep 1,1
    If onscreen Then
        If mousex<>x Or mousey<>y  Then
            dx = mousex - x
            dy = mousey - y
            x = mousex
            y = mousey
            p(m).x=x+dx
            p(m).y=y+dy
        End If
    End If
Wend
#endmacro

Function Regulate(Byval MyFps As Long,Byref fps As Long) As Long
    Static As Double timervalue,_lastsleeptime,t3,frames
    frames+=1
    If (Timer-t3)>=1 Then t3=Timer:fps=frames:frames=0
    Var sleeptime=_lastsleeptime+((1/myfps)-Timer+timervalue)*1000
    If sleeptime<1 Then sleeptime=1
    _lastsleeptime=sleeptime
    timervalue=Timer
    Return sleeptime
End Function

Dim win As p2d.window
Dim key As Integer
Dim As Long fps
win = openwindow ("dot products",-1,-1,800,600)
setactivewindow (win)
textsize (1.5)
texttype (2)
backcolor (0,200,255,255)
Dim As Integer xres=800,yres=600
Dim As pt p(1 To 3)={(100,100),(300,200),(200,400)} 'arbitrary starting points
Dim As Single pi=4*Atn(1)
Do
    display
    For n As Long=1 To 3
        If incircle(p(n).x,p(n).y,10,mousex,mousey) And mousebutton Then
            mouse(n)
        End If
    Next n
    
    Sleep regulate(60,fps)
    
Loop Until key=SDL_SCANCODE_ESCAPE
closewindow(win)
  
