require ("scancodes")
ENGLISH = 1
GERMAN = 2
MAXLIST = 10

function fillbox (x1,y1,x2,y2)

fillrectangle (x1,y1,x2-x1,y2-y1)

end

function roundedbox (x1,y1,x2,y2,radius)
 fillbox (x1,y1,x2,y2)
 fillcircle (x1,y1,radius)
 fillcircle (x1,y2,radius)
 fillcircle (x2,y1,radius)
 fillcircle (x2,y2,radius)
 fillbox (x1,y1,x2,y1-radius)
 fillbox (x1,y1,x1-radius,y2)
 fillbox (x1,y2+radius+1,x2,y2)
 fillbox (x2,y1,x2+radius,y2)
end

function drawbutton (button)
if button.hover == false then
 color (98,98,98,255)
 roundedbox (button.x-2,button.y-2,(button.x+textwidth(button.caption)+10)+2,button.y+textheight()+2,5)
 color (78,78,78,255)
 roundedbox (button.x,button.y,button.x+textwidth(button.caption)+10,button.y+textheight(),5)
 color (170,170,170,255)
 drawtext (button.caption,button.x+5,button.y)
end

if button.hover == true then
 color (50,120,160,255)
 roundedbox (button.x-2,button.y-2,(button.x+textwidth(button.caption)+10)+2,button.y+textheight()+2,5)
 color (78,78,78,255)
 roundedbox (button.x,button.y,button.x+textwidth(button.caption)+10,button.y+textheight(),5)
 color (255,255,255,255)
 drawtext (button.caption,button.x+5,button.y)
end
end

function mousehover (button)

if mousezone (button.x-10,button.y-10,button.x+textwidth(button.caption)+15,button.y+textheight()+5) == true then
  return true
 else
 return false
 end
end

function listhover (button)
if mousezone (button.x,button.y,button.x+textwidth(button.caption)+300,button.y+16) == true then
  return true
 else
 return false
 end

end

function drawlistbutton (button)
textsize (2)
if button.hover == false then
color (170,170,170,255)	
drawtext (button.caption,button.x,button.y)
rectangle (button.x+300,button.y,16,16)
end
if (button.hover == true)  or (button.checked==true) then
color (170,170,170,255)	
drawtext (button.caption,button.x,button.y)
rectangle (button.x+300,button.y,16,16)
color (50,120,160,255)
fillrectangle (button.x+302,button.y+2,12,12)
end

textsize (1)
end
	
requester = openwindow ("Requester",-1,-1,400,300)
setactivewindow (requester)
backcolor (30,30,30,255)


LANGUAGE=GERMAN
	
ressource={}
ressource[ENGLISH]= {choose="Please choose your desired resolution"}
ressource[GERMAN]= {choose="Bitte w"..chr(132).."hlen Sie die gew"..chr(129).."nschte Aufl"..chr(148).."sung"}

ok={}
ok.x=350
ok.y=270
ok.caption = "Ok"
ok.hover = false
ok.click = false

mode={}
for i=1,MAXLIST do
mode[i]={}
mode[i].hover=false
mode[i].click=false
mode[i].checked=false
mode[i].x=0
end
mode[1].checked=true
mode[1].y=30
mode[1].resx =1920
mode[1].resy = 1080

mode[2].y=50
mode[2].resx =1680
mode[2].resy = 1050

mode[3].y=70
mode[3].resx =1600
mode[3].resy = 900

mode[4].y=90
mode[4].resx =1440
mode[4].resy = 900

mode[5].y=110
mode[5].resx =1400
mode[5].resy = 1050

mode[6].y=130
mode[6].resx =1366
mode[6].resy = 768

mode[7].y=150
mode[7].resx =1280
mode[7].resy = 800

mode[8].y=170
mode[8].resx =1280
mode[8].resy = 1024

mode[9].y=190
mode[9].resx =1024
mode[9].resy = 768

mode[10].y=210
mode[10].resx = 800
mode[10].resy = 600

choice=1

for i=1,MAXLIST do
mode[i].caption = mode[i].resx.." x "..mode[i].resy
end

repeat
key=getkey()
cls()
color (170,170,170,255)	

drawtext (ressource[LANGUAGE].choose,0,10)

for i=1,MAXLIST do
if listhover  (mode[i]) == true then
	mode[i].hover= true
end
if (mousebutton()==1) and (mode[i].hover==true) then
	for j=1,MAXLIST do
	if mode [j].checked==true then
		mode[j].checked=false
	end
	end
	mode[i].checked=true
	choice=i
end
drawlistbutton (mode[i])
mode[i].hover = false
end


if mousehover (ok) == true then
    ok.hover=true
 end
 if (mousebutton()==1) and (ok.hover == true) then
   ok.click = true
 end
 drawbutton (ok)
 ok.hover = false

sync()

until key==SCANCODE_ESCAPE or ok.click==true


closewindow (requester)

win=openwindow ("The Game",-1,-1,0,0)
setactivewindow (win)
setvirtualsize (mode[choice].resx,mode[choice].resy)
togglefullscreen()
textsize (2)
repeat
key=getkey()
cls()
color (255,255,255,255)
drawtext ("Width: "..windowwidth(),0,0)
drawtext ("Height: "..windowheight(),0,20)
color (255,255,0,255)
drawtext ("Press ESC to quit",0,40)
sync()
until key==SCANCODE_ESCAPE

closewindow (win)
closeapplication()

