{$IFDEF Windows}
  {$APPTYPE GUI}
  {$R project.rc} 
{$ENDIF}
{
	pulsar2d.pas
        
        Copyright (c) 2013-2015 by Markus Mangold <mmangold@freenet.de>
        
		This software is provided 'as-is', without any express or implied
		warranty. In no event will the authors be held liable for any damages
		arising from the use of this software.

		Permission is granted to anyone to use this software for any purpose,
		including commercial applications, and to alter it and redistribute it
		freely, subject to the following restrictions:

			1. The origin of this software must not be misrepresented; you must not
			claim that you wrote the original software. If you use this software
			in a product, an acknowledgment in the product documentation would be
			appreciated but is not required.

			2. Altered source versions must be plainly marked as such, and must not be
			misrepresented as being the original software.

			3. This notice may not be removed or altered from any source
			distribution.
}

{$define lua52}

program pulsarlua;

uses  
{$IFDEF Windows}
  Windows,
{$ENDIF}
lua52,
p2dvideo,
p2daudio,
p2dhelper,
p2dinput,
p2dcollision,
p2danimation,
p2dparticles,
sysutils,
math,
classes,
uEncrypt,
process;

var L : plua_state;
    script:PChar;
    exename:string;
	fin: file of Byte;
   bread: Byte;
   size, offset: Longint;
   i: integer;
   prog:ansistring;
   path,tag,tmp,lin, wlin: string;
   isbound:boolean;
    j:integer;
   arguments:ansistring;
   userfile:array of text;
   fileindex:integer=0;

const VERSION='0.6.2';
 my_key = 30189;

function l_openwindow (p:plua_state):integer;cdecl;
var x,y,w,h,win:integer;
caption:string;
begin
  if (lua_gettop(L)=5) then
    begin
      caption :=lua_tostring(L,1);
      x := lua_tointeger (L,2);
      y := lua_tointeger(L,3);
      w := lua_tointeger(L,4);
      h := lua_tointeger(L,5);
      win:=openwindow (caption,x,y,w,h);
      lua_pushinteger (L,win);
      Result:=1;
    end	
    else luaL_error(L, PChar('Usage: openwindow (caption,x,y,w,h'),[]); 
    
end;

function l_setvirtualsize (p:plua_state):integer;cdecl;
var w,h:integer;
begin
  if (lua_gettop(L)=2) then
    begin
      w := lua_tointeger(L,1);
      h := lua_tointeger(L,2);
      setvirtualsize (w,h);
      Result:=0;
    end
  else luaL_error(L, PChar('Usage: setvirtualsize (w,h)'),[]); 
end;

function l_messagebox (p:plua_state):integer;cdecl;
var title,textstring:string;
begin
  if (lua_gettop(L)=2) then
    begin
      title := lua_tostring(L,1);
      textstring := lua_tostring(L,2);
      messagebox (1,title,textstring);
      Result:=0;
    end
  else luaL_error(L, PChar('Usage: messagebox (caption,text)'),[]); 
end;

function l_wait (p:plua_state):integer;cdecl;
var ms:integer;
begin
  if (lua_gettop(L)=1) then
  begin
    ms :=lua_tointeger(L,1);
    wait (ms);
    Result:=0;
  end
  else luaL_error(L, PChar('Usage: wait (ms)'),[]); 
end;

function l_colour (p:plua_state):integer;cdecl;
var r,g,b,alpha:integer;
begin
  if (lua_gettop(L)=4) then
    begin
      r := lua_tointeger(L,1);
      g := lua_tointeger(L,2);
      b := lua_tointeger(L,3);
      alpha := lua_tointeger(L,4);
      color (r,g,b,alpha);
      Result:=0;
    end
  else luaL_error(L, PChar('Usage: color (r,g,b,alpha)'),[]); 
end;

function l_redraw (p:plua_state):integer;cdecl;
begin
     redraw;
     Result:=0;
end;

function l_setactivewindow (p:plua_state):integer;cdecl;
var window:integer;
begin
  if (lua_gettop(L)=1) then
    begin
      window := lua_tointeger(L,1);
      setactivewindow (window);
    Result:=0;
    end
  else luaL_error(L, PChar('Usage: setactivewindow (window)'),[]); 
end;

function l_circle (p:plua_state):integer;cdecl;
var x,y,r:integer;
begin
  if (lua_gettop(L)=3) then
    begin
      x := lua_tointeger(L,1);
      y := lua_tointeger(L,2);
      r := lua_tointeger(L,3);
      circle (x,y,r);
    Result:=0;
    end
  else luaL_error(L, PChar('Usage: circle (x,y,radius)'),[]); 
end;

function l_triangle (p:plua_state):integer;cdecl;
var x1,y1,x2,y2,x3,y3:integer;
begin
  if (lua_gettop(L)=6) then
    begin
      x1 := lua_tointeger(L,1);
      y1 := lua_tointeger(L,2);
      x2 := lua_tointeger(L,3);
      y2 := lua_tointeger(L,4);
      x3 := lua_tointeger(L,5);
      y3 := lua_tointeger(L,6);
      triangle (x1,y1,x2,y2,x3,y3);
    Result:=0;
    end
  else  luaL_error(L, PChar('Usage: triangle (x1,y1,x2,y2,x3,y3)'),[]); 
end;

function l_filltriangle (p:plua_state):integer;cdecl;
var x1,y1,x2,y2,x3,y3:integer;
begin
  if (lua_gettop(L)=6) then
    begin
      x1 := lua_tointeger(L,1);
      y1 := lua_tointeger(L,2);
      x2 := lua_tointeger(L,3);
      y2 := lua_tointeger(L,4);
      x3 := lua_tointeger(L,5);
      y3 := lua_tointeger(L,6);
      filltriangle (x1,y1,x2,y2,x3,y3);
    Result:=0;
    end
  else luaL_error(L, PChar('Usage: filltriangle (x1,y1,x2,y2,x3,y3)'),[]); 
end;

function l_closewindow (p:plua_state):integer;cdecl;
var window:integer;
begin
  if (lua_gettop(L)=1) then
	begin
	  window:=lua_tointeger (L,1);
	  closewindow (window);
      Result:=0;
    end
else luaL_error(L, PChar('Usage: closewindow (window)'),[]);     
end;

function l_clearscreen (p:plua_state):integer;cdecl;
begin
     clearwindow;
     Result:=0;
end;

function l_sync (p:plua_state):integer;cdecl;
begin
     sync;
     Result:=0;
end;

function l_backcolour (p:plua_state):integer;cdecl;
var r,g,b,alpha:integer;
begin
  if (lua_gettop(L)=4) then
    begin
      r := lua_tointeger(L,1);
      g := lua_tointeger(L,2);
      b := lua_tointeger(L,3);
      alpha := lua_tointeger(L,3);
      backcolor (r,g,b,alpha);
      Result:=0;
    end
  else luaL_error(L, PChar('Usage: backcolor (r,g,b,alpha)'),[]);
end;

function l_inkey (p:plua_state):integer;cdecl;
var key:char;
begin
  key:=inkey();
  lua_pushstring(L,key);
  Result :=1;
end;

function l_dot (p:plua_state):integer;cdecl;
var x,y:integer;
begin
  if (lua_gettop(L)=2) then
    begin
      x:=lua_tointeger(L,1);
      y:=lua_tointeger(L,2);
      dot (x,y);
      Result:=0;
    end
   else luaL_error(L, PChar('Usage: dot (x,y)'),[]);
end;

function l_rectangle (p:plua_state):integer;cdecl;
var x1,y1,w,h:integer;
begin
  if (lua_gettop(L)=4) then
    begin
    x1:=lua_tointeger(L,1);
    y1:=lua_tointeger(L,2);
    w:=lua_tointeger(L,3);
    h:=lua_tointeger(L,4);
    rectangle (x1,y1,w,h);
    Result:=0;
  end
  else  luaL_error(L, PChar('Usage: rectangle (x,y,w,h)'),[]);
end;

function l_fillrectangle (p:plua_state):integer;cdecl;
var x1,y1,w,h:integer;
begin
  if (lua_gettop(L)=4) then
    begin
    x1:=lua_tointeger(L,1);
    y1:=lua_tointeger(L,2);
    w:=lua_tointeger(L,3);
    h:=lua_tointeger(L,4);
    fillrectangle (x1,y1,w,h);
    Result:=0;
  end
  else  luaL_error(L, PChar('Usage: fillrectangle (x,y,w,h)'),[]);
end;

function l_line (p:plua_state):integer;cdecl;
var x1,y1,x2,y2:integer;
begin
  if (lua_gettop(L)=4) then
    begin
    x1:=lua_tointeger(L,1);
    y1:=lua_tointeger(L,2);
    x2:=lua_tointeger(L,3);
    y2:=lua_tointeger(L,4);
    line (x1,y1,x2,y2);
    Result:=0;
  end
  else luaL_error(L, PChar('Usage: line (x1,y1,x2,y2)'),[]);
end;

function l_getkey (p:plua_state):integer;cdecl;
var key:integer;
begin
  key:=GetKey();
  lua_pushinteger(L,key);
  Result :=1;
end;

function l_fillcircle (p:plua_state):integer;cdecl;
var x,y,r:integer;
begin
  if (lua_gettop(L)=3) then
    begin
      x := lua_tointeger(L,1);
      y := lua_tointeger(L,2);
      r := lua_tointeger(L,3);
      fillcircle (x,y,r);
      Result:=0;
    end
  else luaL_error(L, PChar('Usage: fillcircle (x,y,radius)'),[]);
end;

function l_mousex (p:plua_state):integer;cdecl;
var mx: integer;
begin
  mx:=mousex();
  lua_pushinteger (L, mx);
  Result :=1;
end;

function l_mousey (p:plua_state):integer;cdecl;
var my: integer;
begin
  my:=mousey();
  lua_pushinteger (L, my);
  Result :=1;
end;

function l_mouseb (p:plua_state):integer;cdecl;
var mb: integer;
begin
  mb:=mousebutton();
  lua_pushinteger (L, mb);
  Result :=1;
end;

function l_ellipse (p:plua_state):integer;cdecl;
var x,y,xr,yr:integer;
begin
  if (lua_gettop(L)=4) then
    begin
      x := lua_tointeger(L,1);
      y := lua_tointeger(L,2);
      xr :=lua_tointeger(L,3);
      yr :=lua_tointeger(L,4);
      ellipse (x,y,xr,yr);
      Result:=0;
    end
  else luaL_error(L, PChar('Usage: ellipse (x,y,xradius,yradius)'),[]);
end;

function l_fillellipse (p:plua_state):integer;cdecl;
var x,y,xr,yr:integer;
begin
  if (lua_gettop(L)=4) then
    begin
      x := lua_tointeger(L,1);
      y := lua_tointeger(L,2);
      xr :=lua_tointeger(L,3);
      yr :=lua_tointeger(L,4);
      fillellipse (x,y,xr,yr);
      Result:=0;
    end
  else luaL_error(L, PChar('Usage: fillellipse (x,y,xradius,yradius)'),[]);
end;

function l_loadimage (p:plua_state):integer;cdecl;
var name:string;
    data:p2dimage;
begin
  if (lua_gettop(L)=1) then
    begin
      name := lua_tostring(L,1);
      data := loadimage (name);
      lua_pushlightuserdata (L,data);
      Result:=1;
    end
  else luaL_error(L, PChar('Usage: loadimage (filename)'),[]);
end;

function l_loadsprite (p:plua_state):integer;cdecl;
var name:string;
    data:p2dsprite;
begin
  if (lua_gettop(L)=1) then
    begin
      name := lua_tostring(L,1);
      data := loadsprite (name);
      lua_pushlightuserdata (L,data);
      Result:=1;
    end
  else luaL_error(L, PChar('Usage: loadsprite (filename)'),[]);
end;

function l_freeimage (p:plua_state):integer;cdecl;
var srcimage:p2dimage;
begin
  if (lua_gettop(L)=1) then
    begin
      srcimage := lua_touserdata(L,1);
      freeimage (srcimage);  
      Result:=0;
    end
  else  luaL_error(L, PChar('Usage: freeimage (image)'),[]);
end;

function l_createsprite (p:plua_state):integer;cdecl;
var srcimage:p2dimage;
	sprite:p2dsprite;
begin
  if (lua_gettop(L)=1) then
    begin
      srcimage := lua_touserdata(L,1);
      sprite :=createsprite (srcimage);
      lua_pushlightuserdata (L,sprite);
      Result:=1;
    end
  else  luaL_error(L, PChar('Usage: createsprite (image)'),[]);
end;

function l_spritecolour (p:plua_state):integer;cdecl;
var r,g,b,alpha:integer;
	sprite:p2dsprite;
begin
  if (lua_gettop(L)=5) then
    begin
	 sprite:=lua_touserdata (L,1);
      r := lua_tointeger(L,2);
      g := lua_tointeger(L,3);
      b := lua_tointeger(L,4);
      alpha := lua_tointeger(L,5);
      spritecolor (sprite,r,g,b,alpha);
      Result:=0;
    end
  else luaL_error(L, PChar('Usage: spritecolor (sprite,r,g,b,alpha)'),[]); 
end;

function l_drawsprite (p:plua_state):integer;cdecl;
var sprite:p2dsprite;
	x,y:integer;
	width,height,angle:real;
	vflip,hflip:boolean;
begin
if (lua_gettop(L)=8) then
    begin
      sprite := lua_touserdata(L,1);
      x := lua_tointeger(L,2);
      y := lua_tointeger(L,3);
      width := lua_tonumber(L,4);
      height := lua_tonumber(L,5);
      angle := lua_tonumber(L,6);
      vflip := lua_toboolean(L,7);
      hflip := lua_toboolean(L,8);
      drawsprite (sprite, x,y,width,height,angle,vflip,hflip);
      Result:=0;
    end
  else luaL_error(L, PChar('drawsprite (sprite, x,y,width,height,angle,vflip,hflip)'),[]);
end;

//drawspritepart (sprite:PSDL_Texture; x,y,startx,starty,xoffset,yoffset:integer;width,height,angle:real;vflip,hflip:boolean);
function l_drawspritepart (p:plua_state):integer;cdecl;
var sprite:p2dsprite;
	x,y,startx,starty,xoffset,yoffset:integer;
	width,height,angle:real;
	vflip,hflip:boolean;
begin
if (lua_gettop(L)=12) then
    begin
      sprite := lua_touserdata(L,1);
      x := lua_tointeger(L,2);
      y := lua_tointeger(L,3);
      startx := lua_tointeger(L,4);
      starty := lua_tointeger(L,5);
      xoffset := lua_tointeger(L,6);
      yoffset := lua_tointeger(L,7);
      width := lua_tonumber(L,8);
      height := lua_tonumber(L,9);
      angle := lua_tonumber(L,10);
      vflip := lua_toboolean(L,11);
      hflip := lua_toboolean(L,12);
      drawspritepart (sprite,x,y,startx,starty,xoffset,yoffset,width,height,angle,vflip,hflip);
      Result:=0;
    end
  else luaL_error(L, PChar('drawspritepart sprite,x,y,startx,starty,xoffset,yoffset,width,height,angle,vflip,hflip)'),[]);
end;

function l_freesprite (p:plua_state):integer;cdecl;
var srcimage:p2dsprite;
begin
  if (lua_gettop(L)=1) then
    begin
      srcimage := lua_touserdata(L,1);
      freesprite (srcimage);  
      Result:=0;
    end
  else  luaL_error(L, PChar('Usage: freesprite (image)'),[]);
end;

function l_freesound (p:plua_state):integer;cdecl;
var sound:p2dsound;
begin
  if (lua_gettop(L)=1) then
    begin
      sound := lua_touserdata(L,1);
      freesound (sound);  
      Result:=0;
    end
  else  luaL_error(L, PChar('Usage: freesound (sound)'),[]);
end;

function l_freemusic (p:plua_state):integer;cdecl;
var music:p2dmusic;
begin
  if (lua_gettop(L)=1) then
    begin
      music := lua_touserdata(L,1);
      freemusic (music);  
      Result:=0;
    end
  else  luaL_error(L, PChar('Usage: freemusic (music)'),[]);
end;

function l_keystate (p:plua_state):integer;cdecl;
var keycode:integer;
    pressed:boolean;
begin
if (lua_gettop(L)=1) then
    begin
      keycode:= lua_tointeger (L,1);
      pressed:=keystate (keycode);
      lua_pushboolean (L,pressed);
      Result:=1;
    end
  else luaL_error(L, PChar('Usage: keystate (scancode)'),[]);
end;

function l_closeapplication (p:plua_state):integer;cdecl;
begin
  closeapplication;
  Result:=0;
end;

function l_mousehide (p:plua_state):integer;cdecl;
begin
  hidemouse;
  Result:=0;
end;

function l_mouseshow (p:plua_state):integer;cdecl;
begin
    showmouse;
    Result:=0;
end;

function l_warpmouse (p:plua_state):integer;cdecl;
var mx,my:integer;
begin
    if (lua_gettop(L)=2) then
      begin
	mx := lua_tointeger(L,1);
	my := lua_tointeger(L,2);
	WarpMouse (mx,my);
	Result:=0;
      end
    else luaL_error(L, PChar('Usage: warpmouse (mx,my)'),[]);
end;

function l_mousezone (p:plua_state):integer;cdecl;
var x1,y1,x2,y2:integer;
    state:boolean;
begin
    if (lua_gettop(L)=4) then
      begin
	x1 :=lua_tointeger(L,1);
	y1 :=lua_tointeger(L,2);
	x2 :=lua_tointeger(L,3);
	y2 :=lua_tointeger(L,4);
	state:=mousezone(x1,y1,x2,y2);
	lua_pushboolean (L,state);
	Result:=1;
      end
    else  luaL_error(L, PChar('Usage: mousezone (x1,y1,x2,y2)'),[]);
end;

function l_timeleft (p:plua_state):integer;cdecl;
var left:integer;
begin
  left:=timeleft();
  lua_pushinteger (L,left);
  Result:=1;
end;

function l_setframetimer (p:plua_state):integer;cdecl;
var frames:integer;
begin
if (lua_gettop(L)=1) then
    begin
      frames:=  lua_tointeger (L,1);
      SetFrameTimer (frames);
      Result:=0;
    end
  else luaL_error(L, PChar('Usage: setframetimer (frames)'),[]);
end;

function l_colourkey (p:plua_state):integer;cdecl;
var r,g,b:byte;
begin
  if (lua_gettop(L)=3) then
    begin
      r := lua_tointeger(L,1);
      g := lua_tointeger(L,2);
      b := lua_tointeger(L,3);
      setcolorkey (r,g,b);
      Result:=0;
    end
  else luaL_error(L, PChar('Usage: colorkey (r,g,b)'),[]);
end;

function l_loadsound (p:plua_state):integer;cdecl;
var name:string;
    data:p2dsound;
begin
  if (lua_gettop(L)=1) then
    begin
      name := lua_tostring(L,1);
      data := loadsound (name);
      lua_pushlightuserdata (L,data);
      Result:=1;
    end
  else luaL_error(L, PChar('Usage: loadsound (filename)'),[]);
end;

function l_playsound (p:plua_state):integer;cdecl;
var volume,channel,loop:integer;
    sound:p2dsound;
begin
  if (lua_gettop(L)=4) then
    begin
      sound := lua_touserdata (L,1);
      volume:=lua_tointeger(L,2);
      channel:=lua_tointeger(L,3);
      loop:=lua_tointeger (L,4);
      playsound (sound,volume,channel,loop);
      Result:=0;
    end
  else luaL_error(L, PChar('Usage: playsound (sound,volume,channel,loop)'),[]);
end;

function l_loadmusic (p:plua_state):integer;cdecl;
var name:string;
    data:p2dmusic;
begin
  if (lua_gettop(L)=1) then
    begin
      name := lua_tostring(L,1);
      data := loadmusic (name);
      lua_pushlightuserdata (L,data);
      Result:=1;
    end
  else  luaL_error(L, PChar('Usage: loadmusic (filename)'),[]);
end;

function l_playmusic (p:plua_state):integer;cdecl;
var volume,loop:integer;
    sound:p2dmusic;
begin
  if (lua_gettop(L)=3) then
    begin
      sound := lua_touserdata (L,1);
      volume:= lua_tointeger (L,2);
      loop:= lua_tointeger(L,3);
      playmusic (sound,volume,loop);
      //loop means: -1 = infinite, 0 = once, 1 = twice,...
      Result:=0;
    end
  else  luaL_error(L, PChar('Usage: playmusic (sound,volume,loop)'),[]);
end;

function l_fademusic (p:plua_state):integer;cdecl;
var ms:integer;
begin
  if (lua_gettop(L)=1) then
    begin
      ms:= lua_tointeger (L,1);
      fademusic (ms);
      //loop means: -1 = infinite, 0 = once, 1 = twice,...
      Result:=0;
    end
  else  luaL_error(L, PChar('Usage: fademusic (ms)'),[]);
end;

function l_pausemusic (p:plua_state):integer;cdecl;
begin
    pausemusic;
    Result:=0;
end;

function l_haltmusic (p:plua_state):integer;cdecl;
begin
    haltmusic;
    Result:=0;
end;

function l_resumemusic (p:plua_state):integer;cdecl;
begin
    resumemusic;
    Result:=0;
end;

function l_togglefullscreen (p:plua_state):integer;cdecl;
begin
    togglefullscreen;
    Result:=0;
end;

function l_fullscreen (p:plua_state):integer;cdecl;
var fullscreenvar:boolean;
begin
	  fullscreenvar:=fullscreen();
      lua_pushboolean (L,fullscreenvar);
      Result:=1;
end;
  
function l_drawtext (p:plua_state):integer;cdecl;
var x,y:integer;
textstr:string;
begin
  if (lua_gettop(L)=3) then
    begin
      textstr :=lua_tostring(L,1);
      x := lua_tointeger(L,2);
      y := lua_tointeger(L,3);
      Drawtext (textstr,x,y);
      Result:=0;
    end
  else luaL_error(L, PChar('Usage: drawtext (text,x,y)'),[]);
end;

function l_textsize (p:plua_state):integer;cdecl;
var size:integer;
begin
  if (lua_gettop(L)=1) then
    begin
      size := lua_tointeger(L,1);
      textsize (size);
      Result:=0;
    end
  else luaL_error(L, PChar('Usage: textsize (size)'),[]);
end;

function l_texttype (p:plua_state):integer;cdecl;
var typus:integer;
begin
  if (lua_gettop(L)=1) then
    begin
      typus := lua_tointeger(L,1);
      texttype (typus);
      Result:=0;
    end
  else luaL_error(L, PChar('Usage: texttype (type)'),[]);
end;


function l_textinputcolor (p:plua_state):integer;cdecl;
var r,g,b,alpha:integer;
begin
  if (lua_gettop(L)=4) then
    begin
      r := lua_tointeger(L,1);
      g := lua_tointeger(L,2);
      b := lua_tointeger(L,3);
      alpha := lua_tointeger(L,4);
      textinputcolor (r,g,b,alpha);
      Result:=0;
    end
  else luaL_error(L, PChar('Usage: textinputcolor (red,green,blue,alpha)'),[]);
end;

function l_textinputbackcolor (p:plua_state):integer;cdecl;
var r,g,b,alpha:integer;
begin
  if (lua_gettop(L)=4) then
    begin
      r := lua_tointeger(L,1);
      g := lua_tointeger(L,2);
      b := lua_tointeger(L,3);
      alpha := lua_tointeger(L,4);
      textinputbackcolor (r,g,b,alpha);
      Result:=0;
    end
  else luaL_error(L, PChar('Usage: textinputbackcolor (red,green,blue,alpha)'),[]);
end;

function l_textwidth (p:plua_state):integer;cdecl;
var textstring:string;
    size:integer;
begin
if (lua_gettop(L)=1) then
    begin
      textstring:= lua_tostring (L,1);
      size:=textwidth(textstring);
      lua_pushinteger (L,size);
      Result:=1;
    end
  else luaL_error(L, PChar('Usage: textwidth (textstring)'),[]);
end;

function l_textheight (p:plua_state):integer;cdecl;
var size:integer;
begin
      size:=textheight();
      lua_pushinteger (L,size);
      Result:=1;
end;

function l_spritewidth (p:plua_state):integer;cdecl;
var image:p2dsprite;
    size:integer;
begin
if (lua_gettop(L)=1) then
    begin
      image:= lua_touserdata (L,1);
      size:=spritewidth(image);
      lua_pushinteger (L,size);
      Result:=1;
    end
  else luaL_error(L, PChar('Usage: spritewidth (sprite)'),[]);
end;

function l_spriteheight (p:plua_state):integer;cdecl;
var image:p2dsprite;
    size:integer;
begin
if (lua_gettop(L)=1) then
    begin
      image:= lua_touserdata (L,1);
      size:=spriteheight(image);
      lua_pushinteger (L,size);
      Result:=1;
    end
  else  luaL_error(L, PChar('Usage: spriteheight (sprite)'),[]);
end;

function l_windowwidth (p:plua_state):integer;cdecl;
var size: integer;
begin
  size:=windowwidth();
  lua_pushinteger (L, size);
  Result :=1;
end;

function l_windowheight (p:plua_state):integer;cdecl;
var size: integer;
begin
  size:=windowheight();
  lua_pushinteger (L, size);
  Result :=1;
end;

function l_nocolourkey (p:plua_state):integer;cdecl;
begin
    nocolorkey;
    Result:=0;
end;

function l_timerticks (p:plua_state):integer;cdecl;
var ticks:integer;
begin
  ticks:=timerticks();
  lua_pushinteger (L,ticks);
  Result:=1;
end;

function l_ostype (p:plua_state):integer;cdecl;
var osname:string;
begin
  osname:=ostype;
  lua_pushstring (L,osname);
  Result:=1;
end;

function l_joystickplugged (p:plua_state):integer;cdecl;
var joystate:boolean;
begin
  joystate:=joystickplugged;
  lua_pushboolean (L,joystate);
  Result:=1;
end;

function l_getjoyx (p:plua_state):integer;cdecl;
var joyx:integer;
begin
  joyx:=getjoystickx;
  lua_pushinteger (L,joyx);
  Result:=1;
end;

function l_getjoyy (p:plua_state):integer;cdecl;
var joyy:integer;
begin
  joyy:=getjoysticky;
  lua_pushinteger (L,joyy);
  Result:=1;
end;

function l_getjoybutton (p:plua_state):integer;cdecl;
var button,state:integer;
begin
  if (lua_gettop(L)=1) then
    begin
      button:=lua_tointeger (L,1);
      state:=getjoystickbutton (button);
      lua_pushinteger (L,state);
      Result:=1;
    end
  else luaL_error(L, PChar('Usage: getjoybutton (button)'),[]);
end;

function l_numberjoybuttons (p:plua_state):integer;cdecl;
var number:integer;
begin
  number:=numberjoybuttons;
  lua_pushinteger (L,number);
  Result:=1;
end;

function l_setcaption (p:plua_state):integer;cdecl;
var caption:string;
begin
  if (lua_gettop(L)=1) then
    begin
      caption:=lua_tostring (L,1);
      setcaption(caption);
      Result:=0;
    end
  else luaL_error(L, PChar('Usage: setcaption (caption)'),[]);
end;

function l_seticon (p:plua_state):integer;cdecl;
var icon:p2dimage;
begin
  if (lua_gettop(L)=1) then
    begin
      icon:=lua_touserdata (L,1);
      seticon (icon);
      Result:=0;
    end
  else luaL_error(L, PChar('Usage: seticon (image)'),[]);
end;

function l_boxcoll (p:plua_state):integer;cdecl;
var x1,y1,w1,h1,x2,y2,w2,h2:integer;
    collision:boolean;
begin
if (lua_gettop(L)=8) then
    begin
      x1 := lua_tointeger(L,1);
      y1 := lua_tointeger(L,2);
      w1 := lua_tointeger(L,3);
      h1 := lua_tointeger(L,4);
      x2 := lua_tointeger(L,5);
      y2 := lua_tointeger(L,6);
      w2 := lua_tointeger(L,7);
      h2 := lua_tointeger(L,8);
      collision:=boxcoll (x1,y1,w1,h1,x2,y2,w2,h2);
      lua_pushboolean (L,collision);
      Result:=1;
    end
  else luaL_error(L, PChar('Usage: boxcoll (x1,y1,w1,h1,x2,y2,w2,h2)'),[]);
end;

function l_insidetriangle (p:plua_state):integer;cdecl;
var px,py,x1,y1,x2,y2,x3,y3:integer;
    inside:boolean;
begin
if (lua_gettop(L)=8) then
    begin
      px := lua_tointeger(L,1);
      py := lua_tointeger(L,2);
      x1 := lua_tointeger(L,3);
      y1 := lua_tointeger(L,4);
      x2 := lua_tointeger(L,5);
      y2 := lua_tointeger(L,6);
      x3 := lua_tointeger(L,7);
      y3 := lua_tointeger(L,8);
      inside:= insidetriangle (px,py,x1,y1,x2,y2,x3,y3);
      lua_pushboolean (L,inside);
      Result:=1;
    end
  else luaL_error(L, PChar('Usage: insidetriangle (px,py,x1,y1,x2,y2,x3,y3)'),[]);
end;

function l_insiderectangle (p:plua_state):integer;cdecl;
var px,py,x1,y1,x2,y2:integer;
    inside:boolean;
begin
if (lua_gettop(L)=6) then
    begin
      px := lua_tointeger(L,1);
      py := lua_tointeger(L,2);
      x1 := lua_tointeger(L,3);
      y1 := lua_tointeger(L,4);
      x2 := lua_tointeger(L,5);
      y2 := lua_tointeger(L,6);
      
      inside:= insiderectangle (px,py,x1,y1,x2,y2);
      lua_pushboolean (L,inside);
      Result:=1;
    end
  else luaL_error(L, PChar('Usage: insiderectangle (px,py,x1,y1,x2,y2)'),[]);
end;

function l_insidecircle (p:plua_state):integer;cdecl;
var px,py,cx,cy,radius:integer;
    inside:boolean;
begin
if (lua_gettop(L)=5) then
    begin
      px := lua_tointeger(L,1);
      py := lua_tointeger(L,2);
      cx := lua_tointeger(L,3);
      cy := lua_tointeger(L,4);
      radius := lua_tointeger(L,5);
            
      inside:= insidecircle (px,py,cx,cy,radius);
      lua_pushboolean (L,inside);
      Result:=1;
    end
  else luaL_error(L, PChar('Usage: insidecircle (px,py,cx,cy,radius)'),[]);
end;

function l_rnd (p:plua_state):integer;cdecl;
var number:real;
begin
    number:=rnd;
    lua_pushnumber(L, number);
    Result:=1;
end;

function l_round (p:plua_state):integer;cdecl;
var number:real;
	retnumb:integer;
begin
  if (lua_gettop(L)=1) then
  begin
    number :=lua_tonumber(L,1);
    retnumb:=round(number);
    lua_pushinteger(L, retnumb);
    Result:=1;
  end
  else luaL_error(L, PChar('Usage: round (number)'),[]);
end;

function l_int (p:plua_state):integer;cdecl;
var number:real;
	retnumb:integer;
begin
  if (lua_gettop(L)=1) then
  begin
    number :=lua_tonumber(L,1);
    retnumb:=trunc(number);
    lua_pushinteger(L, retnumb);
    Result:=1;
  end
  else luaL_error(L, PChar('Usage: int (number)'),[]);
end;

function l_sqrt (p:plua_state):integer;cdecl;
var number,resnumber:real;
begin
  if (lua_gettop(L)=1) then
  begin
    number :=lua_tonumber(L,1);
    try
    resnumber:=sqrt(number);
    except
    resnumber:=0;
    end;
    lua_pushnumber(L, resnumber);
    Result:=1;
  end
  else luaL_error(L, PChar('Usage: sqrt (number)'),[]);
end;

function l_abs (p:plua_state):integer;cdecl;
var number,resnumber:real;
begin
  if (lua_gettop(L)=1) then
  begin
    number :=lua_tonumber(L,1);
    try
    resnumber:=abs(number);
    except
    resnumber:=0;
    end;
    lua_pushnumber(L, resnumber);
    Result:=1;
  end
  else luaL_error(L, PChar('Usage: abc (number)'),[]);
end;

function l_cos (p:plua_state):integer;cdecl;
var number,resnumber:real;
begin
  if (lua_gettop(L)=1) then
  begin
    number :=lua_tonumber(L,1);
    try
    resnumber:=cos(number);
    except
    resnumber:=0;
    end;
    lua_pushnumber(L, resnumber);
    Result:=1;
  end
  else luaL_error(L, PChar('Usage: cos (number)'),[]);
end;

function l_sin (p:plua_state):integer;cdecl;
var number,resnumber:real;
begin
  if (lua_gettop(L)=1) then
  begin
    number :=lua_tonumber(L,1);
    try
    resnumber:=sin(number);
    except
    resnumber:=0;
    end;
    lua_pushnumber(L, resnumber);
    Result:=1;
  end
  else luaL_error(L, PChar('Usage: sin (number)'),[]);
end;

function l_floor (p:plua_state):integer;cdecl;
var number,resnumber:real;
begin
  if (lua_gettop(L)=1) then
  begin
    number :=lua_tonumber(L,1);
    try
    resnumber:=floor(number);
    except
    resnumber:=0;
    end;
    lua_pushnumber(L, resnumber);
    Result:=1;
  end
  else luaL_error(L, PChar('Usage: floor (number)'),[]);
end;

function l_ceil (p:plua_state):integer;cdecl;
var number,resnumber:real;
begin
  if (lua_gettop(L)=1) then
  begin
    number :=lua_tonumber(L,1);
    try
    resnumber:=ceil(number);
    except
    resnumber:=0;
    end;
    lua_pushnumber(L, resnumber);
    Result:=1;
  end
  else luaL_error(L, PChar('Usage: ceil (number)'),[]);
end;

function l_exp (p:plua_state):integer;cdecl;
var number,resnumber:extended;
begin
  if (lua_gettop(L)=1) then
  begin
    number :=lua_tonumber(L,1);
    try
    resnumber:=exp(number);
    except
    resnumber:=0;
    end;
    lua_pushnumber(L, resnumber);
    Result:=1;
  end
  else luaL_error(L, PChar('Usage: exp (number)'),[]);
end;

function l_chr (p:plua_state):integer;cdecl;
var code:integer;
	ch:char;
begin
  if (lua_gettop(L)=1) then
  begin
    code :=lua_tointeger(L,1);
    ch:=chrstr(code);
    lua_pushstring(L, ch);
    Result:=1;
  end
  else luaL_error(L, PChar('Usage: chr (ascii)'),[]);
end;

function l_asc (p:plua_state):integer;cdecl;
var code:integer;
	ch:ansistring;
begin
  if (lua_gettop(L)=1) then
  begin
	ch :=lua_tostring (L,1);
    code:=asc(ch);
    lua_pushinteger(L,code);
    Result:=1;
  end
  else luaL_error(L, PChar('Usage: asc (char)'),[]);
end;

function l_val (p:plua_state):integer;cdecl;
var number:real;
	numbstr:ansistring;
begin
  if (lua_gettop(L)=1) then
  begin
	numbstr :=lua_tostring (L,1);
    number:=val(numbstr);
    lua_pushnumber(L,number);
    Result:=1;
  end
  else luaL_error(L, PChar('Usage: val (string)'),[]);
end;

function l_left (p:plua_state):integer;cdecl;
var len:integer;
	returnstr,chars:ansistring;
begin
  if (lua_gettop(L)=2) then
  begin
    chars :=lua_tostring (L,1);
    len :=lua_tointeger (L,2);
    returnstr:=left(chars,len);
	lua_pushstring(L,returnstr);
    Result:=1;
  end
  else luaL_error(L, PChar('Usage: left (string,length)'),[]);
end;

function l_right (p:plua_state):integer;cdecl;
var len:integer;
	returnstr,chars:ansistring;
begin
  if (lua_gettop(L)=2) then
  begin
    chars :=lua_tostring (L,1);
    len :=lua_tointeger (L,2);
    returnstr:=right(chars,len);
	lua_pushstring(L,returnstr);
    Result:=1;
  end
  else luaL_error(L, PChar('Usage: right (string,length)'),[]);
end;

function l_mid (p:plua_state):integer;cdecl;
var start,len:integer;
	returnstr,chars:ansistring;
begin
  if (lua_gettop(L)=3) then
  begin
    chars :=lua_tostring (L,1);
    start :=lua_tointeger (L,2);
    len :=lua_tointeger (L,3);
    returnstr:=mid(chars,start,len);
	lua_pushstring(L,returnstr);
    Result:=1;
  end
  else luaL_error(L, PChar('Usage: mid (string,start,length)'),[]);
end;

function l_insert (p:plua_state):integer;cdecl;
var start:integer;
	returnstr,chars1,chars2:ansistring;
begin
  if (lua_gettop(L)=3) then
  begin
    chars1 :=lua_tostring (L,1);
    chars2 :=lua_tostring (L,2);
    start :=lua_tointeger (L,3);
    returnstr:=insertstr(chars1,chars2,start);
	lua_pushstring(L,returnstr);
    Result:=1;
  end
  else luaL_error(L, PChar('Usage: insert (string1,string2,start)'),[]);
end;

function l_len (p:plua_state):integer;cdecl;
var code:integer;
	chars:ansistring;
begin
  if (lua_gettop(L)=1) then
  begin
    chars :=lua_tostring (L,1);
    code:=len (chars);
	lua_pushinteger(L,code);
    Result:=1;
  end
  else luaL_error(L, PChar('Usage: len (string)'),[]);
end;

function l_uppercase (p:plua_state):integer;cdecl;
var	returnstr,chars:ansistring;
begin
  if (lua_gettop(L)=1) then
  begin
    chars :=lua_tostring (L,1);
    returnstr:=upper(chars);
	lua_pushstring(L,returnstr);
    Result:=1;
  end
  else luaL_error(L, PChar('Usage: uppercase (string)'),[]);
end;

function l_lowercase (p:plua_state):integer;cdecl;
var	returnstr,chars:ansistring;
begin
  if (lua_gettop(L)=1) then
  begin
    chars :=lua_tostring (L,1);
    returnstr:=lower(chars);
	lua_pushstring(L,returnstr);
    Result:=1;
  end
  else luaL_error(L, PChar('Usage: lowercase (string)'),[]);
end;

function l_input (p:plua_state):integer;cdecl;
var x,y,maxlen:integer;
	returnstr:ansistring;
begin
  if (lua_gettop(L)=3) then
  begin
    x :=lua_tointeger (L,1);
    y :=lua_tointeger (L,2);
    maxlen :=lua_tointeger (L,3);
    returnstr:=input(x,y,maxlen);
	lua_pushstring(L,returnstr);
    Result:=1;
  end
  else luaL_error(L, PChar('Usage: input (x,y,maxlength)'),[]);
end;

function l_time (p:plua_state):integer;cdecl;
var clock:string;
begin
	clock:=TimeToStr(Time);
    lua_pushstring(L, clock);
    Result:=1;
end;

function l_date (p:plua_state):integer;cdecl;
Var calender:string;
begin
	calender:=FormatDateTime('yyyy-mm-dd',Now);
    lua_pushstring(L, calender);
    Result:=1;
end;

function l_resizewindow (p:plua_state):integer;cdecl;
var x,y:integer;
begin
  if (lua_gettop(L)=2) then
  begin
    x :=lua_tointeger (L,1);
    y :=lua_tointeger (L,2);
    resizewindow (x,y);
    Result:=0;
 end
  else luaL_error(L, PChar('Usage: resizewindow (x,y)'),[]);
end;

function l_setscalequality (p:plua_state):integer;cdecl;
var mode:string;
begin
  if (lua_gettop(L)=1) then
  begin
    mode :=lua_tostring (L,1);
    setscalequality (mode);
    Result:=0;
 end
  else luaL_error(L, PChar('Usage: setscalequality (mode)'),[]);
end;

function l_arguments (p:plua_state):integer;cdecl;
Var args:ansistring;
begin
	args:=arguments;
    lua_pushstring(L, args);
    Result:=1;
end;

function l_updateanimations (p:plua_state):integer;cdecl;
begin
     updateanimations;
     Result:=0;
end;

function l_createanimation (p:plua_state):integer;cdecl;
var sprite:p2dsprite;
	width,height,startframe,endframe,timer,direction,loop:integer;
	animation:integer;
begin
if (lua_gettop(L)=8) then
    begin
      sprite := lua_touserdata(L,1);
      width := lua_tointeger(L,2);
      height := lua_tointeger(L,3);
      startframe:= lua_tointeger(L,4);
      endframe := lua_tointeger(L,5);
      timer := lua_tointeger(L,6);
      direction := lua_tointeger(L,7);
      loop := lua_tointeger(L,8);
      animation:=createanimation (sprite,width,height,startframe,endframe,timer,direction,loop);
      lua_pushinteger (L, animation);
      Result:=1;
    end
  else luaL_error(L, PChar('createanimation (sprite,width,height,startframe,endframe,timer,direction,loop)'),[]);
end;

function l_drawanimation (p:plua_state):integer;cdecl;
var xw,yw,angle:real;
    vflip,hflip:boolean;
	xscreen,yscreen,spriteanimation:integer;
begin
if (lua_gettop(L)=8) then
    begin
      spriteanimation := lua_tointeger(L,1);
      xscreen := lua_tointeger(L,2);
      yscreen := lua_tointeger(L,3);
      xw:= lua_tonumber(L,4);
      yw := lua_tonumber(L,5);
      angle := lua_tonumber(L,6);
      vflip := lua_toboolean(L,7);
      hflip := lua_toboolean(L,8);
      drawanimation (spriteanimation,xscreen,yscreen,xw,yw,angle,vflip,hflip);
      
      Result:=0;
    end
  else luaL_error(L, PChar('drawanimation (spriteanimation,xscreen,yscreen,xw,yw,angle,vflip,hflip)'),[]);
end;

function l_animationwidth (p:plua_state):integer;cdecl;
var spriteanimation,width:integer;
begin
if (lua_gettop(L)=1) then
  begin
	spriteanimation := lua_tointeger (L,1);
	width:=animationwidth (spriteanimation);
	lua_pushinteger (L, width);
	Result :=1;
 end
  else luaL_error(L, PChar('Usage: animationwidth (spriteanimation)'),[]);
end;

function l_animationheight (p:plua_state):integer;cdecl;
var spriteanimation,height:integer;
begin
if (lua_gettop(L)=1) then
  begin
	spriteanimation := lua_tointeger (L,1);
	height:=animationheight (spriteanimation);
	lua_pushinteger (L, height);
	Result :=1;
 end
  else luaL_error(L, PChar('Usage: animationhieght (spriteanimation)'),[]);
end;

function l_framenumber (p:plua_state):integer;cdecl;
var spriteanimation,frame:integer;
begin
if (lua_gettop(L)=1) then
  begin
	spriteanimation := lua_tointeger (L,1);
	frame:=framenumber (spriteanimation);
	lua_pushinteger (L, frame);
	Result :=1;
 end
  else luaL_error(L, PChar('Usage: framenumber (spriteanimation)'),[]);
end;

function l_setanimationspeed (p:plua_state):integer;cdecl;
var spriteanimation,speed:integer;
begin
if (lua_gettop(L)=2) then
  begin
	spriteanimation := lua_tointeger (L,1);
	speed := lua_tointeger (L,2);
	setanimationspeed (spriteanimation,speed);
	Result :=0;
 end
  else luaL_error(L, PChar('Usage: setanimationspeed (spriteanimation,speed)'),[]);
end;

function l_haltanimation (p:plua_state):integer;cdecl;
var spriteanimation:integer;
begin
if (lua_gettop(L)=1) then
  begin
	spriteanimation := lua_tointeger (L,1);
	haltanimation (spriteanimation);
	Result :=0;
 end
  else luaL_error(L, PChar('Usage: haltanimation (spriteanimation)'),[]);
end;

function l_animationstopped (p:plua_state):integer;cdecl;
var spriteanimation:integer;
	value:boolean;
begin
if (lua_gettop(L)=1) then
  begin
	spriteanimation := lua_tointeger (L,1);
	value:= animationstopped (spriteanimation);
	lua_pushboolean (L, value);
	Result :=1;
 end
  else luaL_error(L, PChar('Usage: animationstopped (spriteanimation)'),[]);
end;

function l_setanimationloop (p:plua_state):integer;cdecl;
var spriteanimation,loop:integer;
begin
if (lua_gettop(L)=2) then
  begin
	spriteanimation := lua_tointeger (L,1);
	loop := lua_tointeger (L,2);
	setanimationloop (spriteanimation,loop);
	Result :=0;
 end
  else luaL_error(L, PChar('Usage: setanimationloop (spriteanimation,loop)'),[]);
end;

function l_bmpfont (p:plua_state):integer;cdecl;
var xw,yw:integer;
	fontface:ansistring;
	fontnumber:integer;
	image:p2dsprite;
begin
  if (lua_gettop(L)=4) then
  begin
    image :=lua_touserdata(L,1);
    xw:=lua_tointeger (L, 2);
    yw:=lua_tointeger (L, 3);
    fontface :=lua_tostring (L,4);
    fontnumber:=createbmpfont (image,xw,yw,fontface);
    lua_pushinteger(L,fontnumber);
    Result:=1;
  end
  else luaL_error(L, PChar('Usage: createbmpfont (sprite,tilewidth,tileheight,fontface)'),[]);
end;

function l_tileset (p:plua_state):integer;cdecl;
var xw,yw:integer;
	fontface:ansistring;
	fontnumber:integer;
	image:p2dsprite;
begin
  if (lua_gettop(L)=4) then
  begin
    image :=lua_touserdata(L,1);
    xw:=lua_tointeger (L, 2);
    yw:=lua_tointeger (L, 3);
    fontface :=lua_tostring (L,4);
    fontnumber:=createbmpfont (image,xw,yw,fontface);
    lua_pushinteger(L,fontnumber);
    Result:=1;
  end
  else luaL_error(L, PChar('Usage: tileset (sprite,tilewidth,tileheight,fontface)'),[]);
end;

function l_drawtile (p:plua_state):integer;cdecl;
var xspace,yspace,fontnumber:integer;
	textstr:ansistring;
begin
  if (lua_gettop(L)=4) then
  begin
    xspace :=lua_tointeger(L,2);
    yspace:=lua_tointeger (L, 3);
    textstr:=lua_tostring (L, 1);
    fontnumber :=lua_tointeger (L,4);
    bmptext (textstr,xspace,yspace,fontnumber);
    Result:=0;
  end
  else luaL_error(L, PChar('Usage: drawtile (textstr,x,y,tileset)'),[]);
end;

function l_bmptext (p:plua_state):integer;cdecl;
var xspace,yspace,fontnumber:integer;
	textstr:ansistring;
begin
  if (lua_gettop(L)=4) then
  begin
    xspace :=lua_tointeger(L,2);
    yspace:=lua_tointeger (L, 3);
    textstr:=lua_tostring (L, 1);
    fontnumber :=lua_tointeger (L,4);
    bmptext (textstr,xspace,yspace,fontnumber);
    Result:=0;
  end
  else luaL_error(L, PChar('Usage: bmptext (textstr,x,y,fontnumber)'),[]);
end;

function l_bmpinputcolor (p:plua_state):integer;cdecl;
var r,g,b,alpha,fontnumber:integer;
begin
  if (lua_gettop(L)=5) then
  begin
    fontnumber :=lua_tointeger(L,1);
    r:=lua_tointeger (L, 2);
    g:=lua_tointeger (L, 3);
    b :=lua_tointeger (L,4);
    alpha :=lua_tointeger (L,5);
    bmpinputcolor (fontnumber,r,g,b,alpha);
    Result:=0;
  end
  else luaL_error(L, PChar('Usage: bmpinputcolor (fontnumber,r,g,b,alpha)'),[]);
end;

function l_bmpinputbackcolor (p:plua_state):integer;cdecl;
var r,g,b,alpha,fontnumber:integer;
begin
  if (lua_gettop(L)=5) then
  begin
    fontnumber :=lua_tointeger(L,1);
    r:=lua_tointeger (L, 2);
    g:=lua_tointeger (L, 3);
    b :=lua_tointeger (L,4);
    alpha :=lua_tointeger (L,5);
    bmpinputbackcolor (fontnumber,r,g,b,alpha);
    Result:=0;
  end
  else luaL_error(L, PChar('Usage: bmpinputbackcolor (fontnumber,r,g,b,alpha)'),[]);
end;

function l_bmpfontsize (p:plua_state):integer;cdecl;
var fontnumber,width,height:integer;
begin
  if (lua_gettop(L)=3) then
  begin
    fontnumber :=lua_tointeger(L,1);
    width:=lua_tointeger (L, 2);
    height:=lua_tointeger (L, 3);
    bmpfontsize (fontnumber,width,height);
    Result:=0;
  end
  else luaL_error(L, PChar('Usage: bmpfontsize (fontnumber,width,height)'),[]);
end;

function l_bmpfontangle (p:plua_state):integer;cdecl;
var fontnumber:integer;
	angle:real;
begin
  if (lua_gettop(L)=2) then
  begin
    fontnumber :=lua_tointeger(L,1);
    angle:=lua_tonumber (L, 2);
    bmpfontangle (fontnumber,angle);
    Result:=0;
  end
  else luaL_error(L, PChar('Usage: bmpfontangle (fontnumber,angle)'),[]);
end;

function l_bmpinput (p:plua_state):integer;cdecl;
var inpx,inpy,maxlen,fontnumber:integer;
	textstr:ansistring;
begin
  if (lua_gettop(L)=4) then
  begin
    inpx :=lua_tointeger(L,1);
    inpy:=lua_tointeger (L, 2);
    maxlen:=lua_tointeger (L, 3);
    fontnumber :=lua_tointeger (L,4);
    textstr:=bmpinput (inpx,inpy,maxlen,fontnumber);
    lua_pushstring (L,textstr);
    Result:=1;
  end
  else luaL_error(L, PChar('Usage: bmpinput (x,y,maxlen,fontnumber)'),[]);
end;

function l_bmpfontwidth (p:plua_state):integer;cdecl;
var fontnumber,width:integer;
begin
if (lua_gettop(L)=1) then
  begin
	fontnumber := lua_tointeger (L,1);
	width:=bmpfontwidth (fontnumber);
	lua_pushinteger (L, width);
	Result :=1;
 end
  else luaL_error(L, PChar('Usage: bmpfontwidth (fontnumber)'),[]);
end;

function l_bmpfontheight (p:plua_state):integer;cdecl;
var fontnumber,height:integer;
begin
if (lua_gettop(L)=1) then
  begin
	fontnumber := lua_tointeger (L,1);
	height:=bmpfontheight (fontnumber);
	lua_pushinteger (L, height);
	Result :=1;
 end
  else luaL_error(L, PChar('Usage: bmpfontheight (fontnumber)'),[]);
end;

function l_imagecoll (p:plua_state):integer;cdecl;
var ax,ay,bx,by:integer;
	ImageA,ImageB:p2dsprite;
    collision:boolean;
begin
if (lua_gettop(L)=6) then
    begin
      ImageA:=Lua_touserdata (L,1);
      ax := lua_tointeger (L,2);
      ay := lua_tointeger (L,3);
      ImageB := lua_touserdata (L,4);
      bx := lua_tointeger (L,5);
      by := lua_tointeger (L,6);
      collision:=ImageColl (ImageA,ax,ay,ImageB,bx,by);
      lua_pushboolean (L,collision);
      Result:=1;
    end
  else luaL_error(L, PChar('Usage: imagecoll (SpriteA,ax,ay,SpriteB,bx,by)'),[]);
end;

function l_circlecoll (p:plua_state):integer;cdecl;
var x1,y1,r1,x2,y2,r2,offset:integer;
	collision:boolean;
begin
if (lua_gettop(L)=7) then
    begin
      x1:=lua_tointeger (L,1);
      y1 := lua_tointeger (L,2);
      r1 := lua_tointeger (L,3);
      x2 := lua_tointeger (L,4);
      y2 := lua_tointeger (L,5);
      r2 := lua_tointeger (L,6);
      offset:=lua_tointeger (L,7);
      collision:=circlecoll (x1,y1,r1,x2,y2,r2,offset);
      lua_pushboolean (L,collision);
      Result:=1;
    end
  else luaL_error(L, PChar('Usage: circlecoll (x1,y1,r1,x2,y2,r2,offset)'),[]);
end;

function l_circletoboxcoll (p:plua_state):integer;cdecl;
var cx,cy,r,x1,y1,w,h:integer;
	collision:boolean;
begin
if (lua_gettop(L)=7) then
    begin
      cx:=lua_tointeger (L,1);
      cy := lua_tointeger (L,2);
      r := lua_tointeger (L,3);
      x1 := lua_tointeger (L,4);
      y1 := lua_tointeger (L,5);
      w := lua_tointeger (L,6);
      h :=lua_tointeger (L,7);
      collision:=circletoboxcoll (cx,cy,r,x1,y1,w,h);
      lua_pushboolean (L,collision);
      Result:=1;
    end
  else luaL_error(L, PChar('Usage: circletoboxcoll (cx,cy,r,x1,y1,w,h)'),[]);
end;

function l_linetocirclecoll (p:plua_state):integer;cdecl;
var LineX1,LineY1,LineX2,LineY2, CircleX,CircleY,CircleRadius: double;
	collision:boolean;
begin
if (lua_gettop(L)=7) then
    begin
      LineX1:=lua_tonumber (L,1);
      LineY1 := lua_tonumber (L,2);
      LineX2 := lua_tonumber (L,3);
      LineY2 := lua_tonumber (L,4);
      CircleX := lua_tonumber (L,5);
      CircleY := lua_tonumber (L,6);
      CircleRadius :=lua_tonumber (L,7);
      collision:=LineHitsCircle (LineX1,LineY1,LineX2,LineY2, CircleX,CircleY,CircleRadius);
      lua_pushboolean (L,collision);
      Result:=1;
    end
  else luaL_error(L, PChar('Usage: linetocirclecoll (LineX1,LineY1,LineX2,LineY2, CircleX,CircleY,CircleRadius)'),[]);
end;


function l_linecoll (p:plua_state):integer;cdecl;
var a1x,a1y,a2x,a2y,b1x,b1y,b2x,b2y:integer;
	collision:boolean;
begin
if (lua_gettop(L)=8) then
    begin
      a1x:=lua_tointeger (L,1);
      a1y := lua_tointeger (L,2);
      a2x := lua_tointeger (L,3);
      a2y := lua_tointeger (L,4);
      b1x := lua_tointeger (L,5);
      b1y := lua_tointeger (L,6);
      b2x :=lua_tointeger (L,7);
      b2y :=lua_tointeger (L,8);
      collision:= intersect (a1x,a1y,a2x,a2y,b1x,b1y,b2x,b2y);
      lua_pushboolean (L,collision);
      Result:=1;
    end
  else luaL_error(L, PChar('Usage: linecoll (a1x,a1y,a2x,a2y,b1x,b1y,b2x,b2y)'),[]);
end;

function l_sidecoll (p:plua_state):integer;cdecl;
var x,y,w,h,dx,dy, rx, ry, rw, rh: integer;
	collision:ansistring;
begin
if (lua_gettop(L)=10) then
    begin
      x:=lua_tointeger (L,1);
      y := lua_tointeger (L,2);
      w := lua_tointeger (L,3);
      h := lua_tointeger (L,4);
      dx := lua_tointeger (L,5);
      dy := lua_tointeger (L,6);
      rx := lua_tointeger (L,7);
      ry := lua_tointeger (L,8);
      rw := lua_tointeger (L,9);
      rh := lua_tointeger (L,10);
      collision:= sidecoll (x,y,w,h,dx,dy, rx, ry, rw, rh);
      lua_pushstring (L,collision);
      Result:=1;
    end
  else luaL_error(L, PChar('Usage: sidecoll (x,y,w,h,dx,dy, rx, ry, rw, rh)'),[]);
end;

function l_roundcoll (p:plua_state):integer;cdecl;
var ax,ay,bx,by,offset:integer;
	ImageA,ImageB:p2dsprite;
    collision:boolean;
begin
if (lua_gettop(L)=7) then
    begin
      ImageA:=Lua_touserdata (L,1);
      ax := lua_tointeger (L,2);
      ay := lua_tointeger (L,3);
      ImageB := lua_touserdata (L,4);
      bx := lua_tointeger (L,5);
      by := lua_tointeger (L,6);
      offset:=lua_tointeger (L,7);
      collision:=roundcoll (ImageA,ax,ay,ImageB,bx,by,offset);
      lua_pushboolean (L,collision);
      Result:=1;
    end
  else luaL_error(L, PChar('Usage: collision=roundcoll (SpriteA,ax,ay,SpriteB,bx,by,offset)'),[]);
end;


function l_open (p:plua_state):integer;cdecl;
var filename,switch:ansistring;
begin
  if (lua_gettop(L)=2) then
  begin
	inc (fileindex);
	SetLength (userfile, fileindex+1);
    filename :=lua_tostring(L,1);
    switch := lua_tostring(L,2);
    assign (userfile[fileindex], filename);
    
    if ansiuppercase(switch)='R' then
    begin
    {$I-}  
    reset (userfile[fileindex]);
    {$I+}
    end;
    if ansiuppercase(switch)='W' then
    begin
    {$I-}  
    rewrite (userfile[fileindex]);
    {$I+}
    end;
    if ansiuppercase(switch)='A' then
    begin
    {$I-}  
    append (userfile[fileindex]);
    {$I+}
    end;
    
    If (IOResult <> 0) then
		Begin
		Messagebox(1,'Error','File not found: '+filename);
		closeapplication;
		halt;
	End 
	Else 
	Begin
    lua_pushinteger (L, fileindex);
    Result:=1;
    end;
  end
  else luaL_error(L, PChar('Usage: open (file, "r/w/a")'),[]);
end;

function l_close (p:plua_state):integer;cdecl;
var index:integer;
begin
  if (lua_gettop(L)=1) then
  begin
    index :=lua_tointeger(L,1);
    close (userfile[index]);
	Result:=0;
  end
  else luaL_error(L, PChar('Usage: close (file)'),[]);
end;

function l_fprint (p:plua_state):integer;cdecl;
var index:integer;
	str:ansistring;
begin
  if (lua_gettop(L)=2) then
  begin
    index :=lua_tointeger(L,1);
    str:= lua_tostring (L,2);
    writeln (userfile[index],str);
	Result:=0;
  end
  else luaL_error(L, PChar('Usage: fprint (file, text)'),[]);
end;

function l_eof (p:plua_state):integer;cdecl;
var filestate:boolean;
index:integer;
begin
  if (lua_gettop(L)=1) then
  begin
    index :=lua_tointeger(L,1);
	filestate:=eof(userfile[index]);
	lua_pushboolean (L,filestate);
	result:=1;
   end
   else luaL_error(L, PChar('Usage: eof (file)'),[]);
end;

function l_eoln (p:plua_state):integer;cdecl;
var filestate:boolean;
index:integer;
begin
  if (lua_gettop(L)=1) then
  begin
    index :=lua_tointeger(L,1);
	filestate:=eoln(userfile[index]);
	lua_pushboolean (L,filestate);
	result:=1;
   end
   else luaL_error(L, PChar('Usage: eoln (file)'),[]);
end;

function l_finput (p:plua_state):integer;cdecl;
var inp:ansistring;
var index:integer;
begin
  if (lua_gettop(L)=1) then
  begin
    index :=lua_tointeger(L,1);
    readln (userfile[index],inp);
	lua_pushstring(L, inp);
    Result:=1;
  end
  else luaL_error(L, PChar('Usage: finput (file)'),[]);
end;

function l_fileexists (p:plua_state):integer;cdecl;
var filestate:boolean;
filename:ansistring;
begin
  if (lua_gettop(L)=1) then
  begin
    filename :=lua_tostring(L,1);
	filestate:=fileexists (filename);
	lua_pushboolean (L,filestate);
	result:=1;
   end
    else luaL_error(L, PChar('Usage: fileexists (file)'),[]);
end;

function l_directoryexists (p:plua_state):integer;cdecl;
var dirstate:boolean;
dirname:ansistring;
begin
  if (lua_gettop(L)=1) then
  begin
    dirname :=lua_tostring(L,1);
	dirstate:=directoryexists (dirname);
	lua_pushboolean (L,dirstate);
	result:=1;
   end
   else luaL_error(L, PChar('Usage: directoryexists (directory)'),[]);
end;

function l_makedir (p:plua_state):integer;cdecl;
var dirname:ansistring;
begin
  if (lua_gettop(L)=1) then
  begin
    dirname :=lua_tostring(L,1);
    try
    mkdir (dirname);
    except
		Messagebox(1,'Error','Error generating directory: '+dirname);
    end;
	Result:=0;
  end
  else luaL_error(L, PChar('Usage: makedir (dirname)'),[]);
end;

function l_removedir (p:plua_state):integer;cdecl;
var dirname:ansistring;
begin
  if (lua_gettop(L)=1) then
  begin
    dirname :=lua_tostring(L,1);
    try
    removedir (dirname);
    except
    Messagebox(1,'Error','Error removing directory: '+dirname);
    end;
	Result:=0;
  end
  else luaL_error(L, PChar('Usage: removedir (dirname)'),[]);
end;

function l_changedir (p:plua_state):integer;cdecl;
var dirname:ansistring;
begin
  if (lua_gettop(L)=1) then
  begin
    dirname :=lua_tostring(L,1);
    {$I-}
    chdir (dirname);
	if IOresult<>0 then
	begin
    Messagebox(1,'Error','Error changing to directory: '+dirname);
    end;
    {$I+}
	Result:=0;
  end
  else luaL_error(L, PChar('Usage: changedir (dirname)'),[]);
end;

function l_deletefile (p:plua_state):integer;cdecl;
var filename:ansistring;
begin
  if (lua_gettop(L)=1) then
  begin
    filename :=lua_tostring(L,1);
    try
    deletefile (filename);
    except
    Messagebox(1,'Error','Error removing file: '+filename);
    end;
	Result:=0;
  end
  else luaL_error(L, PChar('Usage: deletefile (filename)'),[]);
end;

function l_system (p:plua_state):integer;cdecl;
var filename,output:ansistring;
 AProcess: TProcess;
  AStringList: TStringList;
begin
  if (lua_gettop(L)=1) then
  begin
    filename :=lua_tostring(L,1);
   AProcess := TProcess.Create(nil);
   AStringList := TStringList.Create;
   AProcess.CommandLine := filename;
   //AProcess.Executable := filename;
   AProcess.Options := AProcess.Options + [poWaitOnExit, poUsePipes];
   AProcess.Execute;
  AStringList.LoadFromStream(AProcess.Output);
  output:=AStringList.text;
  AStringList.Free;
  AProcess.Free;   
    lua_pushstring (L,output);
	Result:=1;
  end
  else luaL_error(L, PChar('Usage: system (filename)'),[]);
end;

function l_createparticles (p:plua_state):integer;cdecl;
var px,py,number,cycle, red,green,blue,alpha:integer;
begin
if (lua_gettop(L)=8) then
	begin	
		px:=lua_tointeger(L,1);
		py:=lua_tointeger(L,2);
		number:=lua_tointeger(L,3);
		cycle:=lua_tointeger(L,4);
		red:=lua_tointeger(L,5);
		green:=lua_tointeger(L,6);
		blue :=lua_tointeger(L,7);
		alpha :=lua_tointeger(L,8);
		CreateParticles (px,py,number,cycle, red,green,blue,alpha);
		Result:=0;
	end
	else luaL_error(L, PChar('Usage: createparticles (px,py,number,cycle, red,green,blue)'),[]);
end;

function l_updateparticles (p:plua_state):integer;cdecl;
begin
  UpdateParticles;
  Result:=0;
end;

function l_resetparticles (p:plua_state):integer;cdecl;
begin
  ResetParticles;
  Result:=0;
end;

function l_setparticlesize (p:plua_state):integer;cdecl;
var size:integer;
	flag:ansistring;
begin
  if (lua_gettop(L)=2) then
    begin
      size:=lua_tointeger(L,1);
      flag:=lua_tostring (L,2);
      if ansiuppercase (flag)='RANDOM' then begin
		setparticlesize (size, random);
	end
	else if ansiuppercase (flag)='NORMAL' then begin
		setparticlesize (size, normal);
	end;
      
      Result:=0;
    end
   else luaL_error(L, PChar('Usage: setparticlesize (size, "flag")'),[]);  
end;

function l_setparticletype (p:plua_state):integer;cdecl;
var typus:ansistring;
begin
  if (lua_gettop(L)=1) then
    begin
      typus:=lua_tostring (L,1);
      if ansiuppercase (typus)='FILLCIRCLE' then begin
		setparticletype (ptFillcircle)
	end
	else if ansiuppercase (typus)='CIRCLE' then begin
		setparticletype (ptCircle)
	end
      else if ansiuppercase (typus)='FILLBOX' then begin
		setparticletype (ptFillbox)
	end
	  else if ansiuppercase (typus)='BOX' then begin
		setparticletype (ptBox)
	end
	 else if ansiuppercase (typus)='DOT' then begin
		setparticletype (ptDot)
	end
	 else if ansiuppercase (typus)='IMAGE' then begin
		setparticletype (ptImage)
	end;
      Result:=0;
    end
   else luaL_error(L, PChar('Usage: setparticletype ("type")'),[]);  
end;

function l_setparticleimage (p:plua_state):integer;cdecl;
var srcimage:p2dsprite;
begin
  if (lua_gettop(L)=1) then
    begin
      srcimage := lua_touserdata(L,1);
      SetParticleImage (srcimage);      
      Result:=0;
    end
  else luaL_error(L, PChar('Usage: setparticleimage (image)'),[]);  
end;

// *********************************************************************
//main program starts here
// *********************************************************************
begin
DefaultFormatSettings.DecimalSeparator:='.';

arguments:='';
randomize;
isbound:=false;
//if ParamCount < 1 then 
//begin
    //Get the exe name.
          exename := ParamStr(0);
          prog:=' ';
          tag:='';
          lin:='';
         //Check for bind tag at end of file. Should be 'pu2dbind' + egsl filesize + padding (20 chars total).
         try
           AssignFile(fin, exename);
           FileMode := fmOpenRead;
           Reset(fin,1);
           size := FileSize(fin);
           //calc the tag start position
           offset := size - 20;
           Seek(fin, offset);
           //get the tag info
           while not eof(fin) do begin
             Read(fin, bread);
             tag := tag + Char(bread);
           end;
           //Do we have a tag?
           if Pos('pu2dbind', tag) > 0 then begin
             //get the offset of the source code
             isbound:=true;
             tmp := RightStr(tag, 12);
             tmp := Trim(tmp);
             
             offset := StrToInt(tmp);
             //Make sure we have a valid offset
             if offset > 0 then begin
               Reset(fin);
               //Seek to source code position
               Seek(fin, offset);
               //load source code. Lines delimited by linefeed (10)
               for i := offset to size - 20 do begin
                 Read(fin, bread);
                 lin := lin + Char(bread);
                 //look for line delimiter
                 if bread = 10 then begin
                   //trim any spaces
                   wlin := Trim(lin);
                   //copy the current line of source to the string prog
                   // (fortunately an ansistring in Pascal has no size limit ...)
                 
                 prog:=prog+Decrypt(wlin,my_key)+#10;
                   //clear input line
                   
                   lin := '';
                  end;
                   
                 end;
               end;
             end;
             
                       
	finally
        CloseFile(fin);
      end;
	
          
  if (ParamCount<1) and (isbound = false) then
	begin
	Messagebox(1,'No Script','PulsarLua interpreter '+VERSION+#10+'Usage: pulsarlua[.exe] script.lua');
	halt;
      end;

for j:=0 to ParamCount do
	begin
		arguments:=arguments+ParamStr(j)+' ';
		
end;


script := pChar(ParamStr(1));
if isbound = false then begin
	path:=ExtractFilePath(ParamStr(1));
end
else begin
path:=ExtractFilePath(ParamStr(0));
end;
chdir (path);

  L:=luaL_newstate();
  luaL_openlibs(L);
  
//now we will register our functions
  lua_register (L, 'openwindow', l_openwindow);
  lua_register (L, 'setactivewindow', l_setactivewindow);
  lua_register (L, 'closeapplication', l_closeapplication);
  lua_register (L, 'wait', l_wait);
  lua_register (L, 'color', l_colour);
  lua_register (L, 'redraw', l_redraw);
  lua_register (L, 'circle', l_circle);
  lua_register (L, 'clearwindow', l_clearscreen);
  lua_register (L, 'cls', l_clearscreen);
  lua_register (L, 'closewindow', l_closewindow);
  lua_register (L, 'backcolor', l_backcolour);
  lua_register (L, 'inkey',l_inkey);
  lua_register (L, 'dot',l_dot);
  lua_register (L, 'line',l_line);
  lua_register (L, 'getkey',l_getkey);
  lua_register (L, 'fillcircle',l_fillcircle);
  lua_register (L, 'mousex', l_mousex);
  lua_register (L, 'mousey', l_mousey);
  lua_register (L, 'mousebutton', l_mouseb);
  lua_register (L, 'ellipse', l_ellipse);
  lua_register (L, 'fillellipse', l_fillellipse);
  lua_register (L, 'loadimage',l_loadimage);
  lua_register (L, 'mousehide',l_mousehide);
  lua_register (L, 'mouseshow',l_mouseshow);
  lua_register (L, 'hidemouse',l_mousehide);
  lua_register (L, 'showmouse',l_mouseshow);
  
  lua_register (L, 'keystate',l_keystate);
  lua_register (L, 'timeleft',l_timeleft);
  lua_register (L, 'setframetimer',l_setframetimer);
  lua_register (L, 'colorkey', l_colourkey);
  lua_register (L, 'loadsound', l_loadsound);
  lua_register (L, 'playsound', l_playsound);
  lua_register (L, 'drawtext', l_drawtext);
  lua_register (L, 'mousezone', l_mousezone);
  lua_register (L, 'loadmusic', l_loadmusic);
  lua_register (L, 'playmusic', l_playmusic);
  lua_register (L, 'pausemusic', l_pausemusic);
  lua_register (L, 'resumemusic', l_resumemusic);
  lua_register (L, 'togglefullscreen', l_togglefullscreen);
  lua_register (L, 'spritewidth', l_spritewidth);
  lua_register (L, 'spriteheight', l_spriteheight);
  lua_register (L, 'nocolorkey', l_nocolourkey);
  lua_register (L, 'timerticks', l_timerticks);
  lua_register (L, 'ostype', l_ostype);

 lua_register (L, 'joystickplugged', l_joystickplugged);
  lua_register (L, 'getjoyx', l_getjoyx);
  lua_register (L, 'getjoyy', l_getjoyy);
  lua_register (L, 'getjoybutton', l_getjoybutton);
  lua_register (L, 'numberjoybuttons', l_numberjoybuttons);
  lua_register (L, 'setcaption', l_setcaption);
  lua_register (L, 'triangle', l_triangle);
  lua_register (L, 'filltriangle', l_filltriangle);
  lua_register (L, 'boxcoll', l_boxcoll);
  lua_register (L, 'rnd', l_rnd);
  lua_register (L, 'int', l_int);
  lua_register (L, 'chr', l_chr);
  lua_register (L, 'asc', l_asc);
  lua_register (L, 'val', l_val);
  lua_register (L, 'left', l_left);
  lua_register (L, 'right', l_right);
  lua_register (L, 'mid', l_mid);
  lua_register (L, 'insert', l_insert);
  lua_register (L, 'len', l_len);
  lua_register (L, 'time', l_time);
  lua_register (L, 'date', l_date);
  lua_register (L, 'uppercase', l_uppercase);
  lua_register (L, 'lowercase', l_lowercase);
  lua_register (L, 'input', l_input);
  lua_register (L, 'resizewindow', l_resizewindow);
  lua_register (L, 'arguments', l_arguments);
  lua_register (L, 'freeimage', l_freeimage);
  lua_register (L, 'windowwidth', l_windowwidth);
  lua_register (L, 'windowheight', l_windowheight);
  lua_register (L, 'bmptext', l_bmptext);
  lua_register (L, 'bmpinput', l_bmpinput);
  lua_register (L, 'createbmpfont', l_bmpfont);
  lua_register (L, 'sqrt', l_sqrt);
  lua_register (L, 'abs', l_abs);
  lua_register (L, 'cos', l_cos);
  lua_register (L, 'sin', l_sin);
  lua_register (L, 'exp', l_exp);
  lua_register (L, 'floor', l_floor);
  lua_register (L, 'ceil', l_ceil);
  lua_register (L, 'imagecoll', l_imagecoll);
  lua_register (L, 'circlecoll', l_circlecoll);
  lua_register (L, 'roundcoll', l_roundcoll);
  lua_register (L, 'sidecoll', l_sidecoll);
  lua_register (L, 'circletoboxcoll', l_circletoboxcoll);
  lua_register (L, 'linecoll', l_linecoll);
  lua_register (L, 'linetocirclecoll', l_linetocirclecoll);
  
  lua_register (L, 'sync', l_sync);
  lua_register (L, 'open', l_open);
  lua_register (L, 'close', l_close);
  lua_register (L, 'finput', l_finput);
  lua_register (L, 'eof', l_eof);
  lua_register (L, 'eoln', l_eof);
  lua_register (L, 'fprint', l_fprint);
  lua_register (L, 'fileexists', l_fileexists);
  lua_register (L, 'directoryexists', l_fileexists);
  lua_register (L, 'makedir', l_makedir);
  lua_register (L, 'removedir', l_removedir);
  lua_register (L, 'changedir', l_changedir);
  lua_register (L, 'deletefile', l_deletefile);
  lua_register (L, 'system', l_system);
  lua_register (L, 'insidetriangle', l_insidetriangle);
  lua_register (L, 'insiderectangle', l_insiderectangle);
  lua_register (L, 'insidecircle', l_insidecircle);
  
  lua_register (L, 'drawtile', l_drawtile);
  lua_register (L, 'tileset', l_tileset);
  
  lua_register (L, 'warpmouse', l_warpmouse);
   
  lua_register (L, 'bmpfontheight',l_bmpfontheight);
  lua_register (L, 'bmpfontwidth',l_bmpfontwidth);
  
  lua_register (L, 'rectangle',l_rectangle);
  lua_register (L, 'fillrectangle',l_fillrectangle);
  
  lua_register (L, 'round',l_round);
  
  lua_register (L, 'createsprite',l_createsprite);
  lua_register (L, 'freesprite',l_freesprite);
  lua_register (L, 'drawsprite',l_drawsprite);
  lua_register (L, 'loadsprite',l_loadsprite);
  lua_register (L, 'drawspritepart',l_drawspritepart);
  lua_register (L, 'spritecolor',l_spritecolour);
  lua_register (L, 'setvirtualsize',l_setvirtualsize);
  lua_register (L, 'bmpfontsize',l_bmpfontsize);
  lua_register (L, 'bmpinputcolor',l_bmpinputcolor);
  lua_register (L, 'bmpinputbackcolor',l_bmpinputbackcolor);
  lua_register (L, 'bmpfontangle',l_bmpfontangle);
  lua_register (L, 'textsize',l_textsize);
  lua_register (L, 'texttype',l_texttype);
  lua_register (L, 'textwidth',l_textwidth);
  lua_register (L, 'textheight',l_textheight);
  lua_register (L, 'textinputcolor',l_textinputcolor);
  lua_register (L, 'textinputbackcolor',l_textinputbackcolor);
  
  lua_register (L, 'messagebox',l_messagebox);
  lua_register (L, 'setscalequality',l_setscalequality);
  lua_register (L, 'seticon',l_seticon);
  lua_register (L, 'fullscreen',l_fullscreen);
  
  lua_register (L, 'fademusic',l_fademusic);
  lua_register (L, 'haltmusic',l_haltmusic);
  lua_register (L, 'freesound',l_freesound);
  lua_register (L, 'freemusic',l_freemusic);
  lua_register (L, 'updateanimations',l_updateanimations);
  lua_register (L, 'createanimation',l_createanimation);
  lua_register (L, 'drawanimation',l_drawanimation);
  lua_register (L, 'animationheight',l_animationheight);
  lua_register (L, 'animationwidth',l_animationwidth);
  lua_register (L, 'framenumber',l_framenumber);
  lua_register (L, 'setanimationspeed',l_setanimationspeed);
  lua_register (L, 'setanimationloop',l_setanimationloop);
  lua_register (L, 'haltanimation',l_haltanimation);
  lua_register (L, 'animationstopped',l_animationstopped);
    
  lua_register (L, 'createparticles',l_createparticles);
  lua_register (L, 'updateparticles',l_updateparticles);
  lua_register (L, 'setparticlesize',l_setparticlesize);
  lua_register (L, 'setparticletype',l_setparticletype);
  lua_register (L, 'setparticleimage',l_setparticleimage);
  lua_register (L, 'resetparticles',l_resetparticles);
  
      
//execute the script 

if isbound = true then 
begin
	if	luaL_dostring (L,PChar(prog))<>0 then
	begin
	//show if an error occured
	Messagebox(1,'Error',lua_tostring (L,-1));
	closeapplication;
	halt;
	end;

end
else
  if (luaL_dofile(L, script))<>0 then 
   begin
//show if an error occured
	Messagebox(1,'Error',lua_tostring (L,-1));
	closeapplication;
	halt;
  end;
  lua_close(L);
end.
