{ 
	* makeexe - the binder for EGSL and Pulsar2D
	* thanks to Rick for the code
	* original source can be found on:
	* http://forum.basicprogramming.org/index.php/topic,1101.msg6579.html#msg6579
	
}

program makeexe;

uses
  SysUtils;

var
  fvm, fsource, fexe: string;


procedure bind;
var
   fin, fout: file of Byte;
   bread: Byte;
   vmsize, size: Longint;
   i: integer;
   faname, fsname, foutname: string;
   tag: string;
begin
   //get the egsl path
   faname := fvm;
   //get the source path
   fsname := fsource;
   //get the output file name
   foutname := fexe;
   //copy over the runtime
   if (Length(faname) > 0) and (Length(foutname) > 0 ) and (Length(fsname) > 0 ) then begin
      try
        //open the interpreter
        AssignFile(fin, faname);
        Reset(fin);
        //get the file size
        size := FileSize(fin);
        vmsize := size;
        //create the out file.
        AssignFile(fout, foutname);
        Rewrite(fout);
        writeln('Writing Pulsar2D...');
        while not eof(fin) do begin
          Read(fin, bread);
          Write(fout, bread);
        end;
        CloseFile(fin);
        //open the source
        AssignFile(fin, fsname);
        Reset(fin);
        //get the file size
        size := FileSize(fin);
        //write out the source
        writeln('Writing Source...');
        while not eof(fin) do begin
          Read(fin, bread);
          Write(fout, bread);
        end;
        //Set the tag
        writeln('Writing Tag...');
        tag := 'pu2dbind' + IntToStr(vmsize);
        //pad the tag to 20 spaces
        tag := tag + StringOfChar(' ', 20 - Length(tag));
        //write out the tag
        for i := 1 to 20 do begin
          bread := Byte(tag[i]);
          Write(fout, bread);
        end;
        
        writeln('Done!');
      finally
        CloseFile(fin);
        CloseFile(fout);
      end;
   end;
end;

begin
    //get the command line parameters
    if ParamCount < 3 then begin
        
        writeln('ERROR: Not enough paramaters.');
        writeln('Usage: makeexe [path]/pulsarlua(.exe) [path]/source.lua [path]/outfile(.exe)');
    end
    else begin
        //get the comamnd line
        fvm := ParamStr(1);
        fsource := ParamStr(2);
        fexe := ParamStr(3);
        //validate the path and file names.
        if not FileExists(fvm) then begin
            
            writeln('Cannot find file ',fvm);
        end
        else begin
            if not FileExists(fsource) then begin
                
                writeln('Cannot find file ',fvm);
            end
            else begin
                bind;
            end;
        end;
    end;
end.
