{
   uParticle.pas
   
   Copyright 2012 Markus Mangold <info@retrogamecoding.org>
   
   
		This software is provided 'as-is', without any express or implied
		warranty. In no event will the authors be held liable for any damages
		arising from the use of this software.

		Permission is granted to anyone to use this software for any purpose,
		including commercial applications, and to alter it and redistribute it
		freely, subject to the following restrictions:

			1. The origin of this software must not be misrepresented; you must not
			claim that you wrote the original software. If you use this software
			in a product, an acknowledgment in the product documentation would be
			appreciated but is not required.

			2. Altered source versions must be plainly marked as such, and must not be
			misrepresented as being the original software.

			3. This notice may not be removed or altered from any source
			distribution.
   
}


Unit p2dparticles;

Interface
uses sysutils,p2dvideo,p2dhelper;

TYPE TPType = (ptDot, ptFillcircle, ptCircle, ptFillbox, ptBox, ptImage);
TYPE TSize = (Random, Normal);

procedure CreateParticles (px,py,number,cycle, red,green,blue,alpha:integer);
procedure UpdateParticles;
procedure SetParticleSize (size:integer;ranflag:TSize);
procedure SetParticleType (ptype : TPType);
procedure SetParticleImage (pimage:p2dsprite);
procedure ResetParticles;

Implementation

Type TParticle = record
    PosX :single;
    PosY :single;
    VelX :single;
    VelY :single;
    life :integer;
    size : integer;
    colorRed :integer;
    colorGreen :integer;
    colorBlue :integer;
    colorAlpha:integer;
End ;

var  ParticleQuantity, NewParticle, ParticleCounter,ParticleSize:integer;
	ParticleType: TPType;
	 ParticleKilledCounter :integer = 0;
     SingleParticle : array of TParticle;
	 ParticleImage:pointer;
	 SizeFlag : TSize;

procedure CreateParticles (px,py,number,cycle, red,green,blue,alpha:integer);
begin
NewParticle := number;
 ParticleQuantity := ParticleQuantity + NewParticle;
 SetLength (SingleParticle, ParticleQuantity+1);
 For ParticleCounter := (ParticleQuantity-(NewParticle-1)) to ParticleQuantity do begin
	with SingleParticle [ParticleCounter] do begin
		PosX := px;
		PosY := py;
		Life := round (rnd()*cycle);
 		VelX := ((rnd()*2)-1)/0.90;
		VelY := ((rnd()*2)-1)/0.90;
				
		case SizeFlag of
		Random: size := round (rnd*ParticleSize)+1;
		Normal: size := ParticleSize;
		end;
		colorRed := red;
		colorGreen := green;
		colorBlue := blue;
		colorAlpha:=alpha;
   end;
 end;
end;

procedure UpdateParticles;
begin
ParticleKilledCounter :=0 ;

For ParticleCounter := 1 to ParticleQuantity do begin
	with SingleParticle [ParticleCounter] do begin
		if life > 0 then begin
			PosX := PosX + VelX;
			PosY := PosY + VelY;
			VelX := VelX * 1.001;
			VelY := VelY * 1.001;
			dec (life);
		end
		else begin
		 PosX := SingleParticle [ParticleQuantity-ParticleKilledCounter].PosX;
         PosY := SingleParticle [ParticleQuantity-ParticleKilledCounter].PosY;
         life := SingleParticle [ParticleQuantity-ParticleKilledCounter].life;
         VelX := SingleParticle [ParticleQuantity-ParticleKilledCounter].VelX;
         VelY := SingleParticle [ParticleQuantity-ParticleKilledCounter].VelY;
         inc (ParticleKilledCounter );
		end;
	  color (colorRed,colorGreen,colorBlue,colorAlpha);
	  case ParticleType of
	  ptFillcircle:  fillcircle (round (PosX),round (PosY),Size);
	  ptCircle: circle (round (PosX),round (PosY),Size);
	  ptDot: dot (round (PosX),round (PosY));
	  ptBox : rectangle (round (PosX),round (PosY),size,size);
	  ptFillbox : fillrectangle (round (PosX),round (PosY),size,size);
	  ptImage : drawsprite (ParticleImage,round (PosX),round (PosY),0.9+size/10,0.9+size/10,0,false,false);
	  end;
	 end;
end;
ParticleQuantity := ParticleQuantity - ParticleKilledCounter;
Setlength (SingleParticle, ParticleQuantity+1);
end;

procedure SetParticleSize (size:integer;ranflag:TSize);
begin
	ParticleSize:=size;
	SizeFlag:=ranflag;
end;

procedure SetParticleType (ptype : TPType);
begin
  ParticleType := ptype;
end;

procedure SetParticleImage (pimage:p2dsprite);
begin
 ParticleImage :=pimage;
end;

procedure ResetParticles;
begin
ParticleQuantity := 0;
Setlength (SingleParticle, ParticleQuantity+1);
end;

BEGIN
	ParticleQuantity:=0;
	ParticleSize:=2;
	SizeFlag:=Random;
	ParticleType := ptFillcircle;
END.

