{
   p2dinput.pas
   
   Copyright 2013 Markus Mangold <info@retrogamecoding.org>
   
   
		This software is provided 'as-is', without any express or implied
		warranty. In no event will the authors be held liable for any damages
		arising from the use of this software.

		Permission is granted to anyone to use this software for any purpose,
		including commercial applications, and to alter it and redistribute it
		freely, subject to the following restrictions:

			1. The origin of this software must not be misrepresented; you must not
			claim that you wrote the original software. If you use this software
			in a product, an acknowledgment in the product documentation would be
			appreciated but is not required.

			2. Altered source versions must be plainly marked as such, and must not be
			misrepresented as being the original software.

			3. This notice may not be removed or altered from any source
			distribution.
   
}

unit p2dinput;

Interface
uses 
{$IFDEF Windows}
  Windows,
{$ENDIF}

sysutils,
p2dvideo,SDL2;

Function inkey:char;
Function GetKey : integer;
Function mousex:integer;
Function mousey:integer;
Function mousebutton:integer;
function keystate (key:Integer):boolean;
procedure showmouse;
procedure hidemouse;
procedure warpmouse (x,y:integer);
function JoystickPlugged:Boolean;
function GetJoystickX:Integer;
function GetJoystickY:Integer;
function GetJoystickButton(button:integer):Integer;
function NumberJoyButtons:Integer;
function mousezone (x1,y1,x2,y2:integer):boolean;

Implementation

type PKeyStateArr = ^TKeyStateArr;
  TKeyStateArr = array[0..65000] of UInt8;

//waits until key pressed
Function inkey:char;
var ch:integer;
	event:TSDL_Event;
Begin
	repeat
	SDL_Delay(3);
	if (event.type_ = SDL_QUITEV) then
	    begin
	      SDL_Quit();
	      halt;
	   end;   
  	until ( (SDL_PollEvent( @event ) <> 0) and ((event.key.type_ = SDL_KEYDOWN)));
  ch := Event.key.keysym.sym;
  result :=char(ch);
end;

//doesn't wait for key press
Function GetKey : integer;
var ch: integer;
	event:TSDL_event;
Begin
  	while (SDL_PollEvent( @event ) <> 0) do
	  begin
	  if (event.type_ = SDL_QUITEV) then
	    begin
	      SDL_Quit();
	      halt;
	   end;   
	  if (event.key.type_ = SDL_KEYDOWN) then
  		begin
		
  		ch := Event.key.keysym.scancode;

		result := ch;
		end;
      end;
  end	;

//x-coordinates of mouse     
Function mousex:integer;
var mx,my:integer;
begin

  SDL_Pumpevents();
  SDL_GetMouseState (@mx,@my);
  result :=mx;
end;

//y-coordinates of mouse
Function mousey:integer;
var mx,my:integer;
begin
    SDL_Pumpevents();
    SDL_GetMouseState (@mx,@my);
    result:=my;
end;

//hides mouse cursor - important with setvirtualsize
procedure hidemouse;
begin
SDL_ShowCursor (0);
end;

//shows mouse cursor again
procedure showmouse;
begin
SDL_ShowCursor (1);
end;

//warps mouse cursor to x- and y-coordinates
procedure warpmouse (x,y:integer);
begin
SDL_WarpMouseInWindow (SDL_GetWindowFromID(activewindow),x,y);
end;

//check mouse button
Function mousebutton:integer;
var mb:integer;
begin
	SDL_Pumpevents();
    IF (SDL_GetMouseState (nil,nil) and SDL_BUTTON_LMASK)  <> 0  then begin
    mb:=1;
    end
    else IF (SDL_GetMouseState (nil,nil) and SDL_BUTTON_MMASK) <>0 then begin
    mb:=2;
    end
    else IF (SDL_GetMouseState (nil,nil) and SDL_BUTTON_RMASK) <> 0 then begin
    mb:=3;
    end
    else mb:=0;
    result:=mb;
end;

// check if certain key is pressed
function keystate (key:integer):boolean;
var state:pkeystatearr;
begin
  SDL_Pumpevents();
  state:=pkeyStateArr(SDL_Getkeyboardstate(nil));
  if state[key]<>0 then
  begin
  Result:=True;
  end
  else
  Result:=False;
end;

function JoystickPlugged:Boolean;
begin
  if SDL_JoystickGetAttached(joystick)=SDL_TRUE then
    Result:=True
    else
    Result:=False;
end;

function GetJoystickX:Integer;
begin
  if SDL_JoystickGetAttached(joystick)=SDL_TRUE then begin
 Result:=SDL_JoystickGetAxis( joystick, 0 );
  end
  else Result:=0;
end;

function GetJoystickY:Integer;
begin
if SDL_JoystickGetAttached(joystick)=SDL_TRUE then begin
 Result:=SDL_JoystickGetAxis( joystick, 1 );
  end
  else Result:=0;
end;

function GetJoystickButton(button:integer):Integer;
begin
if SDL_JoystickGetAttached(joystick)=SDL_TRUE then begin
  Result:=SDL_JoystickGetButton(joystick,Button);
  end
  else Result:=0;
end;

function NumberJoyButtons:Integer;
begin
if SDL_JoystickGetAttached(joystick)=SDL_TRUE then begin
  Result:=SDL_JoystickNumButtons(joystick);
end
else Result:=0;
end;

//returns true if mouse is in rectangle x1,y1,x2,y2
function mousezone (x1,y1,x2,y2:integer):boolean;
begin
if (mousex >= x1) and (mousex<=x2) and (mousey>=y1) and (mousey<=y2) then
begin	
	result:=True;
end
else
begin
	result:=False;
end;
end;

Begin

End.
