{
   p2animation.pas
   
   Copyright 2013 Markus Mangold <info@retrogamecoding.org>
   
   
		This software is provided 'as-is', without any express or implied
		warranty. In no event will the authors be held liable for any damages
		arising from the use of this software.

		Permission is granted to anyone to use this software for any purpose,
		including commercial applications, and to alter it and redistribute it
		freely, subject to the following restrictions:

			1. The origin of this software must not be misrepresented; you must not
			claim that you wrote the original software. If you use this software
			in a product, an acknowledgment in the product documentation would be
			appreciated but is not required.

			2. Altered source versions must be plainly marked as such, and must not be
			misrepresented as being the original software.

			3. This notice may not be removed or altered from any source
			distribution.
   
}


Unit p2danimation;

Interface
uses sysutils,SDL2,p2dvideo;

TYPE p2danim = integer;

procedure updateanimations;
function createanimation (srcimage:p2dsprite;width,height,startframe,endframe,timer,direction,loop:integer):integer;
procedure drawanimation (spriteanimation,xscreen,yscreen:integer;xw,yw,angle:real;vflip,hflip:boolean);
function framenumber (spriteanimation:integer):integer;
procedure setanimationspeed (spriteanimation,speed:integer);
procedure setanimationloop (spriteanimation,loop:integer);
function animationheight (spriteanimation:integer):integer;
function animationwidth (spriteanimation:integer):integer;
procedure haltanimation (spriteanimation:integer);
function animationstopped (spriteanimation:integer):boolean;

Implementation

var now:integer;
   
TYPE animation = record
	lines,rows,width,height,timer,frame,direction : array of integer;
	index: integer;
	image : array of p2dsprite;
	ticker,nexttime,loop,startframe,endframe : array of integer;
end;

var spriteanim : animation;
	

procedure updateanimations;
var i:integer;
begin

if spriteanim.index > 0 then
		begin
		for i:= 0 to spriteanim.index-1 do
		begin
		now:= spriteanim.ticker[i];
		 inc (spriteanim.nexttime[i]);
		 
if now >= spriteanim.nexttime[i] + spriteanim.timer [i]  then begin
	spriteanim.nexttime[i]:=now;	  	
 if spriteanim.direction[i] > 0 then begin
	spriteanim.frame[i]:=spriteanim.frame[i] +  spriteanim.direction[i];
			
  if spriteanim.frame[i] > (spriteanim.endframe[i]) then begin
	spriteanim.frame[i]:=spriteanim.startframe[i];
   if spriteanim.loop[i]>0 then begin
	dec (spriteanim.loop[i]);
	end;
   end;
  end;
		  
 if spriteanim.direction[i] < 0 then begin
	spriteanim.frame[i]:=spriteanim.frame[i] +  spriteanim.direction[i];
  if spriteanim.frame[i] < spriteanim.startframe[i] then begin
	spriteanim.frame[i]:=spriteanim.endframe[i];
	
   if spriteanim.loop[i]>0 then begin
	dec (spriteanim.loop[i]);
   end;
  end;
 end;
end;
		spriteanim.ticker[i] := timerticks();	
end;
end;
end;

function createanimation (srcimage:p2dsprite;width,height,startframe,endframe,timer,direction,loop:integer):integer;
begin
inc (spriteanim.index);
	
	SetLength (spriteanim.image,spriteanim.index);
	SetLength (spriteanim.width,spriteanim.index);
	SetLength (spriteanim.height,spriteanim.index);
	SetLength (spriteanim.lines,spriteanim.index);
	SetLength (spriteanim.rows,spriteanim.index);
	SetLength (spriteanim.timer,spriteanim.index);
	SetLength (spriteanim.ticker,spriteanim.index);
	SetLength (spriteanim.frame,spriteanim.index);
	SetLength (spriteanim.direction,spriteanim.index);
	SetLength (spriteanim.nexttime,spriteanim.index);
	SetLength (spriteanim.loop,spriteanim.index);
	SetLength (spriteanim.startframe,spriteanim.index);
	SetLength (spriteanim.endframe,spriteanim.index);
	
	spriteanim.image[spriteanim.index-1] := srcimage;
	
	spriteanim.width[spriteanim.index-1] := width;
	spriteanim.height[spriteanim.index-1] := height;
	spriteanim.lines[spriteanim.index-1] := round (spriteheight (spriteanim.image[spriteanim.index-1])/height); 
	spriteanim.rows[spriteanim.index-1] :=  round (spritewidth (spriteanim.image[spriteanim.index-1])/width);
	spriteanim.timer[spriteanim.index-1] := timer;
	spriteanim.direction[spriteanim.index-1] := direction;
	spriteanim.startframe[spriteanim.index-1] := startframe;
	spriteanim.endframe[spriteanim.index-1] := endframe;
	if spriteanim.direction[spriteanim.index-1] > 0 then begin
	spriteanim.frame [spriteanim.index-1] := startframe;	
	end;
    if spriteanim.direction[spriteanim.index-1]  < 0 then begin
	spriteanim.frame [spriteanim.index-1] := endframe; //spriteanim.rows[spriteanim.index-1]*spriteanim.lines [spriteanim.index-1];	
	end;
	spriteanim.ticker[spriteanim.index-1] := timerticks();
	spriteanim.nexttime[spriteanim.index-1] := 0;
	spriteanim.loop[spriteanim.index-1]:= loop;
	if spriteanim.loop[spriteanim.index-1] >=0 then begin
			inc (spriteanim.loop[spriteanim.index-1]);
	end;
	
	result := spriteanim.index-1;
end;

function framenumber (spriteanimation:integer):integer;
var i:integer;
begin
if spriteanimation < spriteanim.index then begin
	i:=spriteanim.frame[spriteanimation];
	result:=i;
end
 else begin
 Messagebox (1,'Error','No animation available.');
  closeapplication;
  halt;
  end;
end;

function animationstopped (spriteanimation:integer):boolean;
begin
if spriteanimation < spriteanim.index then begin
	if spriteanim.loop[spriteanimation]=0 then begin
		result := true;
	end else begin
		result:=false;
	end;
end
 else begin
 Messagebox (1,'Error','No animation available.');
  closeapplication;
  halt;
  end;
end;

procedure setanimationspeed (spriteanimation,speed:integer);
begin
if spriteanimation < spriteanim.index then begin
	spriteanim.timer[spriteanimation]:=speed;
end
 else begin
 Messagebox (1,'Error','No animation available.');
  closeapplication;
  halt;
  end;
end;

procedure setanimationloop (spriteanimation,loop:integer);
begin
if spriteanimation < spriteanim.index then begin
	spriteanim.loop[spriteanimation]:=loop;
	if spriteanim.loop[spriteanimation] >=0 then begin
			inc (spriteanim.loop[spriteanimation]);
	end;
if spriteanim.direction[spriteanimation] > 0 then begin
	spriteanim.frame [spriteanimation] := spriteanim.startframe[spriteanimation]
	end;
    if spriteanim.direction[spriteanimation]  < 0 then begin
	spriteanim.frame [spriteanimation] := spriteanim.endframe[spriteanimation]; //spriteanim.rows[spriteanim.index-1]*spriteanim.lines [spriteanim.index-1];	
	end;
end
 else begin
 Messagebox (1,'Error','No animation available.');
  closeapplication;
  halt;
  end;
end;

procedure haltanimation (spriteanimation:integer);
begin
if spriteanimation < spriteanim.index then begin
	spriteanim.loop[spriteanimation]:=0;
	
if spriteanim.direction[spriteanimation] > 0 then begin
	spriteanim.frame [spriteanimation] := spriteanim.startframe[spriteanimation]
	end;
    if spriteanim.direction[spriteanimation]  < 0 then begin
	spriteanim.frame [spriteanimation] := spriteanim.endframe[spriteanimation]; //spriteanim.rows[spriteanim.index-1]*spriteanim.lines [spriteanim.index-1];	
	end;
end
 else begin
 Messagebox (1,'Error','No animation available.');
  closeapplication;
  halt;
  end;
end;

function animationwidth (spriteanimation:integer):integer;
begin
if spriteanimation < spriteanim.index then begin
	result:=spriteanim.width[spriteanimation];
	
end
 else begin
 Messagebox (1,'Error','No animation available.');
  closeapplication;
  halt;
  end;
end;

function animationheight (spriteanimation:integer):integer;
begin
if spriteanimation < spriteanim.index then begin
	result:=spriteanim.height[spriteanimation];
	
end
 else begin
 Messagebox (1,'Error','No animation available.');
  closeapplication;
  halt;
  end;
end;

procedure drawanimation (spriteanimation,xscreen,yscreen:integer;xw,yw,angle:real;vflip,hflip:boolean);
var x,i,xline,yrow:integer;
begin
if spriteanimation < spriteanim.index then begin
  i:=spriteanim.frame[spriteanimation];
  xline:=1;
  yrow:=0;
  x:=0;
  repeat
   yrow:=yrow + 1;
      
   if yrow > spriteanim.rows[spriteanimation] then
   begin
     xline:=xline+1;
     //x:=x+1;
     yrow:=1;
   end;
   
   if xline > spriteanim.lines[spriteanimation] then
   begin
    xline:=1;
    yrow:=yrow + 1;
   end;
     
   x:=x+1;
   until x>= i;
   
  if spriteanim.loop [spriteanimation] <> 0 then begin   
   drawspritepart (spriteanim.image[spriteanimation],xscreen,yscreen,(yrow-1)*spriteanim.width[spriteanimation],(xline-1)*spriteanim.height[spriteanimation],spriteanim.width[spriteanimation],spriteanim.height[spriteanimation],xw,yw,angle,vflip,hflip);
  end;
end
 else begin
 Messagebox (1,'Error','No animation available.');
  closeapplication;
  halt;
  end;
end;

begin

spriteanim.index:=0;
end.
