/'
'   p2dvideo.bi
'   
'   Copyright 2013-2015 Markus Mangold <info@retrogamecoding.org>
'   
'   
'		This software is provided 'as-is', without any express or implied
'		warranty. In no event will the authors be held liable for any damages
'		arising from the use of this software.
'
'		Permission is granted to anyone to use this software for any purpose,
'		including commercial applications, and to alter it and redistribute it
'		freely, subject to the following restrictions:
'
'			1. The origin of this software must not be misrepresented; you must not
'			claim that you wrote the original software. If you use this software
'			in a product, an acknowledgment in the product documentation would be
'			appreciated but is not required.
'
'			2. Altered source versions must be plainly marked as such, and must not be
'			misrepresented as being the original software.
'
'			3. This notice may not be removed or altered from any source
'			distribution.
'  
'/

#include once "p2dfontdata.bi"

' declaration

type bitmapfont
image (any) as p2d.sprite
width (any) as integer
height (any) as integer
lines (any) as integer 
rows (any) as integer
xfactor (any) as integer
yfactor (any) as integer
binpred (any) as integer
binpgreen (any) as integer
binpblue (any) as integer
binpalpha (any) as integer
inpred (any) as integer
inpgreen (any) as integer
inpblue (any) as integer
inpalpha (any) as integer
angle (any)as double
index as integer
face (any) as string
end type


dim shared TICK_INTERVAL as integer = 1000/100
dim next_time as UInteger = 0
dim shared activewindow as integer
dim shared bkr as integer=0,  bkg as integer=0, bkb as integer=0, bka as integer=255
dim shared ckr as integer =255, ckg as integer=0, ckb as integer=255

dim shared joystick as sdl_joystick ptr
dim shared fontsize as integer =1
dim shared fonttype as integer =1
dim shared colorkey as integer = true
dim shared fullscreenmode as integer= false
dim shared virtualsize as integer= false
dim shared bmpfont as bitmapfont
dim shared  tbred as integer=0, tbgreen as integer = 0, tbblue as integer = 0, tbalpha as integer = 255
dim shared tcred as integer=255 , tcgreen as integer = 255, tcblue as integer = 255, tcalpha as integer = 255

declare sub Messagebox (typus as integer,title as string,textmessage as string)
declare sub SetFrameTimer (frames as integer)
declare function timerticks as integer
declare sub closewindow (window as integer)
declare function openwindow (caption as string, x as integer, y as integer,w as integer, h as integer) as integer
declare sub setvirtualsize (w as integer,h as integer)
declare sub closeapplication()
declare sub setactivewindow (windowID as integer)
declare sub setscalequality (mode as string)
declare sub resizewindow (x as integer,y as integer)
declare function windowwidth() as long
declare function windowheight() as long
declare sub setcaption (caption as string)
declare sub seticon (icon as SDL_Surface ptr)
declare sub togglefullscreen()
declare function fullscreen as integer
declare sub color (rred as integer,ggreen as integer,bblue as integer,alpha as integer)
declare sub backcolor (rred as integer, ggreen as integer,bblue as integer,alpha as integer)
declare sub clearwindow

declare sub dot (x as integer, y as integer)
declare sub line (x1 as integer,y1 as integer,x2 as integer,y2 as integer)
declare sub fillrectangle (x as integer,y as integer,w as integer,h as integer)
declare sub rectangle (x as integer,y as integer,w as integer,h as integer)
declare sub Circle(xcenter as integer,ycenter as integer,radius as integer)
declare sub fillcircle(cx as integer,cy as integer,r as integer)
declare sub triangle (x1 as integer,y1 as integer,x2 as integer,y2 as integer,x3 as integer,y3 as integer)
declare sub filltriangle (xa as integer,ya as integer,xb as integer,yb as integer,xc as integer,yc as integer)
declare sub Ellipse(CX as long, CY as long, XRadius as long, YRadius as long)
declare sub fillellipse (xc as integer,yc as integer,wwidth as integer, hheight as integer)

declare sub textsize (tsize as integer)
declare sub texttype (ttype as integer)
declare sub drawchar (x as integer,y as integer,text as string)
declare sub drawtext (stri as string,x as integer,y as integer)
declare function textwidth (TextString as string) as integer
declare function textheight () as integer

declare sub redraw
declare sub wait (ms as integer)
declare function TimeLeft as UInt32
declare sub sync()

declare sub setcolorkey (rred as integer,ggreen as integer,bblue as integer)
declare sub nocolorkey
declare function loadimage (filename as string) as SDL_Surface ptr
declare sub freeimage (srcimage as SDL_Surface ptr)
declare sub freesprite (srcsprite as SDL_Texture ptr)
declare sub spritecolor  (tex as SDL_Texture ptr,rred as integer,ggreen as integer,bblue as integer,alpha as integer)
declare function createsprite (image as SDL_Surface ptr) as SDL_Texture ptr
declare function loadsprite (filename as string) as SDL_Texture ptr
declare sub drawsprite (sprite as SDL_Texture ptr, x as integer,y as integer,wwidth as double, hheight as double,angle as double, vflip as integer,hflip as integer)
declare sub drawspritepart (sprite as SDL_Texture ptr, x as integer, y as integer, startx as integer, starty as integer, xoffset as integer,_
yoffset as integer, wwidth as double, hheight as double, angle as double, vflip as integer,hflip as integer)
declare function spritewidth (sprite as SDL_Texture ptr) as integer
declare function spriteheight (sprite as SDL_Texture ptr) as integer

declare function createbmpfont (sprite as p2d.sprite, w as integer,h as integer, fontface as string) as integer
declare sub bmpfontsize (fontnumber as integer,xf as integer,yf as integer)
declare sub bmpfontangle (fontnumber as integer,angle as double)
declare function bmpfontwidth (fontnumber as integer) as integer
declare function bmpfontheight (fontnumber as integer) as integer
declare sub bmpinputbackcolor (fontnumber as integer,rred as integer,ggreen as integer,bblue as integer,alpha as integer)
declare sub bmpinputcolor (fontnumber as integer,rred as integer,ggreen as integer,bblue as integer,alpha as integer)
declare function bmpinput (fontnumber as integer, x as integer,y as integer,maxlen as integer) as string
declare sub bmptext (textstr as string,xspace as integer,yspace as integer,fontnumber as integer)

declare function input (x as integer,y as integer,maxlen as integer) as string
declare sub textinputbackcolor (rred as integer,ggreen as integer,bblue as integer,alpha as integer)
declare sub textinputcolor (rred as integer,ggreen as integer,bblue as integer,alpha as integer)

' implementation

' a simple mesage box
sub Messagebox (typus as integer,title as string,textmessage as string)
SDL_ShowSimpleMessageBox (typus, title, textmessage,null)
end sub

'sets the frame timer
sub SetFrameTimer (frames as integer)
 if frames = 0 then frames = 1
  TICK_INTERVAL =1000 / frames
end sub

'returns the passed ms by the start of the prgoram
function timerticks as integer
return  SDL_GetTicks
end function

function TimeLeft as UInt32
dim  now as UInt32
  now = SDL_GetTicks
  if next_time <= now then
     next_time = now + TICK_INTERVAL
    return 0
    
  end if
  return next_time - now
end function

sub sync()
redraw
wait (TimeLeft())
end sub

'closes the given window
sub closewindow (wind as integer)
	SDL_DestroyRenderer(SDL_GetRenderer (SDL_GetWindowFromID(wind)))
	SDL_DestroyWindow (SDL_GetWindowFromID (wind))
	fullscreenmode=false
end sub

'this opens a window and a connected renderer
function openwindow (caption as string, x as integer, y as integer,w as integer, h as integer) as integer
dim windowg as SDL_Window ptr 
dim renderer as SDL_Renderer ptr

if x<0 then 
	x= SDL_WINDOWPOS_CENTERED
end if
if y<0 then 
	y= SDL_WINDOWPOS_CENTERED
end if

windowg = SDL_CreateWindow (caption,x,y,w,h,SDL_WINDOW_SHOWN)

if (windowg = null) then 
	Messagebox(1,"Error","SDL_CreateWindow Error: "& SDL_GetError)
    SDL_Quit
	end
end if
renderer = SDL_CreateRenderer(windowg, -1, 0 )
	if (renderer = null) then 
		Messagebox(1,"Error","SDL_CreateRenderer Error: " & SDL_GetError)
		SDL_Quit
		end
end if
return SDL_GetWIndowID (windowg)
end function

'sets the virtualsize for the game
sub setvirtualsize (w as integer,h as integer)
 	SDL_RenderSetLogicalSize (SDL_GetRenderer (SDL_GetWindowFromID(activewindow)),w,h)
 	virtualsize =true
end sub

'helper function
function fullscreen as integer
	if fullscreenmode = true then 
		return true
	else 
		return false
	end if
end function

'toggles between fullscreen and windowed
sub togglefullscreen()
if fullscreenmode = false then 
	SDL_SetWindowFullscreen (SDL_GetWindowFromID(activewindow), SDL_WINDOW_FULLSCREEN_DESKTOP)
	fullscreenmode =true
else 
	SDL_SetWindowFullscreen (SDL_GetWindowFromID(activewindow), 0)
	fullscreenmode =false
end if
end sub

'resizes the given window
sub resizewindow (x as integer,y as integer)
 if not fullscreen() then 
  SDL_SetWindowSize (SDL_GetWindowFromID (activewindow),x,y)
 end if
end sub

'returns the width of the active window and keeps care of the virtual size
function windowwidth() as long
dim w as long,h as long
if virtualsize= true then 
	SDL_RenderGetLogicalSize (SDL_GetRenderer (SDL_GetWindowFromID(activewindow)),@w,@h)
else 
	SDL_GetWindowSize (SDL_GetWindowFromID (activewindow),@w,@h)
end if
return w
end function

'returns the height of the active window and keeps care of the virtual size
function windowheight() as long
dim w as long,h as long
if virtualsize= true then 
	SDL_RenderGetLogicalSize (SDL_GetRenderer (SDL_GetWindowFromID(activewindow)),@w,@h)
else
	SDL_GetWindowSize (SDL_GetWindowFromID (activewindow),@w,@h)
end if
return h
end function

'changes caption of active window
sub setcaption (caption as string)
SDL_SetWindowTitle(SDL_GetWindowFromID (activewindow), caption)
end sub

'sets an icon for the active window
sub seticon (icon as SDL_Surface ptr)
SDL_SetWindowIcon (SDL_GetWindowFromID (activewindow),icon)
end sub


'set render scale quality - look into SDL documentation
sub setscalequality (mode as string)
 SDL_SetHint (SDL_HINT_RENDER_SCALE_QUALITY, mode)
end sub

'shuts everything down
sub closeapplication()

	#ifdef useaudio
	MIX_HALTMUSIC
	MIX_CLOSEAUDIO
	#endif
	if SDL_JoystickGetAttached(joystick)=SDL_TRUE then 
	        SDL_JoystickClose(joystick)
	  end if
	IMG_Quit()
	SDL_Quit()
end sub

'drawing color
sub color (rred as integer,ggreen as integer,bblue as integer,alpha as integer)
SDL_SetRenderDrawBlendMode (SDL_GetRenderer (SDL_GetWindowFromID(activewindow)),SDL_BLENDMODE_BLEND)
SDL_SetRenderDrawColor (SDL_GetRenderer (SDL_GetWindowFromID(activewindow)), rred,ggreen,bblue,alpha)

end sub

'background color
sub backcolor (rred as integer, ggreen as integer,bblue as integer,alpha as integer)

bkr=rred
bkg=ggreen
bkb=bblue
bka=alpha
end sub

'sets the active window
sub setactivewindow (windowID as integer)
	activewindow =windowID
end sub

'clears the active window
sub clearwindow
color (bkr,bkg,bkb,bka)
SDL_RenderClear(SDL_GetRenderer (SDL_GetWindowFromID(activewindow)))
end sub

'refreshs the active window
sub redraw
SDL_RenderPresent(SDL_GetRenderer (SDL_GetWindowFromID(activewindow)))
end sub

'waits for amount of ms
sub wait (ms as integer)
SDL_Delay (ms)
end sub

'draw a simple dot
sub dot (x as integer, y as integer)
SDL_RenderDrawPoint (SDL_GetRenderer (SDL_GetWindowFromID(activewindow)),x,y)
end sub

'draws a line
sub line (x1 as integer,y1 as integer,x2 as integer,y2 as integer)
SDL_RenderDrawLine (SDL_GetRenderer (SDL_GetWindowFromID(activewindow)),x1,y1,x2,y2)
end sub

'draws a filled rectangle
sub fillrectangle (x as integer,y as integer,w as integer,h as integer)
dim coord as SDL_Rect
coord.x=x
coord.y=y
coord.w=w
coord.h=h
SDL_RenderFillRect (SDL_GetRenderer (SDL_GetWindowFromID(activewindow)),@coord)
end sub

'draws a rectangle
sub rectangle (x as integer,y as integer,w as integer,h as integer)
dim coord as SDL_Rect
coord.x=x
coord.y=y
coord.w=w
coord.h=h
SDL_RenderDrawRect (SDL_GetRenderer (SDL_GetWindowFromID(activewindow)),@coord)

end sub

'draws a circle
sub Circle(xcenter as integer,ycenter as integer,radius as integer)
dim x as integer,y as integer,r2 as integer
    if radius = 0 then 
		radius =1
	end if
	r2 =radius * radius
	dot (xcenter, ycenter+radius)
	dot (xcenter,ycenter-radius)
	dot (xcenter + radius, ycenter)
	dot (xcenter - radius, ycenter)
	x=1
	y= int (sqr (r2-1) + 0.5)
	while (x < y) 
		dot ( xCenter + x, yCenter + y)
        dot (xCenter + x, yCenter - y)
        dot (xCenter - x, yCenter + y)
        dot (xCenter - x, yCenter - y)
        dot (xCenter + y, yCenter + x)
        dot (xCenter + y, yCenter - x)
        dot (xCenter - y, yCenter + x)
        dot (xCenter - y, yCenter - x)
        x=x+1
        y =int (sqr(r2 - x*x) + 0.5)
	wend
	if (x = y) then 
         dot (xCenter + x, yCenter + y)
         dot (xCenter + x, yCenter - y)
         dot (xCenter - x, yCenter + y)
         dot (xCenter - x, yCenter - y)
     end if
end sub

'draws a filled circle
sub fillcircle(cx as integer,cy as integer,r as integer)
dim x as integer,y as integer,r2 as integer,dx as integer
	if r = 0 then 
		r=1
	end if
   r2 = r * r
   for x = r to 0 step -1
      y = int(sqr(r2 - x*x))
      dx = cx - x
      line(dx-1, cy-y, dx-1, cy+y)
      dx = cx + x
      line(dx, cy-y, dx, cy+y)
    next
end sub 

'draws a triangle
sub triangle (x1 as integer,y1 as integer,x2 as integer,y2 as integer,x3 as integer,y3 as integer)
line (x1,y1,x2,y2)
line (x2,y2,x3,y3)
line (x3,y3,x1,y1)
end sub

'draws a filled triangle - old TP code
sub filltriangle (xa as integer,ya as integer,xb as integer,yb as integer,xc as integer,yc as integer)
dim y1 as long,y2 as long,y3 as long,x1 as long,x2 as long,x3 as long
dim dx12 as long,dx13 as long,dx23 as long
dim dy12 as long,dy13 as long,dy23 as long,dy as long
dim a as long,b as long
           if ya=yb then 
			 yb=yb+1
			end if
			if ya=yc then 
			yc=yc+1
			end if
			if yc=yb then 
			yb=yb+1
			end if
     if (ya<>yb) and (ya<>yc) and (yc<>yb) then 
               if (ya>yb) and (ya>yc) then 
                y1=ya:x1=xa
                     if yb>yc then
                         y2=yb:x2=xb
                         y3=yc:x3=xc
                         else
                         y2=yc:x2=xc
                         y3=yb:x3=xb
                         end if
                   else
               if (yb>ya) and (yb>yc) then 
                 y1=yb:x1=xb
                       if ya>yc then
                          y2=ya:x2=xa
                          y3=yc:x3=xc
                        else
                          y2=yc:x2=xc
                          y3=ya:x3=xa
                        end if
                  else
              if (yc>yb) and (yc>ya) then 
                y1=yc:x1=xc
                       if yb>=ya then
                          y2=yb:x2=xb
                          y3=ya:x3=xa
                       else
                          y2=ya:x2=xa
                          y3=yb:x3=xb
                       end if
               END IF
     end if          
               dx12=x2-x1:dy12=y2-y1
               dx23=x3-x2:dy23=y3-y2
               dx13=x3-x1:dy13=y3-y1
               a=x2-((y2-y3+dy23)*dx23) / dy23
               b=x3+(-dy23*dx13)/(dy13)
              if (a<b) then 
				line (a,y2,b,y2)
                  for dy=0 to -dy23-1 
                        a=x2+((dy23+dy)*dx23)/dy23
                        b=x3+(dy*dx13)/(dy13)
                        line (a,dy+y3,b,dy+y3)
                   next
                  for dy=-dy23+1 to -dy13 
                        a=x2+((dy23+dy)*dx12)/ dy12
                        b=x3+(dy*dx13)/(dy13)
                        line (a,dy+y3,b,dy+y3)
                      
                    next
                else 
                   line (b,y2,a,y2)
                  for dy=0 to -dy23-1
                        a=x2+((dy23+dy)*dx23)/dy23
                        b=x3+(dy*dx13)/(dy13)
                        line (a,dy+y3,b,dy+y3)
                   next
                  for dy=-dy23+1 to -dy13 
                        a=x2+((dy23+dy)*dx12)/dy12
                        b=x3+(dy*dx13)/(dy13)
                        line (a,dy+y3,b,dy+y3)
                   next
                 end if
           end if
   end if 
end sub

'draws an ellipse
sub Ellipse(CX as long, CY as long, XRadius as long, YRadius as long)
dim X as long, Y as long
dim XChange as long, YChange  as long
dim	EllipseError  as long
dim TwoASquare as long, TwoBSquare as long
dim	StoppingX as long, StoppingY as long
   If XRadius = YRadius then 
		YRadius=YRadius+1
	end if
	TwoASquare = 2*XRadius*XRadius
	TwoBSquare = 2*YRadius*YRadius
	X = XRadius
	Y = 0
	XChange = YRadius*YRadius*(1 - 2*XRadius)
	YChange = XRadius*XRadius
	EllipseError = 0
	StoppingX = TwoBSquare*XRadius
	StoppingY = 0
	while ( StoppingX >= StoppingY )
		dot (CX+X, CY+Y)
		dot (CX-X, CY+Y)
		dot (CX-X, CY-Y)
		dot (CX+X, CY-Y)
		Y=Y+1
		StoppingY=StoppingY+ TwoASquare
		EllipseError=EllipseError+ YChange
		YChange=YChange+TwoASquare
			if ((2*EllipseError + XChange) > 0 ) then 
				X=X-1
				StoppingX=StoppingX - TwoBSquare
				EllipseError=EllipseError+XChange
				XChange=XChange+TwoBSquare
			end if
	wend
	X = 0
	Y = YRadius
	XChange = YRadius*YRadius
	YChange = XRadius*XRadius*(1 - 2*YRadius)
	EllipseError = 0
	StoppingX = 0
	StoppingY = TwoASquare*YRadius
	while ( StoppingX <= StoppingY )
		dot (CX+X, CY+Y)
		dot (CX-X, CY+Y)
		dot (CX-X, CY-Y)
		dot (CX+X, CY-Y)
		X=X+1
		StoppingX=StoppingX+TwoBSquare
		EllipseError=EllipseError+XChange
		XChange=XChange+TwoBSquare
		if ((2*EllipseError + YChange) > 0 ) then 
			Y=Y-1
			StoppingY=StoppingY-TwoASquare
			EllipseError=EllipseError+YChange
			YChange=YChange+TwoASquare
		end if
	wend
end sub 

'draws a filled ellipse - warning it's slow
sub fillellipse (xc as integer,yc as integer,wwidth as integer, hheight as integer)
dim x as integer,y as integer

for y=-hheight  to hheight 
    for x=-wwidth to wwidth
        if(x*x*hheight*hheight+y*y*wwidth*wwidth <= hheight*hheight*wwidth*wwidth) then 
            dot (xc+x, yc+y)
        end if
 next
next
end sub


'size of built-in font
sub textsize (tsize as integer)
	fontsize=tsize
end sub

'type of built-in font
sub texttype (ttype as integer)
	if 	(ttype >=1) and (ttype <=2) then
		fonttype = ttype
	else
		fonttype = 1
	end if
end sub

'draws a character of the 8x8 font
sub drawchar (x as integer,y as integer,text as string)
dim ch as UBYTE
dim horiz as integer,vert as integer,oldx as integer
oldx=x
ch = asc(text)
for vert=0 to 7 
	for horiz=0 to 7 
	 select case fonttype
	 case 1	
		if (DefaultFontData(ch,vert,horiz))= 1 then 
			  fillrectangle (x,y,fontsize,fontsize)
		end if
	case 2
		if (SerifFontData(ch,vert,horiz))= 1 then 
			  fillrectangle (x,y,fontsize,fontsize)
		end if
	end select
		x=x+fontsize
	next
	y=y+fontsize
  x=oldx
next
end sub

'text output
sub drawtext (stri as string,x as integer,y as integer)
dim ch as string
dim	i as integer,length as integer

length = len (stri)
 for i=1 to length
	ch= mid (stri,i,1)
	drawchar (x,y,ch)
	x=x+fontsize*8
  next
end sub

'textwidth in pixels
function textwidth (TextString as string) as integer
dim length as integer
length = len (TextString)
return length * 8 * fontsize
end function

'textheight in pixels
function textheight () as integer
return fontsize * 8
end function

'sets the global colourkey for images
sub setcolorkey (rred as integer,ggreen as integer,bblue as integer)
ckr=rred
ckg=ggreen
ckb=bblue
colorkey=true
end sub

'turns colourkey off
sub nocolorkey
  colorkey =false
end sub

'loads an image
function loadimage (filename as string)as SDL_Surface ptr
dim image as SDL_Surface ptr
dim	colour as integer

if fileexists(filename) then 
   image=IMG_LOAD (filename)
  else 
  SDL_ShowSimpleMessageBox (SDL_MESSAGEBOX_ERROR, "File not found", "Can't find image file: "& filename,null)
  closeapplication()
  end
  end if
  if (image = null) then 
		Messagebox (1,"Error","SDL_LoadBMP Error: " & str(SDL_GetError))
		closeapplication()
		end
	end if
 if colorkey = true then 
	colour = SDL_MapRGB(image->format, ckr,ckg, ckb)
    SDL_SetColorKey(image, 1 , colour)
 end if
  return image
end function

'frees image from memory
sub freeimage (srcimage as SDL_Surface ptr)
	SDL_Freesurface (srcimage)
end sub

'frees sprite from memory
sub freesprite (srcsprite as SDL_Texture ptr)
SDL_DestroyTexture(srcsprite)
end sub

'color of the sprite
sub spritecolor  (tex as SDL_Texture ptr,rred as integer,ggreen as integer,bblue as integer,alpha as integer)
SDL_SetTextureColorMod (tex,rred,ggreen,bblue)
SDL_SetTextureAlphaMod (tex,alpha)
end sub

'creates a sprite (texture) out of an image
function createsprite (image as SDL_Surface ptr) as SDL_Texture ptr
dim textu as SDL_Texture ptr
textu = SDL_CreateTextureFromSurface(SDL_GetRenderer (SDL_GetWindowFromID(activewindow)) , image)
if (textu = null) then 
		Messagebox(1,"Error","SDL_CreateTextureFromSurface Error: " & SDL_GetError)
		closeapplication()
		end
	end if
return textu
end function

'returns the width of a sprite
function spritewidth (sprite as SDL_Texture ptr) as integer
dim w as long,h as long
SDL_QueryTexture(sprite, null, null, @w, @h)
return w
end function

'returns the height of a sprite
function spriteheight (sprite as SDL_Texture ptr) as integer
dim w as long, h as long
SDL_QueryTexture(sprite, null, null, @w, @h)
return h
end function

' loads a sprite directly (no colorkey!)
function loadsprite (filename as string) as SDL_Texture ptr
dim sprite as SDL_Texture ptr

if fileexists(filename) then 
sprite = IMG_LoadTexture(SDL_GetRenderer (SDL_GetWindowFromID(activewindow)),filename)
else 
  SDL_ShowSimpleMessageBox (SDL_MESSAGEBOX_ERROR, "File not found", "Can't find image file: " & filename,null)
  closeapplication()
  end
end if
  if (sprite = null) then 
		Messagebox(1,"Error","SDL_LoadBMP Error: " & SDL_GetError)
		closeapplication()
		end
	end if
 return sprite
end function

'draws the sprite onto the active window
sub drawsprite (sprite as SDL_Texture ptr, x as integer,y as integer,wwidth as double, hheight as double,angle as double, vflip as integer,hflip as integer)
dim dest as SDL_Rect

dim	w as long,h as long

SDL_QueryTexture(sprite, null, null, @w, @h)
	dest.x=x
	dest.y=y
	dest.w=int(w*wwidth)
	dest.h=int(h*hheight)
	if vflip then 
	SDL_RenderCopyEx(SDL_GetRenderer (SDL_GetWindowFromID(activewindow)), sprite, null, @dest,angle, null, SDL_FLIP_VERTICAL)
	elseif hflip then 
	SDL_RenderCopyEx(SDL_GetRenderer (SDL_GetWindowFromID(activewindow)), sprite, null, @dest,angle, null, SDL_FLIP_HORIZONTAL)
	else 
	SDL_RenderCopyEx(SDL_GetRenderer (SDL_GetWindowFromID(activewindow)), sprite, null, @dest,angle, null, SDL_FLIP_NONE)
    end if
end sub

'draws a part of the sprite onto the active window
sub drawspritepart (sprite as SDL_Texture ptr, x as integer, y as integer, startx as integer, starty as integer, xoffset as integer,_
yoffset as integer, wwidth as double, hheight as double, angle as double, vflip as integer,hflip as integer)
dim dest as SDL_Rect 
dim	src as SDL_Rect
	dest.x=x
	dest.y=y
	dest.w=int(wwidth*(xoffset))
	dest.h=int(hheight*(yoffset))
	
	src.x=startx
	src.y=starty
	src.w=xoffset
	src.h=yoffset
	
	if vflip then 
	 SDL_RenderCopyEx(SDL_GetRenderer (SDL_GetWindowFromID(activewindow)), sprite, @src, @dest,angle, null, SDL_FLIP_VERTICAL)
	elseif hflip then 
	 SDL_RenderCopyEx(SDL_GetRenderer (SDL_GetWindowFromID(activewindow)), sprite, @src, @dest,angle, null, SDL_FLIP_HORIZONTAL)
	else 
	SDL_RenderCopyEx(SDL_GetRenderer (SDL_GetWindowFromID(activewindow)), sprite, @src, @dest,angle, null, SDL_FLIP_NONE)
    end if
end sub

'creates a new bitmapfont
function createbmpfont (sprite as p2d.sprite, w as integer,h as integer, fontface as string) as integer

bmpfont.index=bmpfont.index+1

redim preserve bmpfont.image (bmpfont.index)
redim preserve bmpfont.width (bmpfont.index)
redim preserve bmpfont.height (bmpfont.index)
redim preserve bmpfont.face (bmpfont.index)
redim preserve bmpfont.lines (bmpfont.index)
redim preserve bmpfont.rows (bmpfont.index)
redim preserve bmpfont.xfactor (bmpfont.index)
redim preserve bmpfont.yfactor (bmpfont.index)
redim preserve bmpfont.angle (bmpfont.index)
redim preserve bmpfont.inpred (bmpfont.index)
redim preserve bmpfont.inpgreen (bmpfont.index)
redim preserve bmpfont.inpblue (bmpfont.index)
redim preserve bmpfont.inpalpha (bmpfont.index)
redim preserve bmpfont.binpred (bmpfont.index)
redim preserve bmpfont.binpgreen (bmpfont.index)
redim preserve bmpfont.binpblue (bmpfont.index)
redim preserve bmpfont.binpalpha (bmpfont.index)

bmpfont.image(bmpfont.index-1)=sprite
bmpfont.width(bmpfont.index-1)=w
bmpfont.height(bmpfont.index-1)=h
bmpfont.lines(bmpfont.index-1)=int (spriteheight (bmpfont.image(bmpfont.index-1))/h)
bmpfont.rows(bmpfont.index-1)= int (spritewidth (bmpfont.image(bmpfont.index-1))/w)
bmpfont.face(bmpfont.index-1)=fontface
bmpfont.xfactor(bmpfont.index-1)=1
bmpfont.yfactor(bmpfont.index-1)=1
bmpfont.inpred(bmpfont.index-1)=255
bmpfont.inpgreen(bmpfont.index-1)=255
bmpfont.inpblue(bmpfont.index-1)=255
bmpfont.inpalpha(bmpfont.index-1)=255

bmpfont.binpred(bmpfont.index-1)=0
bmpfont.binpgreen(bmpfont.index-1)=0
bmpfont.binpblue(bmpfont.index-1)=0
bmpfont.binpalpha(bmpfont.index-1)=255

bmpfont.angle(bmpfont.index-1)=0

return bmpfont.index-1
end function

'draws a text with a bitmapfont
sub bmptext (textstr as string,xspace as integer,yspace as integer,fontnumber as integer)
dim as integer counter,textlength,chars,i,xs,ys,xfont,yfont
dim mychar as string
dim space as integer

if fontnumber < bmpfont.index then
chars=len(bmpfont.face(fontnumber))
textlength=len(textstr)
xfont=0
yfont=0
for i=1 to textlength
	mychar= mid(textstr,i,1)
	counter=1
	xs=1
	ys=1
 do
 space =false
 if (mid (bmpfont.face(fontnumber),counter,1)=mychar)   then
 	 xfont =xs
     yfont =ys
  elseif (mychar=" ") then
   space=true
 end if
	xs=xs+1
	if xs>bmpfont.rows(fontnumber) then
	    ys=ys+1
		xs=1
	end if
 counter=counter+1
 loop until counter > chars

 if space = false then
' drawspritepart (sprite:PSDL_Texture; x,y,startx,starty,xoffset,yoffset:integer;width,height,angle:real;vflip,hflip:boolean);
 drawspritepart (bmpfont.image (fontnumber),xspace,yspace,(xfont-1)*bmpfont.width(fontnumber),(yfont-1)*bmpfont.height(fontnumber),bmpfont.width(fontnumber),bmpfont.height(fontnumber),bmpfont.xfactor(fontnumber),bmpfont.yfactor(fontnumber),bmpfont.angle(fontnumber),false,false)
 end if
 xspace =xspace+bmpfont.width(fontnumber)* bmpfont.xfactor(fontnumber)
 space=false
next
else 
  SDL_ShowSimpleMessageBox (SDL_MESSAGEBOX_ERROR, "No font", "Font not loaded!",null)
  closeapplication()
  end
  end if
end sub

'sets the bitmapfont size
sub bmpfontsize (fontnumber as integer,xf as integer,yf as integer)
if fontnumber < bmpfont.index then
	bmpfont.xfactor(fontnumber)=xf
	bmpfont.yfactor(fontnumber)=yf
else 
  SDL_ShowSimpleMessageBox (SDL_MESSAGEBOX_ERROR, "No font", "Font not loaded!",null)
  closeapplication()
  end
end if	
end sub

'sets the bitmapfont angle
sub bmpfontangle (fontnumber as integer,angle as double)
if fontnumber < bmpfont.index then
	bmpfont.angle(fontnumber)=angle
else 
  SDL_ShowSimpleMessageBox (SDL_MESSAGEBOX_ERROR, "No font", "Font not loaded!",null)
  closeapplication()
  end
 end if
end sub

'returns the width of the bitmap font in pixels
function bmpfontwidth (fontnumber as integer) as integer
if fontnumber < bmpfont.index then	
	return bmpfont.width(fontnumber)*bmpfont.xfactor(fontnumber)
else 
	 SDL_ShowSimpleMessageBox (SDL_MESSAGEBOX_ERROR, "No font", "Font not loaded!",null)
     closeapplication()
     end
  end if
end function

'returns the height of the bitmap font in pixels
function bmpfontheight (fontnumber as integer) as integer
if fontnumber < bmpfont.index then
	return bmpfont.height(fontnumber)*bmpfont.yfactor(fontnumber)
else 
	 SDL_ShowSimpleMessageBox (SDL_MESSAGEBOX_ERROR, "No font", "Font not loaded!",null)
     closeapplication()
     end
  end if
end function

'now it's getting complicated, although SDL2 has got a text input function - anyway it's shorter than it was in EGSL
function input (x as integer,y as integer,maxlen as integer) as string
dim done as integer
dim	mytext as string
dim	event as SDL_event

	SDL_SetTextInputRect (null)
	SDL_StartTextInput()
	mytext=""
	color (tcred,tcgreen,tcblue,tcalpha)
	fillrectangle (x+textwidth (mytext),y,textheight(),textheight())
	sync
	do
	
	done=false
	
	
	if (SDL_PollEvent( @event ) <> 0) then 
	  if (event.type) = SDL_TEXTINPUT then 
		sync
		mytext=mytext+ event.text.text
	    if len (mytext) > maxlen then 
		sync
	      mytext=left (mytext,len (mytext)-1)
    	  color (tbred,tbgreen,tbblue,tbalpha)
		  fillrectangle (x,y,textwidth(mytext)+textheight(),textheight())
		  color (tcred,tcgreen,tcblue,tcalpha)
		  drawtext (mytext,x,y)
		  fillrectangle (x+textwidth (mytext),y,textheight(),textheight())
		  sync
		end if
		color (tbred,tbgreen,tbblue,tbalpha)
		fillrectangle (x,y,textwidth(mytext),textheight())
		color (tcred,tcgreen,tcblue,tcalpha)
		drawtext (mytext,x,y)
		fillrectangle (x+textwidth (mytext),y,textheight(),textheight())
		sync
	   end if
	   if (event.type)=SDL_TEXTEDITING then 
	    mytext= event.edit.text
	    sync
	   end if
	   if (event.type= SDL_QUIT_) then
	      closeapplication()
	      end
	   end if
	   if (event.type)=SDL_KEYDOWN then 
		if ((event.key.keysym.scancode) = SDL_SCANCODE_RETURN) or ((event.key.keysym.scancode) = SDL_SCANCODE_KP_ENTER) or ((event.key.keysym.scancode) = SDL_SCANCODE_ESCAPE) then
		  done=true
		end if
		if (event.key.keysym.scancode) = SDL_SCANCODE_BACKSPACE then
		   sync
		   mytext=left (mytext,len (mytext)-1)
		   color (tbred,tbgreen,tbblue,tbalpha)
		   fillrectangle (x,y,textwidth(mytext)+textheight()*2,textheight())
		   color (tcred,tcgreen,tcblue,tcalpha)
		   drawtext (mytext,x,y)
		   fillrectangle (x+textwidth (mytext),y,textheight(),textheight())
			sync
		 end if
		end if
	     
	 end if
  loop until done=true
	SDL_StopTextInput()
	 color (tbred,tbgreen,tbblue,tbalpha)
     fillrectangle (x,y,textwidth(mytext)+textheight(),textheight())
	 color (tcred,tcgreen,tcblue,tcalpha)
	 drawtext (mytext,x,y)
	return mytext
end function

sub textinputbackcolor (rred as integer,ggreen as integer,bblue as integer,alpha as integer)
tbred=rred
tbgreen=ggreen
tbblue=bblue
tbalpha=alpha
end sub

sub textinputcolor (rred as integer,ggreen as integer,bblue as integer,alpha as integer)
tcred=rred
tcgreen=ggreen
tcblue=bblue
tcalpha=alpha
end sub

sub bmpinputbackcolor (fontnumber as integer,rred as integer,ggreen as integer,bblue as integer,alpha as integer)
if fontnumber < bmpfont.index then
	bmpfont.binpred(fontnumber)=rred
	bmpfont.binpgreen(fontnumber)=ggreen
	bmpfont.binpblue(fontnumber)=bblue
	bmpfont.binpalpha(fontnumber)=alpha
else 
  SDL_ShowSimpleMessageBox (SDL_MESSAGEBOX_ERROR, "No font", "Font not loaded!",null)
  closeapplication()
  end
  end if
end sub

sub bmpinputcolor (fontnumber as integer,rred as integer,ggreen as integer,bblue as integer,alpha as integer)
if fontnumber < bmpfont.index then
	bmpfont.inpred(fontnumber)=rred
	bmpfont.inpgreen(fontnumber)=ggreen
	bmpfont.inpblue(fontnumber)=bblue
	bmpfont.inpalpha(fontnumber)=alpha
else 
  SDL_ShowSimpleMessageBox (SDL_MESSAGEBOX_ERROR, "No font", "Font not loaded!",null)
  closeapplication()
  end
  end if	
end sub

'now it's getting complicated, although SDL2 has got a text input function - anyway it's shorter than it was in EGSL
function bmpinput (fontnumber as integer, x as integer,y as integer,maxlen as integer) as string
dim done as integer
dim	mytext as string
dim	event as SDL_event
if fontnumber < bmpfont.index then 
	SDL_SetTextInputRect (null)
	SDL_StartTextInput()
	mytext=""
	color (bmpfont.inpred(fontnumber),bmpfont.inpgreen(fontnumber),bmpfont.inpblue(fontnumber),bmpfont.inpalpha(fontnumber))
	fillrectangle (x+len (mytext)*bmpfont.width(fontnumber)*bmpfont.xfactor(fontnumber),y,bmpfont.width(fontnumber)*bmpfont.xfactor(fontnumber),bmpfont.height(fontnumber)*bmpfont.yfactor(fontnumber))
	sync
	do
	
	done=false
	
	
	if (SDL_PollEvent( @event ) <> 0) then 
	  if (event.type) = SDL_TEXTINPUT then 
		sync
		mytext=mytext+ event.text.text
	    if len (mytext) > maxlen then 
		sync
	      mytext=left (mytext,len (mytext)-1)
    	  color (bmpfont.binpred(fontnumber),bmpfont.binpgreen(fontnumber),bmpfont.binpblue(fontnumber),bmpfont.binpalpha(fontnumber))
		   fillrectangle (x,y,(len (mytext)*bmpfont.width(fontnumber)*bmpfont.xfactor(fontnumber))+bmpfont.width(fontnumber)*bmpfont.xfactor(fontnumber),bmpfont.height(fontnumber)*bmpfont.yfactor(fontnumber))
		   color (bmpfont.inpred(fontnumber),bmpfont.inpgreen(fontnumber),bmpfont.inpblue(fontnumber),bmpfont.inpalpha(fontnumber))
		   bmptext (mytext,x,y,fontnumber)
		   fillrectangle (x+len (mytext)*bmpfont.width(fontnumber)*bmpfont.xfactor(fontnumber),y,bmpfont.width(fontnumber)*bmpfont.xfactor(fontnumber),bmpfont.height(fontnumber)*bmpfont.yfactor(fontnumber))
		  sync
		end if
		 color (bmpfont.binpred(fontnumber),bmpfont.binpgreen(fontnumber),bmpfont.binpblue(fontnumber),bmpfont.binpalpha(fontnumber))
		 fillrectangle (x,y,len (mytext)*bmpfont.width(fontnumber)*bmpfont.xfactor(fontnumber),bmpfont.height(fontnumber)*bmpfont.yfactor(fontnumber))
		 color (bmpfont.inpred(fontnumber),bmpfont.inpgreen(fontnumber),bmpfont.inpblue(fontnumber),bmpfont.inpalpha(fontnumber))
         bmptext (mytext,x,y,fontnumber)
		 fillrectangle (x+len (mytext)*bmpfont.width(fontnumber)*bmpfont.xfactor(fontnumber),y,bmpfont.width(fontnumber)*bmpfont.xfactor(fontnumber),bmpfont.height(fontnumber)*bmpfont.yfactor(fontnumber))
		 sync
	   end if
	   if (event.type)=SDL_TEXTEDITING then 
	    mytext= event.edit.text
	    sync
	   end if
	   if (event.type= SDL_QUIT_) then
	      closeapplication()
	      end
	   end if
	   if (event.type)=SDL_KEYDOWN then 
		if ((event.key.keysym.scancode) = SDL_SCANCODE_RETURN) or ((event.key.keysym.scancode) = SDL_SCANCODE_KP_ENTER) or ((event.key.keysym.scancode) = SDL_SCANCODE_ESCAPE) then
		  done=true
		end if
		if (event.key.keysym.scancode) = SDL_SCANCODE_BACKSPACE then
		   sync
		   mytext=left (mytext,len (mytext)-1)
		   color (bmpfont.binpred(fontnumber),bmpfont.binpgreen(fontnumber),bmpfont.binpblue(fontnumber),bmpfont.binpalpha(fontnumber))
		   fillrectangle (x,y,(len (mytext)*bmpfont.width(fontnumber)*bmpfont.xfactor(fontnumber))+(bmpfont.width(fontnumber)*bmpfont.xfactor(fontnumber)*2),bmpfont.height(fontnumber)*bmpfont.yfactor(fontnumber))
		   color (bmpfont.inpred(fontnumber),bmpfont.inpgreen(fontnumber),bmpfont.inpblue(fontnumber),bmpfont.inpalpha(fontnumber))
		   bmptext (mytext,x,y,fontnumber)
		   fillrectangle (x+len (mytext)*bmpfont.width(fontnumber)*bmpfont.xfactor(fontnumber),y,bmpfont.width(fontnumber)*bmpfont.xfactor(fontnumber),bmpfont.height(fontnumber)*bmpfont.yfactor(fontnumber))
		   sync
		 end if
		end if
	     
	 end if
  loop until done=true
	SDL_StopTextInput()
	 color (bmpfont.binpred(fontnumber),bmpfont.binpgreen(fontnumber),bmpfont.binpblue(fontnumber),bmpfont.binpalpha(fontnumber))
	 fillrectangle (x,y,(len (mytext)*bmpfont.width(fontnumber)*bmpfont.xfactor(fontnumber))+(bmpfont.width(fontnumber)*bmpfont.xfactor(fontnumber)),bmpfont.height(fontnumber)*bmpfont.yfactor(fontnumber))
     bmptext (mytext,x,y,fontnumber)
	 return mytext
else
 SDL_ShowSimpleMessageBox (SDL_MESSAGEBOX_ERROR, "No font", "Font not loaded!",null)
     closeapplication()
     end
  end if
end function
