/'
'   p2dinput.bi
'   
'   Copyright 2013-2015 Markus Mangold <info@retrogamecoding.org>
'   
'   
'		This software is provided 'as-is', without any express or implied
'		warranty. In no event will the authors be held liable for any damages
'		arising from the use of this software.
'
'		Permission is granted to anyone to use this software for any purpose,
'		including commercial applications, and to alter it and redistribute it
'		freely, subject to the following restrictions:
'
'			1. The origin of this software must not be misrepresented; you must not
'			claim that you wrote the original software. If you use this software
'			in a product, an acknowledgment in the product documentation would be
'			appreciated but is not required.
'
'			2. Altered source versions must be plainly marked as such, and must not be
'			misrepresented as being the original software.
'
'			3. This notice may not be removed or altered from any source
'			distribution.
'  
'/


declare function inkey as string
declare function GetKey as integer
declare function mousex as integer
declare function mousey as integer
declare sub hidemouse()
declare sub showmouse()
declare  sub warpmouse (x as integer,y as integer)
declare function mousebutton as integer
declare function keystate (key as integer) as integer
declare function JoystickPlugged as integer
declare function GetJoystickX as Integer
declare function GetJoystickY as Integer
declare function GetJoystickButton(button as integer) as Integer
declare function NumberJoyButtons as Integer
declare function mousezone (x1 as integer,y1 as integer,x2 as integer,y2 as integer)as integer

'waits until key pressed
function inkey as string
dim ch as integer
dim	event as SDL_Event

do
	SDL_Delay(3)
	if (event.type = SDL_QUIT_) then
	       SDL_Quit()
	      end
    end if
	   
Loop until ( (SDL_PollEvent( @event ) <> 0) and ((event.key.type = SDL_KEYDOWN)))
  ch = Event.key.keysym.sym
  return chr(ch)
end function

'doesn't wait for key press
function GetKey as integer
dim ch as integer
dim	event as SDL_event

  	while (SDL_PollEvent( @event ) <> 0) 

	  if (event.type = SDL_QUIT_) then
	      SDL_Quit()
	      end
	   end if 
	  if (event.key.type = SDL_KEYDOWN) then
  		ch = Event.key.keysym.scancode
		return  ch
	  end if
     wend
end function

'x-coordinates of mouse     
function mousex as integer
dim mx as long ,my as long
  SDL_Pumpevents()
  SDL_GetMouseState (@mx,@my)
  return mx
end function

'y-coordinates of mouse
function mousey as integer
dim mx as long,my as long
    SDL_Pumpevents()
    SDL_GetMouseState (@mx,@my)
    return my
end function

'hides mouse cursor - important with setvirtualsize
sub hidemouse()
SDL_ShowCursor (0)
end sub

'shows mouse cursor again
sub showmouse()
SDL_ShowCursor (1)
end sub

'warps mouse cursor to x- and y-coordinates
sub warpmouse (x as integer,y as integer)
SDL_WarpMouseInWindow (SDL_GetWindowFromID(activewindow),x,y)
end sub

'check mouse button
function mousebutton as integer
dim mb as integer
	SDL_Pumpevents()
    IF (SDL_GetMouseState (null,null) and SDL_BUTTON_LMASK)  <> 0  then 
    mb=1
    elseif (SDL_GetMouseState (null,null) and SDL_BUTTON_MMASK) <>0 then 
    mb=2
    elseif (SDL_GetMouseState (null,null) and SDL_BUTTON_RMASK) <> 0 then
    mb=3
    else mb=0
    end if
    return mb
end function

' check if certain key is pressed
function keystate (key as integer) as integer
dim state as const uint8 ptr =SDL_Getkeyboardstate(null)

  SDL_Pumpevents()
  if state[key]<>0 then
   return True
  else
  return False
  end if
end function

' check if a joystick is plugged
function JoystickPlugged as integer
  if SDL_JoystickGetAttached(joystick)=SDL_TRUE then
    return true
    else
    return false
    end if
end function

' get joystick x-axe
function GetJoystickX as Integer
  if SDL_JoystickGetAttached(joystick)=SDL_TRUE then 
  return SDL_JoystickGetAxis( joystick, 0 )
 else return 0
 end if 
end function

' get joystick y-axe
function GetJoystickY as Integer
if SDL_JoystickGetAttached(joystick)=SDL_TRUE then 
  return SDL_JoystickGetAxis( joystick, 1 )
 else return 0
 end if 
end function

function GetJoystickButton(button as integer) as Integer
if SDL_JoystickGetAttached(joystick)=SDL_TRUE then 
  return SDL_JoystickGetButton(joystick,Button)
  else return 0
end if
end function

function NumberJoyButtons as Integer
if SDL_JoystickGetAttached(joystick)=SDL_TRUE then
  return SDL_JoystickNumButtons(joystick)
 else return 0
end if
end function

'returns true if mouse is in rectangle x1,y1,x2,y2
function mousezone (x1 as integer,y1 as integer,x2 as integer,y2 as integer)as integer

if (mousex >= x1) and (mousex<=x2) and (mousey>=y1) and (mousey<=y2) then
	return True
else
    return False
end if
end function
