'
'   p2dcollision.pas
'   
'   Copyright 2013-2015 Markus Mangold <info@retrogamecoding.org>
'   
'   
'		This software is provided 'as-is', without any express or implied
'		warranty. In no event will the authors be held liable for any damages
'		arising from the use of this software.
'
'		Permission is granted to anyone to use this software for any purpose,
'		including commercial applications, and to alter it and redistribute it
'		freely, subject to the following restrictions:
'
'			1. The origin of this software must not be misrepresented; you must not
'			claim that you wrote the original software. If you use this software
'			in a product, an acknowledgment in the product documentation would be
'			appreciated but is not required.
'
'			2. Altered source versions must be plainly marked as such, and must not be
'			misrepresented as being the original software.
'
'			3. This notice may not be removed or altered from any source
'			distribution.
'  
'

declare function Boxcoll (x1 as integer,y1 as integer,w1 as integer,h1 as integer,x2 as integer,y2 as integer,w2 as integer,h2 as integer) as integer
declare function CircleColl (x1 as integer, y1 as integer, r1 as integer, x2 as integer, y2 as integer, r2 as integer, coffset as integer) as integer
declare function RoundColl (aSurface as p2d.sprite, x1 as integer, y1 as integer, bSurface as p2d.sprite, x2 as integer, y2 as integer, coffset as  integer) as integer
declare function sidecoll (x as integer,y as integer,w as integer,h as integer,dx as integer,dy as integer, rx as integer, ry as integer, rw as integer, rh as integer) as string
declare function ImageColl (ImageA as  p2d.sprite,ax as integer,ay as  integer, ImageB as p2d.sprite, bx as integer, yb as integer) as integer
declare function circletoboxcoll (cx as integer,cy as integer,r as integer,x1 as integer,y1 as integer,w as integer,h as integer) as integer
declare function Orientation (x1 as double, y1 as double, x2 as double, y2 as double, Px as double, Py as double) as integer
declare function Intersect (x1 as double, y1 as double, x2 as double, y2 as double, x3 as double, y3 as double, x4 as double, y4 as Double) as integer
declare function getOrientationResult (x1 as integer, y1 as integer, x2 as integer, y2 as integer, px as integer, py as integer) as integer
declare function InsideTriangle (px as integer,py as integer,x1 as integer,y1 as integer,x2 as integer,y2 as integer,x3 as integer,y3 as integer) as integer
declare function InsideCircle (px as integer,py as integer,cx as integer,cy as integer,radius as integer) as integer
declare function InsideRectangle (posx as integer,posy as integer,x1 as integer,y1 as integer,x2 as integer,y2 as integer) as integer

' Implementation

function Boxcoll (x1 as integer,y1 as integer,w1 as integer,h1 as integer,x2 as integer,y2 as integer,w2 as integer,h2 as integer) as integer

  if x2 + w2 < x1 then return false
  if x2 > x1 + w1 then return false

  if y2 + h2 < y1 then return false
  if y2 > y1 + h1 then return false

  return true
end function

function CircleColl (x1 as integer, y1 as integer, r1 as integer, x2 as integer, y2 as integer, r2 as integer, coffset as integer) as integer
dim as integer  xdiff, ydiff, dcentre_sq, r_sum_sq
  xdiff = x2 - x1  ' x plane difference
  ydiff = y2 - y1  ' y plane difference

  ' distance between the circles centres squared 
  dcentre_sq = ydiff*ydiff + xdiff*xdiff

  ' calculate sum of radiuses squared 
  r_sum_sq = r1 + r2  'square on seperate line, so
  r_sum_sq = r_sum_sq*r_sum_sq  ' dont recompute r1 + r2

  return  (dcentre_sq - r_sum_sq <= (coffset*coffset))
end function

function RoundColl (aSurface as p2d.sprite, x1 as integer, y1 as integer, bSurface as p2d.sprite, x2 as integer, y2 as integer, coffset as integer) as integer
dim as integer r1, r2

  'if radius is not specified
  'we approximate them using p2sprite's
  'width and height average and divide by 2 

  r1 = (spritewidth(aSurface) + spriteheight(aSurface)) / 4	' same as / 2) / 2;
  r2 = (spritewidth(bSurface) + spriteheight(bSurface)) / 4

  x1 = x1 + spritewidth(aSurface) / 2		'offset x and y
  y1 = y1 + spriteheight(aSurface)/ 2		' co-ordinates into
            'centre of image
  x2 = x2 + spritewidth(bSurface) / 2
  y2 = y2 + spriteheight(bSurface)/ 2

  return CircleColl(x1, y1, r1, x2, y2, r2, coffset)
end function
 
function sidecoll (x as integer,y as integer,w as integer,h as integer,dx as integer,dy as integer, rx as integer, ry as integer, rw as integer, rh as integer) as string

if (dx = 0) and (dy = 0) then 
   return "none"
end if
if dx < 0 then 
   if x >= rx + rw then 
     if x + dx < rx + rw then 
      if (y + dy < ry + rh) and (ry < y + dy + h) then 
         return "left"
      end if
   end if
 endif  
elseif dx > 0 then 
   if rx >= x + w then 
      if rx < x + w + dx then 
         if (y + dy < ry + rh) and (ry < y + dy + h) then 
            return "right"
            
         end if
      end if
  end if
end if

if dy < 0 then 
   if y >= ry + rh then 
       if y + dy < ry + rh then 
 	   if (x < rx + rw) and (rx < x + w) then 
             return "top"
             
        end if
	end if
  end if
elseif dy > 0 then 
       if ry >= y + h then 
         if ry < y + h + dy then 
		   if (x < rx + rw) and (rx < x  + w) then 
               return "bottom"
                    
           end if
         end if
	end if
end if
return "none"
end function

function ImageColl (ImageA as  p2d.sprite,ax as integer,ay as  integer, ImageB as p2d.sprite, bx as integer, yb as integer) as integer
 
 if boxcoll (ax,ay,spritewidth(ImageA),spriteheight(ImageA),bx,yb,spritewidth (ImageB), spriteheight(ImageB)) then
 	return true
else
	return false
end if
end function

function circletoboxcoll (cx as integer,cy as integer,r as integer,x1 as integer,y1 as integer,w as integer,h as integer) as integer
dim as integer testx,testy,x2,y2
 testx=cx
 testy=cy
 x2=x1+w
 y2=y1+h
 if testx < x1 then 
	testx = x1
 end if
 if testx > x2 then 
	testx = x2
 end if
 if testy < y1 then 
    testy = y1
 end if
 if testy > y2 then 
	testy = y2
 end if
  return (cx - testx) * (cx - testx) + (cy - testy) * (cy - testy) < r * r
end function

function Orientation (x1 as double, y1 as double, x2 as double, y2 as double, Px as double, Py as double) as integer
dim  Orin as Double
  ' Linear determinant of the 3 points 
  Orin = (x2 - x1) * (py - y1) - (px - x1) * (y2 - y1)

  if Orin > 0.0 then 
  return  +1    ' Orientaion is to the right-hand side  
  elseif Orin < 0.0 then 
  return  -1  ' Orientaion is to the left-hand side   
  else
    return  0
  end if                  'Orientaion is neutral if result is 0  
end function

function Intersect (x1 as double, y1 as double, x2 as double, y2 as double, x3 as double, y3 as double, x4 as double, y4 as Double) as integer
 return  (Orientation(x1, y1, x2, y2, x3, y3) <> Orientation(x1, y1, x2, y2, x4, y4))  and  (Orientation(x3, y3, x4, y4, x1, y1) <> Orientation(x3, y3, x4, y4, x2, y2))
end function

function getOrientationResult (x1 as integer, y1 as integer, x2 as integer, y2 as integer, px as integer, py as integer) as integer
dim orientationi as integer
orientationi = ((x2 - x1) * (py - y1)) - ((px - x1) * (y2 - y1))
if orientationi > 0 then 
   return 1
elseif orientationi < 0 then 
   return -1
else 
    return 0
end if
end function

function InsideTriangle (px as integer,py as integer,x1 as integer,y1 as integer,x2 as integer,y2 as integer,x3 as integer,y3 as integer) as integer
dim as integer o1,o2,o3
o1 = getOrientationResult (x1, y1, x2, y2, px, py)
o2 = getOrientationResult (x2, y2, x3, y3, px, py)
o3 = getOrientationResult (x3, y3, x1, y1, px, py)
return  ((o1=o2) and (o2=o3))
end function

function InsideCircle (px as integer,py as integer,cx as integer,cy as integer,radius as integer) as integer
dim distance as double
distance = sqr ((px - cx) * (px - cx) + (py - cy) * (py - cy))
if distance < radius then 
   return true
elseif distance > radius  then 
       return false
end if
end function

function InsideRectangle (posx as integer,posy as integer,x1 as integer,y1 as integer,x2 as integer,y2 as integer) as integer
if (posx > x1) and (posx <x2) and (posy >y1) and (posy<y2) then
   return true
else 
    return false
end if
end function
