' shows how to load an image and turn that into a sprite

#include once "pulsar2d.bi"

using p2d

TYPE player
x as integer
y as integer
image as p2d.sprite
END TYPE

dim win as p2d.window
dim image as p2d.image
dim grass as p2d.sprite
dim key as integer
dim knight as player

win = openwindow ("Simple Sprite Example",-1,-1,800,600)
setactivewindow (win)
setframetimer (100)

image = loadimage ("media/sprite.bmp")
knight.image = createsprite (image)
freeimage (image)

image = loadimage ("media/grass.bmp")
grass = createsprite (image)
freeimage (image)

knight.x=windowwidth()/2
knight.y=windowheight()/2
textsize (2)

do
key=p2d.getkey()
clearwindow()

if keystate (SDL_SCANCODE_RIGHT) then
	knight.x=knight.x+1
end if
if keystate (SDL_SCANCODE_LEFT) then
	knight.x=knight.x-1
end if
if keystate (SDL_SCANCODE_UP) then
	knight.y=knight.y-1
end if
if keystate (SDL_SCANCODE_DOWN) then
	knight.y=knight.y+1
end if

for i as integer = 0 to windowwidth() step spritewidth (grass)
	for j as integer = 0 to windowheight() step spriteheight (grass)
		drawsprite (grass,i,j,1,1,0,false,false)
	next
next

drawsprite (knight.image,knight.x,knight.y,1,1,0,false,false)

color (255,255,255,255)
drawtext ("Cursor keys to move knight, ESC to quit",0,0)

sync()
loop until key = SDL_SCANCODE_ESCAPE
freesprite (knight.image)
freesprite (grass)
closewindow (win)
closeapplication()
