#include "pulsar2d.bi"

using p2d

dim win as p2d.window

win = openwindow ("Mandelbrot",-1,-1,640,480)
setactivewindow (win)

color (255,255,255,255)
backcolor (255,255,255,255)
clearwindow
redraw

dim as integer x,y,i,timer1,timer2
dim zm as integer = 120
dim miter as integer = 128
dim as double zx, zy, cx,cy,tmp

timer1 = timerticks()
for y=0 to 479 
  for x=0 to 639 
    zx=0
    zy=0
    cx= (x-320)/zm
    cy= (y-240)/zm
    i = miter
  while zx*zx+zy*zy <4 and i >0 
    tmp = zx * zx - zy * zy + cx
    zy = 2 * zx * zy + cy
    zx = tmp
    i=i-1
  wend
   color (i*12,i*8,i*4,255)
   dot (x,y)
  next
next
color (0,0,0,255)

timer2 = timerticks()
drawtext ("Time: " & str(timer2 - timer1)&" ms",0,0)
redraw
p2d.inkey()
closewindow (win)
closeapplication()

END
