\newcommand{\dif}{{\rm d}}

# Inverse Trigonometric Functions

Since we have expressions for the trigonometric functions in terms of complex exponentials, we can invert these 
expressions to find explicit expressions for the inverse trig functions!

For example, we [know](complex-trig.html)

$$\sin\theta=\frac{e^{i\theta}-e^{-i\theta}}{2i}.$$

If we can find an expression for $\theta$, then we have found the inverse sine function.  Symbolically, if 
$x=\sin\theta$ then

$$\theta(x)=\sin^{-1}(x).$$

### Example: Find $\sin^{-1}(x)$


Let $y=e^{i\theta}$.  This implies that $y^{-1}=e^{-i\theta}$, and thus

$$ x=\sin\theta=\frac{y-y^{-1}}{2i}.$$

Multiplying the equation by $2iy$ yields:

$$ 2ixy=y^2-1$$

or

$$ 0=y^2-2ixy-1.$$

We can solve for $y$ using the quadratic formula,

$$ y=\frac{2ix\pm\sqrt{4-4x^2}}{2}=ix\pm\sqrt{1-x^2}.$$

Thus,

$$ e^{i\theta}=ix\pm\sqrt{1-x^2}.$$

Taking the logarithm of both sides and isolating $\theta$:

$$\theta=-i\ln\left(ix\pm\sqrt{1-x^2}\right).$$

This yields two values of $\theta$ for each $x$.  We can make the function single-valued by taking only the 
positive root,

$$\theta=-i\ln\left(ix+\sqrt{1-x^2}\right)=\sin^{-1}(x).$$

In order to obtain a numerical result, one can compute the Taylor expansion of the expression.

All of the other inverse trig functions can be found using the same process, of course the details of solving for 
$\theta$ will be a bit different in each case.

These expressions can be used to compute the inverse trig derivatives without using the trick that I demonstrated 
[here](http://www.idius.net/tutorials/calculus/inverse-trig-derivatives/).

For example,

$$\frac{\dif}{\dif x}\sin^{-1}(x)=\frac{\dif}{\dif x}\left[-i\ln\left(ix+\sqrt{1-x^2}\right)\right].$$

Upon differentiating, simplifying a bit, and defining $\alpha=\sqrt{1-x^2}$, we get

$$\frac{\dif}{\dif x}\sin^{-1}(x)=-\frac{1}{ix+\alpha}-\frac{ix}{\alpha xi+\alpha^2}=\frac{1}{\alpha}.$$

Thus,

$$\frac{\dif}{\dif x}\sin^{-1}(x)=\frac{1}{\sqrt{1-x^2}}.$$
