# Euler's Equation

We consider the important complex function,

$$f(z)=e^{z}.$$

Substituting $z$ with its definition, $z=x+iy$:

$$f(z)=e^{x+iy}=e^x e^{iy}.$$

The $e^x$ part is easy to understand, since it is the ordinary exponential function with a real argument, but what about the second exponential on the right hand side of the equation?  What does it mean for an exponent to be imaginary?  To find out, we can expand the term $e^{iy}$ about $y=0$:

$$\displaystyle e^{iy}=1+iy-\frac{y^2}{2}-i\frac{y^3}{3!}+\frac{y^4}{4!}+i\frac{y^5}{5!}-\frac{y^6}{6!}-i\frac{y^7}{7!}+\cdots$$

Grouping the real and imaginary parts,

$$\displaystyle e^{iy}=\left(1-\frac{y^2}{2}+\frac{y^4}{4!}-\frac{y^6}{6!}+\cdots\right) + i\left( y-\frac{y^3}{3!}+\frac{y^5}{5!}-\frac{y^7}{7!}+\cdots\right).$$

The real part is composed of the even terms of the expansion, while the imaginary part is composed of the odd terms.  It is easy to verify that

$$\displaystyle \cos(y)=1-\frac{y^2}{2}+\frac{y^4}{4!}-\frac{y^6}{6!}+\cdots$$

and

$$\displaystyle \sin(y)= y-\frac{y^3}{3!}+\frac{y^5}{5!}-\frac{y^7}{7!}+\cdots$$

Thus,

$$e^{iy}=\cos y+i\sin y.$$

This is known as **Euler's formula.** If we set $y=\pi$, we find that

$$e^{i\pi}=-1$$

or

$$e^{i\pi}+1=0$$

This is known as **Euler's identity**.  It is significant because it relates the fundamental numbers, $e$,  $\pi$, $i$, $1$, and $0$ using multiplication, exponentiation, addition, and equality. Euler's formula also gives us another way to write the imaginary unit:

$$e^{i\pi/2}=i$$

And this allows us to express the $n$th root of $i$ as

$$ i^{1/n} = e^{i\pi/2n}.$$

Returning to the original expression,

$$e^{z}=(\cos y + i\sin y)e^x$$