# Complex Trig Functions

Using [Euler's formula](eulers-equation.html), it is possible to 
write the basic trig functions in terms of complex exponentials.  Cosine and sine are just the real and imaginary 
parts of the complex exponential

$$ \Re \mbox{e} \left\{ e^{i\theta}\right\}=\frac{e^{i\theta}+e^{-i\theta}}{2}=\cos\theta\qquad\qquad\Im\mbox{m} 
\left\{ e^{i\theta}\right\}=\frac{e^{i\theta}-e^{-i\theta}}{2i}=\sin\theta$$

The tangent is then the ratio

$$ \tan\theta=\frac{\sin\theta}{\cos\theta}=\frac{e^{i\theta}-e^{-i\theta}}{i\left(e^{i\theta}+e^{-i\theta}\right)}$$

The secant, cosecant, and cotangent are just the reciprocals

$$ 
\sec\theta=\frac{2}{e^{i\theta}+e^{-i\theta}}\qquad\qquad\csc\theta=\frac{2i}{e^{i\theta}-e^{-i\theta}}\qquad\qquad\cot
\theta=\frac{i\left(e^{i\theta}+e^{-i\theta}\right)}{e^{i\theta}-e^{-i\theta}}$$

The angle addition formulas can be derived easily using the complex exponential forms.  First let's look at angle 
addition formulas for sine and cosine

$$ \sin(\alpha+\beta)=\Im\mbox{m}\left\{ e^{i(\alpha+\beta)}\right\} \qquad\qquad \cos(\alpha+\beta)=\Re\mbox{e} 
\left\{ e^{i(\alpha+\beta)}\right\}$$

noting that

$$ e^{i(\alpha+\beta)}=e^{i\alpha}e^{i\beta}=\left(\cos\alpha+i\sin\alpha\right)\left(\cos\beta+i\sin\beta\right)$$

$$ {}=\cos\alpha\cos\beta-\sin\alpha\sin\beta+i\left(\cos\alpha\sin\beta+\sin\alpha\cos\beta\right)$$

the real and imaginary parts give the results

$$ \cos\left(\alpha+\beta\right)=\cos\alpha\cos\beta-\sin\alpha\sin\beta$$

$$ \sin\left(\alpha+\beta\right)=\cos\alpha\sin\beta+\sin\alpha\cos\beta$$

The angle difference (subtraction) formulas can be found by replacing $\beta$ with $-\beta$ in the above 
expressions and noting that cosine has even parity while sine has odd parity,

$$ \cos\left(\alpha-\beta\right)=\cos\alpha\cos\beta+\sin\alpha\sin\beta$$

$$ \sin\left(\alpha-\beta\right)=\sin\alpha\cos\beta-\cos\alpha\sin\beta$$

The addition and subtraction formulas for tangent are simply the ratios of these

$$ 
\tan\left(\alpha+\beta\right)=\frac{\cos\alpha\sin\beta+\sin\alpha\cos\beta}{\cos\alpha\cos\beta-\sin\alpha\sin\beta}
=\frac{\tan\beta+\tan\alpha}{1-\tan\alpha\tan\beta}
$$

$$ 
\tan\left(\alpha-\beta\right)=\frac{\sin\alpha\cos\beta-\cos\alpha\sin\beta}{\cos\alpha\cos\beta+\sin\alpha\sin\beta}
=\frac{\tan\alpha-\tan\beta}{1+\tan\alpha\tan\beta}
$$

The double angle formulas can be found by setting $$\beta=\alpha$$ in the addition formulas

$$ \cos2\alpha=\cos\left(\alpha+\alpha\right)=\cos^{2}\alpha-\sin^{2}\alpha$$
$$ \sin2\alpha=\sin\left(\alpha+\alpha\right)=2\cos\alpha\sin\alpha$$

$$ \tan2\alpha=\tan\left(\alpha+\alpha\right)=\frac{2\tan\alpha}{1-\tan^{2}\alpha}$$

The half-angle formulas can be found by using the Pythagorean identity to re-write the double angle formula for cosine 
in two different ways

$$ \cos2\alpha=\cos^{2}\alpha-\sin^{2}\alpha=2\cos^2\alpha-1=1-2\sin^2\alpha$$

Then substituting $$\beta=2\alpha$$

$$ \cos\beta=1-2\sin^2(\beta/2)$$

$$ \cos\beta=2\cos^2(\beta/2)-1$$

The the half-angle formulas are then

$$ \cos^{2}(\beta/2)=\frac{1+\cos\beta}{2}$$

$$ \sin^{2}(\beta/2)=\frac{1-\cos\beta}{2}$$

$$ \tan^{2}\left(\beta/2\right)=\frac{1-\cos\beta}{1+\cos\beta}$$

In general, multiple angle formulas can be computed from the real and imaginary parts of the complex exponential

$$ e^{in\theta}=\left(e^{i\theta}\right)^{n}=\left(\cos\theta+i\sin\theta\right)^{n}$$

thus

$$ \cos n\theta=\Re\mbox{e}\left\{ \left(\cos\theta+i\sin\theta\right)^{n}\right\}$$

and

$$ \sin n\theta=\Im\mbox{m}\left\{ \left(\cos\theta+i\sin\theta\right)^{n}\right\}$$

For example, the half angle formula for cosine can be computed as

$$ \cos\left(\alpha/2\right)=\Re\mbox{e}\left\{ 
\left(\cos\alpha+i\sin\alpha\right)^{1/2}\right\}=\frac{\left(\cos\alpha+i\sin\alpha\right)^{1/2}+\left(\cos\alpha-i\sin
\alpha\right)^{1/2}}{2}$$

squaring both sides of the equation yields

$$ 
\cos^{2}\left(\alpha/2\right)=\frac{\left[\left(\cos\alpha+i\sin\alpha\right)^{1/2}+\left(\cos\alpha-i\sin\alpha\right)^
{1/2}\right]^{2}}{4}$$

which, upon expanding the square on the right hand side and simplifying, becomes

$$ \cos^{2}\left(\alpha/2\right)=\frac{2+2\cos\alpha}{4}=\frac{1+\cos\alpha}{2}$$

which is the same as the result above.

Using the complex form of the trigonometric functions also allows us to write explicit representations for the 
[inverse trigonometric functions](inverse-trig.html).