# La justice.

D'Aguesseau, *Méditations métaphysiques*.
Platon, *La République*.

## I. Introduction.

D'Aguesseau est un magistrat français du XVIIIe siècle.

L'œuvre que nous étudions s'intitule *Méditations métaphysiques sur les vraies ou les fausses idées de la justice*. L'expression de méditations métaphysiques rappelle le titre d'un livre de Descartes.

La question que D'Aguesseau se propose d'examiner est de savoir "si l'homme peut trouver en lui des idées naturelles du juste ou de l'injuste".
Comment jugeons-nous de la justice d'une action ? Est-ce par la conformité à une idée naturelle de la justice que nous trouvons en nous ? Ou par la conformité à la volonté positive d'un supérieur ?

Une volonté positive : une volonté observable, écrite. Le mot *positif* a ici le même sens que lorsqu'on parle de *droit positif*, par opposition au *droit naturel*. On parle aussi des *sciences positives* (qui s'appuient sur l'expérience), par opposition à la métaphysique.

Première méditation. Pas de question plus **intéressante**, dit l'auteur, que celle qu'on entreprend ici d'examiner. Pourquoi ? Parce que "de là dépendent tous **les devoirs** qui lient les hommes entre eux".

"Tout devient flottant et incertain dans **la morale**, s'il n'y a pas une règle naturelle, immuable, qui sépare le juste de l'injuste."

D'Aguesseau, *Méditations métaphysiques*.

Méditation.  Ce sont des pensées, ou des paroles (la pensée est une parole intérieure). C'est un dialogue avec soi-même. Comparaison entre le dialogue socratique et la méditation cartésienne : c'est soit un dialogue avec les autres, soit un dialogue avec soi-même. Cartésien : de Descartes.

Résumé simpliste de l'histoire de la philosophie : Platon, la philosophie grecque, les Anciens, le dialogue ; Descartes, la philosophie moderne, la méditation.

Le sujet, c'est la justice, les vraies et les fausses idées de la justice.

Nous étudions la première méditation.

La question est de savoir ce que sont en eux-mêmes le juste et l'injuste.

Quelle est la question (que l'auteur de ce livre entreprend d'examiner) ?

La question est de savoir s'il y a (s'il existe) "une règle naturelle qui sépare le juste de l'injuste".

Une accusation, par exemple, peut être juste ou injuste. (Une réponse juste.) Une loi peut être juste ou injuste. Une action. Un jugement.

Il est à noter que les mots "juste" et "injuste" sont employés ici comme adjectifs. Losqu'on juge qu'une chose est juste (ou injuste), sur quoi s'appuie-t-on ?

Par qui a été faite la loi qui défend le meurtre ? Où est-elle écrite ? De quand date-t-elle ?

Voilà la question : Y a-t-il une loi naturelle ? L'homme trouve-t-il en lui une idée naturelle du juste et de l'injuste (comme qualités) ?

Intérêt de la question. Pourquoi cette question nous intéresse-t-elle ?

Pourquoi est-ce une question ? Un grand nombre de philosophes s'accorde à reconnaître l'existence d'une loi naturelle. Cependant les uns et les autres n'en donnent pas la même définition. Les uns appellent loi naturelle une loi qui serait commune aux hommes et aux animaux. Les autres conçoivent la loi naturelle comme la loi du genre humain.

Cette question nous intéresse parce "qu'il n'y a qu'une justice naturelle qui puisse nous donner une notion juste des vertus et des vices".

## II. L'amour du prochain.

Certains soutiendront que toutes les lois ont pour principe l'amour du prochain. C'est la thèse de Jean Domat dans son livre sur les lois civiles. Jean Domat, *Les lois civiles dans leur ordre naturel*.

Or, nous voyons que les hommes se haïssent ; qu'ils sont enclins à se comporter de manière injuste les uns envers les autres, par exemple en s'emparant par la fraude ou par la violence de ce qui appartient aux autres.

Si la plupart des hommes évitent les grands crimes, c'est "par la crainte de la peine, non par l'amour de la vertu". 

24/09/2025

Intérêt de la question. La justice "est blessée par tous les vices et entre dans toutes vertus".

Doutes. Les philosophes s'accordent sur l'existence d'une loi naturelle, mais pas sur sa définition. Les uns conçoivent la loi naturelle comme celle qui est commune à tous les animaux. D'autres la conçoivent comme la loi commune à tous les hommes. Fort bien, dira-t-on, mais cette loi commune à tous hommes, en quoi consiste-t-elle ? Ce qui est autorisé dans un pays est interdit dans un autre. Exemples : le port d'armes, l'avortement, la polygamie, le divorce (etc.). L'âge de la majorité.

Certains philosophes soutiennent que le principe de tous nos devoirs les uns envers les autres, c'est l'amour du prochain : c'est le devoir d'aimer son prochain comme soi-même. Jean Domat, *Les lois civiles dans leur ordre naturel*.

Doutes ou objections. "Ouvrons les yeux sur nous-mêmes et sur tous ceux qui nous environnent." Voyez comme ils se haïssent : c'est ce qu'on serait tenté de dire. Dès que les hommes croient pouvoir faire des choses injustes impunément, ils le font. L'anneau de Gygès. Fable qui se trouve au livre II de *La République* de Platon. Anneau magique qui rend invisible. Berger qui trouve cet anneau. Il va s'en servir pour entrer dans le palais du roi et le tuer, après avoir séduit la reine. Meurtre, adultère, usurpation.

## III. Céphale.

Nous passons à la lecture de *La République* de Platon, qui est un dialogue sur l'essence de la justice.

Le Livre I fait un premier tour de la question. Socrate s'y entretient entre autres avec le vieillard Céphale.

Socrate se plaît à converser avec les vieillards. La vie est comme une route que nous devons parcourir. Les plus vieux ont vécu, ont fait l'expérience, de ce que les autres n'ont pas vu.

Socrate désire savoir si la vieillesse est un moment difficile. Céphale n'a pas le même avis sur ce point que la plupart des veillards. Que dit la plupart des vieillards ? Ils regrettent **les plaisirs** de la jeunesse. La bonne chère. D'autres se plaignent "des outrages auxquels l'âge les expose de la part de leurs proches".

Mot du poète Sophocle sur l'amour. Quelqu'un demande un jour au vieux Sophocle s'il n'est pas impuissant : s'il a encore du désir pour les femmes. Lui fait une réponse inattendue : "À Dieu ne plaise, il y a longtemps que j'ai secoué le joug de ce maître furieux et brutal." Céphale compare le désir amoureux à un maître tyrannique, et il se félicite d'en être délivré. L'âme humaine est comme une maison (ou comme une cité) : nous retrouverons cette idée plusieurs fois dans *La République*.

La discussion passe ensuite sur le sujet de la richesse : car Céphale est riche.

Quelle est, demande Socrate, la principale utilité de l'argent ? La plupart des hommes diraient sans doute...

Là encore, la réponse de Céphale n'est pas celle de tout le monde. À mesure qu'ils vieillissent (dit-il), les hommes se mettent à craindre des choses dont ils se moquaient dans leur jeunesse : ils redoutent que ce qu'on raconte, au sujet des châtiments qui attendent, après cette vie, ceux qui ont commis des injustices, ne soit vrai.

Aussi, ceux qui ont beaucoup de choses à se reprocher passent leurs vieux jours dans la crainte. Ceux qui, au contraire, se savent innocents, sont consolés par l'espérance (d'une vie heureuse après la mort).

À cet égard, le richesse (dit Céphale) est un avantage. C'est que le riche, par définition, a de quoi **payer ce qu'il doit** : "soit un sacrifice à un dieu, soit de l'argent à un homme".

(Il y a une similitude remarquable entre ce texte et la prière du Notre Père.)

## IV. L'opinion commune au sujet du juste et de l'injuste.

La plupart des hommes ont une certaine opinion au sujet du juste et de l'injuste, opinion qu'ils n'expriment pas toujours clairement et sincèrement.

La plupart des hommes pensent que "par nature il est bon de commettre l'injustice et mauvais de la subir". Ils pensent, d'autre part, qu'il y a "plus de mal à la subir que de bien à la commettre".

Ils estiment donc utile de **s'entendre** pour ne plus commettre ni subir l'injustice. Telle est l'essence et l'origine de la justice selon l'opinion commune.

"Donnons licence au juste et à l'injuste de faire ce qu'ils veulent."

(Sujet de dissertation : "Le juste et l'injuste ne sont-ils que des conventions ?")

L'anneau de Gygès. Un anneau magique qui donne à celui qui le porte le pouvoir de devenir invisible à volonté. Dès que Gygès découvre, par hasard, le pouvoir de l'anneau, il se sert de ce pouvoir pour commettre des injustices : il tue le roi et prend sa place.

Dès qu'on a le pouvoir de commettre l'injustice impunément, on le fait : parce qu'on croit que "par nature il est bon de commettre l'injustice".

Si l'on donnait au juste et à l'injuste l'anneau dont parle la fable, l'un et l'autre agiraient de la même façon, c'est-à-dire injustement.

S'il y avait un homme extraordinaire qui, ayant reçu l'anneau de la fable, ne s'en serve pas pour commettre des injustices, les autres penseraient de lui qu'il est fou. Ils ne le diraient pas : ils diraient même le contraire, de peur que cet homme ne se serve de son pouvoir contre eux.

## V. Naissance et devenir d'une république.

Les amis de Socrate prient ce dernier de leur faire voir **que la justice est un vrai bien** ; et qu'il faut la pratiquer pour être heureux.

Il y a de la justice (ou de l'injustice) dans l'homme d'une part, et dans la cité d'autre part. Socrate propose de commencer par considérer l'essence de la justice dans la cité.

Imaginons, dit-il, **la naissance d'une cité** ou d'une république.
 
Qu'est-ce qu'une cité ? Ce sont des hommes qui ont **besoin** pour **vivre** d'une foule de choses. Ils ont besoin, entre autres choses, de nourriture, de logement, de vêtements, de chaussures... Ils vont devoir **travailler** pour **produire** toutes ces choses : labourer la terre, bâtir des maisons, etc.

Comment vont-ils travailler ? Chacun fera-t-il tour à tour tous les travaux, ne produisant que pour lui-même ? Ou bien fera-t-il un seul travail, produisant pour toute la communauté ?

Il est plus avantageux, et par conséquent plus naturel, que chacun fasse un seul travail. Trois raisons expliquent pourquoi cela est plus avantageux : 1° la nature ne nous a pas faits tous semblables. L'un est apte à un travail, l'autre à un autre. 2° On travaille mieux quand on fait un seul travail, puisque c'est en faisant un métier qu'on l'apprend. 3° Il y a un temps pour faire chaque chose, et ce temps est imposé par l'ouvrage.

Pour toutes ces raisons, il est bon que chacun fasse un seul travail. En vertu de ce principe, le laboureur ne fera pas lui-même ses outils : il y aura donc aussi dans la cité des forgerons... Le laboureur n'ira pas s'asseoir sur la place du marché pour vendre ses produits : c'est le travail des commerçants.
 
