# La justice.

Platon, *La République*.
D'Aguesseau, *Méditations métaphysiques*.

## I. Introduction.

D'Aguesseau est un magistrat français du XVIIIe siècle.

L'oeuvre que nous étudions s'intitule *Méditations métaphysiques sur les vraies ou les fausses idées de la justice*.

La question que l'auteur examine est de savoir "si l'homme peut trouver en lui des idées naturelles du juste ou de l'injuste".

Comment jugeons-nous de la justice ou de l'injustice de nos actions ? Est-ce par la conformité de ces actions à des idées naturelles que nous trouvons en nous, ou est-ce par la conformité à la volonté positive d'un supérieur ?

Positif : 1. Qui s'appuie sur les faits, l'expérience. Les sciences positives. Le positivisme (la philosophie d'Auguste Comte). 2. Se dit, par opposition à "naturel", de ce qui est écrit. Droit positif et droit naturel.

Première Méditation.

Il n'y a pas, dit l'auteur, de question plus intéressante que celle qu'on entreprend ici d'examiner. Pourquoi ? Parce que de là dépendent tous les **devoirs** qui lient les hommes entre eux. Tout devient flottant et incertain dans **la morale**, s'il n'y a pas **une règle naturelle, immuable**, qui sépare le juste de l'injuste. Règle naturelle : qui existe sans avoir été faite. Immuable : qui ne peut pas changer.

La question que l'auteur examine est celle "du principe et du fondement de toute la morale". La morale c'est (d'après l'étymologie) la science des mœurs. Quand on dit que c'est un mal (une mauvaise action) de faire ceci ou cela, sur quoi s'appuie-t-on pour l'affirmer ? Y a-t-il une loi naturelle ?

De nombreux sages anciens et modernes ont soutenu **qu'il y avait une loi naturelle** : une loi dont les premiers principes sont connus par eux-mêmes de tous les hommes, comme les **axiomes** de la géométrie. 
Axiomes : vérité évidente et non démontrable, par exemple que le tout est plus grand que la partie.

La plupart des philosophes conviennent qu'il y a une loi naturelle. Seulement ils n'en donnent pas tous la même définition. Les uns appellent *loi naturelle* la loi qui serait commune à tous les animaux. Les autres appellent *loi naturelle* celle qui est commune à tous les hommes. La difficulté est alors  de savoir quelle est cette loi prétendument commune à tous les hommes.
 
D'Aguesseau, *Méditations métaphysiques*. Méditation. Ce sont des pensées ou des paroles (la pensée est une parole). C'est un dialogue avec soi-même. "La pensée est un dialogue silencieux de l'âme avec elle-même", dit Platon.

Résumé simpliste de l'histoire de la philosophie : Platon, ou la philosophie grecque, ou le dialogue ; Descartes, ou la philosophie moderne, ou la méditation.

Le sujet (la question), c'est l'essence de la justice. C'est la question de savoir s'il y a **une loi naturelle**. On parle d'une loi éternelle (elle n'a pas été faite), universelle (pour le monde), une loi que tout le monde connaît.

C'est la loi (si elle existe) qui défend le meurtre, le vol ou le larcin, l'adultère... "Quel voleur accepte qu'on le vole ?" demande saint Augustin. Le voleur ne respecte pas la loi mais il la reconnaît. La loi naturelle, dit le même saint Augustin, est "la loi qui est gravée dans le cœur de l'homme". Si c'est gravé, c'est inaltérable, ineffaçable, immuable.

La loi naturelle, par opposition aux **lois positives**. La loi Bonald abolit le divorce en France (en 1816).

Pourquoi ne pas s'en tenir aux lois positives ? Parce que (dit encore le même Augustin) "les hommes désirent, non seulement croire, mais aussi comprendre". *Traité du libre arbitre*. Exemple de l'adultère.

Certains auteurs (comme Domat) soutiennent que la loi naturelle consiste dans le devoir d'aimer son prochain comme soi-même.

Y a-t-il dans l'homme une pente naturelle à aimer son semblable ? Philanthropie. Altruisme.

Quel est le philosophe qui a soutenu la thèse de la bonté naturelle de l'homme ? Rousseau.

Si nous ouvrons les yeux sur le monde tel qu'il est, et sur les hommes tels qu'ils sont, que vois-je ? Je vois que les hommes se haïssent. Qu'ils ont de l'envie les uns des autres (qu'ils sont envieux). Qu'ils sont portés à commettre des injustices, et que s'ils s'en abstiennent, c'est "par la crainte de la peine, et non par l'amour de la vertu".

L'anneau de Gigès (ou Gygès). Histoire qui est racontée par Platon dans *La République*. Une fable. Un berger trouve un anneau magique qui permet de se rendre invisible à volonté. Gygès s'introduit dans le palais du roi, le tue et devient roi à sa place. Cette histoire montre que dès que les hommes ont l'assurance de l'impunité, plus rien ne les retient de faire des choses injustes. L'occasion fait le larron.

24/09/2025

La question est celle de l'essence de la justice. La question de savoir s'il existe une loi naturelle, "une règle naturelle qui sépare le juste de l'injuste".

Intérêt de la question. Il s'agit du principe et du fondement de la morale. La justice est blessée par tous les vices et entre dans toutes les vertus. S'il n'y a pas une justice naturelle "antérieures à toutes les institutions positives", je ne peux pas connaître mes devoirs, je ne peux pas avoir "une notion juste des vertus et des vices".

Les philosophes s'accordent à affirmer l'existence d'une loi naturelle ; mais ils n'en donnent pas tous la même définition.

Mettons que cette loi soit la loi commune à tous les hommes. En quoi consiste-t-elle ? Les uns condamnent ce que les autres approuvent. Fragment des *Pensées* de Pascal : "Plaisante justice qu'une rivière borne. Vérité en deça des Pyrénées, vérité au-delà." Rivière : l'image de la frontière. Droit de port des armes. Polygamie, divorce. Manière de se vêtir. L'avortement, l'euthanasie.

Quelqu'un dira peut-être, comme Domat, que le premier principe de toutes les lois civiles est le devoir d'aimer son prochain comme soi-même. Jean Domat, *Les lois civiles dans leur ordre naturel*.

Doutes, objections. Si nous ouvrons les yeux sur nous-mêmes et sur tous ceux qui nous environnent, nous voyons que les hommes se haïssent. Ils sont injustes par inclination. Ils évitent les grands crimes par crainte de la peine. Anneau de Gygès. Fable. Anneau magique qui donne à celui qui le porte le pouvoir de devenir invisible à volonté. Meurtre, adultère, usurpation.

Les hommes ne sont justes que malgré eux. C'est la remarque que fait l'un des personnages de *La République*. Les hommes pensent, sans toujours oser le dire, que l'injustice est plus profitable individuellement que la justice.

Autre opinion. Le juste et l'injuste ne sont que des conventions, qui ont pour principe le désir de conservation. On a peur d'être tué, donc on se met d'accord pour dire que le meurtre est une mauvaise action, et que le meurtrier mérite d'être puni. Telle est l'origine et la nature de la justice selon l'opinion commune. (C'est ce que dit Platon dans *La République*.) C'est aussi l'opinion de certains philosophes comme Hobbes.

L'état de nature. Le premier état de la nature. C'est une hypothèse qu'on chez plusieurs philosophes, chez Hobbes, chez Rousseau : ces auteurs imaginent que les premiers hommes vivaient sans lois. Ce prétendu "état de nature", Hobbes l'imagine comme un état du guerre permanente de tous contre tous.

Dans cet état de choses, il y a un droit naturel : c'est le droit du plus fort. Les anciens Gaulois qui se rendirent maîtres de Rome : c'est un épisode de l'histoire romaine raconté Tite-Live.

Afin de sortir de cet état de choses misérable, les hommes conviennent de tous obéir à un souverain : c'est la théorie du contrat social.

## II. Étude de La République de Platon.

### A. Céphale.

Le dialogue de Platon intitulé *La République* est un dialogue sur l'essence de la justice. On se demande quel est le meilleur gouvernement. Le meilleur gouvernement est le plus juste.

Au début du livre, Socrate s'entretient avec le vieillard Céphale.

Le sujet de la discussion, c'est la vieillesse. Socrate se plaît "à converser avec les vieillards". La vie, dit Socrate, est une route qu'on parcourt. Ceux qui sont au milieu de la route peuvent se faire une idée de la suite du parcours en interrogeant ceux qui ont parcouru une plus grande distance. Plaisir de la conversation, plaisir de s'instruire.

Socrate veut savoir si la vieillesse est un moment difficile. Vieillesse et faiblesse. Céphale n'a plus la force d'aller en ville.

Sur ce sujet, il y a ce que disent la plupart des gens, et ce qu'en disent quelques autres. La plupart des vieillards regrettent **les plaisirs** de la jeunesse : plaisirs de l'amour, du vin, de la bonne chère. Le commun des mortels croit que le bonheur consiste dans le plaisir. Hédonisme.

Mot de Sophocle sur l'amour. Quelqu'un demande au vieux Sophocle s'il n'est pas impuissant. Sophocle s'estime heureux d'avoir moins de désirs pour les femmes. Parce que le désir est comme "un maître rageur et sauvage". Sophocle s'estime **libéré** de la tyrannie des désirs.

La discussion passe ensuite à un autre sujet, **la richesse**. Car Céphale est riche. Si Céphale ne s'estime pas malheureux, s'il ne croit pas être à plaindre, c'est peut-être grâce aux consolations que la richesse apporte.

La réponse de Céphale (à la question de savoir quel est l'avantage d'avoir de l'argent) n'est pas la réponse de tout le monde.

Il y a une crainte que connaissent les vieillards et que ne connaissent pas les jeunes gens. Il s'agit **de ce qu'on raconte** au sujet de l'enfer : au sujet des châtiments qui seraient réservés dans l'au-delà, à ceux qui ont commis des injustices dans cette vie. Les jeunes, en général, se moquent de ces histoires, qu'ils prennent pour des fables. Les vieux, au contraire, craignent que ces histoires ne soient vraies.

Ceux qui se savent innocents  passent leurs vieux jours dans l'espérance, tandis que les autres les passent dans la crainte.

C'est là que le vrai avantage de la richesse apparaît. L'homme riche peut payer ses dettes. L'homme pauvre est quelquefois contraint de commettre des injustices, par exemple s'il n'a pas de quoi **payer ses dettes**. (À comparer avec la définition du courage par Lachès.) Voilà donc **la plus grande utilité de l'argent** selon Céphale.

Socrate pose alors la question de l'essence de la justice. Pour Céphale, la justice consiste à **rendre chacun ce qui lui appartient**. N' y a-t-il pas certaines circonstances où il est injuste de rendre à quelqu'un ce qui lui appartient ? Par exemple un ami m'a confié une arme, alors qu'il était sain d'esprit. Devenu fou, il vient me la réclamer. Tout le monde conviendra qu'on ne doit pas lui rendre son arme, que ce ne serait pas juste.

La définition, que Céphale a proposée, de la justice n'est pas satisfaisante.

01/10/2025

La plupart des vieilles gens regrettent les plaisirs de la jeunesse, les plaisirs des sens. Ils estiment qu'une vie sans plaisir est une vie malheureuse. On appelle *hédonisme* cette philosophie qui assimile bonheur au plaisir. On pourrait l'appeler aussi *épicurisme*, à cause d'Épicure.

Mot de Sophocle. Sophocle s'estime heureux de ne plus éprouver ce genre de désir. Il voit dans le désir amoureux "un maître furieux et tyrannique".

L'âme humaine est comme une maison, ou comme une cité.

Richesse. Il est plus facile à l'homme riche de payer ses dettes. Soit qu'il doive un sacrifice à un dieu, soit qu'il doive de l'argent à un homme, il peut s'en acquitter (il en a les moyens).

Ce qui inquiète Céphale, c'est de mourir avec des dettes. L'idée que Céphale se fait de la justice, c'est de rendre à chacun ce qui lui appartient. (Dans la prière du Notre Père, dans sa version latine, il est aussi question de dettes : "remettez-nous nos dettes commes nous remettons à nos débiteurs".) 

C'est l'image que Céphale se fait de la justice.

Mais si un ami m'a confié une arme, alors qu'il était sain d'esprit, et que devenu fou, il me la réclame, je ferais une mauvaise action si je la lui rendais. Ce ne serait pas agir avec justice, ce ne serait pas bien agir.

Donc la question se pose de savoir **ce qu'est la justice**, et comment on peut la définir.

Il y a un auteur qui a expliqué pourquoi on ne doit pas rendre l'épée : c'est Domat dans le *Traité des lois*. Rendre l'épée dans ces circonstances, ce ne serait pas aimer la personne (vouloir son bien). Ce serait serait enfreindre "le commandement d'aimer".

### B. Nature de la justice selon l'opinion commune. L'anneau de Gygès.

On se demande ce qu'est la justice, et on se demande aussi s'il vaut mieux pratiquer la justice ou l'injustice.

Les hommes pensent, sans l'avouer, que l'injustice est plus profitable indidividuellement que la justice.

L'anneau de Gygès. Si vous voulez savoir ce que les hommes pensent, n'écoutez pas ce qu'ils disent ; donnez-leur l'anneau et regardez ce qu'ils feront.

Comme dit le proverbe, l'occasion fait le larron. Dès qu'un homme a l'assurance de l'impunité, il commet des injustices, parce qu'il croit que l'injustice est avantageuse.

Si quelqu'un prétend qu'il n' a pas cette opinion, faisons **une expérience** : donnons-lui le pouvoir que reçut Gygès dans la fable. Pouvoir de se rendre invisible à volonté. Assurance de l'impunité.

En jouant avec l'anneau, Gygès constate que l'anneau lui donne le pouvoir d'être invisible. Les personnes qui sont à côté de lui se mettent à parler de lui comme s'il n'était pas là. (Pensée de Pascal sur le même sujet : "Si les hommes savaient ce qu'ils disent les uns des autres, il n'y aurait pas quatre amis dans le monde.")

Le juste, l'injuste : l'homme juste, l'homme injuste. Si on donne à l'un et à l'autre le pouvoir dont parle la fable, ils agiront de la même façon : ils pratiqueront l'injustice impunément, et de cette façon ils seront heureux. Ils auront raison d'agir ainsi, si l'on en croit la manière commune de penser sur ce sujet. D'ailleurs, s'il y avait un homme qui, possédant l'anneau de Gygès, s'abstenait volontairement de commettre toute injustice, les autres penserait de lui qu'il est fou ; mais ne le diraient pas en sa présence. En sa présence ils le loueraient et l'approuveraient, l'appelleraient "juste", de peur d'être ses victimes.

Les hommes croient que le juste et l'injuste ne sont que **des conventions** : on s'est entendu pour dire que l'injustice était un mal et pour l'interdire. "Ils estiment utiles de s'entendre". Telle est l'origine et l'essence de la justice, selon l'opinion. Cette même opinion se retrouve chez certains philosophes, comme Hobbes. À l'origine, dit Hobbes, il y a un état d'anarchie, "l'état de nature", qui est un état de guerre de tous contre tous. Poussés par le désir de leur conservation, les hommes renoncent à leur liberté et acceptent le contrat social.

### C. Histoire d'une cité.

Les amis de Socrate l'invitent, lui le champion de la justice, à leur montrer que la justice, contrairement à l'opinion commune, est un vrai bien, pour celui qui la pratique.

Où y a-t-il, demande Socrate, de la justice ou de l'injustice ? Il y en a dans l'homme, d'une part, et dans la cité d'autre part. Socrate choisit de considérer d'abord la nature de la justice dans la cité.

**Imaginons**, dit-il, **la naissance d'une cité**. La cité : par exemple Athènes, non pas seulement la ville d'Athènes, mais la république d'Athènes. *Res publica* : la chose publique.

Ce qui pousserait les hommes à vivre en société, si ce n'était pas le cas, c'est **le besoin** qu'ils ont, **pour vivre**, d'une foule de choses qu'ils sont incapables de se procurer par eux-mêmes.

De quoi ont-ils besoin ? Ils ont besoin de nourriture, de logement, de vêtement (pour commencer).

Ces choses, il faut travailler pour les produire. Il faut labourer la terre, construire des maisons...

Une cité, ce sont des hommes qui ont des besoins et qui doivent travailler pour satisfaire leurs besoins.

Comment travailleront-ils ? On pourrait imaginer que chacun fasse tour à tour tous les travaux : qu'il soit à la fois laboureur, maçon... L'autre possibilité serait que chacun fasse un seul travail, et produise pour toute la communauté.

Il est évident que c'est cette dernière possibilité qui est la plus avantageuse (et par conséquent **plus naturelle**).

Il y a trois principales raisons à cela : 1° la nature ne nous a pas faits tous semblables, mais avec des aptitudes différentes ; 2° on apprend un métier en le faisant ; 3° il y a un temps pour faire chaque chose.

Toutes ces raisons font qu'il est plus avantageux que chacun fasse un seul travail : le sien, celui qui correspond à ses compétences.

Il faudra donc aussi dans la cité des commerçants, un marché, une monnaie.

Voilà ce qu'est essentiellement une cité, une république. La loi fondamentale de la cité est celle qui veut que chacun fasse son travail. 
