
program Renamer;

uses
{$IFDEF unix}
  cthreads,{ cwstring,}
{$ENDIF}
  SysUtils, Classes, FindFiles;

var
  oldnames, newnames: TStringList;
  log: TextFile;
  i: integer;
  s: string;
  
begin
  Assign(log, ChangeFileExt(ParamStr(0), '.log'));
  Rewrite(log);
  
  oldnames := TStringList.Create;
  newnames := TStringList.Create;
  
  (* Recherche des fichiers. *)
  SearchFiles(oldnames, '.', '^(.+\.md)$');
  
  WriteLn(oldnames.Count);
  
  for i := 0 to oldnames.Count - 1 do
  begin
    (*
    s := ChangeFileExt(ExtractFileName(oldnames[i]), '');
    s := StringReplace(s , ' ', '-', [rfReplaceAll, rfIgnoreCase]);
    *)
    
    s := ChangeFileExt(oldnames[i], '');
    newnames.Append(s);
    
    (* Enregistrement des transformations dans le journal. *)
    if newnames[i] <> oldnames[i] then
    begin
      WriteLn(log, Format('oldnames[%0.3d]: "%s"', [i, oldnames[i]]));
      WriteLn(log, Format('newnames[%0.3d]: "%s"', [i, newnames[i]]));
      //RenameFile(oldnames[i], newnames[i]);
    end;
  end;
  
  oldnames.Free;
  newnames.Free;
  
  Close(log);
end.
