
# La liberté

## I. Ambiguïté du terme de liberté

"Le terme de liberté (dit Leibniz) est fort ambigu."

Essayons de distinguer les différents sens du mot "liberté" en suivant la méthode proposée par Leibniz. Dichotomie.

![Image](arbre.png)

### A. Liberté de droit et liberté de fait

Voici la première ambiguïté : il y a *liberté de droit* et *liberté de fait*.

Quand on oppose l'esclave à l'homme libre, on parle de la *liberté de droit*.

### B. Liberté de faire et liberté de vouloir

Il faut encore distinguer entre *liberté de faire* et *liberté de vouloir*.

La *liberté de faire*, c'est le pouvoir de faire ce qu'on veut. Prison, maladie.

La liberté de faire est une chose, la liberté de vouloir en est une autre.

Envoûtement, enchantement.

Une personne enchantée (dans le premier sens du terme) n'a plus toute sa liberté de vouloir.

### C. Tempérance et libre arbitre

Enfin, la liberté de vouloir peut (comme le remarque Leibniz) se concevoir de deux façons, suivant qu'on l'oppose à l'esclavage d'esprit ou à la **nécessité** (au sens qu'a ce terme dans le langage philosophique).

Vocabulaire. **Nécessaire** : qui ne peut pas ne pas être ou ne pas se faire. Si je lâche la pierre que je tiens dans ma main, elle va *nécessairement* tomber : il est impossible qu'elle ne tombe pas. Ce qui n'est pas nécessaire est **contingent**.

## II. Le libre arbitre (Le sentiment de la liberté)

Dire que nous avons un libre arbitre, c'est dire que nos actes volontaires (nos volitions) sont contingents.

Si on me demande de choisir un nombre au hasard, ou de choisir entre la droite et la gauche, je sens clairement qu'il est en mon pouvoir de choisir **ou l'un ou l'autre**.

Il y a des philosophes et des théologiens qui ont nié le libre arbitre.

Luther. Luther, c'est un chrétien qui croit qu'il y a un Dieu, et que ce Dieu est omniscient. Luther affirme qu'il est impossible de croire à la fois à l'omniscience divine et à la liberté de l'homme. 

### A. Évidence du libre arbitre

Bossuet, *Traité du libre arbitre,* chapitres 1 et 2.

On ne doute ni de la *liberté de droit* ni de la *liberté de faire*. "La question est de savoir s'il y a des choses qui soient tellement en notre pouvoir que nous puissions ou les choisir ou ne les choisir pas." Ou... ou... : contingence.

Ce que Bossuet va montrer dans le chapitre 2, c'est qu'il est **certain** que nous avons un libre arbitre, parce que cela est **évident**. (Ce lien entre évidence et certitude nous rappelle Descartes.)

Bossuet distingue trois sortes d'évidence : l'évidence du sentiment, l'évidence du raisonnement et l'évidence de la révélation.

La promenade. Quelqu'un m'invite à une promenade. Je sens en moi-même que je pourrais ou accepter ou refuser. En revanche, je ne peux pas ne pas vouloir être heureux. J'ai nécessairement cette volonté.

Pourquoi peut-on douter malgré tout de la liberté ? "Parce que dans les délibérations importantes il y a toujours quelque raison qui nous détermine, et qu'on peut croire que cette raison fait dans notre volonté **une nécessité secrète dont notre âme ne s'aperçoit pas**." J'ai choisi d'aller à la promenade : il y a une raison qui m'a déterminé à le faire.

Comment sortir de ce doute ? Comment faire une **expérience** encore plus claire de notre liberté ? En choisissant entre deux choses qui
nous sont égales, comme : de lever la main et de la tourner d'un côté ou de l'autre. Quelle différence avec l'exemple de la promenade ? C'est que cette fois-ci, je n'ai aucune raison de choisir l'un plutôt que l'autre : les deux choses me sont absolument indifférentes.

C'est lorsque j'ai à choisir entre deux choses égales que je fais l'expérience la plus claire de ma liberté.

Cette expérience me fait aussi comprendre que **je suis fait à l'image de Dieu**. "Tel qu'il est à l'égard de toute la matière, tel a-t-il voulu que je fusse à l'égard de cette petite partie de la matière qu'il a mise dans la dépendance de ma volonté." Quelle est cette partie de la matière dont parle Bossuet ?

### B. La doctrine horrible de Luther

Bossuet, *Histoire des variations des églises protestantes*.

Il est impossible, soutient Luther, qu'un autre que Dieu soit libre. Il est impossible d'affirmer à la fois la prescience divine.

L'argument de Luther n'est pas méprisable : il y a bien là une difficulté. Mais la doctrine de Luther, dit Bossuet, est "horrible".

Pourquoi cette doctrine est-elle horrible ? Parce qu'elle fait de Dieu l'auteur de toutes nos ations, bonnes ou mauvaises. C'est ce que Luther écrit en toutes lettres : "Que Dieu fait en nous le mal comme le bien. Cette doctrine est horrible puisqu'elle nous conduit à croire à un Dieu mauvais.

## III. L'origine du mal

Saint Augustin, *Du libre arbitre*. Un dialogue philosophique à la manière de Platon.

Auparavant nous lisons une page tirée des *Confessions*.

### A. Le fruit défendu

Vocabulaire. Le larcin : le vol. (Le larron : le voleur.) Iniquité : injustice, méchanceté. L'indigence : la pauvreté. Un abîme : une cavité profonde ou sans fond.

Il y a une **loi naturelle**. La loi qui défend de voler n'a pas été faite : c'est une loi éternelle (ou encore divine comme le dit saint Augustin). Elle n'a pas été faite par l'homme. Ce dernier la connaît naturellement : elle est "gravée dans son cœur". L'homme peut l'enfreindre ; mais il ne peut pas l'abolir. Le voleur n'accepte pas qu'on le vole. Le riche n'admet pas l'excuse de l'indigence.

Récit. L'auteur raconte comment il a volé des poires sur l'arbre d'un voisin. Il a volé ces fruits, non pas pour les manger, mais pour le seul plaisir d'enfreindre la loi, de faire le mal. L'auteur s'étonne et se demande pourquoi les hommes trouvent du plaisir dans le mal.

Le fruit défendu peut nous faire penser, d'une part, à la faute d'Adam et Ève, et d'autre part à l'adultère, dont saint Augustin parle longuement dans le dialogue *Du libre arbitre*.

### B. L'origine du mal

Évodius demande si Dieu n'est pas l'auteur du mal.

Si on croit que Dieu est bon, répond Augustin, on peut pas croire qu'il soit l'auteur du mal. C'est chaque méchant qui est l'auteur de sa mauvaise action. Cependant une **question troublante** se pose : si c'est Dieu qui a créé les hommes qui font le mal, n'en est-il pas d'une certaine l'auteur ?

Augustin raconte que c'est cette question qui l'a poussé vers le **manichéisme**, vers l'hérésie manichéenne. Saint Augustin a été hérétique. Les manichéens croient qu'il y a un Dieu bon et un Dieu mauvais. (Ceux qu'on a appelés en France cathares et albigeois sont des manichéens. Les manichéens étaient végétariens. Le mot "bougre" vient aussi de là.)

Qu'est-ce qu'une mauvaise action ? Évodius ne sait pas quelle **définition** donner. À la place il donne des **exemples**. Je ne sais pas, dit-il, ce qu'est une mauvaise action ; mais je suis certain que l'adultère ou l'homicide, par exemple, sont de mauvaises actions : tout le monde en convient.

Pourquoi l'adultère est-il une mauvaise action ? Trois réponses vont être successivement examinées.

Première réponse : L'adultère est un mal parce qu'il est défendu. C'est mauvais parce que c'est interdit.

Que penser de cette réponse ? Cette réponse n'est pas entièrement satisfaisante. Que la chose soit interdite, c'est signe qu'elle est mauvaise. Mais elle n'est pas mauvaise *parce qu'elle est interdite* ; elle est interdite *parce qu'elle est mauvaise*. Cette réponse ne nous fait pas **comprendre** ce que l'adultère a de mauvais.

"Les hommes désirent non seulement croire, mais aussi comprendre."

Deuxième réponse : L'adultère est un mal parce que je ne voudrais que cela m'arrive. Ce que je ne voudrais que les autres me fassent, je ne dois pas le faire moi-même.

Cette réponse a un point faible.


La morale est-elle une science ? Ou alors le bien et le mal ne sont-ils qu'affaire d'opinion ?

Exemple de l'adultère. Exemple de mauvaise action. Tout le monde **croit** que l'adultère est une mauvaise action ; et cette unanimité est signe de vérité. Mais croire est une chose, savoir en est une autre. **Savoir**, c'est comprendre.

On désire comprendre ce qu'il y a de mal dans l'adultère. L'adultère est un mal parce qu'on ne veut pas le subir.

Cet réponse a un point faible. "Si la passion..." La passion : dans le texte latin, c'est le mot *libido*. Le désir, le désir charnel. Voir l'adjectif "libidineux".

Un homme effronté et libidineux pourrait accepter de livrer son épouse à un autre. Ce serait mal agir ; et pourtant cet homme pourrait dire : "Je ne fais rien de mal, puisque je consens à subir la même chose."

Le consentement éventuel de la victime n'enlève rien à la malice ou à la "mauvaiseté" de l'action.

Troisième réponse possible. Je sais que l'adultère est un mal parce qu'il y a des gens qui sont condamnés pour cela. Condamnés à la lapidation (à être tué à coups de pierre).

La condamnation est-elle le signe certain d'une action mauvaise ? N'y a-t-il pas dans les histoires des exemples d'hommes condamnés pour de bonnes actions ?

On pourrait donner l'exemple de Socrate. Certes il est condamné pour impiété. Les véritables raisons de la condamnation de Socrate, c'est qu'il fait sentir aux autres leur ignorance. Les gens croient savoir des choses. Socrate, en les questionnant, leur fait voir qu'ils ne sont pas aussi sages qu'ils croient. C'est un service qu'il leur rend ; mais en leur rendant ce service il se fait haïr.

Finalement Évodius se rend compte qu'il ne sait pas pourquoi l'adultère est un mal. (Le personnage d'Augustin remplit dans le dialogue le même rôle que Socrate dans les dialogues de Platon. Voir par exemple le passage du *Ménon* sur le carré deux fois plus grand.)

Peut-être (dit Augustin) que c'est le désir qui est mauvais. Un homme qui convoite la femme d'un autre, même si les circonstances l'empêchent de passer à l'acte, est déjà coupable. Le mal est dans l'intention. 

Y a-t-il des désirs mauvais ?

La suite de la discussion porte, non plus l'adultère, mais sur le meurtre (l'homicide).

Que penser, pour commencer, d'un esclave qui tue son maître par peur des mauvais traitements que ce dernier lui inflige ? C'est une mauvaise action. Cet homme sera condamné. Pourtant, ce qu'il désirait, tout le monde le désire. Il désirait une vie paisible. on ne peut pas dire que ce soit un désir mauvais. Ce qui est mauvais, c'est qu'il désire ce bien, qu'il l'aime au point de verser le sang d'un homme. Ce qui est mauvais, c'est **l'amour des choses qu'on peut perdre contre son gré**. Par exemple la vie.

Que penser, ensuite, d'un homme qui en tue un autre qui est sur le point de le tuer ? Un bandit est sur le point de tuer ou de violer une personne : cette dernière le tue pour se défendre. D'après ce qui a été dit précédemment, cette action paraît mauvaise. Pourtant, cette personne en état de légitime défense ne sera pas condamnée. Comment se fait-il que la loi permette une mauvaise action ? Cette loi est-elle juste ?

Cette loi est juste. Aux yeux du législateur, la mort d'un injuste agresseur est **un moindre mal** que la mort d'un innocent.

Néanmoins, cette action reste mauvaise, et condamnée par **la loi éternelle**.

Les deux lois. Il y a une **loi temporelle** et une **loi éternelle**. La loi éternelle peut aussi être appelée **loi naturelle**. C'est cette loi qui n'est pas écrite sur le papier, mais "gravée dans le cœur de l'homme". Relire sur ce sujet la page des *Confessions* où saint Augustin raconte avoir volé des poires sur l'arbre d'un voisin. La loi qui interdit le larcin, ce n'est pas la loi de tel ou tel État ; c'est la loi naturelle.

Ce n'est pas parce que la loi temporelle permet une action que celle-ci est bonne. Une action peut être mauvaise et néanmoins permise par la loi, par la loi temporelle. La légitime défense.
