
# Sur l'indifférence.

Étude des *Pensées* de Pascal.

## I. Introduction.

Les *Pensées* de Pascal sont un livre inachevé. C'est un livre qui parle principalement de religion. C'est une **apologie** (une défense) de la religion chrétienne, qui s'adresse aux athées, ou encore aux **libertins**, ou encore à ceux que Pascal appelle **les esprits forts**. (Parce qu'ils disent que la religion est pour les esprits faibles, pour les personnes qui ont besoin de consolation et d'illusion. Freud, *L'avenir d'une illusion*. Marx : « La religion est l'opium du peuple. »)

Dans la langue du XVIIe siècle, le mot *libertin* a un sens à la fois intellectuel et moral. Mœurs. Il y a un personnage de théâtre qui incarne le libertin, c'est Dom Juan.

## II. Lecture (sur l'indifférence).

Il est question dans ce fragment de l'immortalité de l'âme. La question de l'immortalité de l'âme, autrement dit la question de savoir s'il y a une autre vie après celle-ci, si l'âme meurt ou ne meurt pas en même temps que le corps, est une des grandes questions de la philosophie.

Selon Kant, toute la philosophie tourne autour de trois questions :

- Que puis-je connaître ?
- Que dois-je faire ?
- Que m'est-il permis d'espérer ?

Revenons à Pascal. Personne ne peut être indifférent à la question de savoir si son âme est immortelle ; autrement dit à la question de savoir s'il y a "des biens éternels à espérer".

Toute notre conduite dépend de ce que nous croirons à ce sujet. Pour être indifférent à cette question, dit Pascal, il faut « avoir perdu tout sentiment » : un peu comme les morts-vivants des romans.

Il y a à l'égard trois sortes de personnes. 1° Celles qui sont persuadées (de l'immortalité, de l'existence des biens éternels, en un mot de la vérité de la religion). 2° Celles qui ne sont pas persuadées mais qui cherchent à s'instruire. 3° Celles qui ne sont pas persuadées et qui ne cherchent pas ; mais qui vivent « sans s'en mettre en peine et sans y penser ».

C'est de cette dernière sorte de personnes que parle Pascal dans ce fragment : les indifférents. Cette indifférence, dit Pascal, est étonnante, épouvantable, monstrueuse. Il est incompréhensible que quelqu'un puisse être indifférent à sa propre destinée.

La prosopopée de l'athée. Pascal imagine le discours que tient intérieurement le libertin. Dans la première partie du discours, le libertin fait un tableau sombre de sa condition, de la **condition humaine**. Il remarque qu'il est dans **une ignorance terrible de toutes choses**. Tout ce qu'il sait, c'est qu'il doit mourir ; et il ne sait même pas ce qu'est la mort.

Le discours du libertin se termine par une conclusion **extravagante** (insensée, déraisonnable) : le libertin décide de passer sa vie sans jamais penser à la mort, sans jamais se demander ce qu'il adviendra de lui lorsqu'il quittera ce monde.

L'extravagance du libertin prouve, au yeux de Pascal, la vérité d'une partie de la religion chrétienne. La foi chrétienne, dit Pascal, consiste principalement à croire deux choses : 1° la corruption de la nature humaine ; 2° la rédemption de Jésus-Christ. Voir Littré au mot « corruption ». Corruption d'un texte. La corruption d'une viande.

L'indifférence monstrueuse du libertin à sa propre destinée prouve que la nature humaine est corrompue, prouve que l'homme mauvais, malade.

On pourrait rapprocher des *Pensées* de Pascal l'opéra de Mozart *Don Giovanni*. Dom Juan, c'est le personnage du libertin (dans les deux sens du mot). Bonne interprétation de Furtwängler.

## III. Le divertissement.

Un roi a tout apparemment pour être heureux. Pourtant, s'il est sans divertissement, il sera malheureux, tout roi qu'il est.

Pourquoi sera-t-il malheureux ? Parce qu'il pensera à lui-même, à sa **condition misérable**. Il pensera aux maux qui le menacent : la mort, les maladies, les « révoltes qui peuvent arriver »...

Qu'est-ce que Pascal appelle divertissement ? Exemples : la chasse, le jeu (en particulier le jeu d'argent), la guerre, la « conversation des femmes »...

Le chasseur, remarque Pascal, ne voudrait pas du lièvre qu'il poursuit si on le lui offrait. Ce qui prouve que l'objet de son désir n'est pas le lièvre, mais autre chose. Quoi ? il cherche un moyen de ne plus penser à la mort, de ne plus penser à sa condition misérable. Il cherche à **détourner** son esprit de la pensée de la mort.

Voir Littré. Divertir une somme d'argent.

Dom Juan (le libertin, l'homme dissolu) n'est-il pas lui aussi quelqu'un qui cherche à se divertir au sens où l'entend Pascal ? Air du catalogue.

## IV. Raison et déraison.

Que faut-il penser de la monarchie héréditaire ?

Un philosophe superficiel dirait que cette loi (qui veut que le fils succède au père) est déraisonnable. Il vaudrait mieux, dira encore ce philosophe, qu'on choisisse le meilleur des citoyens, le plus vertueux. Ce serait plus raisonnable.

Cependant, qu'arriverait-il ?

Les faux philosophes jugent mal des choses, parce qu'ils ne savent pas que la nature humaine est corrompue, et que le monde est « un hôpital de fous ».
 

