# La liberté

## I. Ambiguïté du terme de liberté

"Le terme de liberté (dit Leibniz) est fort ambigu."

C'est un terme qui a plusieurs sens. Si quelqu'un parle de "la liberté" sans plus de précision, on ne peut pas savoir de quoi il parle exactement.

À présent, essayons de distinguer les différents sens du mot liberté, en suivant la méthode proposée par Leibniz. Méthode par dichotomie.

### A. Liberté de droit et liberté de fait

Il y a une première distinction à faire, entre la *liberté de droit* et la *liberté de fait*.

Par exemple, quand on oppose l'esclave à l'homme libre, on parle de la liberté de droit. Un enfant.

### B. Liberté de faire et liberté de vouloir

Une deuxième distinction est nécessaire, entre la *liberté de faire* et la *liberté de vouloir*.

C'est une chose de pouvoir faire ce qu'on veut ; c'en est une chose d'être libre de vouloir.

Prison. Maladies.

### C. Sagesse et libre arbitre.

Enfin, la liberté de vouloir peut se comprendre de deux façons, suivant qu'on l'oppose à l'esclavage d'esprit (à la contrainte des passions sur l'esprit), ou à la nécessité.

Dans le premier sens, on dira d'un homme en colère qu'il n'a pas l'esprit libre. Jalousie. *Othello*.

Dans le deuxième sens, on parle du **libre arbitre**.

Dire que nous avons un libre arbitre, c'est dire que nos actes volontaires sont **contingents**.

Vocabulaire : nécessaire, contingent.

**Nécessaire :** Dans le langage de la philosophie, se dit de ce qui ne peut pas ne pas être, par opposition à ce qui est **contingent**.

Chaque fois que j'ai à choisir entre deux choses (surtout entre deux choses qui me sont égales), je sens clairement qu'il est en mon pouvoir de choisir ou l'un ou l'autre. Contingence de nos actes volontaires.

J'ai voulu librement faire le mal ou le bien ; je suis l'auteur de mon action. C'est pourquoi il est juste que je sois, suivant le cas, récompensé ou puni.

Cependant, il y a des philosophes et des théologiens qui ont nié le libre arbitre de l'homme. Luther.

## II. Le sentiment de la liberté

Bossuet, *Traité du libre arbitre*, chapitres 1 et 2.

Noues **savons** que nous avons un libre arbitre. C'est une chose que nous **connaissons naturellement**.


Comment savons-nous que nous avons un libre arbitre ? Nous le savons par le **sentiment** et par l'**expérience**.

Je fais l'expérience de ma liberté quand, par exemple, on m'invite à une promenade. Je **sens** que je pourrais, ou vouloir accepter, ou vouloir refuser. 

Cependant, il y a place pour le doute. Il y a une raison qui a déterminé mon choix. "On peut croire que cette raison fait dans notre volonté une nécessité secrète dont notre âme ne s'aperçoit pas." C'est l'argument de Spinoza.

Que répondre à ces philosophes ? Faisons une autre expérience. Choisissons entre des choses qui nous sont égales. Par exemple, je peux lever ma main et ou la tenir immobile, ou la mouvoir. Ou la mouvoir à gauche, ou à droite. Cette fois, je sens si clairement ma liberté que je n'ai plus aucun doute. car il n'y a aucune raison de tourner ma main d'un côté plutôt que de l'autre.

C'est lorsque nous choisissons entre des choses qui nous sont égales que nous avons le sentiment le plus clair de notre liberté.

Par la même occasion (continue Bossuet) je comprends que je suis fait à l'image de Dieu. Le pouvoir que j'ai sur ma main est une image du pouvoir que Dieu a sur l'univers : "tel qu'il est à l'égard de toute la matière et de tout son mouvement, tel a-t-il voulu que je fusse à l'égard de cette petite partie de la matière et du mouvement qu'il a mis dans la dépendance de ma volonté."

Spinoza pense que l'homme projette sur Dieu l'idée fausse qu'il se fait de sa propre liberté.

## III. L'origine du mal

Saint Augustin, *Du libre arbitre*.

Pour commencer, nous lisons une page des *Confessions*, où saint Augustin raconte qu'il a volé des poires sur l'arbre d'un voisin, puis les a jetées aux cochons. Il a volé ces fruits, non pas pour les manger, mais pour le seul plaisir faire quelque chose de mal, de commettre un acte défendu. Pourquoi l'homme est-il attiré par le fruit défendu ?

Cette image du fruit défendu peut nous faire penser, d'une part, à la faute d'Adam et Ève ; et d'autre part à l'adultère, dont saint Augustin parle longuement dans le livre (le dialogue *Du libre arbitre*).

C'est un dialogue à la manière de Platon. Évodius demande si Dieu n'est pas l'auteur du mal. Quel mal ? Non pas la douleur, mais les mauvaises actions.

Qu'est-ce qu'une mauvaise action ? Évodius ne sachant pas dire ce que c'est, il répond par une énumération d'exemples. L'adultère, l'homicide, dit-il, sont certainement de mauvaises actions, puisque tout le monde s'accorde à les regarder comme telles.

Pourquoi l'adultère est-il une mauvaise action ? Le croire est une chose, le comprendre en est une autre.

Trois réponses vont être successivement examinées.

Première réponse : L'adultère est une mauvaise action parce que c'est une action défendue.

Une chose est interdite, en principe, parce qu'elle est mauvaise : elle n'est pas mauvaise parce qu'elle est interdite. Donc cette réponse ne nous satisfait pas : elle ne nous permet pas de **comprendre** ce qu'il y a de mauvais dans l'adultère.

Deuxième réponse. C'est une mauvaise action (dit Évodius), parce que je ne voudrais pas qu'on me fasse la même chose.

Cependant, Augustin n'est pas entièrement convaincu par cette réponse.

La morale est-elle une science ? Ou alors le bien et le mal ne sont-ils qu'affaire d'opinion ?

Tout le monde croit que l'adultère est une mauvaise action. Cette unanimité est signe de vérité. Maintenant, on voudrait **comprendre** pourquoi l'adultère est un mal. "Les hommes désirent, non seulement croire, mais aussi comprendre."

La deuxième réponse proposée par Évodius était l'adultère est un mal, parce qu'on ne voudrait pas que quelqu'un d'autre nous fasse la même chose.

Cette réponse a cependant un point faible. Si la passion (*libido* dans le texte latin) inspirait à un homme de livrer sa moitié à un autre homme... Cet homme effronté et libidineux pourrait dire : "D'après la règle proposée je ne fais rien de mal, puisque j'accepte de subir la même chose." Or il agirait très mal.

Troisième réponse proposée par Évodius : L'adultère est un mal parce qu'il y a des hommes qui sont condamnés. Problème : On trouve dans les histoires des exemples d'hommes condamnés pour de bonnes actions. Socrate. Martyrs. Condamnés pour avoir avoué leur religion.

La condamnation n'est pas le signe certain d'une action mauvaise.

Finalement Évodius (comme le serviteur dans le *Ménon*) se rend compte qu'il ne sait pas pourquoi l'adultère est un mal.

C'est peut-être le désir qui est mauvais dans l'adultère. Si un homme convoite la femme d'un autre et que les circonstances l'empêchent de passer à l'acte, il est coupable.

Faut-il donc admettre qu'il y aurait deux sortes de désirs, des désirs bons et des désirs mauvais ?

Que faut-il penser, demande Augustin, d'un esclave qui tue son maître par peur des mauvais traitements que ce dernier lui inflige ? Cet homme désire une vie paisible. Ce désir est naturel. Il n'y a rien de mauvais dans ce désir. Ce qui est mauvais est d'en venir jusqu'au point de commettre un meurtre.

Ce qui est mauvais, c'est **d'aimer les choses qu'on peut perdre contre son gré**. (Idée qui rappelle la philosophie stoïcienne.)

Le méchant n'a pas des désirs différents des autres. Ce qui le différencie des autres, c'est l'amour qu'il a pour ces choses qu'il devrait mépriser : amour qui fait qu'il est prêt à employer tous les moyens.

Que penser d'un homme dont la vie est menacée et qui tue son agresseur ? Ce qu'on appelle l'état de légitime défense : c'est une personne qui est sur le point d'être tuée ou violée.

D'après ce qui a été dit précédemment, cette action est mauvaise, puisque par amour pour la vie cet homme se souille de sang humain.

Pourtant, la loi ne condamne pas cette action. La loi permet ce meurtre. cette loi est-elle injuste ? Non, la loi n'est pas injuste : si elle permet cet homicide, c'est parce qu'aux yeux du législateur la mort de l'agresseur est **un moindre mal**.

Néanmoins, cette action reste mauvaise, et condamnée par la **loi éternelle**. Il faut donc distinguer la loi écrite de la loi non écrite, la loi temporelle de la loi éternelle, la loi humaine de la **loi naturelle** (cette loi qui est "gravée dans le cœur de l'homme").
