
# Descartes et la métaphysique

La métaphysique est-elle une science ?

Certains disent que la métaphysique n'est pas une science ; qu'il n'y a de **vérité certaine** que dans les sciences expérimentales (qu'ils appellent d'ailleurs, pour cette raison, « la science »).

Cette opinion, nous la trouvons chez Bacon, l'auteur du *Novum organum,* et également chez Kant, l'auteur de la *Critique de la raison pure*.

Dire que la métaphysique n'est pas une science, c'est dire qu'il n'y a pas de preuves de l'existence de Dieu. On peut pas savoir si Dieu existe. On peut y croire, ou ne pas y croire, mais on ne peut pas le savoir.

Nous allons trouver chez Descartes une tout autre vision des choses. La quatrième du *Discours de la méthode* (1) s'intitule « Preuves de l'existence de Dieu et de l'âme humaine ».

(1) Discours de la méthode pour chercher la vérité dans les sciences.

Les disciples de Descartes sont appelés les cartésiens.

## I. Le doute métaphysique.

Y a-t-il une vérité qui soit entièrement indubitable ?

Indubitable : dont on ne peut pas douter.

L'existence de la matière est-elle une vérité entièrement indubitable ?

Est-il possible d'**imaginer** que la matière n'existe pas ?

Je pourrais imaginer que je rêve ; que cette table que je vois n'est que le fruit de mon imagination.

L'existence des corps n'est donc pas une vérité entièrement indubitable.

Que dire des vérités mathématiques ? Par exemple que deux plus deux égale quatre ? Ce n'est pas non plus une vérité entièrement indubitable, parce que je peux imaginer que je me suis trompé.

Mais alors, dira-t-on, il n'y a rien d'entièrement indubitable !

Si, il y a une chose, c'est que j'existe. Je ne peux pas imaginer que je n'existe pas.

Même en supposant que je rêve, cela prouve encore que j'existe : car si je n'existais pas, je ne pourrais pas rêver.

## II. La nature du moi.

Qu'est-ce donc que je suis ? Quelle est la nature de ce moi ?

Suis-je un corps ? Non, j'ai un corps ; je ne suis pas un corps. Mon corps, c'est le corps qui est à moi ; ce n'est pas moi.

Je suis *quelque chose qui pense* : autrement dit un esprit ou une âme.

L'existence de l'âme humaine est donc une vérité entièrement indubitable.

## III. Le critère de la vérité.

Qu'est-ce qui m'assure que je dis la vérité quand je dis que j'existe ?

C'est que « **je vois très clairement** que pour penser il faut être (ou exister) ». 

Le critère de la vérité, c'est **l'évidence** : non pas l'évidence des sens (1), mais l'évidence de la raison.

Être cartésien, c'est se fier à l'évidence de la raison.

(1) C'est la différence entre l'apôtre saint Thomas et Descartes.

## IV. Première preuve de l'existence de Dieu.

Il y a donc au moins une chose que je sais. Il y en a beaucoup d'autres que j'ignore, ou dont je doute. Cela m'apprend quelque chose sur ma propre nature : c'est que je ne suis pas « tout parfait ». J'ai l'idée de quelque chose de plus parfait que moi-même. Quand je dis que je ne sais pas tout, que je ne peux pas tout faire en même temps, que je ne peux pas être partout à la fois, je me compare à quelque chose de plus parfait que moi : je me compare à « un être tout parfait ».

J'ai donc l'idée d'une nature toute parfaite. Les athées ne disent pas qu'ils ne savent pas ce qu'est Dieu ; ils disent que Dieu n'existe pas.

Si Dieu n'existe pas, comment ai-je pu m'en faire une idée ? « D'où ai-je appris à penser à quelque chose de plus parfait que je ne suis ? »

L'homme est un être fini qui a l'idée de l'infini. Où a-t-il pris cette idée ?

Descartes n'est pas l'inventeur de cette preuve de l'existence de Dieu. On la trouve déjà chez saint Anselme de Cantorbéry. Cette preuve, Kant la nomme « preuve ontologique ».



# Révision chapitres 5 & 6

La métaphysique est-elle une science ? Ou bien seule la physique mérite-t-elle le nom de science, comme l'affirment certains ?

Y a-t-il des preuves de l'existence de Dieu et de l'âme humaine ?

Peut-on **savoir** si Dieu existe ? L'existence de Dieu est-elle une **vérité certaine** ?

## Fénelon et le spectacle de la nature

Parmi les différentes preuves qu'ont proposées les philosophes, la plus facile est celle qui est tirée **du spectacle de la nature**.

Fénelon a développé cette preuve dans son *Traité de l'existence de Dieu*.

« Je ne puis ouvrir mes yeux sans admirer l’art qui éclate dans toute la nature. Toute la nature montre l’art infini de son auteur. »

Voir chapitre 1. Machine à planer du pissenlit.

## Saint Anselme de Cantorbéry

Saint Anselme de Cantorbéry, philosophe du XIe siècle, est l'auteur d'une célèbre preuve de l'existence de Dieu.

C'est une prière dans laquelle l'auteur demande à Dieu de l'aider à comprendre ce qu'il croit.

Saint Anselme part, non pas du spectacle de la nature, mais d'une définition ou d'une idée. Qu'est-ce que Dieu ? C'est « quelque chose de tel que rien de plus grand ne peut être conçu ». Or, si Dieu n'existait que dans l'esprit de l'homme, on pourrait concevoir quelque chose de plus grand, ce qui est contradictoire. Il est donc évident que Dieu existe.

## Descartes

Descartes, *Discours de la méthode*, quatrième partie, §§ 4 et 5.

Afin de me défaire de tous mes préjugés, j'ai voulu penser que tout était faux ; et je me suis rendu compte que je ne pouvais pas penser que je n'existais pas. Je ne peux pas imaginer un seul instant que je n'existe pas. or qu'est-ce ce *moi* ? Qu'est-ce que je suis ? Je suis quelque chose qui pense, autrement dit un esprit ou une âme. Il n'y a donc pas de vérité plus certaine que l'existence de l'âme humaine.

Je sais que j'existe. Je sais aussi que je ne suis pas tout parfait. Il me manque des connaissances. Si je savais tout, je n'aurais aucun doute.

D'où ai-je appris à penser à quelque chose de plus parfait que je ne suis ? Si l'être tout parfait n'existe, comment ai-je pu m'en faire une idée ?

## Kant

Kant est l'auteur de la *Critique de la raison pure*. *Kritik der reinen Vernunft*.

La thèse que soutient Kant dans ce livre, c'est que la métaphysique n'est pas une science. Il n'y a de science que fondée sur l'expérience. Or ni Dieu ni l'âme humaine ne sont des objets d'expérience.

Cette opinion était déjà celle de Bacon, à qui la *Critique de la raison pure* est dédiée.

J. de Maistre, *Examen de la philosophie de Bacon*.

Pour Bacon, il n'y a de certitude que dans la physique. Seule la physique mérite le nom de science.

La métaphysique, ou la théologie naturelle n'est pas une science. Seule la théologie positive nous permet de parler de Dieu.

« Il serait un peu dur (commente J. de Maistre) de chasser Dieu de partout ; mais c'est déjà quelque chose de l'enfermer strictement dans la Bible ; il ne reste qu'à brûler le livre. »

## Duhem et la théorie physique

Duhem, *Sauver les apparences*. Sur l'astronomie, qui est la branche la plus ancienne de la physique.

Quel est le but de la physique ? Ce n'est pas la connaissance d'une vérité absolue ; c'est de sauver les apparences. Or on peut sauver les apparences au moyen de plusieurs hypothèses.

# Appendice au chapitre 6.

S. Thomas d'Aquin, *Somme théologique*.

## I. Les cinq voies.

Il y a, dit saint Thomas, cinq voies (ou cinq chemins) pour prouver l'existence de Dieu.

Arrêtons-nous à la cinquième preuve. C'est la preuve par les **causes finales**.

La flèche et l'archer.

Si je vois des flèches plantées sur une cible ou autoru d'une cible, j'en conclus immédiatement que quelqu'un a visé la cible, a eu l'**intention** d'atteindre la cible. Or il est évident que ce n'est pas la flèche elle-même qui a eu cette intention. C'est l'archer qui a visé la cible.

De la même façon, il y a partout dans la nature des intentions manifestes. Par exemple, dans le monde des fleurs, on observe des mécanismes qui ont manifestement pour fin d'éloigner la graine de la plante. Machine à planer du pissenlit. Or il paraît également évident que ce n'est pas la fleur qui a eu cette intention. Il y a donc un être intelligent qui a conçu ce mécanisme ; et cet être intelligent, dit S. Thomas, c'est lui que nous appelons Dieu.

## II. L'existence de Dieu est-elle évidente ?

Est évidente la proposition dont la vérité apparaît dès que les termes en sont connus. « Le tout est toujours plus grand que sa partie. »

Certains disent que, de la même façon, l'existence de Dieu est une évidence. Dès qu'on a compris ce que signifie ce mot : *Dieu*, aussitôt on sait que Dieu existe. C'est la célèbre preuve de S. Anselme de Cantorbéry.

Aux yeux de S. Thomas, cette preuve n'est pas absolument convaincante. Il n'est pas certain que tout le monde donne au mot *Dieu* le même sens. Certains ont cru que Dieu était un corps.

On pourrait dire encore qu'il est évident que Dieu existe parce qu'il est évident que la vérité existe.

Pourquoi est-il évident que la vérité existe ? Parce que celui nie l'existence de la vérité prétend dire en cela quelque chose de vrai : donc il se contredit. Le relativisme est une doctrine absurde, contradictoire en elle-même.

## III. L'existence de Dieu est-elle démontrable ?

L'existence de Dieu, diront certains, est un article de foi. Ce n'est donc pas une chose qu'on puisse démontrer. La démonstration engendre la science. La foi, au contraire, a pour objet ce dont la vérité n'apparaît pas.

L'existence de Dieu, dit S. Thomas, fait partie des vérités que la raison naturelle peut connaître. Cependant, rien n'empêche que ce qui est, de soi, objet de démonstration et de science ne soit reçu comme objet de foi par celui qui ne peut saisir la démonstration.

L'existence de Dieu, dit S. Thomas, est objet de démonstration et de science ; mais rien n'empêche de la recevoir comme objet de foi.







