
# Le bonheur

Étude du *Gorgias* de Platon.

Notions du programme : Le bonheur, le langage, la justice, la vérité...

## Présentation

Gorgias est un **orateur** contemporain de Socrate. Lors d'une conférence, il se vante de pouvoir répondre à n'importe quelle question qu'on lui posera. Socrate l'interroge sur **la nature et l'utilité de la rhétorique**.

La rhétorique, dit Gorgias, est **l'art de persuader par le discours** des citoyens réunis en assemblée, au sujet de **ce qui est juste**.  L'orateur, continue Gorgias, est l'homme le plus puissant qui soit. Pour preuve, Gorgias raconte une **expérience**, une **chose vécue**. Il est arrivé à Gorgias d'accompagner son frère, qui est médecin, chez un patient qui refusait de se soumettre au traitement prescrit par le médecin. Gorgias est parvenu, grâce à son éloquence, à persuader le malade d'écouter le médecin.

Dans ce cas, on peut dire que l'orateur a fait un bon usage de son art, puisqu'il a aidé le médecin. Gorgias admet qu'il y a un bon et un mauvais usage de la rhétorique, comme des arts martiaux.

Socrate nie que la rhétorique soit un art. Il y voit un simple **savoir-faire**, comparable à la cuisine. La rhétorique, ajoute-t-il, est la contrefaçon d'un art : c'est la contrefaçon de la justice (comme la cuisine est la contrefaçon de médecine).

Polos, un jeune élève de Gorgias, s'insurge contre les propos de Socrate. Les orateurs, dit-il, sont les hommes les plus puissants de la cité. Leur pouvoir est comparable à celui des tyrans : ils peuvent faire tuer, exiler ou emprisonner qui ils veulent. Qui ne voudrait pas être à leur place ?

Socrate conteste qu'un tel pouvoir soit une chose enviable, et que ces hommes soient heureux. S'ils font un usage injuste de leur pouvoir, ils sont même à plaindre et à prendre en pitié. Commettre l'injustice est un grand mal que de la subir ; et la commettre impunément est la pire chose qui puisse nous arriver.

Le sujet de la discussion est à présent de savoir **qui est heureux et qui ne l'est pas**. Nous croyons le savoir. Notre opinion, c'est que l'homme qui **subit** une injustice est à plaindre. Quant à celui qui **commet** une injustice, nous le plaignons pas. Peut-être même l'envions-nous en secret, s'il a réussi à ne pas se faire prendre.

Il nous semble que l'homme qui commet l'injustice et échappe à la punition est le plus heureux des hommes. Histoire du tyran Archélaos. Socrate prétend que cet homme est au contraire aussi malheureux qu'on puisse être.

Calliclès est frappé par cette opposition diamétrale entre l'opinion de Socrate et celle de la plupart des hommes : "Si Socrate parle sérieusement, et si jamais il a raison, alors nous faisons tout le contraire de ce qu'il faudrait."

Parallèle à faire entre le *Gorgias* et le sermon sur la montagne. Le fondateur du christianisme a tenu, lui aussi, des propos étranges, des propos renversants, sur le bonheur. *Évangile selon saint Matthieu,* chapitres 5 à 7.

## Lectures

On peut diviser le *Gorgias* en trois parties, correspondant aux trois interlocuteurs successif de Socrate :

- Gorgias
- Polos
- Calliclès

### Extrait 1 : De la différence entre croire et savoir

Cest Socrate qui interroge Gorgias.

Le sujet de la discussion, c'est la nature (ou l'essence) de la rhétorique. Gorgias a dit de la rhétorique qu'elle était un art de persuader. Cette définition est ambiguë, parce que persuader peut vouloir dire deux choses. Persuader peut vouloir dire 1° qu'on fait croire ; 2° qu'on apprend quelque chose à quelqu'un.

Qu'est-ce qui prouve que croire et savoir sont deux choses différentes ? C'est qu'il y a une croyance vraie et une fausse, tandis que la science, par définition, est vraie.

Reprise. L'homme le plus sage est celui qui reconnaît, comme Socrate, qu'il ne sait pas grand chose. Ainsi, nous croyons savoir **qui est heureux et qui ne l'est pas**. Or Socrate prétend que nous ne le savons pas. Or, (dit Socrate dans le *Gorgias*) c'est **la question sur laquelle il est le plus beau de savoir la vérité** et le plus honteux de l'ignorer.

Nous croyons 1° que l'homme qui subit une injustice est plus malheureux que celui qui la commet. Plus malheureux, c'est-à-dire **plus à plaindre**. Nous croyons 2° que le coupable qui échappe au châtiment est plus heureux que celui qui est puni.

Nous vivons d'une manière conforme à cette opinion. S'il nous arrive d'avoir à choisir entre subir une injustice et la commettre, nous préférons la commettre. Si nous avons commis une injustice, nous préférons échapper au châtiment.

Socrate soutient tout le contraire. Il dit 1° qu'il vaut mieux subir une injustice que de la commettre ; et 2° qu'il vaut mieux (quand on est coupable) être puni que de ne pas être puni.

Similitude entre le *Gorgias* et le sermon sur la montagne, notamment le passage qu'on appelle les Béatitudes. Évangile selon saint Matthieu, chapitre 5. Cette similitude a été relevée y compris par les adversaires du christianisme, comme Nietzsche qui voyait dans le christianisme "un platonisme pour le peuple".

### Extrait 6 : Une étrange théorie

L'étrange théorie de Socrate. Deux points. 1° Commettre une injustice est un plus grand malheur que de subir une injustice. 2° Ne pas être puni, quand on a commis une injustice, est un malheur supplémentaire. Commettre une injustice et ne pas être puni est le plus grand malheur qui soit.

Cette théorie est étrange parce que c'est le contraire de ce que la plupart des hommes pensent.

Il y a encore un autre désaccord entre Polos et Socrate : c'est que Polos (qui est un orateur) estime facile de **réfuter** la théorie de Socrate, alors que Socrate l'estime impossible, parce que "la vérité est irréfutable". La vérité peut être contredite, mais elle ne peut pas être réfutée.

Polos se lance dans un discours. Il décrit longuement, il fait un tableau horrible, effrayant, du supplice infligé à cet homme qui a tenté de renverser le tyran. D'où la réponse de Socrate : "Tu me présentes un épouvantail, brave Polos, non une réfutation." Le but du discours de Polos est d'effrayer.

Pourquoi n'est-ce pas une réfutation ? Parce que Polos enfonce une porte ouverte : il montre que le châtiment est douloureux, ce que personne ne nie. Socrate n'a pas soutenu que le coupable qui échappe au châtiment souffrait plus, mais qu'il était plus à plaindre.

Le commun des mortels ne fait pas la différence entre le plaisir et le bien, entre la douleur et le malheur.

Cette différence entre le bien et le plaisir va être le sujet de la discussion entre Socrate et Calliclès.

La philosophie de Calliclès peut faire penser à celle d'Épicure. Hédonisme. Tout ce qui est agréable est bon. Tout plaisir en soi est un bien. *Lettre à Ménécée*. Tout plaisir n'est cependant pas à rechercher : Certains plaisirs ont pour conséquence une douleur plus grande. Principe de modération chez Épicure : c'est peut-être ce qui le distingue de Calliclès, qui lui fait l'éloge de l'intempérance.

## Extrait 7 : Éloge de l'intempérance

De quoi est-il question dans le *Gorgias* ? Il est question, dans un premier temps, de savoir **ce qu'est la rhétorique** et quelle est son utilité. Il est question, ensuite, de savoir **comment il faut vivre pour être heureux**. Il est question, autrement dit, de savoir **qui est heureux et qui ne l'est pas**.

Polos a concédé que commettre l'injustice était **plus laid** que de la subir. Calliclès estime que Polos a manqué de courage et de franchise.

Calliclès est courageux et franc : il va faire l'éloge de l'intempérance.

Tempérance : vertu qui modère les passions et les désirs, particulièrement les désirs sensuels.

Socrate fait l'éloge de la tempérance, de la maîtrise de soi, de ce qu'il appelle la sagesse.

Or, Calliclès estime, et il ne craint pas de le dire, que **ceux que Socrate appelle les sages sont des imbéciles**.

Pour être heureux, dit Calliclès, il faut entretenir en soi les plus fortes passions, et se mettre en état de les satisfaire. La foule blâme l'intempérance uniquement par dépit et par impuissance.

Pour être heureux, il faut donc acquérir le plus de pouvoir possible dans la cité, et pour cela le meilleur moyen est la rhétorique.

## Extrait 8 : Contre l'hédonisme de Calliclès.

Calliclès est hédoniste. Hédonisme : **système qui fait du plaisir le but de la vie**.

Gale : une maladie qui donne des démangeaisons. Ce qui est comparable à une démangeaison, c'est le désir. Le désir en lui-même est pénible, mais il est la condition du plaisir. Plus on a soif, c'est-à-dire plus on souffre, plus on a de plaisir à boire.

Calliclès soutient que l'agréable et le bon sont la même chose, autrement dit **que tout plaisir est un bien**. Socrate prétend au contraire qu'il y a "des choses agréables qui ne sont pas bonnes".

La thèse de Calliclès, pour la formuler encore d'une autre manière, c'est **qu'une vie agréable est une vie heureuse**.

Est-ce une vie heureuse d'avoir la gale, d'avoir envie de se gratter et de passer son temps à se gratter ? Quand on a une démangeaison et qu'on se gratte, on éprouve une sorte de plaisir, plaisir d'autant plus grand que la démangeaison était plus vive. La démangeaison est l'image du désir, qui est en lui-même une souffrance, et qui est la condition du plaisir. La démangeaison est plus particulièrement l'image du désir sensuel.

Un galeux qui aurait tout loisir de se gratter aurait une vie agréable. Il ressemblerait à cet homme dont parlait Calliclès, qui entretient en lui-même les plus fortes passions et se met en état de les satisfaire.

Socrate pousse Calliclès le brave dans ses retranchements et l'interroge avec malice sur certaines sortes de démangeaisons. Calliclès accuse alors alors d'être "un orateur populaire". On pourrait dire effectivement que Socrate à cet endroit de la discussion cherche à intimider Calliclès en lui faisant les conséquences honteuses de son hédonisme.

Mais ce reproche de vulgarité, c'est à lui-même que Calliclès devrait le faire : c'est lui qui en soutenant **que le plaisir et le bonheur sont la même chose**, a amené la conversation sur de pareils sujets.

On pourrait lire ce texte comme une réfutation par avance de la philosophie d'Épicure, telle qu'elle est exposée dans la *Lettre à Ménécée*. Épicure affirme, comme Calliclès, que tout plaisir en soi est un bien ; mais il ajoute que tout plaisir n'est pas pour autant à rechercher : car il y a des plaisirs qui ont pour suite des douleurs plus grandes en valeur absolue.

Passage du *Phédon*. Dialogue sur l'immortalité de l'âme. Ce dialogue se passe le jour où Socrate doit boire la ciguë. Le gardien de la prison lui enlève les fers qu'il a portés pendant sa détention. "Dans cette vie, le plaisir et la douleur vont toujours ensemble" : ce qui prouve que le plaisir n'est pas le bonheur. Car il serait absurde de dire que le bonheur et le malheur vont toujours ensemble.

## Extrait 5 : Désirer et vouloir

Polos envie les orateurs qui font **tout ce qui leur plaît** dans la cité. Ils peuvent faire tuer, emprisonner ou exiler qui ils veulent. Ce sont des personnes puissantes, des personnes qui ont un grand pouvoir.

Socrate doute que les orateurs soient aussi puissants que le croit Polos. Car, de ce que quelqu'un fait **ce qui lui plaît**, il ne s'ensuit pas qu'il fasse **ce qu'il veut**.

Dans tout ce que nous faisons, voulons-nous la chose même que nous faisons, ou ce **en vue de quoi** nous le faisons ? Exemple d'un malade qui boit une potion amère prescrite par le médecin. Exemple des marins qui transportent des marchandises.

Ce que nous voulons, dans tout ce que nous faisons, c'est la fin de notre action, sa cause finale. Or, cette fin, c'est le bien. Si nous faisons une chose, quelle qu'elle soit, c'est parce que nous croyons bon de la faire. **Toute volonté est volonté du bien**. Quand un orateur fait tuer ou emprisonner quelqu'un, il le fait parce qu'il croit bon de le faire.

Maintenant, imaginons qu'un orateur fasse tuer ou emprisonner quelqu'un, croyant y trouver son avantage, et que cette action troune à son préjudice : il aura fait ce qui lui plaisait, mais il n'aura pas fait ce qu'il voulait.

Si on part du principe que le pouvoir est un bien (comme le veut Polos), alors il faut reconnaître que les orateurs n'ont pas nécessairement un grand pouvoir.

Qu'est-ce qu'un grand pouvoir ? Peut-être le grand pouvoir est-il donné par la science ? Peut-être le grand pouvoir consiste-t-il à savoir qui est heureux et qui ne l'est pas ? Selon l'opinion commune, l'homme le plus heureux est celui qui commet l'injustice impunément. (C'est ce que la plupart des hommes croient sans l'avouer.)

## Extrait 9 : Les arts qui sauvent de la mort.

Calliclès estime que Socrate a tort de mépriser la rhétorique : si les ennemis de Socrate décidaient un jour de traîner ce dernier devant les tribunaux, il serait incapable de se défendre. 

## La philosophie d'Épicure

L'œuvre la plus connue d'Épicure est la *Lettre à Ménécée*.

Trois points remarquables dans cette lettre : ce qu'Épicure pense du bonheur ; ce qu'il pense des dieux ; ce qu'il pense de la mort.

Sur les dieux. On appelle quelquefois *épicuriens* les athées. Épicure tient l'existence des dieux pour une évidence. Nous avons une notion de la Divinité : ainsi nous concevons les dieux comme immortels. Mais Épicure rejette les opinions de la foule au sujet des dieux. L'opinion qu'Épicure rejette, c'est que la Divinité punirait les méchants et récompenserait les bons. Ce qu'Épicure rejette, c'est l'idée de la Providence ou de la justice divine. Épicure est ce qu'on appelle un *déiste*. Il rejette toute religion révélée, et dans ce sens il est bel et bien athée.

Sur la mort. "La mort n'est rien pour nous." Car il n'y a de bien et de mal que dans la sensation, et une fois morts, nous n'avons plus aucune sensation, puisque nous n'existons. Voilà le raisonnement par lequel Épicure entend nous délivrer de la peur de la mort. (Épicure affirme que l'âme meurt avec le corps. Comment le sait-il ? Le sait-il, ou aimerait-il s'en persuader ? Qu'est-ce qui nous effraie dans la mort ? Socrate prétend que ce n'est pas de la mort qu'on a peur, mais des châtiments qui attendent, dit-on, ceux qui ont des commis des injustices ici-bas. Épicure voit dans ces châtiments une opinion erronée de la foule.)

Sur le bonheur. Épicure assimile le bien au plaisir. "le plaisir est le but de la vie." Tout plaisir en soi est un bien, et toute douleur un mal. Une vie heureuse, c'est une vie agréable. Toutefois (et c'est là peut-être ce qui sépare Épicure de Calliclès), Épicure recommande la modération et la simplicité. Le plaisir dont il parle ne consiste pas dans une jouissance déréglée de la nourriture ni de la boisson. Épicure recommande une certaine frugalité ou une certaine sobriété. Pour lui, le bonheur, c'est l'absence de souffrance pour le corps, et l'absence de trouble pour l'âme. (Aux yeux d'Épicure, c'est le corps qui souffre. Là-dessus, on peut relire le beau fragment de Pascal : "Qu'est-ce qui sent du plaisir en nous ?")

## La religion de Socrate

Les grandes questions de la philosophie d'après Kant. La troisième, c'est la question de savoir ce qu'il nous est permis d'espérer, et à cette question (dit Kant) répond **la religion**.

À la fin du *Gorgias*, Socrate raconte **une histoire** afin de prouver à Calliclès "que la mort en soi n'a rien d'effrayant ; que ce qui est effrayant, c'est l'injustice". C'est mourir coupable qui est effrayant.

Cette histoire, Socrate s'attend à ce que Calliclès l'incrédule la prenne pour **une fable** ; mais pour sa part, il la **croit vraie**.

Il y a une loi qui ordonne que les hommes qui ont mené une vie juste et sainte soient envoyés après leur mort dans un lieu où ils seront heureux ; et que ceux qui ont commis des crimes soient envoyés dans un lieu d'expiation (le Tartare).

À l'origine des choses, les hommes étaient jugés de leur vivant, par des juges eux-mêmes vivants : si bien que la justice était mal rendue. Afin de corriger cette injustice, Zeus décide que les hommes seraient jugés après leur mort, par des hommes eux-mêmes morts.

La mort est la séparation de l'âme et du corps. Ni le corps ni l'âme ne sont anéantis. L'un et l'autre subsistent, et demeurent dans l'état où ils étaient avant la mort.

Les châtiments ont pour but le bien : il s'agit de rendre meilleurs ceux qu'on punit ; ou, si c'est impossible, de rendre meilleurs les autres par le spectacle d'un châtiment éternel. La souffrance, la peine, est le seul moyen de guérir de l'injustice.

Archélaos est un roi qui est parvenu au trône par des crimes. Socrate s'attend à ce qu'Archélaos soit du nombre de ceux qui subiront un châtiment éternel.

Les hommes qui n'ont pas un grand pouvoir sont plus heureux que ceux qui ont un grand pouvoir : parce qu'ils courent moins de risques de commettre de grandes injustices.

Il est difficile, quand on a la liberté de mal faire, de rester juste toute sa vie. Exemple d'Aristide le Juste.

La question était de savoir comment il faut vivre pour être heureux. La réponse de Socrate à cette question, est qu'il faut craindre de commettre l'injustice plus encore que de la subir ; et qu'il faut "s'appliquer, non pas à paraître bon, mais à l'être, dans la vie privée comme dans la vie publique".

### Conclusion

Nous ne **savons pas** ce qui se passe dans les enfers : nous ne savons pas ce que nous deviendrons après notre mort. Il y a des choses qu'on **raconte** à ce sujet. Socrate raconte que les hommes, après leur mort, sont jugés dans une prairie... Tradition, histoire qu'on se transmet. À ce récit, on peut ajouter foi, comme le fait Socrate. la foi, c'est croire quelque chose parce qu'on croit quelqu'un (quelqu'un à qui on se fie).

 