
# La liberté

## I. Ambiguïté du terme de liberté

Leibniz nous avertit que "le terme de liberté est fort ambigu".

"La liberté", ça n'existe pas : ça ne veut rien dire. Il faut faire des distinctions et préciser de quelle liberté on parle.

### A. Liberté de droit et liberté de fait

Première ambiguïté : "Il y a liberté de droit et de fait." Un esclave (ou un enfant) n'est pas libre, dans ce sens qu'il n'a pas les mêmes droits qu'un citoyen.

### B. Liberté de faire et liberté de vouloir

Ce que Leibniz appelle *liberté de faire*, c'est le pouvoir de faire ce qu'on veut. Cette liberté, comme le remarque Leibniz, a des degrés. La prison, les maladies.

La liberté de faire est une chose, la liberté de vouloir en est une autre. On pourrait parler aussi de liberté extérieure, opposée à la liberté intérieure.

### C. Liberté du sage et libre-arbitre

La liberté de vouloir peut se comprendre de deux manières différentes, suivant ce à quoi on l'oppose.

Un homme en colère n'a pas l'esprit libre. C'est dans ce sens que les stoïciens disaient que seul le sage est libre. Libre dans le sens où il ne laisse pas emporter, dominer par ses passions. Il est maître de lui-même.

La liberté de l'esprit ou de la volonté opposée à la nécessité (au sens métaphysique) est ce qu'on appelle le libre-arbitre.

*Nécessaire* : qui ne peut pas ne pas se produire. Si je lâche la pierre qui est dans ma main, elle va *nécessairement* tomber. Il est impossible qu'elle ne tombe pas. Les choses qui ne sont pas nécessaires (dans ce sens-là) sont *contingentes*.

Dire que l'homme a un libre arbitre, c'est dire que nos actes volontaires sont contingents.

Comme nous allons le voir en lisant le *Traité du libre arbitre* de Bossuet, nous avons une idée très claire de notre liberté dans ce sens-là.

Cependant, des philosophes et des théologiens ont nié que l'homme ait un libre arbitre. Ils ont dit que cette liberté était une illusion. C'est le cas, par exemple de Luther. On ne peut pas à la fois, dit Luther, affirmer l'omniscience de Dieu et le libre arbitre de l'homme. Selon Luther, l'homme n'a pas un libre arbitre, mais un "serf arbitre". C'est la théorie de la **prédestination**.

Parmi les philosophes qui ont nié le libre arbitre, on peut nommer Spinoza. Un homme en colère croit vouloir librement se venger.

La seule liberté dont on discute, c'est le libre arbitre.

### D. Exercice.

Chacun connaît la première phrase du *Contrat social* de Rousseau : "L'homme est né libre, et partout il est dans les fers."

De quelle liberté Rousseau parle-t-il ? La liberté dont parle Rousseau, c'est l'indépendance, comme on peut le voir dans le chapitre sur la famille. La famille est la seule société qui soit naturelle (contrairement à ce que croyait Aristote, avec son *animal politique*). Encore cette société n'est-elle que temporaire, puisque lorsque l'enfant n'a plus besoin du père, il *rentre* dans l'indépendance : il devient "son propre maître" ; il ne doit plus obéissance à son père. Rousseau parle donc à la fois d'une indépendance de droit et d'une indépendance de fait. L'homme du commencement n'a pas de maître : il n'est soumis à l'autorité de personne.  Par ailleurs, il n'a pas besoin des autres pour vivre. Il cueille des fruits, il boit l'eau de la source...

### E. La liberté selon les stoïciens

Troisième distinction faite par Leibniz : deux façons de concevoir la liberté de vouloir, suivant qu'on l'oppose à la domination des passions ou à **la nécessité** au sens philosophique.

Il y a chez les stoïciens comme Épictète une réflexion originale sur la liberté. Le stoïcisme est surtout une morale, dont l'un des caractères est **l'amour du destin**, ou l'acceptation du destin. Première phrase du *Manuel* d'Épictète : "Tu ne dois pas vouloir que les choses arrivent comme il te plaît ; mais tu dois vouloir qu'elles arrivent comme elles arrivent." Le sage accepte de bon cœur tout ce qui lui arrive, même de douloureux et de fâcheux. Pourquoi ? Parce qu'il croit que l'univers est bien gouverné.

Comparaison à faire avec le personnage biblique de Job.

Anecdote de la jambe cassée. C'est le maître qui est esclave (de ses passions) ; et c'est l'esclave qui est l'homme libre.

"Il n'y a qu'un moyen de devenir libre, c'est de mépriser tout ce qui ne dépend pas de nous."

Les hommes sont esclaves à la fois de leurs passions et de la fortune. *Fortuna imperatrix mundi.*

Cette liberté du sage selon les stoïciens et le libre arbitre sont deux choses différentes.

Quand on parle du libre arbitre, on parle d'une liberté qui est dans la nature de l'homme. Nos actes volontaires sont contingents. Nous sommes les auteurs de nos actions. *Mea culpa*.

## II. Lectures sur le libre arbitre

Dans le langage ordinaire, libre arbitre signifie seulement une volonté qui n'est pas contrainte.

Nous ne pouvons pas entrer dans cette discussion si nous ne faisons pas l'effort de voir précisément ce que c'est que les philosophes appellent libre arbitre.

Dire que l'homme a un libre arbitre, c'est dire que nos volontés sont **contingentes**, et non pas **nécessaires** (au sens que le langage philosophique donne à ce terme : voir dans Littré, article "nécessaire", sens 3).

Tout le monde est persuadé d'avoir un libre arbitre. Pourquoi ? Parce que (comme nous l'expliquera Bossuet), nous en faisons continuellement l'expérience. À chaque fois que nous avons à choisir entre deux choses (et surtout entre deux choses qui nous sont égales), nous sentons clairement qu'il est en notre pouvoir de choisir **ou l'un ou l'autre**.

Pourquoi y a-t-il eu des philosophes et des théologiens pour nier la liberté de notre volonté ?

Comme philosophe, nous parlerons de Spinoza. "Tout ce qui arrive, arrive nécessairement."

Pour la partie théologique, nous parlerons du manichéisme et de Luther.

Quel est l'argument de Luther ? Vous ne pouvez pas à la fois croire à l'omniscience divine et croire que vous avez un libre arbitre.

L'argument de Luther n'est pas méprisable. L'inconvénient de la doctrine de Luther, c'est qu'elle fait de Dieu l'auteur de nos actions, bonnes ou mauvaises (ce qui était déjà la croyance des manichéens). Cependant Luther croit à la justice divine : il croit que certains hommes seront sauvés et d'autres damnés.

### A. Bossuet

Bossuet, *Traité du libre arbitre*, chapitres 1 & 2.

Bossuet, *Histoire des Variations*. Doctrine "horrible" de Luther. Histoire de Jean Viclef (John Wycliffe). Non pas l'aède, le rhapsode ou le barde, mais le théologien anglais du XIVe siècle.

#### 1. Définition

Dans le chapitre 1 du *Traité du libre arbitre*, Bossuet distingue les différents sens du mot "liberté". Ni la *liberté de droit*, ni la *liberté de faire* ne sont des sujets de discussion : "On ne doute point de la liberté en ces deux
sens."

La liberté dont on doute, c'est la liberté de notre volonté, c'est le libre arbitre. "La question est de savoir, s'il y a des choses qui soient tellement en notre pouvoir que nous puissions ou les choisir ou ne les choisir pas." Ou... ou... : contingence.

On me demande de choisir un nombre au hasard entre un et dix. Je choisis cinq. Était-il en mon pouvoir de choisir quatre ou six ?

#### 2. Évidence du libre arbitre

Nous savons que nous avons un libre arbitre. C'est une notion commune. Nous connaissons cela naturellement.

D'où cette connaissance naturelle nous vient-elle ? De l'évidence.

Il y a trois sortes d'évidence :

- Évidence du sentiment et de l'expérience
- Évidence du raisonnement
- Évidence de la révélation

Que chacun de nous s'écoute et se consulte soi-même, il sentira qu'il est libre. Je veux être heureux. Je veux (imaginons) aller à la promenade. Je sens une grande différence entre ces deux volontés. Je ne peux pas m'empêcher de vouloir être heureux. Cette volonté est inscrite dans ma nature même. Je veux *nécessairement* être heureux : je ne peux pas ne pas vouloir être heureux. En revanche, je sens bien que je peux, ou vouloir aller à la promenade, ou ne pas le vouloir.

Cependant, dans cet exemple de la promenade, il y a place pour le doute. Aller à la promenade, ou ne pas y aller : ces deux choses ne me sont pas égales : l'une me plaît plus que l'autre. Un philosophe, un Spinoza par exemple, dirait qu'il y a une raison qui m'a fait choisir l'un plutôt que l'autre. Il y a une raison qui m'a déterminé à faire ce choix. Qui sait si cette raison ne fait pas dans ma volonté "une nécessité secrète dont mon âme ne s'aperçoit pas" ? C'est la doctrine de Spinoza : Les hommes se croient libres parce qu'ils ont conscience de leur volonté mais qu'ils ignorent les causes qui leur ont fait avoir cette volonté.

Que répondre à cette objection ? Remplaçons l'exemple de la promenade par un autre. La main qui tourne. Choix sans importance. Je n'ai aucune raison de choisir l'un plutôt que l'autre. C'est dans le choix entre des choses indifférentes que nous sentons le plus clairement notre liberté. (Âne de Buridan.)

L'homme fait à l'image de Dieu. Mon corps dépend de ma volonté comme toute la matière dépend de la volonté de Dieu : "tel qu'il est à l'égard de toute la matière, tel a-t-il voulu que je fusse à l'égard de cette petite partie de la matière qu'il a mise dans la dépendance de ma volonté".

Passons de l'**évidence du sentiment** à l'**évidence du raisonnement**. (Chapitre 2 du *Traité du libre arbitre*.)

Tous les hommes sentent en eux cette liberté. Toutes les langues, dit Bossuet, ont des mots et des façons de parler très clairs pour exprimer notre liberté. "C'est ma faute." *Mea culpa*. "Je n'aurais pas dû faire cela." C'est ma faute : j'ai voulu librement cette chose-là ; je suis l'auteur de mon action ; j'ai un libre arbitre. Le crime. Le meurtre. Le blâme.

#### 3. Doctrine de Luther

La doctrine de Luther est la suivante : Il est impossible qu'un autre que Dieu soit libre. (Différence entre Luther et Spinoza : ce dernier nie à la fois la liberté de Dieu et celle de l'homme.) Il est impossible d'accorder la prescience divine avec la liberté de l'homme.

Bossuet juge "horrible" cette doctrine. Pourquoi ? Si je n'ai pas de libre arbitre, je ne suis pas l'auteur de mes actions : c'est Dieu qui est l'auteur de toutes nos actions, bonnes ou mauvaises. C'est ce qu'écrit Luther en toutes lettres : "Dieu fait en nous le mal comme le bien." La doctrine de Luther semble conduire à l'idée d'un Dieu méchant, d'un Dieu mauvais. Raison pour laquelle Bossuet croit voir une parenté entre la pensée de Luther et le manichéisme. Les manichéens croient qu'il y a un Dieu bon et un Dieu mauvais.

Jean Viclef, ou John Wycliffe.

#### 4. Conclusion

Comment peut-on savoir que l'homme a un libre arbitre ? Nous connaissons naturellement notre liberté. Comment la connaissons-nous ? Par le **sentiment** et par **l'expérience**.

Par ailleurs, dit Bossuet, nous savons aussi qu'il y a un Dieu qui peut tout et qui sait tout. Ces deux vérités paraissent se contredire : nous ne savons pas comment les accorder.

La conclusion de Bossuet est qu'il faut croire ces deux choses (puisqu'elles sont l'une et l'autre évidentes), même si nous ne savons pas comment les accorder. "La raison nous oblige à croire ces deux vérités, quand même nous ne pourrions trouver le moyen de les accorder ensemble."

Il faut admettre les limites de la sagesse. Il y a des choses qu'on (l'homme) peut savoir, et d'autres qu'on ne peut pas savoir. La philosophie est l'étude de la sagesse humaine : c'est l'étude des choses que l'homme peut savoir.

Cette solution au problème du libre arbitre est aussi celle de Descartes. Cartésianisme de Bossuet. Foi dans l'évidence (de la raison). L'évidence comme critère de la vérité. La philosophie est l'étude de la sagesse humaine.

Lecture. Descartes, *Principes de la philosophie,* première partie, articles 39 à 41.

[Lien](https://fr.wikisource.org/wiki/Principes_de_la_philosophie_(%C3%A9d._Desrez)).

## III. Saint Augustin et l'origine du mal

Saint Augustin, *Du libre arbitre*.

### A. Le fruit défendu

Une page célèbre des *Confessions*.

C'est l'histoire d'un larcin (un vol). Injustice. Iniquité.

La loi naturelle. La loi qui condamne le vol. Depuis quand existe-t-elle ? Par qui a-t-elle été faite ? Est-ce du fait des hommes qu'il y a des lois ? du juste et de l'injuste. Cette loi n'a pas été faite. C'est une **loi naturelle**. Elle est "gravée dans le cœur de l'homme". L'homme peut l'enfreindre, mais il ne peut pas l'abolir. "Quel voleur accepte qu'on le vole ?"

Récit. Ce sont des jeunes gens qui volent des poires sur l'arbre d'un voisin. Ils font cela, non pas poussés par la faim, ni par le plaisir de manger ces poires, mais par le plaisir de commettre un acte défendu. Les hommes trouvent plaisir à faire ce qui est défendu, du simple fait que c'est défendu. Saint Augustin s'en étonne.

Fruit défendu. Histoire du péché originel, l'histoire d'Ève. Adultère. L'adultère est un exemple sur lequel saint Augustin s'arrête longuement dans le dialogue *Du libre arbitre*.

### B. La question de l'origine du mal

Saint Augustin, *Du libre arbitre*.

#### Extrait 1

Évodius demande si Dieu est l'auteur du mal (comme le disent les manichéens).

Il faut préciser de quel mal on parle. Quand on dit que quelqu'un a mal fait, a fait quelque chose de mal, on parle d'une mauvaise action, d'une faute, d'une injustice. Quand on dit que quelqu'un a mal, on parle de la douleur.

Si on suppose que Dieu est à la fois bon et juste (comme on l'apprend au catéchisme), alors il est évident qu'il n'est pas l'auteur des mauvaises actions. En revanche, s'il est juste, il punit les méchants, en leur infligeant des peines, des châtiments.

Qui donc est l'auteur des mauvaises actions ? Il n'y en a pas un seul : "chaque méchant est l'auteur de sa mauvaise action." C'est pourquoi il est juste que le méchant soit puni.

#### Extrait 2

Qui (demande ensuite Évodius) a appris au méchant à mal faire ?

Augustin répond d'une manière qui rappelle Socrate. On ne peut pas enseigner le mal. L'enseignement éveille en nous la science, et la science, comme l'intelligence, est bonne en soi. Il faut renoncer à découvrir on ne sait "docteur du mal : s'il est mauvais, il n'instruit pas ; s'il instruit, il n'est pas mauvais".

#### Extrait 3

La question troublante est de savoir si Dieu n'est pas d'une certaine manière l'auteur du mal, dans la mesure où il a créé les hommes qui commettent les mauvaises actions ?

Augustin raconte que c'est cette question qui l'a poussé vers le manichéisme, l'hérésie manichéenne.

#### Extrait 4

Qu'est-ce qu'une mauvaise action ? Évodius ne sachant quoi répondre, répond par une énumération d'exemples. Je suis sûr que l'adultère, ou l'homicide (par exemple) sont de mauvaises actions : tout le monde en convient. (Aristote : "Le consentement universel est signe de vérité.")

On pose donc la question de savoir pourquoi l'adultère est une mauvaise action. On le croit ; on voudrait le comprendre.

Trois réponses vont être examinées. 1° C'est un mal parce que c'est défendu. 2° C'est un mal parce que je ne voudrais pas que ça m'arrive. 3° C'est un mal parce que c'est condamné.

On cherche à **savoir**, à **comprendre** ce qu'on **croit** : à savoir que l'adultère est une mauvaise action.

Premier essai de réponse : l'adultère est une mauvaise action parce que c'est une action défendue. C'est mauvais parce que c'est interdit.

Cette réponse est-elle satisfaisante ? Cette réponse n'est pas satisfaisante. Elle nous renvoie à l'autorité de la loi. Or, "les hommes désirent, non seulement croire, mais aussi comprendre".

Une chose n'est pas mauvaise *parce qu'elle est interdite* : elle est interdite (en principe) *parce qu'elle est mauvaise*. Si elle n'était pas mauvaise, il n'y aurait aucune raison de l'interdire.

Deuxième essai de réponse : L'adultère est un mal parce qu'on ne voudrait pas le subir. Celui qui commet l'adultère ne voudrait pas le subir. (Quel voleur accepte qu'on le vole ?)

Objection d'Augustin. "Si la passion..." Dans le texte original, c'est le mot *libido*, qu'on retrouve dans l'adjectif *libidineux*. Le désir, spécialement le désir charnel.

Augustin qui par désir d'abuser de la femme d'un autre, serait prêt à livrer sa propre épouse. Cette homme agirait très mal, et pourtant il pourrait dire : Je ne fais rien de mal, puisque j'accepte de qu'on me fasse la même chose.

Le consentement de la victime ne change rien au caractère mauvais de l'action. (Voir les remarques de saint Augustin sur le suicide dans *La cité de Dieu*.)

Troisième essai de réponse. L'adultère est un mal, parce que des hommes ont été condamnés pour cela.

Tout ce qui est condamné est-il mauvais ?

On trouve dans l'histoire des exemples d'hommes condamnés pour de bonnes actions. Augustin prend l'exemple des martyrs. Les martyrs ont été condamnés pour avoir "confessé leur foi" : autrement dit pour avoir avoué qu'ils étaient chrétiens. Or avouer ce qu'on croit n'est pas une mauvaise action. Au contraire, c'est une bonne action.

La condamnation n'est pas le signe certain d'une action mauvaise. Exemple de Socrate.

Finalement, Évodius ne sait plus quoi dire. Il se rend compte qu'il ne sait pas pourquoi l'adultère est une mauvaise action. (Parallèle à faire avec la discussion sur le carré deux fois plus grand dans le *Ménon*.)

Pourquoi la discussion est-elle dans l'impasse ? Parce que le mal, dit Augustin, n'est pas dans "l'acte extérieurement visible", mais dans le désir ou la passion (*libido*). Il peut y avoir culpabilité là même où aucun acte n'a été commis. Si un homme convoite la femme d'un autre, mais qu'il est empêché de passer à l'acte, il est coupable. S'il est démontré qu'il le désire et qu'il le ferait s'il le pouvait : autrement dit, s'il en a non seulement le désir, mais aussi la volonté.

Dans toute mauvaise action, il y a, semble-t-il, un désir coupable, un désir mauvais.

#### Extrait 5

Reste à préciser la nature de ce désir coupable.

On prend l'exemple d'un esclave qui tue son maître, par peur des mauvais traitements que ce dernier lui inflige. 

C'est une mauvaise action : c'est un meurtre. Pourtant le désir de vivre sans crainte est naturel et légitime. Personne n'aime être maltraité. Il n'y a rien de coupable dans ce désir.

Où est le mal ? La loi punit-elle à tort cet homicide ?

Les bons et les méchants, remarque Augustin, désirent les mêmes choses. Tout le monde désire une vie sans crainte. La différence est que le méchant est si attaché à ce bien qu'il est prêt à tout pour éloigner les obstacles, pour obtenir ce bien. Le bon désire aussi une vie sans crainte, mais il ne va pas jusqu'à l'aimer. Plus généralement, le bon détourne son amour **des choses qu'il peut perdre contre son gré**.

Nous ne devrions pas aimer les choses que nous pouvons perdre contre notre gré : c'est cet amour qui est la racine de tous les crimes. La liberté, la vie.

Parallèle à faire avec le début du *Manuel* d'Épictète. "Il y a des choses qui dépendent de nous, et d'autres qui ne dépendent pas de nous."

#### Extrait 6

La morale est-elle une science ? Y a-t-il une science des mœurs ? Le bien et le mal sont-ils seulement affaire d'opinion ?

Qu'est-ce qu'une mauvaise action ? C'est peut-être une action inspirée par un désir coupable. Une cupidité coupable. Convoiter la femme de son prochain serait un désir coupable.

Mais que penser d'un esclave qui tue son maître par peur des mauvais traitements que ce dernier lui inflige ? Que désire cet homme ? Il désire une vie tranquille. L'idée d'un désir coupable ne tient plus. Ce n'est pas mauvais de désirer une vie tranquille. Pourtant ce désir qui n'est pas mauvais en soi, va aboutir à un meurtre. Cet homme sera condamné. Il sera peut-être grâcié (comme Jacqueline Sauvage) mais la grâce n'annule pas la condamnation.

Le principe de toutes les mauvaises actions, dit Augustin, c'est **l'amour des choses qu'on peut perdre contre son gré**. La vie par exemple. Ces choses qu'on peut perdre contre son gré, on ne devrait pas les aimer. Si on aime ces choses, on sera prêt à tout faire pour essayer de les conserver.

Mais alors, que faut-il penser de la légitime défense ? Si je tue un bandit qui menace ma vie, n'est-ce pas une mauvaise action, d'après la définition donnée précédemment ? Puisque je vais jusqu'à me souiller de sang humain pour sauver ma vie. Si c'est une mauvaise action, pourquoi la loi ne la condamne-t-elle pas ?

La loi ne condamne pas ce meurtre parce qu'aux yeux du législateur, la mort d'un injuste agresseur est **un moindre mal** que la mort d'un citoyen. Pourtant, cette action reste mauvaise et elle sera punie, dit Augustin, s'il est vrai que l'univers est gouvernée par la Providence. (C'est une idée qu'on trouve chez les stoïciens, que l'univers est bien gouverné.)

Il y a donc deux lois : la loi temporelle et la loi éternelle. La loi qui ne condamne pas la légitime défense, c'est la loi temporelle. La loi éternelle la condamne.

La conséquence de tout ce raisonnement, c'est qu'on homme parfaitement juste, parfaitement bon, choisirait plutôt d'être tué que de tuer quelqu'un. Cette idée, qu'il vaut mieux subir un crime que de le commettre, c'est l'idée que développe Platon dans le *Gorgias*.

D'ailleurs, la loi permet la légitime défense, mais elle ne la commande pas. La loi me permet de repouuser violemment mon agresseur, jusqu'à le tuer, mais elle ne m'y oblige pas. C'est la différence qu'il y a avec le cas d'un soldat qui tue un ennemi sur le champ de bataille. Dans ce cas, on ne parle pas de meurtre. Pourquoi ? Parce que la loi ordonne au soldat de repousser l'ennemi par la violence, au risque de le tuer. Le soldat est justifié puisqu'il obéit à la loi.

Tout ce qui est permis par la loi temporelle n'est pas nécessairement bon. Cette loi ne peut pas tout faire. Il y a de mauvaises actions qu'elle ne condamne pas.


