
# Descartes et la métaphysique

La métaphysique est-elle une science ?

Nous avons lu sous la plume de Bacon cette affirmation caractéristique de la philosophie moderne qu'il n'y a de certitude que dans les sciences expérimentales, ce qui implique que la métaphysique (entre autres) n'est pas une science. Que la métaphysique ne soit pas une science, c'est aussi la thèse que soutient Kant dans la *Critique de la raison pure*. Dieu, l'âme humaine, n'étant pas des objets de l'expérience, ne sont pas non plus objets de science.

Nous allons trouver chez Descartes une tout autre opinion. La quatrième partie du *Discours de la méthode pour chercher la vérité dans les sciences*. Descartes est l'inventeur de l'optique (qu'il appelle la dioptrique). Réfraction.

La quatrième partie du *Discours* s'intitule : « Preuves de l'existence de Dieu et de l'âme humaine ».

## I. Le doute métaphysique.

C'est un récit. Descartes raconte l'histoire de ses pensées.

Les pensées dont Descartes va nous faire part dans cette partie sont métaphysiques et peu communes.

La vie et la philosophie sont deux choses différentes. Dans la vie (dans l'action) on a quelquefois « besoin de suivre des opinions qu'on sait être fort incertaines ». En revanche, pour celui qui cherche la vérité, tout ce qui est incertain a peu de valeur.

Descartes se donne pour règle, pendant le temps de sa méditation, de « rejeter comme absolument faux tout ce en quoi il pourra imaginer le moindre doute ». Si je peux **imaginer** qu'une chose est fausse, je la tiendrai provisoirement pour fausse. Le but de cet exercice, c'est de voir si je trouverai « quelque chose en ma créance qui soit entièrement indubitable ».

Les **sceptiques** (ou les **pyrrhoniens**) disent qu'on peut douter de tout ; qu'il n'y a rien de certain. Montaigne.

Voyons si j'arriverai effectivement à douter de tout : c'est ce que se dit Descartes.

Je crois qu'il y a des corps, de la matière. Il y a une table. Il y a une terre et un ciel. Je crois que ces choses existent parce que je les vois. Mais je peux **imaginer** que mes sens me trompent, puisqu'il arrive en effet qu'ils me trompent. Exemple du bâton planté dans l'eau qui paraît tordu. Donc je supposerai provisoirement qu'il n'y a aucun corps ni aucun monde. L'existence du monde (ou, pour le dire autrement, de la matière) n'est pas une vérité *entièrement indubitable*.

Même les vérités mathématiques, dit Descartes, ne sont pas entièrement indubitables : parce qu'on peut toujours imaginer qu'on s'est trompé (ce qui arrive en effet : on se trompe, on fait des *paralogismes*).

On peut toujours aussi imaginer qu'on rêve. C'est l'un des arguments classiques du scepticisme : on ne peut être absolument sûr de rien, parce qu'il n'y a aucun moyen de savoir si on ne rêve. Je supposerai donc provisoirement que je rêve. Doute hyperbolique (exagéré).

Mais je m'aperçois que pendant que je veux ainsi penser que tout est faux, il est impossible que moi, qui le pense, je ne sois pas quelque chose. Je peux imaginer que le monde n'existe pas, mais je ne peux pas imaginer que je n'existe pas. Même en supposant que je dorme et que toute ma vie ne soit qu'un rêve, il demeure certain que j'existe. Du moment que je pense à quoi que ce soit, c'est que j'existe ; c'est je suis quelque chose.

Je peux douter de tout, à la rigueur, sauf de ma propre existence.

## II. La nature du moi.

Je suis quelque chose. Mais quoi ?

Suis-je un corps ? Non, puisque j'ai supposé qu'il n'y avait aucun corps. Que suis-je donc ? Je suis quelque chose qui pense. Autrement dit, une âme.

Voilà la preuve de l'existence de l'âme humaine. Les matérialistes disent qu'ils croient à l'existence des choses matérielles parce qu'ils peuvent les voir et les toucher. S'ils raisonnaient rigoureusement, ils devraient plutôt déduire, du fait qu'ils voient quelque chose, l'existence de leur âme.

S'il y a bien que je **sais**, c'est que j'existe. Il n'y a pas de vérité plus certaine. L'existence de l'âme humaine est une vérité plus certaine que l'existence de la matière.

## III. Le critère de la vérité.

Puisque j'ai trouvé une vérité certaine, je dois aussi pouvoir en déduire le critère de la vérité. Qu'est-ce qui me permet d'avoir l'assurance de ne pas me tromper, quand je dis que j'existe ? D'où me vient cette certitude ?

Il y a donc au moins une chose que je sais. C'est-à-dire que quand je dis *que j'existe,* je suis **assuré** de dire la vérité. C'est cette assurance qui constitue l'essence de la science. D'où cette assurance me vient-elle ? C'est la question du **critère de la vérité**.

Ce qui m'assure que je dis la vérité quand j'affirme que j'existe, c'est « que je vois très clairement que pour penser il faut être ». Savoir, c'est voir. Non pas avec les yeux, mais avec son esprit, avec ce que Platon « l'œil de l'âme ».

Tel est donc le critère cartésien de la vérité : c'est l'évidence. Être cartésien, c'est se fier à l'évidence : non pas à l'évidence des sens, mais à l'évidence de la raison.

Ne confondons pas Descartes avec l'apôtre saint Thomas. Ce dernier ne veut croire que ce qu'il a vu de ses yeux. Descartes, au contraire, rejette (provisoirement) le témoignage de ses sens et se fie à ce qu'il voit très clairement par la pensée. Car il y a une lumière qui rend les choses visibles pour l'esprit, comme il y a une lumière qui rend les choses visibles pour les yeux. (Voir le passage sur le soleil dans la *République* de Platon.)

## IV. Première preuve de l'existence de Dieu.

Pour une chose que je sais, il y en a beaucoup d'autres que j'ignore ou dont je doute. Je ne sais pas tout. Ma science n'est pas infinie. Mais quelque chose m'étonne dans ce que je viens de dire. Où ai-je pris l'idée d'une science infinie ? Je ne suis pas parfait. Où ai-je pris l'idée du parfait ? D'où ai-je appris à penser à quelque chose de plus parfait que moi-même ?

En méditant sur mes doutes et sur mon imperfection, je me rends compte que j'ai l'idée de quelque chose de plus parfait que moi-même. J'ai l'idée d'un être tout parfait. Si cet être tout parfait n'existait pas, comment aurais-je pu m'en faire une idée ?

### Saint Anselme

Cette preuve (qu'on appelle depuis Kant la « preuve ontologique »), Descartes n'en est pas l'inventeur. On la trouve chez saint Anselme de Cantorbéry (Canterbury).
 
Qu'est-ce que Dieu ? C'est « quelque chose de tel que rien de plus grand ne peut être conçu ». Grand : parfait.

Tout le monde entend cette idée. L'athée (que saint Anselme appelle l'insensé) ne dit pas qu'il ne sait pas de quoi on parle : il dit que l'être tout parfait n'existe pas, ou n'existe que dans l'esprit de l'homme.



# Révision

La métaphysique est-elle une science ?

Qu'est-ce que la science ?

Peut-on savoir si Dieu existe ?

Y a-t-il des preuves de l'existence de Dieu ?

Aristote, saint Anselme de Cantorbéry, Descartes...

Ces prétendues preuves sont-elles de véritables preuves ?

Preuves métaphysiques de l'existence de Dieu. Il y a aussi des preuves de l'existence de Dieu qui n'ont pas un caractère métaphysique. Preuves tirées du spectacle de la nature. Fénelon, *Traité de l'existence de Dieu*. « Je ne puis ouvrir mes yeux sans admirer l’art qui éclate dans toute la nature... toute la nature montre l’art infini de son auteur. »

Commentaire de l'apôtre saint Paul. Les hommes qui prétendent n'avoir aucune connaissance de Dieu sont « inexcusables ». 
Épître aux Romains. Juif citoyen et soldat romain, qui se convertit au christianisme à la suite d'une apparition **sur le chemin de Damas**.

Preuve de l'ouvrier par l'ouvrage.

## D'où vient l'opinion selon laquelle la métaphysique n'est pas une science ?

Préjugé.

Que la métaphysique ne soit pas une science, c'est ce que soutient notamment Kant dans la *Critique de la raison pure*.
*Kritik der reinen Vernunft*.

À peu près à la même époque, sous Robespierre, où est gravée sur la cathédrale de Clermont-Ferrand cette inscription : « Le peuple français reconnaît l'Être suprême et l'immortalité de l'âme ». Deux dogmes fondamentaux de la **religion civile** imaginée par Rousseau et imposée par Robespierre. Déisme. Religion naturelle.

Existence de Dieu, immortalité de l'âme : c'est presque mot pour mot le titre de la quatrième partie du *Discours de la méthode*.

L'être suprême, c'est le « Dieu des philosophes » comme dit Pascal, et non pas « le Dieu d'Abraham ».

Comparer avec la loi salique. *Vivat Christus, qui Francos diligit.* « Vive le Christ, qui aime les Francs. »

Bossuet dit du déisme que c'est « un athéisme déguisé ».

Revenons à la question. Cette opinion qui veut qu'il n'y ait pas d'autre science que la physique, c'est aussi celle de Bacon. J. de Maistre, *Examen de la philosophie de Bacon*.

## Notes sur les textes

### Saint Anselme de Cantorbéry

Ce n'est pas comme chez Fénelon une preuve tirée du spectacle de la nature. C'est une preuve *a priori* comme disent les philosophes, c'est-à-dire une preuve de pur raisonnement, une preuve métaphysique.

Saint Anselme part d'une définition, d'une idée. Qu'est-ce que Dieu ? C'est « quelque chose de tel que rien de plus grand ne peut être conçu ».

Cett définition, tout le monde la comprend. Cette idée, tout le monde la conçoit, y compris celui que l'Écriture appelle « l'insensé », c'est-à-dire celui qui croit qu'il n'y a pas de Dieu.

Or cette idée implique l'existence de son objet. C'est le même raisonnement que fait Descartes (*Discours*, quatrième partie, § 5). Si Dieu n'existait que dans l'esprit de l'homme, on pourrait concevoir quelque chose de plus grand, ce qui est contradictoire.

Si Dieu n'existe pas, ce n'est pas Dieu. Si l'Éternel n'existe pas, ce n'est pas l'Éternel.

### Descartes

*Discours de la méthode*, quatrième partie, §§ 4 et 5.

J'ai des doutes, donc mon être n'est pas tout parfait. D'où ai-je appris à penser à quelque chose de plus parfait que je ne suis ?

Preuve qui part de l'idée de Dieu qui est dans l'esprit de chacun.

« Si l'Éternel existe... » Supposons qu'il n'existe pas, d'où vous vient cette idée ?

Freud, *L'avenir d'une illusion*. La croyance de l'existence de Dieu est une illusion. L'enfant s'aperçoit un jour que son père n'est pas tout-puissant, n'est pas parfait. Il se met à désirer et à rêver d'avoir un père tout-puissant, immortel... Il « prend ses désirs pour des réalités ».

On pourrait poser à Freud la question de Descartes : où l'enfant a-t-il pris l'idée d'un être tout-puissant ?

Dans le § 5, Descartes compare des vérités de géométrie à l'existence de Dieu. D'où vient la grande certitude que tout le monde attribue aux mathématiques ? Cette certitude vient de l'évidence. La somme des trois angles d'un triangle, la distance des points d'une sphère au centre.

Je **sais** que tous les points d'une sphère sont à égale distance du centre. Cela est compris évidemment dans l'idée même de sphère. Or, continue Descartes, à la différence de l'idée du triangle ou de la sphère, l'idée d'un être tout parfait implique l'existence de cet être.
