# La liberté

## I. Ambiguïté du terme de liberté

« Le terme de liberté, dit Leibniz, est fort ambigu. » Le terme de liberté a plusieurs sens.

Il faut donc faire les distinctions nécessaires, comme le font Leibniz et Bossuet.

Nous verrons que, parmi les différents sens du mot « liberté », un seul est véritablement un sujet de discussion. Voir le chapitre I du *Traité du libre arbitre* : « La question est de savoir... » La question est de savoir si l'homme a un libre arbitre. Il y a des philosophes et des théologiens (notamment Luther) qui ont nié le libre arbitre de l'homme.

Leibniz propose une façon rigoureuse de distinguer les différents sens du mot « liberté ». Il procède par dichotomie.

### A. Liberté de droit et liberté de fait

La première ambiguïté, c'est qu'on parle tantôt d'un droit, tantôt d'un fait.

### B. Liberté de faire et liberté de vouloir

Une deuxième distinction est à faire, entre la **liberté de faire** et la **liberté de vouloir**.

La liberté de faire, c'est le pouvoir de faire ce qu'on veut. Comme le remarque Leibniz, cette liberté a des degrés. Prison, maladie.

### C. Liberté du sage et libre arbitre

Enfin, la liberté de vouloir peut se concevoir de deux façons, suivant ce à quoi on l'oppose.

La première façon est celle des stoïciens.  Ils disent que seul le sage est libre, parce qu'il domine ses passions, alors que les autres hommes sont dominés par elles.

La morale stoïcienne est faite d'impassibilité et d'acceptation du destin. 
Épictète, l'auteur du *Manuel*. Anecdote de la jambe cassée.

Le sage accepte de bon cœur tout ce qui lui arrive, même de douloureux ou de fâcheux. « Tu ne dois pas vouloir que les choses arrivent comme il te plaît ; mais tu dois vouloir qu'elles arrivent comme elles arrivent. » Le sage aime le destin. Il croit que l'univers est sagement gouverné.

Comparaison à faire avec le personnage biblique de Job.

L'autre façon de concevoir la liberté de vouloir, c'est lorsqu'on l'oppose à **la nécessité** (au sens métaphysique). Dans le langage de la philosophie, est *nécessaire* ce qui ne peut pas ne pas être. Si je lâche la pierre qui est dans ma main, elle va nécessairement. Ce qui n'est *nécessaire* dans ce sens-là est *contingent*.

Dire que nous avons un libre arbitre, c'est dire que nos actes volontaires sont contingents. J'ai choisi d'aller à gauche : j'aurais pu choisir d'aller à droite. J'ai un libre arbitre. Je suis l'auteur de mes actions. C'est ce que signifie la formule latine *mea culpa*.

Luther nie le libre arbitre de l'homme, qu'on ne peut pas accorder selon lui avec l'omniscience divine. Théorie de la prédestination. Nous sommes prédestinés, pour les uns, à être sauvés, pour les autres à être damnés. Luther a développé ses idées dans un *Traité du serf arbitre*.

Cette négation du libre arbitre se trouvait déjà dans le **manichéisme**, comme nous le verrons en lisant le dialogue *Du libre arbitre* de saint Augustin. Les manichéens disent que Dieu est l'auteur de nos mauvaises actions.

Sermon de Luther sur le mariage.

## II. Le libre arbitre

### A. Bossuet et le libre arbitre

Bossuet, *Traité du libre arbitre*, chapitres 1 & 2.

#### 1. Définition du libre arbitre

L'analyse de Bossuet rejoint celle de Leibniz. Le mot « liberté » a trois principaux sens. Dans un premier sens, liberté est synonyme de droit. Dans un second sens, liberté est synonyme de volonté.

Comme le remarque Bossuet, « on ne doute point de la liberté en ces deux sens ». On ne doute (pour reprendre les expressions de Leibniz) ni de la *liberté de droit*, ni de la *liberté de faire*.

La liberté dont on doute, c'est la liberté de notre volonté : c'est le libre arbitre. On doute si l'homme a un libre arbitre. On doute « s'il y a des choses qui soient tellement en notre pouvoir, que nous puissions ou les choisir ou ne les choisir pas ». On doute (pour le dire encore autrement) de la **contingence** de nos actes volontaires.

#### 2. Connaissance naturelle du libre arbitre

Il est **certain** que nous avons un libre arbitre. C'est une chose que nous savons de science certaine.

Comment le savons-nous ? Comment savons-nous que nous avons une volonté libre ? Nous le savons parce que cette liberté nous est **évidente**.

Elle nous est évidente de plusieurs façons. Car il y a, selon Bossuet, plusieurs sortes d'évidence :

- l'évidence du **sentiment** et de **l'expérience**
- l'évidence du raisonnement
- l'évidence de la révélation

L'évidence du sentiment. Je veux être heureux et je veux (imaginons) aller à la promenade. Ce sont deux volontés que j'ai. Or je sens très clairement qu'il y a une différence entre ces deux volontés : je ne peux pas ne pas vouloir être heureux, alors que je pourrais ne pas vouloir aller à la promenade ; l'une de ces volontés est en moi de façon*nécessaire*, l'autre de façon contingente.

Je sens donc clairement ma liberté : j'en fait l'expérience.

Cependant, il y a place pour le doute dans cette histoire de promenade. Peut-être Bossuet pense-t-il au célèbre Spinoza en écrivant ce passage...

Je sais que j'ai un libre arbitre parce que je le **sens** et que j'en fait l'**expérience**. **Évidence** du sentiment. Promenade. Si on m'invite à une promenade et que je choisis d'y aller, il était en mon pouvoir de faire un autre choix.

Cependant, il y a dans cet exemple de la promenade place pour le doute. Aller à la promenade ou ne pas y aller, cela ne m'est pas égal : l'un me plaît plus que l'autre. Cela m'importe. Il y a une raison qui m'a déterminé à faire ce choix. Qui sait si cette raison ne fait pas « dans notre volonté une nécessité secrète dont notre âme ne s'aperçoit pas » ? C'est l'argument de Spinoza : Les hommes se croient libres parce qu'ils ont conscience de ce qu'ils veulent, mais qu'ils n'ont pas conscience des causes qui leur font avoir telle ou telle volonté.

La main qu'on lève et qu'on tourne. Je n'ai aucune raison de tourner la main de ce côté plutôt que de l'autre. Je fais donc là une expérience très claire de ma liberté. C'est lorsque j'ai à choisir entre deux choses indifférentes que je sens le plus clairement ma liberté. (Voir le paradoxe de l'âne de Buridan.)

L'homme fait à l'image de Dieu. Cette expérience consistant à tourner la main d'un côté ou de l'autre m'apprend que je suis fait à l'image de Dieu. Le pouvoir que j'ai sur ma main est une l'image du pouvoir que Dieu a sur l'univers.

Évidence du raisonnement. Tous les hommes sentent en eux leur liberté. Toutes les langues ont des mots et des façons de parler très claires et très précises pour l'expliquer. La faute. C'est ma faute. *Mea culpa*. Le crime. Le repentir. Le blâme.

#### 3. La doctrine « horrible » de Luther

Il est impossible, dit Luther, qu'un autre que Dieu soit libre. Tout ce qui arrive arrive par la volonté de Dieu, est prévu par Dieu : il est donc impossible que la créature soit libre.

Mais si nous n'avons pas un libre arbitre, nous ne sommes pas les auteurs de nos actions, bonnes ou mauvaises. C'est une conséquence que Luther accepte. « Dieu fait en nous le mal comme le bien. » Luther n'est pas loin de tomber dans une forme de manichéisme.

Reprise. Quelle est la question ? La question est de savoir si l'homme a un libre arbitre.

Attention ! Ce que les philosophes et les théologiens appellent le libre arbitre n'est pas la même chose que ce que le langage ordinaire appelle du même nom. Dans le langage
philosophique, le libre arbitre signifie la **contingence** de nos actes volontaires. Contingent, nécessaire.

Si je lâche la pierre qui est dans ma main, elle va nécessairement tomber : elle ne peut pas ne pas tomber ; il est impossible qu'elle ne tombe pas.

La philosophie de Spinoza, si on la résume en une proposition, c'est que **tout ce qui arrive arrive nécessairement**. La pierre tombe, l'homme en colère se venge, le bavard succombe au plaisir de bavarder...

Tous nos mots, toutes nos manières de parler implique notre croyance au libre arbitre de l'homme. « Il a fait quelque chose de mal : il est coupable ; il mérite d'être puni. Il a fait quelque chose de bien, etc. » S'il n'y a pas de libre arbitre, les hommes ne sont pas les auteurs de leurs actions : il n'y a pas de différence essentielle entre le bien et le mal.

Revenons à Bossuet, et à la doctrine « horrible » de Luther. Luther, comme le fera Spinoza après lui, nie la liberté de l'homme ; mais, à la différence de Spinoza, Luther croit à la liberté de Dieu.

L'argument de Luther contre le libre arbitre, c'est précisément qu'il est impossible qu'un autre que Dieu soit libre. On ne peut pas croire à la fois à la **prescience divine** et à la liberté de l'homme.

Ce que cette doctrine a d'horrible (peut-être) c'est qu'elle fait de Dieu l'auteur de toutes nos actions, bonnes ou mauvaises. « Dieu fait en nous le mal comme le bien. »

La doctrine de Luther nous conduit à l'idée d'un Dieu mauvais, qui semble se plaire au supplice des malheureux.

### B. Saint Augustin et l'origine du mal

Saint Augustin, Augustin d'Hippone.

#### 1. Le fruit défendu

Un passage des *Confessions*.

Un récit. Le récit d'un larcin (un vol). Une mauvaise action. Une action (s'emparer du bien d'autrui) condamnée par **la loi naturelle**. Loi gravée dans le cœur de l'homme. Ineffaçable. Qu'on ne peut pas abolir. Loi que tous les hommes connaissent naturellement.

Que raconte saint Augustin ? Il raconte qu'il a volé des poires, ni par besoin, ni par désir ; des poires qui « n'avaient rien de tentant, ni la beauté ni la saveur ». Le seul plaisir qu'il a tiré de cette action fut de commettre un acte défendu. D'où vient le plaisir de faire ce qui est défendu ?

Complément sur Bossuet. Cartésianisme de Bossuet. Comment savons-nous que nous avons un libre arbitre ? Nous le savons par **le sentiment et l'expérience**. On m'invite à une promenade. Je sens que je pourrais ou accepter ou refuser. Expérience imparfaite parce qu'il y a une raison qui a déterminé mon choix. Donc « on peut croire que cette raison fait dans notre volonté une nécessité secrète dont notre âme ne s'aperçoit pas ». La main qui tourne. Expérience parfaite. Choix entre des choses indifférentes, des choses qui me sont égales.

Nous savons aussi, dit Bossuet, qu'il y a un Dieu qui sait tout. Comment accorder ces choses : l'omniscience divine et la liberté humaine ? On a l'impression que ces deux choses se contredisent. Luther a résolu le problème en niant la liberté de l'homme.

Selon Bossuet, il faut croire à la fois à l'omniscience divine et à la liberté humaine, même si nous ne comprenons pas comment ces deux vérités s'accordent. Il y a des choses qu'on peut savoir, et d'autres qu'on peut pas savoir. La philosophie est l'étude de la sagesse humaine.

La façon dont Bossuet résout le problème du libre arbitre rappelle la solution de Descartes. *Principes de la philosophie,* première partie, articles 39 à 41. Nous savons d'une part que nous avons un libre arbitre ; et d'autre part que Dieu a préordonné toutes choses. Nous devons croire ces deux choses, même si nous n'avons pas assez d'intelligence pour comprendre comment elles s'accordent. La philosophie est « l'étude de la sagesse humaine ».

Revenons à saint Augustin. Saint Augustin raconte, dans une page des *Confessions*, comment il a volé des poires sur l'arbre d'un voisin. Le vol (le larcin) est condamné par la **loi naturelle**. Il a volé ces poires **pour le seul plaisir de commettre un acte défendu**, autrement dit **pour le seul plaisir de faire quelque chose de mal**.

#### 2. La question de l'origine du mal

Saint Augustin, *Du libre arbitre*.

Évodius pose la question de savoir si Dieu est l'auteur du mal (comme le croient les manichéens).

Le mal veut dire deux choses. 1° Il a mal fait : il a commis une faute. 2° Il a mal : il éprouve de la douleur.

Si on croit que Dieu est juste et bon, on ne peut pas penser qu'il soit l'auteur du premier genre de mal. En revanche on peut penser qu'il est l'auteur du second : il punit les méchants.

Qui est l'auteur du premier genre de mal ? Le mal n'a pas un seul auteur. Chaque méchant est l'auteur de sa mauvaise action.

Cependant une **question troublante** demeure. Si l'on croit que Dieu a créé ces hommes qui font de mauvaises actions, n'est-il pas lui aussi d'une certaine manière l'auteur du mal ?

Augustin raconte que c'est cette question qui a été à l'origine de sa conversion au **manichéisme**, à l'**hérésie manichéenne**. (Ceux qu'on a appelés Cathares ou Albigeois sont des manichéens. Les signes extérieurs auxquels on reconnaissait les manichéens était le végétarisme, et le refus du mariage.)

Qu'est-ce qu'une mauvaise action ? Évodius ne sait comment définir une mauvaise action. À la place, il propose des exemples. L'adultère, le meurtre (par exemple) sont certainement de mauvaises actions : tout le monde en conviendra.

Pourquoi l'adultère est-il une mauvaise action ?

Trois réponses vont être examinées. (Revoir ce que nous avons dit sur la maïeutique. Passage du *Ménon* sur le carré deux fois plus grand.)

Première réponse. L'adultère est une mauvaise action parce c'est défendu. Cette réponse n'est pas entièrement satisfaisante, puisqu'elle nous renvoie à l'autorité de la loi, alors qu'en l'occurrence nous voudrions **comprendre** ce que l'adultère a de mauvais. L'adultère n'est pas mauvais *parce qu'il est interdit* ; il est interdit *parce qu'il est mauvais*.

Deuxième réponse. Je sais que l'adultère est un mal, dit Évodius, parce que je ne voudrais pas le subir.

Augustin montre que cette réponse a un point faible. Un homme effronté pourrait dire qu'il accepte de livrer son épouse à un autre, afin de recevoir la même permission de ce dernier. cet homme pourrait dire que suivant la règle proposée, il ne fait rien, puisqu'il consent à subir l'adultère.

Cet homme ne ferait-il rien de mal ? Au contraire, dit Évodius, cet homme agirait très mal. En effet, il marchande son épouse pour s'offrir un plaisir. (L'hypocrisie, a dit La Rochefoucauld, est l'hommage que le vice rend à la vertu.)

Le consentement des personnes impliquées ne change pas le caractère mauvais de l'action.

Troisième réponse. Je sais que l'adultère est un mal, dit enfin Évodius, parce que j'ai vu des personnes être condamnées pour cela.

On a vu par le passé, répond Augustin, des hommes être condamnés pour de bonnes actions. Il prend l'exemple des martyrs. Les martyrs furent condamnés pour avoir confessé leur foi, c'est-à-dire pour avoir avoué qu'ils étaient chrétiens. Pourtant avouer ce qu'on croit n'est pas en soi une mauvaise action. Donc la condamnation n'est pas le signe certain d'une action mauvaise.

Finalement Évodius se rend compte qu'il ne sait pas ce qu'est une mauvaise action. (À comparer avec le passage du *Ménon* sur le carré deux fois plus grand, où le serviteur, après avoir donné plusieurs mauvaises réponses, se rend compte qu'il ne sait pas comment construire le carré deux fois plus grand.)

Évodius ne sait plus quoi dire. Il est dans l'embarras, dans cet état que la langue appelle *aporie*. Une aporie : une impasse dans la discussion.

Si la discussion a abouti à une impasse, c'est parce qu'on cherché le mal "dans l'acte extérieurement visible". Or c'est plutôt du côté de la volonté ou de l'intention qu'il faut chercher. Il peut y avoir culpabilité là même il n'y a eu aucune action.

La suite du texte est une discussion sur le meurtre. Que faut-il penser du soldat qui tue un ennemi sur le champ de bataille ? Que faut-il du voyageur qui pour défendre sa vie tue un bandit ?
