
# Descartes et la métaphysique

La métaphysique est-elle une science ?

Certains disent qu'il n'y a de **certitude** que dans les sciences expérimentales et que la métaphysique n'est pas une science. Cette opinion, nous l'avons rencontrée chez Bacon, l'auteur du *Novum organum,* et aussi chez Kant. L'idée principale de la *Critique de la raison pure,* c'est justement que la métaphysique n'est pas une science. On ne peut savoir si Dieu existe. On peut le croire, on ne peut pas le savoir.

Nous allons trouver chez Descartes une tout autre vision des choses, puisque la quatrième partie du *Discours de la méthode* s'intitule : « Preuves de l'existence de Dieu et de l'âme humaine ».

Descartes, c'est l'inventeur de l'optique (entre autres choses). Réfraction.

## I. Le doute métaphysique.

Descartes est un philosophe qui essaie de se défaire de tous ses **préjugés** en doutant de tout.

Y a-t-il une vérité qui soit **entièrement indubitable** ?

L'existence de la matière (pour commencer) est-elle une vérité entièrement inubitable ?

Je peux **imaginer** que je rêve. Je peux feindre que je rêve.

Afin de déraciner de son esprit tous les préjugés, Descartes décide un jour de « rejeter comme absolument tout ce en quoi il pourra **imaginer** le moindre doute ». C'est un doute métaphysique et hyperbolique.

L'existence de la matière n'est pas une vérité entièrement indubitable. (Chez Descartes, le doute portant sur l'existence de la matière est provisoire. Le philosophe irlandais Berkeley ira plus loin et soutiendra que la matière n'existe pas. Cette philosophie s'appelle l'immatérialisme. Voir la cerise de Berkeley.)

L'argument du rêve est un argument traditionnel du scepticisme.

Que dire des vérités mathématiques ? N'est-il pas entièrement indubitable que deux plus deux égale quatre ? Non, répond Descartes, parce que je peux imaginer que je me trompe.

Mais alors, dira-t-on, si on veut raisonner de cette manière, il n'y a rien qui soit entièrement indubitable.

Si, il y a quelque chose : c'est que j'existe. Il m'est absolument impossible d'imaginer que je n'existe pas.

J'ai donc trouvé un vérité entièrement indubitable, un point d'Archimède pour ma pensée.

## II. La nature du moi.

Mais qu'est-ce donc que je suis ? Quelle est la nature de ce *moi* ?

Suis-je un corps ? Non, j'ai un corps ; mais je ne suis pas un corps. Je suis *quelque chose qui pense* : autrement dit un esprit ou une âme.

Il n'y a donc rien de plus certain que l'existence de l'âme humaine.

## III. Le critère de la vérité.

Qu'est-ce qui **m'assure que je dis la vérité** quand je dis que j'existe ?

C'est que « **je vois très clairement** que pour penser il faut être ».

Le critère cartésien de la vérité, c'est l'évidence. Non pas l'évidence des sens, mais l'évidence de la raison. (C'est la différence entre Descartes et l'apôtre saint Thomas.)

## IV. Première preuve de l'existence de Dieu.

Pour une chose que je sais, il y en beaucoup d'autres que j'ignore ou dont je doute.

Cela m'apprend encore quelque chose sur ma propre nature : à savoir que je ne suis pas « tout parfait ». 

Je peux concevoir un être plus parfait que moi-même. Quand je dis que je ne sais pas tout (ou que je ne peux pas tout faire en même temps, que je ne peux pas être partout à la fois), je me compare à « un être tout parfait » donc j'ai l'idée. (Expression à rapprocher de celle de l'Être suprême, dont se serviront les **déistes**.)

Kant appellera ce raisonnement *la preuve ontologique*. Descartes n'est pas l'inventeur de cette preuve, qu'on trouve déjà chez (saint) Anselme de Cantorbéry.

## V. Deuxième preuve de l'existence de Dieu.

Descartes, qui raconte dans le *Discours de la méthode* qu'étant écolier il aimait par-dessus tout les mathématiques, se demande dans ce paragraphe d'où vient « la grande certitude que tout le monde leur attribue ».

L'existence de Dieu, dit Descartes, est au moins aussi certaine que les vérités de la géométrie.

La certitude de la géométrie vient de **l'évidence**. Par exemple, si on **suppose** un triangle, il est évident que la somme de ses trois angles est égale à deux angles droits. Maintenant, y a-t-il un triangle dans l'univers, le géomètre ne s'intéresse pas à cette question.

Si quelqu'un affirme qu'il y a une sphère dont tous les points ne sont pas à égale distance de son centre, on peut être certain *a priori* que c'est faux.

De la même façon, si quelqu'un dit que Dieu n'existe pas, il y a contradiction. Si une sphère n'a pas tous ses points équidistants à son centre, ce n'est pas une sphère. Si Dieu n'existe pas, ce n'est pas Dieu : ce n'est pas un être parfait.




# Révision

La métaphysique est-elle une science ?

Y a-t-il des preuves de l'existence de Dieu et de l'âme humaine ?

Des preuves de l'existence de Dieu, il y en a chez Aristote, chez saint Anselme de Cantorbéry, chez Descartes... Ces preuves méritent-elles bien ce nom ?

Des preuves métaphysiques de l'existence de Dieu. Il faudra dire un mot de ce qu'on peut appeler la preuve de l'ouvrier par l'ouvrage : la preuve de l'existence de Dieu tirée du spectacle de la nature. Fénelon, *Traité de l'existence de Dieu*.

« Je ne puis ouvrir mes yeux sans admirer l’art qui éclate dans toute la nature. ...toute la nature montre l’art
infini de son auteur. »

(C'est cette preuve dont parle l'apôtre saint Paul dans l'épître aux Romains en disant que les athées sont « inexcusables ».)

## Kant

L'opinion selon laquelle la métaphysique n'est pas une science se trouve chez Kant, l'auteur de la *Critique de la raison pure*. *Kritik der reinen Vernunft*.

Livre à peu près contemporain de la révolution de France. Contemporain donc de Robespierre. Voir inscription cathédrale
de Clermont-Ferrand : « Le peuple français reconnaît l'être suprême et l'immortalité de l'âme ». L'être suprême, c'est ainsi que les déistes comme Robespierre nommait Dieu. Voltaire était également déiste.

Loi salique. Jésus-Christ.

## Bacon

Avant Kant, c'est Bacon qui a soutenu qu'il n'y avait **pas d'autre science que la physique**. J. de Maistre, *Examen de la philosophie de Bacon*.

« La **gloire factice** accordée à Bacon n'est que le loyer de sa **métaphysique pestilentielle**. »

Quelle est donc cette philosophie de Bacon ?

De l'importance des sens. Il faut, dit Bacon, tout demander aux sens dans l'étude de la nature.

Affirmation dans laquelle Maistre voit un *truïsme*.

Le véritable sens de cette affirmation, c'est qu'il n'y a de **science réelle** que la physique.

La doctrine de Bacon conduit au matérialisme. Bacon rejette la métaphysique, et renvoie les objets de celle-ci à la théologie positive. Théologie naturelle, théologie positive.

## Preuves de l'existence de Dieu

### Preuve tirée du spectacle de la nature

« Je ne puis ouvrir mes yeux sans admirer l’art qui éclate dans toute la nature. Toute la nature montre l’art infini de son auteur. »

### Preuve de la Divinité par son idée

Preuves métaphysiques.

#### Saint Anselme de Cantorbéry

Qu'est-ce que Dieu ? C'est « quelque chose de tel que rien de plus grand ne peut être conçu ».

L'athée (ou l'insensé) comprend cette idée, puisqu'il dit : il n'y a pas de Dieu.

Si Dieu n'existe pas, c'est-à-dire s'il n'existe que dans l'esprit de l'homme, alors on peut concevoir quelque de plus grand : ce qui est contradictoire.

#### Descartes

L'existence de Dieu est comprise dans son essence.



