
# La liberté

## I. Ambiguïté du terme de liberté

"Le terme de liberté (dit Leibniz) est fort ambigu."

Ce mot a plusieurs sens, de sorte que si quelqu'un parle de "la liberté" sans plus de précision, on ne sait pas de quoi il parle.

Essayons à présent de distinguer les différents sens du mot "liberté" en suivant la méthode proposée par Leibniz.

Il y a trois distinctions à faire.

### A. Liberté de droit et liberté de fait

Quand on oppose l'esclavage à la liberté, on parle de droit. Droit de se marier.

Si on parle de droit, on peut dire que le pauvre est aussi libre que le riche ; mais **de fait**, puisqu'il a moins de moyens, il a aussi moins de liberté.

### B. Liberté de faire et liberté de vouloir

Il y a une deuxième distinction à faire, entre liberté de faire et liberté de vouloir.

La liberté de faire, c'est le pouvoir de faire ce qu'on veut. C'est cette liberté que la prison ou la maladie nous ôte.

### C. Tempérance et libre arbitre.

Enfin, la liberté de vouloir peut se concevoir de deux façons : soit par opposition à "l'esclavage d'esprit" ; soit par opposition à la nécessité (au sens que ce mot a dans le langage philosophique).

Un homme en colère n'a pas l'esprit libre.

Ce que les philosophes appellent libre arbitre, c'est la contingence de nos actes volontaires : c'est la liberté opposée à la nécessité. Voir dans Littré, article "nécessaire", sens 3.

Si je lâche la pierre qui est dans ma main, elle va nécessairement tomber. Elle va forcément tomber ; elle ne peut pas ne pas tomber.

Ce qui n'est pas nécessaire dans ce sens-là, les philosophes l'appellent contingent.

Si on me demande de choisir au hasard un nombre entre un et dix, je sens très clairement qu'il est en mon pouvoir de choisir ou l'un ou l'autre. Il me paraît évident que j'ai un libre arbitre.

Pourtant, il y a des philosophes et des théologiens qui ont nié la liberté humaine. Luther.

## II. Le sentiment de la liberté

Précédemment nous nous sommes demandés **ce qu'est la liberté**.

À présent nous nous posons la question de savoir **si l'homme a un libre arbitre**.

Nous croyons avoir un libre arbitre (et nous verrons que nous avons raison de le croire). Cependant quelques philosophes l'ont nié, comme Spinoza. Il n'y a rien de **contingent** dans la nature : tout arrive par **nécessité**, y compris les actions humaines. Le bavard ne peut pas résister au plaisir de bavarder.

Lecture. Bossuet, *Traité du libre arbitre*, chapitres 1 et 2.

Nous **savons** que nous avons un libre arbitre. C'est une chose que nous **connaissons naturellement**.

Comment savons-nous que nous avons un libre arbitre ? Nous le savons **par le sentiment et l'expérience**.

Si on m'invite à une promenade, **je sens** en moi-même que je pourrais choisir ou d'accepter ou de refuser. Contingence.

À chaque fois que j'ai à faire un choix, je fais **l'expérience** de ma liberté (de ma **liberté de vouloir**).

Cependant, si j'ai choisi d'aller à la promenade, c'est qu'il y a eu une raison qui m'a déterminé à faire ce choix.  Il y a presque toujours une raison qui nous détermine. Qui sait si cette raison ne fait pas dans notre volonté "une nécessité secrète dont notre âme ne s'aperçoit pas" ?

Comment répondre à ce doute ? Il faut imaginer avoir à choisir entre deux choses égales. Lever sa main et la tourner d'un côté ou de l'autre. Dans ce cas, il n'y a aucune raison qui détermine mon choix. Tourner ma main à droite ou à gauche, cela m'est indifférent ; cela m'est égal.

C'est lorsque j'ai à choisir entre des choses qui me sont égales que je sens le plus clairement ma liberté. C'est ce que les philosophes appellent la *liberté d'indifférence*.

## III. Saint Augustin et l'origine du mal

### A. Le fruit défendu

Une page des *Confessions*. Récit d'un larcin (un vol). Saint Augustin raconte avoir volé des poires sur l'arbre d'un voisin pour les jeter aux cochons, et donc **pour le seul plaisir de commettre un acte défendu** : pour le seul plaisir de faire le mal.

Les hommes trouvent plaisir à faire ce qui est défendu par **la loi naturelle**, simplement parce que c'est défendu.

L'image du fruit défendu peut nous faire penser, d'une part, à la faute de nos premiers parents, et d'autre part à l'adultère, sujet dont saint Augustin parle longuement au début du livre.

### B. L'adultère

Saint Augustin, *Du libre arbitre*.

Dialogue philosophique à la manière de Platon. Évodius demande à Augustin **si Dieu n'est pas l'auteur du mal**.

Afin de répondre à cette question, il faut définir le mal. Qu'est-ce que le mal ? Qu'est-ce qu'une mauvaise action ?

Évodius ne sait pas le dire. Il répond par une énumération d'exemples. Je sais (dit-il) que l'adultère et l'homicide, par exemple, sont de mauvaises actions : tout le monde en convient.

On pose alors la question de savoir pourquoi l'adultère est une mauvaise action. Extrait 4.

On demande pourquoi l'adultère est une mauvaise action. On le **croit**, mais on voudrait aussi le **comprendre** : parce que c'est seulement lorsqu'on a compris une chose qu'on peut dire qu'on la **sait**.

"Les hommes désirent non seulement croire, mais aussi comprendre."

Pourquoi l'adultère est-il une mauvaise action ? Trois réponses vont être proposées et examinées.

Dira-t-on que c'est parce que c'est défendu ? Cette réponse ne serait pas satisfaisante. "L'adultère n'est pas un mal parce qu'il est défendu ; il est défendu parce qu'il est un mal."

Deuxième réponse proposée (par Évodius) : L'adultère est un mal parce qu'on ne voudrait pas le subir. Est mauvaise toute action qu'on veut bien commettre mais qu'on n'accepte pas de subir.

Cette réponse a un point faible. Un homme effronté et libidineux pourrait accepter de livrer son épouse à un autre en échange de la même permission que lui donnerait ce dernier. Cet homme pourrait dire : Je ne fais rien de mal, puisque je suis d'accord pour... Pourtant cet homme agirait très mal : poussé par la passion, par le désir (*libido*), il est prêt à marchander sa femme.

Le consentement de la victime ne change rien au caractère mauvais de l'action.

Troisième réponse proposée : C'est mal parce que c'est condamné. Tout ce qui est condamné est-il mauvais ? Ne trouve-t-on pas dans les histoires des exemples de gens condamnés pour de bonnes actions ? Exemple de Socrate.

Révision. Pourquoi Socrate est-il condamné ? On l'accuse faussement d'impiété. Quelle est la vraie raison ? Socrate fait sentir aux autres leur ignorance. Maïeutique.

Est-ce une mauvaise action ? Si quelqu'un croit qu'on peut doubler la surface d'un carré en doublant la longueur de son côté, n'est-ce pas lui rendre service que de lui montrer qu'il n'est pas aussi savant qu'il croit ?

Il est arrivé que des gens soient condamnés pour de bonnes actions. Augustin donne l'exemple des martyrs, condamnés pour avoir avoué qu'ils étaient chrétiens. Pourtant avouer ce qu'on croit n'est pas une mauvaise  action ; c'est plutôt le dissimuler qui serait une action.

Finalement Évodius (comme le serviteur du *Ménon*) se rend compte qu'il ne sait pas pourquoi l'adultère est une mauvaise action. Il ne sait plus quoi répondre.

Peut-être ne faut-il pas chercher le mal dans l'action elle-même, mais dans le désir. Si un homme convoite la femme d'un autre, sans avoir la possibilité d'accomplir ce qu'il désire, il est déjà coupable.

### C. Le meurtre (extraits 5 et 6).

Serait mauvaise l'action inspirée par un mauvais désir, un désir coupable. Y a-t-il donc de bons et de mauvais désirs ?

Que penser d'un esclave qui tue son maître par peur des mauvais traitements que ce dernier lui inflige ? Cet homme désire une vie paisible, ce qui est naturel. Pourtant son action est mauvaise : c'est un meurtre. Il sera condamné. Peut-être grâcié.

C'est une chose naturelle de désirer une vie paisible, mais pas au point de verser le sang d'une personne. La tranquillité est un bien, certes, mais c'est **une chose qu'on perdre contre son gré** et que pour cette raison **on ne doit pas aimer**.

Mais alors, demande Évodius, que penser du cas où quelqu'un tue, pour se défendre, un injuste agresseur qui menace lui-même de le tuer ou de le violer ? C'est ce qu'on appelle la légitime défense. Cette personne ne sera pas condamnée. Pourtant, ce qu'elle fait est mal (d'après ce qui a été dit précédemment), puisque par amour pour la vie (pour une chose qu'on peut perdre contre son gré), elle se souille de sang humain.

Que penser de la loi qui permet ce meurtre ? Cette loi est-elle injuste ? Est-ce même une loi ? À mes yeux, dit Augustin, "une loi injuste n'est pas une loi".

Aux yeux du législateur, la mort de l'agresseur est **un moindre mal**.

Néanmoins, c'est un meurtre. D'ailleurs la loi le permet, mais ne l'ordonne pas. Je suis libre de ne pas le faire. C'est la différence avec le soldat qui tue un ennemi sur le champ de bataille : lui, il obéit à un ordre. La loi lui ordonne de repousser l'ennemi par la violence. C'est pourquoi dans ce cas personne n'appellera cette action un meurtre.

Un meurtre commis en état de légitime défense reste un meurtre. Si **la loi temporelle** ne le condamne pas, **la loi éternelle**, elle, le condamne. Cette action sera punie, si l'univers est gouverné par la divine Providence.

Il n'y a pas une seule loi. Il n'y a pas que la loi. À côté et au-dessus de la loi temporelle, il y a la loi éternelle. Une action peut être permise par la loi temporelle et être mauvaise.
 