
# Descartes et la métaphysique

La métaphysique est-elle une science ?

Certains disent que la métaphysique n'est pas une science ; qu'il n'y a de **vérité certaine** que dans les **sciences expérimentales** (qu'ils appellent, pour cette raison, « la science »). Cette opinion, nous l'avons trouvée notamment chez Bacon, l'auteur du *Novum organum*. Cette opinion est aussi celle de Kant, l'auteur de la *Critique de la raison pure*.

Affirmer que la métaphysique n'est pas une science, c'est dire (entre autres choses) qu'**on ne peut pas savoir si Dieu existe**. C'est dire qu'il n'y a pas de preuves de l'existence de Dieu.

Nous allons chez Descartes une tout autre vision des choses. Descartes, l'inventeur de l'optique. Réfraction.

La quatrième partie du *Discours de la méthode pour chercher la vérité dans les sciences* s'intitule : « Preuves de l'existence de Dieu et de l'âme humaine ».

## I. Le doute métaphysique.

Les disciples de Descartes sont appelés les cartésiens.

Y a-t-il quelque chose dont on ne puisse absolument pas douter ? Y a-t-il une seule chose dont on ne puisse pas imaginer qu'elle est fausse ?

L'existence de la matière (par exemple) est-elle **une vérité entièrement indubitable** ?

Pourtant, dit Descartes, nous pourrions **IMAGINER** que les choses que nous voyons n'existent pas. Nous pourrions IMAGINER que tout ce que nous voyons n'est qu'un rêve.

L'existence de la matière (des corps, des choses matérielles) n'est donc pas une vérité **entièrement indubitable**.

Alors qu'est-ce qui est entièrement indubitable, monsieur Descartes ?

Ce qui est entièrement indubitable, c'est que j'existe. Même en supposant que je ne fasse que rêver, il demeure entièrement certain que j'existe. C'est une vérité dont je ne peux pas douter un seul instant.

## II. La nature du moi.

Qu'est-ce que je suis ? Quelle est la nature de ce *moi* ?

Suis-je un corps ? Non, j'ai un corps sans doute ; mais je ne suis pas un corps. Mon corps, c'est le corps qui est à moi, qui est le mien : ce n'est pas moi.

Moi, qu'est-ce que c'est ? C'est **quelque chose qui pense** : autrement dit un esprit ou **une âme**.

Il n'y a pas de vérité plus certaine que l'existence de l'âme humaine. Certes c'est quelque chose dont nous ne pouvons nous faire une image ; néanmoins c'est quelque chose qui existe.

## III. Le critère de la vérité.

Qu'est-ce qui m'assure que je dis la vérité quand je dis que j'existe ?

C'est que « **je vois très clairement** que pour penser il faut être (exister) ».

Le critère de la vérité, c'est l'évidence. Être cartésien, c'est se fier à l'évidence : non pas à l'évidence des sens (comme l'apôtre saint Thomas), mais à **l'évidence de la raison**. C'est se fier à ce qu'on voit avec « l'œil de l'âme » (comme dit Platon).

## IV. Première preuve de l'existence de Dieu.

Il y a donc au moins une chose que je sais ; et il y en a beaucoup d'autres que j'ignore, ou dont je doute. Par exemple, je doute de l'existence de Dieu.

Et cela (quand j'y pense), m'apprend encore quelque chose sur moi-même : à savoir que je ne suis pas tout parfait. Quand je dis que je ne sais pas tout, je me compare à quelque chose de plus parfait que moi-même : je compare ma science à une science plus grande, à une science infinie.

Quand je dis que je ne sais pas tout (ou que je ne peux pas tout faire en même temps, ou que je ne peux pas être partout à la fois), je me compare à **un être tout parfait**, qu'on appelle aussi Dieu.

Même les athées comprennent ce que ce mot veut dire, puisqu'ils disent : « Dieu n'existe pas ».

S'il n'y avait rien de plus parfait que moi-même ; si cet être tout parfait, dont j'ai l'idée et auquel je me compare, n'existait pas, d'où me viendrait cette idée ? D'où ai-je appris à penser à quelque chose de plus parfait que je ne suis ?

Cette façon de prouver l'existence d'un être suprême, Descartes n'en est pas l'inventeur. On la trouve déjà chez saint Anselme de Cantorbéry. Kant appelle cette preuve la « preuve ontologique ».


## Appendice au chapitre 6

S. Thomas d'Aquin
saint Thomas d'Aquin

*Somme théologique*.

Sur les preuves de l'existence de Dieu.

## I. Les cinq voies.

Il y a, dit saint Thomas, cinq voies pour prouver l'existence de Dieu.

Arrêtons-nous sur la cinquième. C'est la preuve par les **causes finales**.

La flèche et l'archer. Si je vois des flèches groupées sur une cible, j'en déduis que quelqu'un a eu l'**intention** d'atteindre la cible. Or ce quelqu'un, il est évident que ce n'est pas la flèche, qui est un être privé de connaissance. Ce quelqu'un, c'est l'archer. De la même façon, on voit partout dans la nature des intentions. Par exemple, dans le monde des fleurs, on voit des mécanismes qui ont manifestement pour fin d'éloigner la graine de la plante. La machine à planer du pissenlit.

## II. L'existence de Dieu est-elle évidente ?

### A. Définition.

Est évidente la **proposition** dont la vérité apparaît dès que les termes en sont connus.

### B. Exemple.

« Le tout est plus grand que la partie. »

### C. Application à la question de l'existence de Dieu.

Certains philosophes (comme S. Anselme de Cantorbéry) disent qu'il est évident que Dieu existe. Dès qu'on a compris (disent-ils) ce que signifie ce mot : *Dieu*, aussitôt on sait que Dieu existe.

Cette preuve, aux yeux de S. Thomas, n'est pas absolument convaincante, parce qu'il n'est pas certain que tout le monde comprenne le mot *Dieu* de la même façon. Certains croient que Dieu est un corps.

### D. Évidence de l'existence de la vérité.

Quelqu'un pourrait dire encore qu'il est évident que Dieu existe, parce que Dieu est synonyme de vérité, et qu'il est évident que la vérité existe.

Celui qui nie l'existence de la vérité reconnaît par le fait même que la vérité existe : puisqu'il prétend dire quelque chose de vrai. Le relativisme est une doctrine absurde, puisque contradictoire en elle-même.

## III. L'existence de Dieu est-elle démontrable ?

Quelqu'un pourrait dire que l'existence de Dieu étant un article de foi, elle n'est pas une vérité démontrable. La démonstration engendre la science, alors que l'objet de la foi est ce dont la vérité n'apparaît pas.

## Révision chapitres 5 & 6

Physique et métaphysique.

La métaphysique est-elle une science ? Ou seule la physique mérite-t-elle le nom de science, comme le pensent certains ?

Y a-t-il des preuves de l'existence de Dieu et de l'âme humaine ?

Des preuves de l'existence de Dieu, il y en a dans les livres : dans les livres d'Aristote, dans saint Anselme de Cantorbéry, dans Descartes... Ces preuves méritent-elles vraiment le nom de preuves ?

## Fénelon et le spectacle de la nature

Dans le *Traité de l'existence de Dieu*, Fénelon propose des preuves tirée du spectacle de la nature.

« Je ne puis ouvrir mes yeux sans admirer l’art qui éclate dans toute la nature... Toute la nature montre l’art infini de son auteur. »

Par exemple Fénelon nous invite à admirer la distance et la grandeur du soleil, qui paraissent avoir été exactement calculées pour rendre possible la vie sur terre. Compas, justesse.

## Preuves métaphysiques

### Saint Anselme de Cantorbéry

Comment cet auteur croit-il prouver l'existence de Dieu ?

« Nous croyons que tu es quelque chose de tel que rien de plus grand ne peut être conçu. »

D'où part-il ? Fénelon partait, lui, du spectacle de la nature. Saint Anselme part...

### Descartes 

Descartes, *Discours de la méthode*, quatrième partie : « Preuves de l'existence de Dieu et de l'âme humaine ».

Afin de me défaire de mes préjugés, j'ai essayé de douter de tout, et j'ai trouvé une vérité entièrement indubitable : à savoir que j'existe, et que je suis *quelque chose qui pense*, autrement dit un esprit ou une âme.

Il n'y a donc rien de si évident que l'existence de l'âme humaine, puisque c'est une chose dont il est même absolument impossible de douter. Personne ne peut penser qu'il n'existe pas. Même si je rêve, cela prouve encore que j'existe.

Notre erreur est de vouloir imaginer ce qui par nature n'est pas imaginable. Nous sommes prisonniers de notre imagination. (Voir l'allégorie de la caverne dans Platon.)

Puis j'ai réfléchi sur mes doutes, et cela m'a appris que j'étais pas tout parfait. Je me suis alors demandé « d'où j'avais appris à penser à quelque chose de plus parfait que je n'étais ».

La preuve cartésienne de l'existence de Dieu est semblable à celle de saint Anselme : elle consiste à se rendre compte que tout homme a l'idée d'un être tout parfait.

Preuve tirée du spectacle de la nature. Preuve tirée de l'idée de l'infini qui est dans l'esprit humain.

## Kant et la métaphysique

Kant est un philosophe allemand du XVIIIe siècle, l'auteur de la *Critique de la raison pure*.

L'idée principale de ce livre, c'est que la métaphysique n'est pas une science. Il n'y a de science que fondée sur l'expérience. Or ni Dieu ni l'âme ne sont des objets de l'expérience.

Cette conception de la science était déjà celle de Bacon.

Lecture : J. de Maistre, *Examen de la philosophie de Bacon*.

Selon Bacon, seule la physique, seules les sciences expérimentales méritent le nom de science. Hors des sciences expérimentales, il n'y a que des opinions, des croyances, et pas de certitude.

## Sur le but de la physique

Duhem montre qu'une théorie physique n'est pas une vérité absolue. Le but du physicien est de « sauver les phénomènes » (ou sauver les apparences).

Or il est possible de sauver les apparences au moyen de plusieurs hypothèses : par exemple l'hypothèse géocentrique et l'hypothèse héliocentrique.
La terre immobile ou mobile.
