
# La liberté

## I. Ambiguïté du terme de liberté

"Le terme de liberté (dit Leibniz) est fort ambigu."

C'est un mot qui a plusieurs sens, et donc si quelqu'un parle de "la liberté", on ne sait pas de quoi il parle.

Combien ce mot a-t-il de sens ?

Essayons de distinguer les différents sens du mot liberté, en suivant la méthode proposée par Leibniz.

D'abor il faut commencer par distinguer entre **liberté de droit** et **liberté de fait**.

### A. Liberté de droit et liberté de fait.

Si le feu est rouge, je n'ai pas le droit de passer, et dans ce sens, je ne suis pas libre de le faire ; mais **de fait**, à moins qu'il n'y ait une barrière...

Autre exemple : séparation de droit et séparation de fait.

(Quelle différence y a-t-il entre la séparation et le divorce ? Le divorce est la dissolution du lien conjugal.)

### B. Liberté de faire et la liberté de vouloir

Il y a une deuxième distinction à faire, entre la **liberté de faire** et la **liberté de vouloir**.

C'est une chose de pouvoir **faire ce qu'on veut** ; c'en est une autre d'avoir une volonté libre ou un **libre arbitre**.

C'est la liberté dans ce dernier sens qui est discutée. Pourquoi ? Parce qu'il y a des philosophes, des théologiens, qui ont nié le libre arbitre de l'homme. Luther par exemple, a soutenu que l'homme n'avait pas de libre arbitre.

## II. Le libre arbitre

Vocabulaire utile : *nécessaire, contingent*. Lire dans le Littré l'article "nécessaire". Ce mot n'a pas le même sens dans le langage philosophique que dans le langage ordinaire.

Dire que nous avons un libre arbitre, c'est dire que nos actes volontaires sont *contingents*. On m'a demandé de choisir un nombre au hasard : j'ai choisi huit ; il me paraît évident qu'il était en mon pouvoir d'en choisir un autre.

Que peut-on trouver à dire contre le libre arbitre ? Voyons par exemple ce qu'en dit Luther.

### A. Argument de Luther contre le libre arbitre

Luther est chrétien. Il croit qu'il y a un Dieu, et il croit que Dieu est omniscient. Omniscient : qui sait tout. On ne peut pas affirmer à la fois l'omniscience divine et le libre arbitre. Prédestination. Nous sommes prédestinés, pour les uns, à être sauvés, et pour les autres, à être damnés. Inconvénient de cette doctrine : Dieu nous juge pour des actions dont nous ne sommes pas les auteurs. Si nous n'avons pas de libre arbitre, nous ne sommes pas les auteurs de nos actions. S'il n'y a pas de libre arbitre, il n'y a pas de faute. Mea culpa. C'est ma faute. J'ai un libre arbitre. Je suis l'auteur de mes actions.

Luther n'est pas le premier à avoir nié notre arbitre. On pourrait parler aussi des manichéens. Une secte religieuse à laquelle a appartenu saint Augustin.

### B. L'argument de Spinoza contre le libre arbitre

La doctrine de Spinoza tient en une proposition : "Il n'y a rien de contingent dans la nature." Tout ce qui arrive arrive nécessairement (dans le sens philosophique du mot, voir plus haut).

J'ai choisi le huit. Il ne pouvait pas arriver que je choisisse un autre nombre. J'ai **l'illusion** d'avoir un libre arbitre parce que **je ne connais pas les causes** qui m'ont déterminé à choisir le huit. 

## III. Lectures

### A. Bossuet et l'évidence de la liberté

Bossuet, *Traité du libre arbitre*, chapitres 1 & 2.

Dans le chapitre 1, Bossuet distingue les différents sens du mot liberté et explique de quelle liberté il est question. Il n'est question ni de la *liberté de droit*, ni de la *liberté de faire*, mais de la *liberté de vouloir* ou du *libre arbitre*.

"La question est de savoir, s'il y a des choses qui soient tellement en notre pouvoir, que nous puissions ou les choisir ou ne les choisir pas." Ou... ou... : contingence.

Maintenant que nous voyons quelle est la question, que faut-il en penser ? Il est **certain**, dit Bossuet, que nous avons un libre arbitre : c'est d'ailleurs une chose que tout le monde sait, parce qu'elle est **évidente**.

Bossuet distingue trois sortes d'évidence :

- l'évidence du sentiment et de l'expérience
- l'évidence du raisonnement
- l'évidence de la révélation

Évidence du sentiment. Quelqu'un m'invite à une promenade. Je sens qu'il est en mon pouvoir d'accepter ou de refuser. Je sens que je pourrais choisir ou l'un ou l'autre. Je ne peux pas ne pas vouloir être heureux ; mais je peux vouloir aller à la promenade ou ne pas le vouloir. Chaque fois que j'ai à choisir entre deux choses, je fais l'expérience de ma liberté. C'est comme cela que je la connais : par le **sentiment** et par l'**expérience**.

Pourquoi pourrions-nous douter, malgré tout, de notre liberté ? Parce que (pour conserver le même exemple), aller ou ne pas aller à la promenade ne m'est pas égal, ne m'est pas indifférent : cela m'importe ; j'ai une préférence pour l'un des deux. Il y a une raison qui m'a déterminé à aller à la promenade ; et "on peut croire que cette raison fait dans notre volonté une nécessité secrète dont notre âme ne s'aperçoit pas".

Comment sortir de ce doute ? Il faut faire l'épreuve (l'expérience) dans un choix portant sur des choses égales. L'expérience que nous propose Bossuet consiste à lever la main et à la tenir immobile ou à la mouvoir ; et à la mouvoir à droite ou à gauche. Cette fois-ci, il n'y a aucune raison qui me fasse choisir l'un plutôt que l'autre. Je fais donc une expérience très claire de ma liberté. C'est lorsque nous avons à choisir entre des choses égales que nous sentons le plus clairement notre liberté.

L'homme fait à l'image de Dieu. Il y a une petite partie de la matière que le Créateur a mise dans la dépendance de ma volonté. Le pouvoir que j'ai sur ma main, c'est l'image du pouvoir que Dieu a sur toute la matière.

Évidence du raisonnement. Il est également évident par le raisonnement que nous avons un libre arbitre. Quel raisonnement ? Il y a dans toutes les langues, dit Bossuet, des mots et des façons de parler qui expriment clairement notre liberté.

La faute. C'est ma faute. *Mea culpa*. J'ai mal fait. Une mauvaise action. Un crime. C'est ma faute : j'ai voulu librement faire cela ; il était en mon pouvoir de ne pas le vouloir ; je suis l'auteur de mon action : j'ai un libre arbitre.

### B. La doctrine "horrible" de Lutherdoctrine de Luther sur le libre arbitre. C'est dans l'*Histoire des variations*.

C'est Bossuet qui juge "horrible" la 

La doctrine de Luther est que l'homme n'a pas de libre arbitre. Pourquoi ? Parce qu'il est impossible qu'un autre que Dieu soit libre. Il est impossible d'accorder la liberté humaine avec la prescience divine.

Pourquoi cette doctrine est-elle "horrible" ? Cette doctrine fait de Dieu l'auteur de toutes nos actions, bonnes ou mauvaises. C'est ce que Luther écrit en toutes lettres : "Dieu fait en nous le mal comme le bien." La doctrine de Luther nous donne l'idée d'un Dieu mauvais. Raison pour laquelle Bossuet voit une parenté entre la pensée de Luther et le **manichéisme**, l'hérésie manichéenne (dont parle saint Augustin dans plusieurs de ses livres).

## IV. Saint Augustin et l'origine du mal

Saint Augustin. Nous lisons une page tirée des *Confessions*, et plusieurs pages tirées du dialogue *Du libre arbitre*.

### A. Le fruit défendu

Le larcin : le vol (s'emparer injustement du bien d'autrui). Le larron : le voleur.

Leur iniquité : leur méchanceté, leur injustice.

L'indigence : le besoin, la pauvreté.

La première chose que ce texte nous apprend, c'est qu'il y a une **loi naturelle**. La loi naturelle, c'est la loi qui interdit le vol (entre autres). Elle est naturelle dans le sens où elle n'a pas été faite. Elle est naturelle aussi dans le sens où les hommes la connaissent naturellement : elle est "gravée dans le cœur des hommes". Ils peuvent l'enfreindre ; mais ils ne peuvent pas l'abolir. Le voleur n'accepte pas qu'on le vole.

Un récit, le récit d'une mauvaise action, d'un larcin. L'auteur raconte avoir volé des poires sur l'arbre d'un voisin. Il n'a volé ces poires ni par besoin, ni par désir, mais pour le seul plaisir de faire quelque chose de mal ; pour le seul plaisir de commettre un acte défendu. Pourquoi trouvons-nous du plaisir à faire ce qui est défendu ?

Le fruit défendu, cela nous peut nous faire penser à deux choses : 1° à la faute d'Adam et Ève ; et 2° à l'adultère, dont il va question dans la lecture suivante.

### B. L'auteur du mal

*Du libre arbitre*, extrait 1.

C'est un dialogue philosophique à la manière de Platon.

Évodius demande si Dieu est l'auteur du mal.

On ne peut pas répondre à cette question si on ne précise pas de quel mal on parle. Car il y a mal et mal. Si on dit que quelqu'un a *mal fait*, on parle d'une mauvaise action, d'une faute, d'une injustice. Si on dit que quelqu'un *a mal*, on parle de la douleur.

Si on suppose que Dieu est à la fois bon et juste, alors il est évident qu'il ne peut pas être l'auteur du premier genre de mal. En revanche, il peut être l'auteur du second genre de mal : dans la mesure où il punit les méchants. Il leur inflige des peines.

### C. La question troublante

Le mal n'a donc pas un seul auteur : chaque méchant est l'auteur de sa mauvaise action. C'est d'ailleurs pourquoi il mérite d'être puni.

Cependant, si on admet que Dieu a créé les hommes, ces mêmes hommes qui font de mauvaises, n'est-il pas lui-même à l'origine du mal ? C'est une question "troublante", dit saint Augustin, qui fait allusion aux erreurs de sa jeunesse, à sa conversion au manichéisme.

### D. L'exemple de l'adultère (extrait 4)

Qu'est-ce qu'une mauvaise action ? Évodius répond à cette question par des exemples. Tout le monde s'accorde à voir de mauvaises actions dans le meurtre ou l'adulère.

Pourquoi l'adultère est-il un mal ?

Évodius ne sachant pas dire **ce qu'est une mauvaise action**, il répond par une énumération d'exemples : tout le monde conviendra, dit-il, que l'adultère ou le meurtre (par exemple) sont de mauvaises actions.

On pose donc la question de savoir **pourquoi l'adultère est une mauvaise action**.

Évodius va proposer successivement trois réponses à cette question, dont aucune ne donnera satisfaction.

#### Première réponse.

La première réponse examinée, c'est que l'adultère est un mal **parce qu'il est défendu** (par la loi). Une action serait mauvaise parce qu'elle est interdite.

Cette réponse n'est pas satisfaisante. Elle ne nous permet pas de **comprendre** pourquoi l'adultère est un mal : elle se contente de nous renvoyer à l'autorité de la loi.

L'adultère n'est pas mauvais *parce qu'il est interdit* : il est interdit *parce qu'il est mauvais*. On revient donc à la question initiale : pourquoi est-il mauvais ?

#### Deuxième réponse.

La deuxième réponse proposée par Évodius, c'est que l'adultère est un mal parce que c'est une chose qu'on veut bien faire subir aux autres mais qu'on ne veut pas subir soi-même. "Je ne voudrais pas," dit Évodius, "en être victime dans la personne de mon épouse."

De façon étonnante, Augustin n'est pas satisfait par cette réponse. Imagine (dit Augustin) qu'un homme accepte de livrer son épouse à un autre, dans le but de recevoir la même permission de la part de ce dernier ? Cet homme ne ferait-il rien de mal ? D'après la règle proposée, il ne pèche pas. Pécher, pêcher. Je pèche. Je pêche (un poisson).

Cet homme, dit Évodius, agirait très mal. On ne prête pas sa femme aux gens !

Même si tout le monde est d'accord pour procéder à cet échange, l'action reste mauvaise. Le consentement éventuel n'enlève pas le mal de l'action.

#### Troisième réponse.

La troisième (et dernière) réponse proposée par Évodius, c'est que l'adultère est un mal parce qu'il est condamné. Je sais que cette action est mauvaise parce que j'ai vu des gens être condamnés pour cela.

À quoi Augustin répond qu'il est arrivé dans l'histoire que des gens soient condamnés pour de bonnes actions. Il donne l'exemple des martyrs : c'est-à-dire des chrétiens condamnés à mort pour avoir "confessé leur foi" (avoué leur croyance, leur religion).

Si la condamnation était le signe certain d'une action mauvaise, il faudrait juger que les martyrs ont mal agi.

Saint Augustin, *Du libre arbitre,* extrait 4.

La question qu'on se posait est de savoir pourquoi l'adultère est une mauvaise action. Tout le monde **croit** que l'adultère est une mauvaise action ; mais on voudrait aussi le **comprendre**. Ce n'est que lorsqu'on a compris qu'on peut dire qu'on **sait**.

Finalement, Évodius se rend compte qu'il ne sait pas pourquoi l'adultère est une mauvaise action. Au début, il croyait le savoir ; mais en discutant avec Augustin, il découvre qu'il l'ignore. (Ce qui nous rappelle Socrate et la maïeutique.)

Peut-être que ce qu'il y a de mauvais, dans l'adultère, c'est le désir. Il peut y avoir culpabilité même en l'absence d'acte.

### E. Le meurtre (extrait 5).

Il y aurait donc des désirs coupables, des désirs mauvais. Cette réponse, qui sent le manichéisme, doit être examinée.

Que penser d'un serviteur qui tue son maître par peur des mauvais traitements que ce dernier lui inflige ? (L'exemple peut être remplacé par celui d'une femme battue.)

Que désire cette homme ? Il désire une vie sans crainte. Il n'y a rien de mauvais dans ce désir-là. Tout le monde désire une vie sans crainte : personne ne veut être maltraité. Pourtant c'est un meurtre, et l'auteur de ce meurtre sera condamné. (Jacqueline Sauvage a été condamnée et grâciée.)

C'est quand même une mauvaise action, parce que cet homme est allé jusqu'à se souiller de sang humain pour une chose qui n'en valait pas la peine. Le méchant aime une chose qu'il n'aurait pas dû aimer. Il ne faut pas **aimer les choses qu'on peut perdre contre son gré**. Au principe de toute mauvaise action, il y aurait l'amour des choses qu'on peut perdre contre son gré.

### F. La légitime défense (extrait 6).

Que faut-il penser de celui qui tue un bandit qui menaçait sa vie ou sa vertu ?

D'après la définition donnée précédemment, c'est (semble-t-il) une mauvaise action : puisque j'ai tué quelqu'un pour sauver ma vie ou ma vertu ou mon honneur (expression d'ailleurs discutable). Pourtant la loi ne condamne pas cette action. La loi est-elle injuste ? Pourquoi la loi permet-elle une mauvaise action ?

Que penser du soldat qui tue un ennemi sur le champ de bataille ? C'est son devoir. Raison pour laquelle personne n'appellera cela un meurtre.

Le cas de la légitime défense est différent. La loi me **permet** de faire violence à mon agresseur ; elle ne me l'**ordonne** pas.

Pourquoi le permet-elle ? La loi le permet parce que c'est **un moindre mal**. La mort d'un injuste agresseur est un moindre que la mort d'un citoyen innocent.

Mais cela reste un mal, puisque c'est un meurtre (un homicide). C'est permis par la loi, et pourtant c'est un mal. Le fait qu'une soit permise par la loi ne signifie pas nécessairement que cette chose est bonne.

En réalité, il n'y a une loi, mais deux. Il y a une **loi temporelle** et une **loi éternelle** ; une **loi humaine** et une **loi naturelle** (ou encore divine). (Sur l'idée de loi naturelle ou divine, revoir la page des *Confessions* où saint Augustin raconte avoir volé des fruits sur l'arbre du voisin.  La loi qui défend de voler, qui défend le larcin, est une loi naturelle, "gravée dans le cœur de l'homme".)

Une personne qui en tue une autre pour se défendre, ne sera pas condamnée par la loi écrite, mais le sera (peut-être) par la loi éternelle, s'il est vrai que l'univers est gouverné par la Providence.

Cette croyance d'un univers gouverné par la Providence se trouve également chez les stoïciens, chez Épictète.

### G. Le suicide.

Lecture complémentaire. Saint Augustin, *La Cité de Dieu*. Livre I, chap. 16 à 21.

Il y est question de Lucrèce, cette femme romaine célèbre pour s'être tuée à la suite d'un viol qu'elle avait subi.

Il est évident que Lucrèce n'a pas été adultère.

Si Lucrèce est innocente (comme tout le monde en convient), en se tuant elle a tué une innocente.

Donc elle a commis un meurtre. Un meurtre pardonnable peut-être, mais un meurtre tout de même. Saint Augustin rejette l'opinion de ces philosophes qui autorisent le suicide.






