
# Sur l'indifférence.

Lecture des *Pensées* de Pascal.

## I. Introduction.

Les *Pensées* de Pascal sont un livre inachevé.

Ce sont principalement des pensées sur la religion. C'est une **apologie** du christianisme, contre ceux que Pascal appelle les *esprits forts*, ou encore les **libertins**.

Apologie : discours qui prend la défense d'un accusé, comme dans le titre du dialogue de Platon, *Apologie de Socrate*.

Libertins : dans la langue du XVIIe siècle, ce mot a un sens à la fois intellectuel et moral.

## II. Lecture (sur l'indifférence).

### A. L'immortalité de l'âme.

La question de l'immortalité de l'âme, c'est la question de savoir s'il y a une autre vie après celle-ci, ou si l'âme meurt avec le corps.

C'est l'une des grandes questions de la philosophie. D'après Kant, la philosophie tourne autour de trois questions :

- Que puis-je connaître ?
- Que dois-je faire ?
- Que m'est-il permis d'espérer ?

Cette question de l'immortalité de l'âme, dit Pascal, "nous importe si fort, nous touche si profondément, qu'il faut avoir perdu tout sentiment pour être dans l'indifférence de savoir ce qui en est".

Y a-t-il "des biens éternels à espérer" ? Toute sa manière d'agir doit changer, suivant la réponse que donnerons pour nous-même à cette question. Si nous croyons qu'il n'y a pas de biens éternels à espérer, nous passerons notre vie à nous divertir, à la manière de Dom Juan.

Toute notre conduite dépend de l'existence ou de la non-existence des biens éternels que la religion nous fait espérer.

Il y a donc trois sortes de personnes. Celles qui sont persuadées de la vérité de la religion. Celles qui ne sont pas persuadées mais qui cherchent à s'instruire. Celles qui ne sont pas persuadées et qui ne cherchent.

Cette dernière sorte de personnes inspire à Pascal de **l'étonnement** et de **l'épouvante**. Il ne sait comment qualifier une "si **extravagante** créature" : l'homme qui vit dans l'indifférence de sa propre destinée. Extravagance étant synonyme de folie.

### B. Prosopopée de l'athée ou du libertin.

Pascal imagine le discours que se tient à lui-même le libertin. La première partie de ce discours est un tableau de la condition humaine. Nous sommes dans "une ignorance terrible de toutes choses" : Nous ignorons qui nous a mis au monde ; nous ignorons même ce qu nous sommes. Tout ce que nous savons est que nous devons mourir dans peu d'années. Mais nous ignorons aussi ce qu'est la mort.

Le libertin, après avoir fait ce constat, en tire une conclusion absurde : à savoir qu'il décide de passer toute sa vie sans s'inquiéter de sa destinée.

Finalement, Pascal voit dans l'extravagance du libertin **une preuve de la vérité de la religion**. L'athéisme ou l'indifférentisme serait une preuve de la vérité de la religion.
 
L'extravagance (la folie) du libertin, dit Pascal, prouve l'une des vérités de la religion chrétienne. La foi chrétienne consiste principalement à croire deux choses : 1° "la corruption de la nature" (humaine) ; 2° "la rédemption de Jésus-Christ".

Les chrétiens croient que la nature humaine est corrompue (altérée, abîmée, malade). L'homme d'aujourd'hui n'est pas le même que l'homme du commencement.

L'assoupissement du liberté prouverait la corruption de la nature humaine.

## III. Le divertissement.

Un roi a tout pour être heureux. pourtant, s'il est sans divertissement, il est malheureux, tout roi qu'il est.

Béatitude, félicité : bonheur.

Un roi sans divertissement est malheureux. Pourquoi est-il malheureux ? Il va penser à tous les maux qui le menacent, en tant qu'homme et en tant que roi : les "révoltes qui peuvent arriver", les maladies et la mort. Il sera malheureux parce qu'il pensera à lui-même, à sa condition misérable.

Qu'est-ce que Pascal appelle divertissement ? Exemples : les jeux d'argent, la "conversation des femmes" (expression un peu énigmatique), la guerre, les grands emplois, la chasse. Le chasseur, observe Pascal, ne voudrait pas du lièvre qu'il court si celui-ci lui était offert.

Qu'ont en commun toutes ces activités ? C'est qu'elles **nous empêchent de penser à nous-mêmes**. Et c'est cela que Pascal appelle divertissement : une activité qui n'est pas forcément agréable en elle-même mais qui nous plaît parce qu'elle **détourne notre esprit de la pensée de la mort**.

Et la "conversation des femmes " ? Rapprochons de ce fragment de Pascal l'opéra de Mozart *Don Giovanni*, qui met en scène un libertin, dans les deux sens du terme : un athée et un homme dissolu. Air du catalogue. Le valet de Dom Juan a un livre dans lequel il a noté le nom de toutes les femmes séduites par son maître, classées par pays. 

Que cherche Dom Juan ? Est-il heureux en vivant de cette façon ? Ne cherche-t-il pas à se divertir dans le sens où Pascal l'entend ?

