
# Descartes et la métaphysique

Descartes, *Discours de la méthode pour chercher la vérité dans les sciences*. Quatrième partie : « Preuves de l'existence de Dieu et de l'âme humaine ».

La métaphysique est-elle une science ? Certains disent que la métaphysique n'est pas une science ; qu'il n'y a de **vérité certaine** que dans les sciences expérimentales (qui sont à leurs yeux « la science »). Cette opinion, nous l'avons trouvée chez Bacon. On la trouve aussi chez Kant, l'auteur de la *Critique de la raison pure*.

Y a-t-il des preuves de l'existence de Dieu ?

Les disciples de Descartes sont appelés les cartésiens.

## I. Le doute hyperbolique.

Les **sceptiques** disent qu'il n'y a de certain ; qu'on ne peut rien savoir, c'est-à-dire connaître avec certitude ; qu'on ne peut que croire.

Essayons (dit Descartes) de voir si ce qu'affirment les sceptiques est vrai. Essayons de penser que tout est faux. Essayons de « rejeter comme faux tout ce en quoi nous pourrons **imaginer** le moindre doute ».

Parmi les choses que j'ai toujours crues certaines, il y a l'existence des corps, l'existence de la matière. L'existence de la terre, du ciel, de cette table...

Je peux imaginer que je rêve, et que cette table que je vois n'existe pas.

Mais même dans cette supposition, une chose demeure certaine : c'est que moi, j'existe. Si je rêve, c'est que j'existe.

Je peux donc, à la rigueur, douter de l'existence des choses matérielles ; mais je ne peux pas douter un seul instant de ma propre existence.

Cette vérité, à savoir que j'existe, est *entièrement indubitable*.

## II. La nature du moi.

Qu'est-ce que je suis ? Quelle est la nature de ce *moi* ?

Suis-je un corps ? Est-ce que mon corps, c'est moi ?

Mon corps, c'est quelque chose qui est **à moi** mais qui n'est pas **moi**.

Moi, que suis-je ? Je suis (dit Descartes) *quelque chose qui pense* : autrement dit **un esprit** ou **une âme**.

Il n'y a donc pas de vérité plus certaine que l'existence de l'âme humaine. C'est quelque chose que je ne peux imaginer (de même que je ne peux pas imaginer Dieu) ; mais pourtant c'est quelque chose qui existe.

## III. Le critère de la vérité.

Qu'est-ce qui m'assure que je dis la vérité, quand je dis que *j'existe* ?

C'est que « **je vois très clairement** que pour penser il faut être ». Il est on ne peut plus clair que si je n'étais rien, je ne pourrais pas penser.

Savoir, c'est voir. Mais pas voir avec les yeux ; voir par la pensée, ou par « l'œil de l'âme » comme dit Platon.

Le critère cartésien de la vérité, c'est **l'évidence**. Être cartésien, c'est se fier à l'évidence. Non pas à **l'évidence des sens**, comme l'apôtre saint Thomas, mais à **l'évidence de la raison**.

## IV. Première preuve de l'existence de Dieu.

Il y a donc une chose que je sais, une chose que je ne peux pas ignorer, dont je ne peux même pas douter : c'est que j'existe. Mais il y a aussi une foule de choses que j'ignore, ou dont je suis incertain.

Quand j'y pense, ces doutes m'apprennent quelque chose sur moi-même : c'est que je ne suis pas « tout parfait ». Je peux concevoir quelque chose de plus parfait que moi-même.

Quand je dis (par exemple) que « je ne sais pas tout », je me compare à quelque chose de plus parfait que moi-même, dont j'ai l'idée.

D'autres paroles de ce genre : « Je ne peux pas tout faire en même temps. Je ne peux pas être partout à la fois. »

Quand je dis cela, je dis quelque chose d'étonnant (quand on y pense). Je me compare à quelque chose de plus parfait que moi-même : à un être tout parfait, dont la puissance et la science seraient infinies.

Cet être tout parfait auquel je me compare n'existe-t-il pas ? Supposons qu'il n'existe pas. D'où cette idée m'est-elle venue ? « D'où ai-je appris à penser à quelque chose de plus parfait que je ne suis » ? Je ne peux l'avoir appris « que d'une nature qui soit en effet plus parfaite ».

L'homme a l'idée de quelque chose de plus parfait que lui-même.





 


# Révision

La métaphysique est-elle une science ?

Descartes, *Discours de la méthode*. Quatrième partie : « Preuves de l'existence de Dieu et de l'âme humaine ».

Y a-t-il des preuves de l'existence de Dieu et de l'âme humaine ?

Des preuves de l'existence de Dieu, oui il y en a dans les livres : dans Aristote (Dieu comme premier Moteur), dans saint Anselme de Cantorbéry, dans Descartes...

Il y a aussi les preuves tirées du spectacle de la nature, dans le *Traité de l'existence de Dieu* de Fénelon. Cette preuve-là parle aux yeux.

## Fénelon et le spectacle de la nature

Fénelon, *Traité de l'existence de Dieu*.

Démonstration de l'existence de Dieu tirée du spectacle de la nature.

« Je ne puis ouvrir les yeux sans admirer l'art qui éclate dans toute la nature ».

Voir par exemple ce que dit Fénelon sur le soleil, sur sa grandeur et sa distance. Compas, mesure, justesse.

« Toute la nature montre l'art infini de son auteur ».

Faire le lien avec la botanique. Machine à planer du pissenlit.

Cette preuve peut être appelée **la preuve de l'ouvrier par l'ouvrage**. C'est à cause de cette preuve que l'apôtre saint Paul écrit (dans l'*Épître aux Romains*) que les athées sont « inexcusables ».

Passons maintenant aux preuves métaphysiques.

## Saint Anselme de Cantorbéry

C'est une page tirée du *Proslogion* qui veut dire allocution.

L'auteur s'adresse à Dieu. Il lui adresse une prière : il lui demande une preuve de son existence. 

L'auteur se demande d'abord *ce qu'est Dieu*. Qu'est-ce que Dieu ? C'est, dit saint Anselme, « quelque chose de tel que rien de plus grand ne peut être conçu ». (Comparer avec l'expression  de Descartes : un « être tout parfait ».)

L'auteur remarque que « l'insensé » (celui qui dit dans son cœur qu'il n'y a pas de Dieu) comprend de quoi on parle : il conçoit l'idée de Dieu. Simplement il pense que Dieu n'existe que dans l'esprit de l'homme, et non pas dans la réalité.

Or, cela est contradictoire. Si Dieu n'existe que dans l'esprit humain, alors on peut concevoir quelque chose de plus grand.

Descartes tient le même raisonnement. *Discours*, quatrième partie, paragraphe 5.

Descartes compare l'existence de Dieu à des vérités de géométrie. Si une sphère n'a pas tous ses points équidistants à son centre, ce n'est pas une sphère. On peut en être certain *a priori*. Si Dieu n'existe pas, ce n'est pas Dieu. Si l'Éternel n'existe pas, ce n'est pas l'Éternel.

Cette preuve est différente de celle que propose Fénelon. C'est une preuve qui s'adresse non pas aux yeux, mais à l'intelligence seule.

## Kant et la métaphysique

Kant, philosophe allemand du XVIIIe siècle, est l'auteur de la *Critique de la raison pure*. En allemand, *Kritik der reinen Vernunft*.

La métaphysique n'est pas une science. Il n'y a pas de preuves de l'existence de Dieu ou de l'âme humaine. Pourquoi ? Parce que ni Dieu ni l'âme humaine ne sont des objets d'expérience. Il n'y a de science
que fondée sur l'expérience.

Autant dire qu'il n'y a de science que la physique.

Cette opinion était déjà celle de Bacon. Voir le livre de J. de Maistre intitulé *Examen de la philosophie de Bacon*.
