
# La société.

## I. Introduction.

Les hommes sont-ils faits pour vivre en société ? En d'autres termes, l'homme est-il par nature un *animal politique* ?

Nous consulterons les ouvrages suivants :

  - Platon, *La République*.
  - Bossuet, *Politique tirée de l'Écriture sainte*.
  - Rousseau, *Du Contrat social*.

Si étrange que cela puisse paraître, il y a des auteurs qui ont soutenu que les hommes ne sont pas faits pour vivre en société. Rousseau, par exemple, affirme que les premiers hommes ne vivaient pas en société. Rousseau imagine qu'il y a eu un temps où les hommes ne vivaient pas en société : c'est ce qu'il appelle *l'état de nature*, antérieur selon lui à l'état social. Si les hommes aujourd'hui vivent en société, c'est parce qu'ils l'ont décidé : c'est ce que Rousseau appelle le contrat social. 

## II. Les fondements de la cité selon Socrate.

C'est le récit d'une discussion. Socrate raconte une discussion qu'il a eue avec des amis.

La cité. Les cités antiques, les cités grecques : Athènes, Sparte... Une ville, un État.

La question que Socrate examine est celle des fondements de la cité. Une cité, ça repose sur quoi ? C'est fait comment ?

Les fondements de la cité, dit Socrate, sont **nos besoins**. Au minimum et en ne considérant que les besoins du corps, les hommes ont besoin pour vivre de **nourriture**, de **logement**, de **vêtement** et de **chaussures**. (Revoir la fable de Prométhée. Les animaux viennent au monde avec des vêtements, des chaussures, des armes, toutes choses dont l'homme est dépourvu, comme si la nature l'avait oublié.)

Il faut **travailler** pour produire toutes ces choses. Il y aura donc donc dans la cité des laboureurs, des maçons, des tisserands, des cordonniers....

Socrate demande s'il est plus avantageux que chacun ne produise que pour lui-même, exerçant donc tour à tour tous les métiers, ou s'il vaut mieux que chacun ne fasse qu'un seul métier et produise pour toute la communauté.

Il est évident que cette dernière façon de travailler est plus avantageuse.

Pour quelles raisons ?

1° Les hommes ne sont pas tous semblables. Ils n'ont pas tous les mêmes aptitudes : l'un sait faire une chose, l'autre une autre chose. Il est dans l'intérêt de tous que chacun fasse le travail qui correspond à ses aptitudes.

2° On travaille mieux quand on fait un seul travail. C'est en faisant un métier qu'on l'apprend : c'est en forgeant qu'on devient forgeron.

3° Il y a un temps pour faire chaque chose. Il y a un temps pour semer, un temps pour récolter... Ce temps, l'homme n'en est pas le maître : il doit s'y soumettre. Il doit être disponible pour faire la chose au moment au moment voulu. On ne peut pas être à la fois au four et le moulin.

Conclusion. Il est donc plus avantageux et plus naturel que chacun ne fasse qu'un seul travail. De cette façon, on produit davantage et de meilleure qualité. Sans la société, pas de pain, et encore moins de bon pain. C'est donc une façon de montrer que les hommes sont faits pour vivre en société : puisqu'il n'y a que de cette façon qu'ils peuvent avoir en abondance les choses dont ils ont besoin.

Rappel. On cherche à savoir si l'homme est *par nature* un animal politique. Politique, du grec "πόλις/polis", la cité, la ville, l'État.

Il y a des Français et des Allemands. Il y a des Athéniens et des Spartiates. Est-ce la nature qui l'a voulu ? Les hommes ont-ils toujours vécu en société ?

Certains disent que les premiers hommes ne vivaient pas en société, mais qu'ils étaient sauvages. Nous nous représentons nos premiers ancêtres comme vivant dans les bois, solitaires et indépendants les uns des autres. Ces hommes sauvages auraient un jour décidé de vivre en société. C'est l'opinion (par exemple) de Jean-Jacques Rousseau, l'auteur du *Contrat social*.

Que nous dit Socrate sur le sujet ? Dans *La République*, Socrate bâtit une cité par la pensée. Qu'est-ce qu'une cité ?

Une cité, ce sont des hommes qui ont des besoins, à commencer par le besoin de nourriture. Ils ont besoin de pain. Où trouve-t-on du pain ? dans la cité. La production du pain nécessite le travail accumulé d'une multitude de personnes. Pas de société, pas de nourriture (ni de vêtements, ni de chaussures, ni de maisons). Cela ne prouve-t-il pas que les hommes sont faits pour vivre en société, et qu'ils ont toujours vécu ainsi ?

## III. Cité saine et cité malade. Le luxe, la guerre.

Nous avons bâti une cité par la pensée. Est-elle achevée ?

Quelqu'un pourrait faire observer que nos citoyens n'ont que le nécessaire. Leur manière de vivre est rustique. Ne faudrait-il pas leur donner des meubles, des confiseries, des spectacles, de la musique, des parfums ? Des plaisirs, du luxe.

Si on laisse s'introduire le luxe dans la cité (dit Socrate), elle va tomber malade. Pour fournir toutes ces superfluités aux citoyens, il va falloir agrandir la cité et y entrer des cuisiniers, des serviteurs, des artistes, en un mot des *flatteurs* (comme dit Socrate).

La conséquence de cet accroissement démesuré, c'est que le territoire de la cité va devenir insuffisant. Il faudra donc conquérir d'autres territoires et pour cela faire la guerre. Socrate voit donc dans le luxe la cause première de la guerre.

Qui fera la guerre ? Il y aura des citoyens dont ce sera la fonction. Platon les appelle les **gardiens** de la cité. Ces gardiens auront besoin de chefs. Voilà donc une troisième classe de citoyens, les gouvernants.

La vertu qui fait les chefs, c'est la sagesse. La vertu qui fait les gardiens, c'est le courage.

Chacun a une place naturelle dans la cité, une tâche à accomplir, en fonction de ses aptitudes. Il est juste que chacun s'occupe des affaires qui sont les siennes : qui sont les siennes non pas parce qu'il les a choisies, mais parce qu'elles correspondent à ses aptitudes. Le juste et l'injuste ne sont donc pas que des conventions.

Il y a une pensée semblable dans le livre de l'*Écclésiaste,* ce livre qui attribué au roi Salomon. « J'ai vu des esclaves à cheval ; et des princes, allant à pied comme des esclaves. »

## IV. L'origine des peuples et des nations.

Comment se fait-il qu'il y ait différentes nations ?

De vieilles histoires disent qu'au commencement il y avait une seule famille. Histoire de Noé, telle qu'on la trouve dans les livres écrits par Moïse.

Bossuet, *Politique tirée de l'Écriture*.

Selon cette histoire, tous les hommes seraient les descendants de Noé, seul homme qui aurait survécu avec sa famille au Déluge. Si tous les hommes sont les descendants de Noé, comment se fait-il qu'il y ait plusieurs nations ?

L'origine des peuples selon la Bible. Comment les nations et les peuples se sont-ils formés ? Par division. Ils auraient tous une ascendance commune.

## V. Rousseau et la théorie du contrat social.

Rousseau suppose que l'état naturel de l'homme est l'indépendance et la solitude. L'homme du commencement, dit-il, était un animal libre et solitaire. C'est ce que Rousseau appelle « l'état de nature », antérieur selon lui à l'état social.

La famille au moins n'est-elle pas une société naturelle ? N'est-elle pas aussi ancienne que le genre humain ?

Lecture. Jean-Jacques Rousseau, *Du Contrat social*. Sur la famille.

Qu'est-ce qu'une famille selon Rousseau ? La plus ancienne des sociétés, et la seule naturelle. Un père et des enfants. La mère est absente du texte de Rousseau. Le père et les enfants sont liés. Liens. Obligations. Le père (toujours selon Rousseau) doit « des soins » aux enfants ; les enfants doivent obéissance au père. Pourquoi ? Parce qu'ils ont **besoin** de lui pour vivre.

Or, continue Rousseau, il y a un temps où ce besoin cesse : alors « le lien naturel se dissout », et le père et les enfants « rentrent dans l'indépendance ». N'est-ce pas une exagération de parler d'une dissolution du lien filial ? Faut-il comprendre que le fils pourra épouser la mère ? On a l'impression que Rousseau ne voit dans l'homme qu'une bête.

Notons l'emploi que fait Rousseau du verbe « rentrer ». Entrer, rentrer. Rousseau suppose que le père et les enfants ont renoncé à l'indépendance et après un temps y REVIENNENT (comme si c'était leur état initial).

Cet état initial d'indépendance dont parle Rousseau n'est-il pas une chimère ?

Qui enterrera le père ?

## VI. L'erreur de Rousseau.

L'erreur de Rousseau selon J. de Maistre.

Rousseau IMAGINE (et même en fait il ESSAIE D'IMAGINER) quoi ? Un peuple qui discute des avantages et des désavantages de la société, et qui à la fin décide d'abandonner l'état sauvage (que Rousseau appelle « l'état de nature ») et de vivre en société.

J. de Maistre soutient que cette supposition est absurde. Pourquoi est-elle absurde ? Pour que cette discussion ou cette délibération puisse avoir lieu, il a fallu que ces hommes se comprennent, donc qu'ils parlent et qu'ils parlent la même langue. Mais s'ils parlaient la même langue, c'est qu'ils vivaient déjà en société. C'est donc qu'ils n'étaient pas, ces hommes du commencement, les brutes dont ces philosophes nous entretiennent.

Les sauvages.


« Les hommes sont-ils faits pour vivre en société ? »
Pourquoi cette question ? Parce qu'il y a des philosophes qui supposent que l'état naturel est l'indépendance. « L'homme est né libre. » Cet état d'indépendance dans lequel les premiers hommes auraient vécu, ces philosophes l'appellent « l'état de nature ».

Qu'est-ce que la *nature* d'un être ? Comment la connaître ? Comment connaît-on, par exemple, la nature de la vipère ? La vipère est un animal qui rampe. Qu'est-ce qui permet de l'affirmer ? L'expérience. Tous les serpents qu'on a vus dans le monde rampaient. Donc le serpent est un reptile.

Revenons à l'homme, dont Rousseau nous dit que « par nature c'est un animal libre et solitaire ». Cet homme naturel n'existe peut-être que dans l'imagination de Rousseau. L'homme qu'on peut voir ici-bas est « un animal intelligent, religieux et sociable ». Sociable : avec qui on peut parler, avec qui on peut s'entendre.

Résumé. Que faut-il savoir sur la philosophie de Jean-Jacques Rousseau ? « L'homme est né libre, et partout il est dans les fers. » C'est dans le *Contrat social*. Rousseau oppose l'homme du commencement à l'homme d'aujourd'hui. Il suppose que l'homme du commencement était un animal solitaire. Mais cet animal solitaire qui est selon Rousseau l'homme naturel n'a peut-être jamais existé.

## VII. L'origine du langage.

Condillac et l'invention humaine du langage.

Un autre philosophe du XVIIIe siècle, Condillac, est allé plus loin que Rousseau et a supposé que les premiers hommes ne parlaient pas, ne savaient pas parler. Ils auraient donc inventé le langage, en commençant par des gestes et des cris.

Peut-on croire à l'invention humaine du langage ?

### A. L'expérience.

Que nous apprend l'expérience à ce sujet ? Comment les choses se passent-elles sur terre ? Comment apprend-on à parler ?

On apprend à parler en **entendant** parler ; et on parle **la langue** qu'on a entendu parler. Qui n'entend pas parler ne parle pas. Personnes nées sourdes. Enfants sauvages. Personnes isolées. Expérience de Frédéric II.

Partout et toujours l'homme **reçoit** le langage, comme la vie. Le langage est transmis et reçu, jamais inventé.

Ces observations nous conduisent à penser que l'homme du commencement parlait, et que le langage s'est transmis de façon ininterrompue jusqu'à nous.

### B. L'impossibilité a priori de l'invention du langage.

Qu'est-ce qu'inventer ? Prenons l'exemple de la machine à vapeur, dont on attribue l'invention à Denis Papin. L'inventeur de cette machine **s'est dit** qu'on pourrait peut-être convertir de la chaleur en mouvement par le moyen de la vapeur d'eau.

Inventer, c'est penser. Or la pensée est une parole intérieure. Penser, c'est se parler à soi-même. Le langage est donc « le moyen de toute invention ». Le langage lui-même ne peut donc pas être une invention.

L'homme a donc dû naître parlant.

### C. Le langage, expression de la société.

Bonald, *Recherches philosophiques*.

La société, dit Bonald, est composée de trois personnes nécessaires : le père, la mère, l'enfant. La constitution de la **société publique** (ou société politique) est identique à celle de la **société domestique**. Pouvoir, ministre, sujet.

Ce nombre trois se retrouve dans le langage, où il y a aussi trois personnes : *je, tu, il*. Les trois personnes du langage correspondent aux trois personnes de la famille : celle *qui* parle, celle *à qui* l'on parle, celle *de qui* l'on parle.

L'homme n'a inventé ni la société ni le langage, qui sont le moyen de sa conservation.

