<!-- http://robertfaurisson.blogspot.com/1992/05/vie-quotidienne-des-juifs-allemands.html -->

<!-- Friday, May 1, 1992 -->

Vie quotidienne des juifs allemands pendant la guerre (Trois documents)

Célestin Loos

(en réalité, feu Pierre Moreau, de Bruxelles, et Robert Faurisson ; article publié dans la Revue d'histoire révisionniste, n° 6, mai 1992, p. 131-140)

On sait qu'en mars 1933 les organisations juives mondiales décrétaient la guerre économique contre l'Allemagne. En septembre 1939, Chaïm Weizmann déclarait la guerre armée. En Europe, pendant toutes les années de guerre, la résistance juive ― en particulier communiste ― fut active. Pour ne prendre que cet exemple, le 13 mai 1942, onze juifs communistes appartenant au groupe Herbert Baum et au groupe Werner Steinbrinck (également appelé « groupe Franka ») organisèrent l'incendie de l'exposition « Le Paradis soviétique » au Lustgarten de Berlin. Cinq civils allemands trouvèrent la mort dans cet incendie [1]. 

Les Allemands tenaient les juifs dans leur ensemble pour les représentants d'une puissance belligérante hostile d'autant plus redoutable que, sur le plan international, elle était dotée de moyens considérables dans le domaine financier (l'argent, nerf de la guerre) et dans celui des médias et de la propagande. Les attentats entraînaient des représailles et les représailles, de nouveaux attentats. De même que les Américains ou les Canadiens, estimant dangereuses ou hostiles les personnes d'origine japonaise, décidaient, malgré l'absence d'attentats ou de sabotages, de placer ces dernières dans des camps de concentration, de même les Allemands procédèrent-ils à l'évacuation et à la mise en camps de concentration, de travail ou de transit d'une grande partie des juifs allemands. Mais il a subsisté durant toute la guerre, au grand jour, une vie juive en Allemagne. On trouvera, ci-dessous, trois documents qui permettent de fournir une esquisse de cette vie quotidienne : un journal, un extrait de l'annuaire des téléphones, une carte d'alimentation. Il va de soi que plus la guerre se prolongeait et plus cette vie se détériorait, comme celle des autres Allemands, d'ailleurs.

Un journal

Le premier est l'hebdomadaire Jüdisches Nachrichtenblatt [L'Informateur juif] qui paraissait, en toute légalité, durant la seconde guerre mondiale, à l'intention des communautés religieuses israélites allemandes. Il faut y insister, cet hebdomadaire était parfaitement officiel et ses titre, adresse et numéro d'appel figuraient à l'annuaire téléphonique. Le siège du périodique se trouvait à Berlin N4, Oranienburger Straße 40/41. On y perçoit le reflet d'une organisation bien structurée et d'une autonomie sociale, brimée mais sans signe tragique, souvent même paisible, si l'on considère l'époque et ses bouleversements éprouvants pour le restant de la population allemande. A cause du manque de papier, tous les journaux allemands virent leurs dimensions se réduire. Ce fut le cas du Jüdisches Nachrichtenblatt en janvier 1943 et la dernière livraison parut en décembre de la même année. 

Analysons la livraison numéro 23 de l'année 1942, en date du 5 juin. 

On y trouve annoncés les cultes qui se tiendront dans les neuf synagogues berlinoises pour la semaine du 5 au 12. On y lit aussi les éphémérides selon le calendrier juif pour la semaine correspondante, à partir du sabbat suivant, c'est-à-dire « du 21 au 28 Siwan 5702 ». Ou encore, un avis concernant la permanence du service de pompes funèbres juives, avec les heures d'appel aux différents numéros de téléphone. On annonce l'activité du culte dans deux autres villes, Francfort-sur-le-Main et Hambourg. 

Le décès à Berlin, à l'âge de 86 ans, d'une personnalité originaire de Dessau fait l'objet d'une rubrique spéciale. Il s'agit de l'ancien banquier Paul (Israel) Märker. « Monsieur Märker », peut-on lire, « fut pendant plusieurs dizaines d'années trésorier de la fondation Cohn-Oppenheim et membre du Comité de direction de la communauté de Dessau. Il a rendu de grands services à la communauté juive. » 

Pour la ville de Rheydt, on fait part des noces d'or d'un couple « qui jouit d'une grande estime parmi les juifs de l'endroit. Monsieur Spier s'est signalé notamment en accomplissant gracieusement la charge de récitant pour permettre le maintien des cérémonies religieuses ». 

L'article principal du Jüdisches Nachrichtenblatt consiste en l'exposé purement technique des nouvelles dispositions légales sur la démission volontaire des membres des communautés juives qui ne pouvaient avoir lieu que dans d'étroites limites. De même paraît une rubrique prescrivant l'obligation, pour les Israélites, de ne faire appel qu'à des coiffeurs juifs. 

Pour le reste, il y a les annonces, qui éclairent la vie quotidienne des juifs en Allemagne en 1942. 

Les annonces familiales d'abord. On fait part d'un mariage pour le 7 juin. D'autres jeunes mariés répondent aux vœux reçus. Un jeune garçon remercie ceux qui l'ont félicité à l'occasion de sa barmitzva. Des noces d'argent, des noces d'or encore. On célèbre les anniversaires de personnes dont les âges vont de soixante à quatre-vingt-dix ans. Puis les nécrologies de personnes décédées le plus souvent à un âge avancé, d'autres plus jeunes « après une longue et pénible maladie ». Une dame et une autre « se sont paisiblement endormies » [sanft entschlafen]. 

Bref, en pleine guerre, les joies et les peines habituelles de la vie. 

Il y a encore d'autres annonces, plus prosaïques. Une librairie juive [Jüdischer Buchvertrieb] fait de la réclame pour quelques titres : une biographie de Theodor Herzl, le père du sionisme ; une autre de Moses Heß, le fondateur du socialisme moderne ; une autre encore de Chaïm Arlosoroff, activiste sioniste assassiné en 1933 (à Tel-Aviv). Elle vend aussi des livres d'occasion, au comptoir ou par correspondance. Le paiement se fait à l'enlèvement ou à la commande, mais on garantit les envois par retour du courrier. 

Une dame, « professeur diplômée », propose des leçons particulières d'anglais et de français. Un professeur de musique ne donne ses cours qu'à domicile. Des personnes recherchent une pension de famille juive. Il y a des offres et des demandes de locaux à louer, meublés ou non. 

Les praticiens de l'art de guérir, médecins, dentistes, kinésithérapeutes, doivent obligatoirement spécifier qu'ils ne sont autorisés qu'à soigner des patients juifs, mais ils annoncent leur pratique. Il leur est réservé une rubrique d'annonces « Soins de santé » où chacun donne, avec son adresse et son numéro de téléphone, les jours et heures de ses consultations. Le Dr Jacob, Wilmersdorf, Badensche Str. 21, II (coin de la Kaiserallee), tél. 87 70 28, consulte de 10 à 12 h et de 4 à 7 h, sauf le lundi et le mercredi après-midi ; le samedi après-midi et le dimanche matin, uniquement sur rendez-vous. Le Dr Berthold Alexander est radiologue et reçoit de telle à telle heure au 19 de la Augsburger Straße, matin et après-midi (même le dimanche, si l'on comprend bien), mais le samedi uniquement en matinée. Le Dr Leopold Berendt, Friedrichstraße 3, lui aussi, reçoit le mercredi et le dimanche matin, ainsi que le samedi après-midi, mais uniquement sur rendez-vous. De même encore, le Dr Herbert Rittler reçoit en consultation Markgrafenstraße 20, sauf le samedi après-midi et le dimanche matin sur rendez-vous. Sally Rosenthal est kinésithérapeute et assure des massages médicaux et des bains de lumière localisés, qu'elle dispense sur rendez-vous à la Neuen Roßstraße et le samedi de 10 h à 14 h sans interruption. Et elle est agréée par toutes les caisses de sécurité sociale réservées aux juifs [Zu allen Krankenkassen nur für Juden zugelassen]. « J'ai rouvert mon cabinet », annonce le Dr Max Brandenstein, de Hambourg, au rez-de-chaussée de la Bundesstraße 35a, et on peut l'atteindre au numéro de téléphone 55 71 50, au nom de Siegmund Elias (cet annonceur avait eu des ennuis ― on ne sait de quel ordre ― mais enfin, sa situation se rétablissait, semble-t-il). 

On propose une garde « consciencieuse et affectueuse » pour des vacances de convalescence, à deux ou à trois enfants d'âges allant jusqu'à six ans, que l'on ira chercher et reconduire à domicile. 

Telle était, prise sur le vif, l'existence juive dans la capitale et dans quelques grandes villes du Reich au milieu de la guerre. Il existait un bulletin de liaison et des lecteurs qui en profitaient pour communiquer entre eux. Quelle qu'en soit l'importance ou le caractère dérisoire, il doit être permis d'en faire la constatation, sans rien affirmer, sans forcer les conclusions.

Un annuaire téléphonique

Une autre pièce intéressante sort d'un annuaire téléphonique dont voici le titre complet : AMTLICHES FERNSPRECHBUCH für den Bezirk der Reichspostdirection BERLIN ― Herausgegeben von der Reichspostdirektion Berlin / Ausgabe Juni 1941 / Stand vom 1. Februar 1941 [Annuaire officiel des téléphones pour le secteur postal de Berlin ― édité par la direction des Postes du Reich pour la section de Berlin / Édition de juin 1941 / État du 1^er^ février 1941]. 

Aux pages 581 et 582 sont groupés les numéros d'appel des associations juives de la capitale. Il y en a deux colonnes et demie de texte serré, énumérant les différents centres, leurs adresses, les activités assurées, les services mis à disposition des membres. Voici reproduite la première partie de la première rubrique, celle de la Fédération religieuse juive : Communautés juives de Berlin, société enregistrée [Jüdische Kultusvereinigung Jüdische Gemeinde zu Berlin eV. (eingetragener Verein)] :

- Bâtiments administratifs N4 Oranienburger Str 28, 29 et 31 - 

*42 59 21. 

Le central permet d'atteindre les services suivants : 

Archives ― Bureau des constructions ― Service des cotisations -Encaissements ― Gestion financière ― Gestion immobilière ― Direction générale ― Comptabilité générale ― Caisse centrale ― Cadastre ― Bureau du culte et des mariages ― Service du matériel ― Service du personnel ― Service de la presse ― Service juridique ― Service de révision ― Service des écoles ― Bureau des statistiques ― Secours d'hiver ― Aide au logement ― Service central des homes de vieillards. 

En soirée et la nuit :

Plörin, Oranienburger Str 29 (42 94 27). 

Salle du conseil de la Présidence (42 94 30).

- Bâtiments administratifs N4 Oranienburger Str 31 -

 *42 51 31. 

Le central permet d'atteindre les services suivants : 

Office de l'émigration ― Changement de métier et service social ― Arbitrage et conseil juridique ― Aide aux sans abris ― Aide à l'entreprise (argent). 

Emploi et service des étrangers (42 51 31). 

*42 63 96.

Ce qui est reproduit ci-dessus ne représente qu'un peu plus de 13 % de l'espace réservé dans l'annuaire aux associations juives reliées au réseau téléphonique de Berlin en 1941, donc en pleine guerre. 

Dressons une liste tirée de ces rubriques, montrant la complexité de la structure sociale juive dans la seule capitale du Reich à cette époque. La liste n'est pas exhaustive, parce que certaines entrées se répètent dans les différentes sections : Administration des écoles ― Aide à l'entreprise (fonds) ― Aide au logement ― Aide aux prisonniers et aux sans abris ― Aide à l'enfance ― Arbitrage et conseil juridique ― Archives ― Assistance aux malades ― Association pour la culture juive en Allemagne ― Bâtiments administratifs ― Bienfaisance et protection de la jeunesse ― Bureau des statistiques ― Bureau des constructions ― Bureau du culte et des mariages ― Cadastre ― Caisse centrale ― Chambre d'habillement ― Cimetières (inspection des) ― Clinique privée juive ― Comptabilité générale ― Cuisines communautaires ― École ménagère ― École primaire (garçons) ― École primaire (filles) ― École privée supérieure ― École de commerce ― École professionnelle pour le dessin de mode et la décoration ― École de chimie ― École ménagère ― École moyenne ― Écoles primaires (huit adresses) ― Emploi et service des étrangers ― Encaissements ― Équipe de fossoyeurs ― Fonds national juif (société enregistrée) ― Foyer pour infirmières ― Foyer pour institutrices israélites ― Foyer pour jeunes filles ― Gestion financière ― Gestion immobilière ― Home pour dames et jeunes filles ― Home pour jeunes gens juifs ― Home de vieillards et de soins ― Home pour nourrissons et jeunes enfants juifs ― Home pour malades ― Home pour enfants et adolescents ― Homes pour enfants (trois adresses) ― Hôpital Auguststr. 16 ― Hôpital Elsasser Str. 85 ― Hôpital Iranische Str. 2 ― Hôpital Schulstr. 78 ― Maison d'éducation ― Maison pour aveugles Stylz ― Maison pour sourds-muets et malentendants ― Mise au travail et service des étrangers ― Nationalfonds (société enregistrée) ― Office de l'émigration ― Pension pour vieillards ― Permanence d'aide [Bereitschaftsfürsorge] ― Population résidente [Insasse] ― Protection de la jeunesse ― Reclassement professionnel et service social ― Résidence sud ― Résidence nord ― Résidence Weißensee ― Résidence centrale ― Salle de lecture pour les enfants ― Secours d'hiver ― Séminaire juif pour jardins d'enfants et garderies ― Service de la presse ― Service de révision ― Service des écoles -Service du matériel ― Service de santé ― Service de la presse ― Service d'immigration ― Service des écoles ― Service central des homes de vieillards -Service des cotisations ― Service juridique ― Service du personnel ― Service du matériel. 

Il fait peu de doute que la population juive établie en Allemagne bénéficiait d'institutions propres et légalement reconnues. Leur situation officielle reflète la position des autorités à leur égard, mais elle était aussi parfaitement cohérente avec l'état d'esprit de la population allemande, comme en témoignait, fin 1941, le journaliste juif américain George Axelsson. En mission professionnelle en Allemagne, il câblait un reportage à son journal, le New York Times (qui le publiait le 10 novembre 1941, page 31), sur le Reich et sur les plus de 200 000 juifs qui y séjournaient encore. Il le concluait en ces termes : « Dans les lieux publics et dans ses contacts de travail dans les usines, l'ouvrier allemand semble considérer le juif comme un égal. » [2]  Tout cela n'est guère compatible avec l'image des juifs dans l'Allemagne de cette époque telle qu'on la présente habituellement. Nous sommes loin d'une horde traquée, disloquée, sans aucune espèce de recours, sans aucun bien, sans aucun droit. Ce sort-là ne fut pas celui des juifs en général, mais bien celui que des millions d'Allemands devraient subir à partir de 1945. Dans l'esprit du public, il s'est fait assez facilement la substitution, induite par la propagande, entre la déchéance souvent fictive des juifs sous le Reich et celle qui ne fut que trop réellement infligée aux Allemands, surtout aux déportés chassés de l'Est, après 1945.  On ne manquera pas d'opposer que l'annuaire en question ici remonte à 1941 et que toute l'organisation qu'il reflète ne tarda pas à être anéantie peu après. Il ne semble pas. Le Comité International de la Croix-Rouge a publié juste après la guerre un ouvrage sur les camps de concentration allemands : L'Activité du CICR en faveur des civils détenus dans les camps de concentration en Allemagne (1939-1945) [3^e^ édition, Genève 1947]. On y trouve à la page 103, le rapport, daté du 16 avril 1945, d'un de ses délégués sur ses pourparlers avec le SS-Obergruppenführer Müller, de la SS-Führungshauptamt. On y peut lire cette phrase :

D'autre part [Müller] me permit de placer sous la protection du CICR le camp de rassemblement juif de la Schulstrasse 78 à Berlin, ainsi que l'hôpital juif de l'Iranische Strasse 2, également à Berlin. [3] 

Ces deux adresses figurent bien dans la liste que nous donnions ci-dessus et sont effectivement celles de deux hôpitaux qui subsistaient donc encore en tant que propriété juive à la fin du conflit. On aimerait savoir ce qu'étaient devenus les deux autres, ainsi que le reste du patrimoine immobilier de la communauté juive. Il n'est pas téméraire de penser qu'ils se trouvaient, pour une bonne part, comme des milliers d'autres immeubles, parmi les ruines de Berlin bombardé [4]. 

Une carte d'alimentation

Mais de l'administration juive, et d'ailleurs des civils juifs eux-mêmes, est-il seulement vraisemblable qu'il en subsistât encore quelque chose ou quelques-uns en Allemagne à la fin du conflit ? Voici un élément de réponse que fournit en sa page 324 le livre de Gérard Silvain, La Question Juive en Europe, 1933-1945 [5]. Sous le fac-similé d'un document l'auteur a inscrit cette légende :

1945 

Carte d'alimentation (produits de première nécessité) pour adulte.

Le cachet « JUDE » a été apposé non seulement sur la carte mais aussi sur le coupon. 

Entre le 5 février et le 4 mars 1945 existait-il encore des Juifs en liberté sur le territoire allemand ? 

Cette carte, dont les tickets sont découpés, prouve qu'elle a été utilisée et permet donc de répondre par l'affirmative.

De fait, la période de validité de la carte reproduite courait du 5 février au 4 mars 1945, et l'office de ravitaillement émetteur était celui de Munich-ville. Il est bien exact que non seulement la carte mais aussi les coupons portaient la mention « JUDE » ; cette mention n'était nullement apposée au moyen d'un tampon mais imprimée, ce qui signifie que le nombre de destinataires de ces cartes était important et justifiait l'impression. Il fallait donc programmer cette impression. Les cartes de ravitaillement n'étaient pas distribuées à la volée, mais sur la foi de listes nominales rigoureusement dressées, on s'en doute. Ces listes ont-elles toutes disparu, de toutes les archives, de toutes les villes d'Allemagne? On a peine à le croire, mais alors, que ne les produit-on ? 

En outre, les juifs sont surtout citadins et, à ce titre, ils étaient particulièrement vulnérables puisque les Alliés ne bombardaient principalement que les villes. Combien en est-il mort de la sorte, brûlés à domicile ? Sauf erreur, on ne nous l'a jamais dit, mais là aussi les chiffres prouvés doivent avoir survécu. 

Dans certains cas, des enfants juifs étaient envoyés à la campagne pour échapper aux bombardements ; ce fut, entre autres, le cas de Lea Rosch, aujourd'hui importante personnalité de la télévision allemande. 

La période du 5 février au 4 mars 1945 fut celle du bombardement de Dresde (13/14 février 1945). Les Alliés tuaient par le feu les civils allemands. Les Allemands, on le voit, nourrissaient les civils juifs. 

En mai 1945, les Soviétiques installèrent le Dr Werner à la tête de la mairie de Berlin. Ils lui demandèrent de créer près le conseil municipal une institution des cultes composée d'un prêtre catholique, de deux pasteurs protestants et d'un rabbin représentant, pour sa part, les 6 000 juifs de Berlin (Georges Soria, L'Allemagne a-t-elle perdu la guerre ?, Bibliothèque française, 1947, p. 23).

1^er^ mai 1992

______________

Notes

[1] Voy. Eliahou Maoz, « Une Résistance juive en Allemagne », Commémoration de la révolte des ghettos, Jérusalem, mars 1965, 15 pages éditées en photocopie par le département d'organisation de l'Organisation sioniste mondiale ; voy., aussi, l'article « Berlin » de l'Encyclopedia Judaica (1971).

[2] Cité par James J. Martin, The Man Who Invented Genocide / The Public Career And Consequences of Raphael Lemkin, Institute for Historical Review, Torrance, 1984, p. 35. Sur l'exacte condition des juifs travaillant aux côtés d'ouvriers allemands à Fürstengrube, l'un des 39 camps auxiliaires du camp d'Auschwitz, on peut lire l'étonnant document NI-10847 traduit, assez mal, dans La Persécution des juifs dans les pays de l'Est présentée à Nuremberg, recueil de documents publié sous la direction de Henri Monneray, éditions du Centre [de documentation juive contemporaine], Paris, 1949, p. 201.

[3] « L'hôpital juif de Berlin, dirigé par le Dr Walter Lustig, fonctionna jusqu'à la fin de la guerre ainsi que le cimetière juif de Weissensee » (article « Berlin » de l'Encyclopedia of the Holocaust, 1990).

[4] Le 24 novembre 1943, un bombardement de l'aviation britannique détruisait la « Nouvelle Synagogue » du 30, Oranienburgstrasse. La photographie de cette synagogue en flammes a, depuis 1945, circulé dans le monde entier avec l'explication suivante : la synagogue a été détruite par un incendie volontaire, dû aux nazis, pendant la Nuit de Cristal du 8/9 novembre 1938. Encore récemment, la Poste fédérale allemande éditait un timbre-poste présentant cette version des faits également répétée dans Le Monde (Frédéric Edelmann, «Le Souvenir d'une négation», 8 février 1992, p. 17). Pourtant, en 1987, une publication de la communauté juive de Berlin, préfacée par Heinz Galinski, responsable de la communauté juive de Berlin, avait admis la vérité (voy. la brochure Wegweiser durch das jüdische Berlin ― Guide du Berlin juif).

[5] Paris, éd. Jean-Claude Lattès, 1985.

Labels: Chaïm Weizmann, CICR, Dr Werner, Georges Soria, Gérard Silvain, Jüdisches Nachrichtenblatt, Lea Rosch, New York Times, Pierre Moreau
