<!-- http://robertfaurisson.blogspot.com/1991/11/un-monument-de-propagande-le-memorial.html -->

<!-- Saturday, November 30, 1991 -->

Un monument de propagande ("Le Mémorial de la Résistance charentaise")

Le voyageur qui se déplace sur la RN 141 reliant Angoulême à Limoges peut apercevoir de loin un imposant monument de pierre blanche en forme de « V » et de croix de Lorraine. Il s'agit du Mémorial de la résistance charentaise situé à Chasseneuil-sur-Bonnieure. Les panneaux de direction indiquent : « Cimetière national. Mémorial de la Résistance. »

A première vue, le vaste cimetière au centre duquel s'élève ce monument, doté d'une crypte à sa base, est celui de résistants charentais morts au combat ou des suites du combat.

C'est ce qu'on peut croire au premier abord ; et tout, au surplus, aussi bien dans la disposition des lieux que dans le commentaire officiel, tend à confirmer cette impression qui, comme on va le voir, est pourtant fausse.

Mais tenons-nous-en, pour l'instant, à cette impression première et à tout ce qui la suscite et l'entretient.

Pour commencer, le visiteur qui gravit l'allée centrale du cimetière en direction du monument n'aperçoit, à sa droite et à sa gauche, que des tombes de résistants. A un moment donné, sur sa droite, il avisera un vaste bloc de pierre dédié à la mémoire de vingt-cinq « résistants du maquis "Bir Hakeim" » dont on aperçoit les tombes individuelles en contrebas. Parvenu au pied du monument lui-même, le visiteur constatera que de nombreux hauts-reliefs y retracent l'histoire de la résistance charentaise. Aucune sculpture ne rappelle que plus de cent mille soldats français sont morts pendant la campagne de France de 1939-1940 ; tout au plus note-t-on la sculpture d'un soldat français écrasé par la défaite ; celui-ci ne porte pas le casque du combattant mais le simple calot du prisonnier ; à ses pieds s'entassent des armes qu'il a fallu déposer et qu'un résistant ― une autre sculpture le montre ― viendra rechercher.

Entrons dans la crypte du mémorial. On y compte une série d'alvéoles contenant les restes de vingt-neuf résistants. C'est ici, dit le commentaire d'un recueil photographique, que « reposent les principaux chefs de la résistance charentaise ». Ce recueil photographique ainsi que les brochures qui sont en vente sur place ne parlent que de résistance et jamais de la campagne de France, à l'exception peut-être de très vagues et inévitables allusions.

Comme pareille crypte constitue en principe l'endroit, par excellence, où devraient reposer des héros morts au champ d'honneur, et comme les escarmouches contre l'occupant n'ont surtout pris place en Charente que pendant quelques jours de l'été 1944, on ne devrait pas y trouver, semble-t-il, les restes de résistants morts après l'été 1944 ou, à la rigueur, après la bataille de Royan et le 8 mai 1945, jour où l'Allemagne a signé sa reddition sans condition.

Or, on a la surprise de constater que, dans cette crypte, reposent aussi les corps de résistants morts en 1949 (René Véry), en 1963 (colonel Marc Roger Geissmann et colonel André Chabanne), en 1975 (colonel Bernard Lelay ou Le Lay), en 1987 (Jacques Nancy), en 1989 (Yves Faure) et même en 1991 (Thérèse Bonnier).

C'est alors que le visiteur peut commencer à se poser des questions et reprendre sa visite afin de vérifier ce que, jusqu'ici, il avait vu ou cru voir. C'est ce qu'on appelle un travail de révision.

Revoyons précisément ce cimetière et revisitons-le.

Nous découvrirons alors que :

1° cet impressionnant cimetière est surtout peuplé de morts de la campagne de France et des suites de cette campagne ; sur 2.029 corps (certaines des 2.255 tombes ne sont pas occupées), 1.843 sont ceux de soldats de 1939-1940 tandis que 186 corps [1] sont ceux de résistants (cent cinquante-sept dans le cimetière même et vingt-neuf dans la crypte) ;

2° la grande majorité de ces soldats de 1939-1940 étaient des Nord-Africains, des Africains et des Indochinois ; un certain nombre sont morts dans des hôpitaux militaires de Libourne, de Nantes et d'autres villes de la côte atlantique ; dans la partie haute du cimetière, où ne se rendent guère les visiteurs, on aperçoit un carré de sépultures surmontées du croissant et non de la croix ;

3° le bloc de pierre dédié à la mémoire de vingt-cinq « résistants du maquis "Bir Hakeim" » et les tombes en contrebas ne concernent pas le maquis commandé par le héros local de Chasseneuil, le colonel A. Chabanne, un enfant du pays, ancien instituteur, mais un maquis de... Lozère. Ces vingt-cinq maquisards, comme l'indiquent les inscriptions tombales, sont morts à La Parade (dans les gorges du Tarn) ; ils sont venus faire nombre à Chasseneuil où ils n'ont franchement pas leur place, vu qu'ils n'appartenaient pas le moins du monde à la «résistance charentaise» ;

4° dans la crypte se trouvent, en plus de FFI morts au combat en 1944, quelques FFI ou FFL morts en 1944 ou en 1945 mais, les uns, dans un accident de camion en Charente et, les autres, dans un accident d'avion en Allemagne ; ne parlons pas de ceux qui sont morts bien après la guerre comme, par exemple, le colonel André Chabanne, tué dans un accident de voiture ;

5° dans certains cas, rarissimes il est vrai, on a porté la mention de FFI (Forces françaises de l'Intérieur) sur les tombes de personnes mortes en... 1940, alors que la création des FFI date du 1^er^ février 1944.

Bref, au terme de cette seconde visite, l'impression se forme que, dans ce cimetière où les morts auraient dû avoir le droit à un égal respect et à la même dose d'attention, on a magnifié les uns au détriment des autres et, par des moyens contestables, cherché à gonfler le nombre des morts de la Résistance.

Parmi ces moyens, ne faudrait-il pas surtout compter la disposition même des rangées de sépultures ? A droite et à gauche de l'allée centrale et des voies de pénétration importantes dans le cimetière, on a systématiquement commencé les rangées avec des tombes de Résistants ; le visiteur n'aperçoit ainsi que ces tombes-là et il ne lui viendra sans doute pas à l'esprit qu'après deux, trois ou quatre tombes de Résistants situées à proximité, tout le reste de la longue rangée ― de chaque longue rangée ― ne porte plus que les noms de Français ou de «coloniaux» mobilisés en 1939-1940 et morts pour la France.

La brochure intitulée Mémorial de Chasseneuil aurait besoin d'une sévère révision des faits et des chiffres rapportés. Elle est vendue au profit du Comité des œuvres du Mémorial de Chasseneuil, sis à la préfecture de la Charente à Angoulême. Ce comité a pour but «de perpétuer le souvenir des héros de la résistance et de veiller à l'exécution des travaux d'entretien et d'embellissement de cette Nécropole nationale». Comme cette «nécropole» comporte, sur 2.029 sépultures, 1.843 sépultures des morts de la campagne de 1939-1940 et de ses suites, on est en droit de s'étonner que pas une page, pas une ligne ne fasse mention de ces morts-là. D'emblée, on nous parle d'«une nécropole nationale qui regroupe 2.255 sépultures» et d'«un cimetière abritant les restes des héros de la résistance [2] ». Comment le lecteur n'en déduirait-il pas que le cimetière qu'il visite abrite les restes de 2.255 «héros de la résistance», alors qu'en réalité le vrai chiffre est de cent quatre-vingt-six? De quel droit multiplier ici par douze le nombre des morts de la résistance ? Un tableau intitulé «La Souffrance de la Charente pendant la seconde guerre mondiale, 1939-1945 » [3] mentionne que 1.097 « militaires 1939-1940 » sont morts pour la France et trois cent dix « résistants » ; cependant, il s'agit là d'un tableau général intéressant non pas la nécropole mais le département tout entier. Dans ce tableau, à peu près toutes les rubriques et tous les chiffres seraient à revoir. Une rubrique, par exemple, porte : «Victimes civiles (fusillés, victimes de bombardements). » Les jeunes générations ont peu de chance de voir que ces victimes civiles de bombardements sont, pour la plupart, à mettre au compte des Anglo-Américains plutôt que des Allemands [4] ; rappelons que les bombardements anglo-américains ont provoqué la mort de soixante mille Français et un nombre bien plus considérable de blessés et de mutilés et que, parmi les Français morts en Allemagne, un certain nombre ont été tués dans les effroyables bombardements des villes allemandes. On oublie trop que l'un des motifs qui retenaient les Français d'obéir aux injonctions du STO (Service du travail obligatoire en Allemagne) était précisément la crainte d'être pris dans les bombardements des usines d'outre-Rhin.

Les auteurs de la brochure ne pouvaient passer sous silence le fait que l'essentiel du « travail gigantesque réalisé avec des moyens archaïques » pour l'édification de cette nécropole et de son monument est dû aux travaux forcés auxquels ont été contraints des prisonniers allemands [5]. Peut-être aurait-on pu insister un peu plus sur le sort de ces prisonniers ; en est-il mort sur place ? Combien ? Où les a-t-on enterrés avant un éventuel rapatriement en Allemagne?

Au sujet de la crypte, on écrit un peu trop habilement qu'elle était conçue pour abriter les corps de « fusillés, déportés, combattants tués face à l'ennemi [6]». Peut-être était-elle conçue dans cet esprit mais le fait est qu'elle abrite bien d'autres corps que ceux-là, y compris les corps de gens morts dans leur lit plus de quarante ans après la guerre.

Les commentaires des sculptures cachent mal le désir de faire sa propre apologie [7]. Les sculpteurs ont notamment représenté trois personnes qui sont à l'origine de la création, très tardive, du maquis Bir Hakeim : les instituteurs André Chabanne, Hélène Nebout et Guy Pascaud. Ces trois personnes ont longuement survécu à la guerre. Elles ont donc pu se voir statufier. On insiste particulièrement sur la figure de Guy Pascaud, sénateur de la Charente. Avec son père Édouard Pascaud, maire de Chasseneuil, il avait fait don du terrain. Curieusement, on ne rappelle pas qu'il fut arrêté par les Allemands le 22 mars 1944 à Chasseneuil. Ce jour-là, une importante formation militaire allemande encercla le bourg, procéda à des arrestations et s'empara à Négret d'un fort groupe de maquisards mal armés, mal préparés au combat, mal encadrés et dont les responsables n'étaient pas présents sur place. Il y eut des morts et tous les prisonniers furent fusillés à Biard, près de Poitiers. Parmi leurs trois responsables, deux (André Chabanne et Hélène Nebout) resteront indemnes tandis que Guy Pascaud, arrêté à Chasseneuil, sera déporté ; revenu de déportation, il fera après la guerre une carrière politique, comme son père.

Le chapitre consacré à l'activité combattante des maquisards [8] cache mal l'extrême modestie de la participation des maquis locaux sur ce plan. Henri Noguères, ancien résistant, est l'auteur d'une Histoire de la résistance en France. Dans les dix volumes et les quatre mille cinq cent quarante pages de ce monumental ensemble, aucune mention n'est faite du maquis Bernard (Bernard Lelay) ; quant au maquis Chabanne (André Chabanne), il ne se voit accorder, pour son activité dans la région, que quelques modestes lignes [9].

La brochure passe complètement sous silence les exécutions sommaires perpétrées par le maquis Chabanne et le maquis Bernard : environ quarante dans un cas et environ quatre-vingts dans l'autre cas, et cela dans des conditions parfois atroces que les historiens spécialisés (Robert Aron, Henri Amouroux, Philippe Bourdrel...) ont rapportées [10]. Dans la région, la réputation du maquis Bernard est si fâcheuse que la famille de Bernard Lelay et le Parti communiste rencontrèrent bien des difficultés avant d'obtenir le transfert du corps dans la crypte.

Il faut espérer que le temps viendra où, comme à Verdun pour la première guerre mondiale, on rendra un égal hommage à tous les morts de la seconde guerre mondiale qui fut une abominable boucherie d'où personne n'est rentré les mains propres. On ne cachera plus rien, on dira tout. Oradour (six cent quarante-deux morts) et Dresde (cent trente-cinq mille morts ?) seront unies dans le jumelage des villes et des bourgades martyres [11]. On essaiera de comprendre tous les Français au lieu de les répartir en des catégories morales stéréotypées, avec un traitement de faveur pour certains, l'oubli pour d'autres et la condamnation à perpétuité pour les vaincus.

Le cimetière national de Chasseneuil est impeccablement entretenu. Les tombes du tirailleur sénégalais, de l'officier métropolitain et du maquisard sont l'objet des mêmes soins. Pourquoi le secrétariat d'État aux anciens combattants et les hautes autorités qui ont conçu ce cimetière ne prendraient-ils pas modèle sur les jardiniers qui, dans leur besogne quotidienne, traitent tous les morts avec les mêmes égards ?

Pour commencer, on modifierait de fond en comble la substance des brochures, guides et ouvrages proposés sur place à la vente et, dans le commentaire des visites, on accorderait plus de place à l'histoire de la France dans la seconde guerre mondiale et moins de place à la légende dorée de la résistance.

Les soldats de la Campagne de France méritent des égards. Il y avait certainement plus de risque à essayer de faire face, en 1940, aux divisions allemandes en pleine offensive et dotées de redoutables moyens, qu'à livrer en 1944 des escarmouches, comme ce fut le cas en Charente, contre une troupe en retraite ou à multiplier contre des Allemands isolés des actes de terrorisme [12].

Quant aux cent vingt hommes et femmes victimes des exécutions sommaires perpétrées en 1944 par les maquis Chabanne et Bernard, ils n'ont eu droit à aucune sépulture. Tous, sans exception, ont été enterrés comme des chiens. Certains corps n'ont toujours pas été exhumés pour être transférés dans un cimetière. Les emplacements des charniers sont connus. Les autorités municipales, préfectorales et judiciaires de la Charente le savent et ne font rien pour remédier à cette anomalie.

30 novembre 1991

------------------------------------------------------------------------

Notes

[1] Ce chiffre aurait été évidemment plus important si plus de familles avaient accepté le transfert des cendres des leurs dans la nécropole.

[2] Mémorial de Chasseneuil, Angoulême, Comité des œuvres du Mémorial de Chasseneuil, 1989, p. 3.

[3] Id., p. 26.

[4] A moins, bien sûr, que le chiffre indiqué ne corresponde qu'aux victimes de bombardements allemands et que le nombre des victimes de bombardements anglo-américains ait été tout simplement omis.

[5] Id., p. 5.

[6] Id., p. 4.

[7] Id., p. 7-10.

[8] Id., «La Résistance militaire», p. 18-25.

[9] H. Noguères, Histoire de la Résistance en France, Genève, Famot, 1981-1982, tome VIII, p. 119-120.

[10] Voy. également R. Faurisson, «Chronique sèche de l'Épuration» pour le décompte précis de ces exécutions sommaires, Ecrits révisionnistes (1974-1998), p. 1265-1285.

[11] Pour l'historien, le massacre d'Oradour garde bien des mystères. Pourquoi, au juste, les Allemands ont-ils fusillé la population mâle ? Ont-ils mis le feu à l'église (où ils avaient enfermé femmes et enfants) ou le feu s'est-il communiqué à l'église ? Ont-ils tiré sur les femmes et les enfants ? Les maquisards de la région avaient-ils choisi ce paisible village pour y entreposer, dans les maisons et jusque dans le clocher de l'église, des armes, des munitions et des explosifs de toutes provenances ? La chaleur dégagée dans le clocher a été si forte que la cloche a fondu (!) tandis que le confessionnal de bois a été retrouvé indemne. Pourquoi n'a-t-on pas demandé une expertise à des spécialistes de balistique, du feu et des explosifs ? Les procès de Nuremberg, de Bordeaux et de Berlin n'ont pas apporté de réponse claire. Les Français gardent secret le rapport d'enquête du juge d'instruction militaire allemand Detlef Okrent et les archives ne seront pas ouvertes avant 2044 : pourquoi ? Certaines «fictions» d'Oradour sont entretenues pour des motifs intéressés : «la Commission nationale [des déportés et internés politiques] a admis la fiction [sic] de l'encerclement de la localité par les troupes SS» ; ainsi « le titre d'Interné Politique à titre posthume » a-t-il pu être « reconnu à tous les massacrés d'Oradour-sur-Glane» (Secrétariat d'État aux anciens combattants, note pour M. Bergeras, conseiller technique, en date du 12 juillet 1971, avec PV joint d'une réunion de la Commission les 4 et 5 février 1963). Le bombardement de Dresde par les Alliés a moins de mystères.

[12] Voy. Marc Leproux, Nous les terroristes, Monte-Carlo, R. Solar, 1947.

Labels: "maquis Bernard", "maquis Bir Hakeim", "maquis Chabanne", Bernard Lelay, Guy Pascaud, Henri Amouroux, Henri Noguères, Mémorial de Chasseneuil, Robert Aron
