<!-- http://robertfaurisson.blogspot.com/1995/04/un-etonnant-numero-special-dhistoria.html -->

<!-- Wednesday, April 5, 1995 -->

Un étonnant numéro spécial d'"Historia" sur "les camps de la mort" (mars-avril 1995)

Le magazine Historama-Historia vient de consacrer son numéro spécial n° 34 à une série d'articles sur «Les camps de la mort». Dans l'amas habituel d'exagérations et d'inventions sur le sujet, on discerne quelques articles ou quelques éléments d'articles qui témoignent de l'avancée du révisionnisme historique dans l'esprit d'historiens et de journalistes pourtant attachés à la défense de la thèse du génocide des juifs et des chambres à gaz nazies.

La tragédie de Lübeck

Aux pages 10-11 figure un tableau intitulé «Les camps de travail et les camps de la mort dans le Grand Reich». A propos du camp de Neuengamme on note :

Particularité : des avions britanniques coulent, le 3 mai 1945, quatre navires chargés de déportés évacués [de Neuengamme], provoquant la mort de 7.300 déportés et 600 Allemands (c'est la tragédie de Lübeck) [1].

Passons sur les détails et relevons ici un tragique fait de guerre, parmi bien d'autres, où ce sont les Alliés et non les Allemands qui sont justement rendus responsables de la mort de milliers de déportés.

Les Tziganes : des chiffres revus et corrigés

Aux pages 14-17, Denis Peschanski, chercheur au Centre national de la recherche scientifique, attaché à l'Institut d'histoire du temps présent, résume en un article son dernier ouvrage : Les Tsiganes en France 1939-1946. Il écrit :

Jusqu'à ce jour l'historiographie la plus sérieuse retenait, pour la France, les chiffres suivants : 30.000 Tsiganes internés dans les camps, un peu plus de 20.000 déportés et 18.000 morts. Or, on a pu déterminer aujourd'hui que 3.000 Tsiganes seulement (ce qui est déjà considérable) ont connu les camps français entre 1940 et 1946. A l'échelle de l'Europe, le chiffre de 500.000 déportés avancé par certains historiens semble, là encore, très au-dessus de la réalité. ― Il y a indéniablement crime contre l'humanité puisque perpétré contre des gens non pour ce qu'ils ont fait mais parce qu'ils sont nés. Mais il n'y a pas eu d'entreprise exterminatrice à l'échelle européenne, comme ce fut le cas pour les Juifs [2].

La formule «non pour ce qu'ils ont fait mais parce qu'ils sont nés» relève de l'effet de style ; elle pourrait s'appliquer pour toutes les guerres et pour toutes les victimes d'actes de guerre. Les enfants des cités allemandes brûlées au phosphore mouraient, eux aussi, à ce compte, «parce qu'ils étaient nés». Ni pour les juifs, ni pour les Tsiganes, ni pour quelque autre groupe que ce fût, il n'y a eu d'ordre, de plan ou de politique d'extermination physique. Pour ne s'en tenir qu'au groupe ici considéré, celui des Tsiganes, rappelons que, durant la guerre, certaines troupes de Tsiganes ont bénéficié d'une relative liberté de mouvement tandis que d'autres ont été, pour des raisons de sécurité notamment, internées dans des camps administratifs ou de concentration. Contentons-nous, pour l'heure, de retenir que «l'historiographie la plus sérieuse» avait multiplié par dix le nombre réel des Tziganes internés en France. Pour ce qui est du nombre des morts, «l'historiographie la plus sérieuse» avançait le chiffre de dix-huit mille. D. Peschanski, lui, n'avance aucun chiffre de morts dans son article, de crainte, sans doute, qu'on se rende compte que, sur ce chapitre, « l'historiographie la plus sérieuse » a multiplié le chiffre réel par bien plus de dix.

Révision de Höss et de l'importance

des chambres à gaz d'Auschwitz

Aux pages 25-33, Michaël Marrus, professeur d'histoire à l'université de Toronto (Canada), traite du « Rôle d'Auschwitz dans la solution finale ». M. Marrus, qui est juif et qui a tenu sur les révisionnistes les propos les plus insultants, avait publié en français, avec l'Américain Robert Paxton, Vichy et les Juifs. Les tenants de la thèse du génocide des juifs ont fait grand cas, pendant près de cinquante ans, de l'aveu de Rudolf Höss, l'un des trois commandants successifs du camp d'Auschwitz. Pour ces historiens, il fallait croire R. Höss quand, dans ses aveux aux vainqueurs, il prétendait avoir été informé au milieu de l'année 1941, à Berlin, par Himmler, de ce qu'Auschwitz allait devenir un camp d'extermination et allait ainsi inaugurer une politique d'extermination physique des juifs.

Au début des années quatre-vingt, les historiens officiels ont commencé à mettre en doute cet aveu, si commode pour leur thèse, de R. Höss. Mais à quelle date fallait-il faire commencer cette politique d'extermination physique ? Là, faute de preuves, on s'est livré à des supputations, toutes plus arbitraires les unes que les autres. M. Marrus, pour sa part, semble se rallier à la thèse de Jean-Claude Pressac pour lequel cette politique n'a pas pu commencer en juin 1941 mais durant l'été 1942. Il écrit :

[...] Jean-Claude Pressac pense que Höss s'est trompé de toute une année et que la réunion [avec Himmler, à Berlin] n'eut lieu en réalité qu'au mois de juin de l'année suivante [soit, juin 1942]. Rien ne semble indiquer qu'on se soit préparé à assassiner les Juifs sur une vaste échelle au cours de l'été et de l'automne 1941, ni même de l'hiver 1941-42 [3].

M. Marrus balaie, en une phrase lourde de sens, toutes les élucubrations, même les plus récentes, sur le nombre des prétendus gazés d'Auschwitz. Il écrit :

Personne ne sait avec précision combien de déportés furent assassinés ni par quels moyens [4].

Puis, ce qu'il dit des prétendues chambres à gaz homicides devient particulièrement significatif du désarroi des exterminationnistes. Pour M. Marrus, il ne faudrait plus mettre l'accent sur ces chambres à gaz et sur leurs prouesses. Dans son désir manifeste de passer discrètement sur le sujet des chambres à gaz, il en vient à écrire que, pour ce qui est d'exterminer, la science américaine a dépassé, et de loin, la science allemande ! Mentionnant le «projet Manhattan», c'est-à-dire le projet américain de fabrication des bombes atomiques sous la responsabilité, en particulier, de R. Oppenheimer, un juif américain, il en vient à écrire :

Le caractère «remarquable» d'Auschwitz, a-t-on dit parfois, réside dans l'application sans précédent de technologies de pointe et de méthodes scientifiques ultramodernes au meurtre d'êtres humains et à l'élimination de leurs cadavres [...]. Il ne faudrait pourtant pas exagérer [le] niveau d'efficacité technique ou scientifique [des chambres à gaz nazies]. Auschwitz n'était pas l'équivalent allemand du projet Manhattan [...]. La machine de destruction construite par Topf et les autres entrepreneurs SS n'avait rien d'une merveille scientifique. Le personnel de Topf et ses employeurs SS se servirent sans nul doute de leur savoir pour résoudre leurs problèmes d'assassins, mais leur travail fait penser bien plus à un atelier d'artisan qu'à un vrai laboratoire scientifique. L'histoire d'Auschwitz montre que, quelle que soit la manière dont leur vint l'idée d'assassiner les Juifs d'Europe, les nazis consacrèrent peu de temps à la manière dont ils viendraient à bout de leur tâche [5].

M. Marrus conclut :

Ce que nous pouvons dire avec certitude, c'est qu'ils voulaient la mort des Juifs et qu'ils la voulurent plus que jamais lorsque les perspectives du Reich s'assombrirent en 1943 et 1944 [6].

Toutefois, pas un instant M. Marrus ne nous dit sur quoi il fonde cette «certitude» qui ressemble plus à une persuasion du cœur qu'à une conviction de l'esprit.

Révision des chiffres de la déportation en France

Aux pages 54-59, Olivier Lalieu, qui participe au séminaire d'histoire de la Shoah à l'université de Paris-I et qui est l'auteur de La Déportation fragmentée (La Boutique de l'Histoire, 1994), signe un article intitulé «Survivre au quotidien». Il révise à la baisse, de façon sensible, les chiffres jusqu'ici généralement admis, d'abord pour le nombre des déportés de France, raciaux ou non raciaux, puis, parmi ceux-ci, pour le nombre des morts. Il écrit :

En France, entre 1940 et 1944, 63.085 personnes sont déportées par les nazis au titre de droit commun, de résistants et d'otages. 59 % d'entre elles reviennent [en France]. En revanche, sur les 75.721 juifs acheminés vers les camps d'extermination, seuls 2.000 retrouvent le sol national en 1945, soit 3 % [7].

Ce qui revient à dire qu'au bout de cinquante ans d'exagérations et de dissimulations on avance aujourd'hui, de source officielle, que près de cent quarante mille personnes ont été déportées de France (y compris les criminels de droit commun) et que près de quarante mille ont survécu. Mais le chiffre dessurvivants juifs est entièrement à revoir. Sans le préciser ici, O. Lalieu ne fait que reprendre les affirmations de Serge Klarsfeld. Ce dernier, qui évalue le nombre des survivants à deux mille cinq cents, et non à deux mille, dans son Mémorial de la déportation des juifs de France [8], a ajouté des survivants dans les Additifs de son mémorial et, surtout, il a dû admettre qu'il n'avait essentiellement comptabilisé comme survivants que les juifs qui étaient revenus en France et qui avaient pris la peine, sans qu'on le leur demande officiellement, de venir se déclarer vivants au ministère des Anciens combattants, et cela avant le 1er janvier 1946 [9] ! Rappelons que la grande majorité des juifs déportés de France étaient étrangers ou apatrides et qu'on voit mal pourquoi beaucoup d'entre eux auraient voulu, après la guerre, revenir dans notre pays au lieu de rester dans le pays dont ils étaient originaires ou de s'expatrier vers la Palestine, les États-Unis ou d'autres pays. Je répète ici ce que j'ai si souvent dit : « Le vrai chiffre des survivants juifs de la déportation peut, avec les moyens modernes de l'informatique, être déterminé à l'aide des innombrables documents détenus, en Allemagne mais sous la responsabilité du Comité international de la Croix-Rouge (CICR), par le Service international de recherches de Bad Arolsen (SIR). Mais ce service a dissous en 1978 sa "Section historique" et refuse tout accès aux chercheurs indépendants ».

La tenue rayée des déportés

Détail qui a son importance pour l'image qu'on se fait en général du déporté, Historia écrit au sujet du plus sévère de tous les camps, celui de Mauthausen :

La tenue rayée est réservée à ceux qui travaillent hors du camp. Les autres détenus portent des vêtements civils [10].

D'ailleurs, cette tenue rayée ressemblait à s'y méprendre à la tenue rayée de certains bagnes américains d'avant-guerre, notamment dans l'Alabama.

La raison des horreurs de Bergen-Belsen

Le même O. Lalieu reconnaît que les visions horribles de Bergen-Belsen sont dues aux ravages exercés par le typhus. Il écrit :

A Bergen-Belsen, l'épidémie de typhus prend [à la fin de la guerre] une tournure dramatique. Sur les 1.200 survivants français à l'arrivée des Anglais le 14 avril 1945, les deux tiers vont mourir avant leur rapatriement [11].

Une résistance mythique

Aux pages 66-71, Jean-Michel Chaumont, auteur d'un livre Autour d'Auschwitz, écrit, dans un article intitulé «Soulèvements, révoltes et résistance » :

Presque tout ce qui a été écrit sur la résistance dans les camps de concentration relève davantage de l'apologie que de l'histoire stricto sensu [12].

Regarder la vérité en face

J.-M. Chaumont conclut sur le sujet :

Après cinquante ans, il faut se résoudre à regarder la vérité en face [13].

Que dirait aujourd'hui François Mauriac de la propagande de guerre et de haine, lui qui, ainsi que le rapporte Gérard Chauvy [14], estimait, dès le 1er juin 1945, que l'horrible réalité de tous ces cadavresainsi que de toutes ces villes détruites imposait qu'on se passe désormais de propagande? Il écrivait, en effet :

Commençons par cela : efforçons-nous désormais de penser, parler, de regarder sans souci de propagande. La propagande, voilà l'ennemie. Devant ces images dont elle cherche à créer en nous l'obsession, pénétrons-nous de cette vérité que l'espèce humaine vient de subir le plus grand de ses désastres, que les villes anéanties ne sont que l'apparence d'une immense ruine invisible [souligné par moi]

Révision d'Auschwitz par Pressac

Aux pages 114-125, J-C. Pressac, pharmacien d'officine dans la région parisienne, propose une «Enquête sur les camps de la mort». Jusqu'à la troisième colonne de la page 119, il se contente de rappeler la thèse qu'il a développée dans son ouvrage Les Crématoires d'Auschwitz. J'ai commenté cet ouvrage, dépourvu de toute valeur scientifique, dans ma Réponse à Jean-Claude Pressac sur le problème des chambres à gaz. Je ne reviendrai pas ici sur les multiples concessions faites par J.-C. Pressac aux conclusions des révisionnistes. En bref, pour Pressac, les Allemands n'ont nullement conçu de vastes abattoirs chimiques mais seulement des crématoires classiques et normaux ; puis, à une date indéterminée, sans ordre ni instruction et selon une procédure dont on ignore tout, ils auraient bricolé ces crématoires de manière à transformer des chambres froides pour la conservation des cadavres en chambres à gaz homicides ! Pressac ne fournit pas la moindre représentation physique du résultat de ces bricolages ; il ne montre aucune photographie, aucune maquette, aucun dessin qui nous permettrait de voir à quoi ces extraordinaires abattoirs chimiques auraient pu ressembler et quels auraient pu être leur technique et leur fonctionnement [15]. Il ne nous explique pas non plus comment les Allemands pouvaient entreposer, puis incinérer les cadavres de tous ceux, internés ou gardiens, qui mouraient de maladie ou d'épidémie, puisque, aussi bien, les crématoires auraient été transformés en «usines de mort». L'originalité de la thèse aberrante de Pressac est là : en fin de compte, il n'y avait pas à Auschwitz-Birkenau de crématoires !

A partir de la fin de la page 119 et jusqu'à la fin de son article, Pressac va étendre son analyse, toujours selon le même système, à Belzec, Treblinka, Sobibor, Majdanek et Dachau. Il régale alors son lecteur de considérations tellement iconoclastes que les tenants de la thèse officielle sur l'extermination des juifs ne peuvent qu'en frémir. Il accumule de graves accusations contre «l'historiographie la plus sérieuse».

Révision de Belzec, Treblinka, Sobibor par Pressac

Pour Belzec, Treblinka et Sobibor, il rejette la version, jusqu'ici dotée du statut de vérité intangible, selon laquelle ces camps avaient été conçus et avaient fonctionné comme des «camps d'extermination» (expression forgée par les Alliés), dotés de chambres à gaz homicides. Pour lui, dans les témoignages sur ce point ― en l'absence de tout document prouvant des gazages homicides ― il y a des éléments «incompréhensibles», des «bizarreries» (pour Treblinka encore plus que pour Belzec) et des «contradictions». L'hypothèse ― car, à ses yeux, on en est maintenant réduit à une hypothèse ― est que ces camps étaient dotés de chambres à gaz d'épouillage comme pouvaient l'être des camps de transit ; les Allemands auraient ensuite bricolé ces chambres d'épouillage pour en faire des chambres à gaz homicides ! Pressac en profite pour glisser que ces abattoirs fonctionnaient au «monoxyde de carbone» fourni par un « moteur à essence». Sans doute s'est-il rendu compte que les révisionnistes ne pouvaient qu'avoir raison quand ils montraient que la version jusqu'ici retenue du gazage avec un «moteur Diesel» constituait une absurdité. Il conclut sur ce point :

Si l'existence des stations d'épouillage est reconnue, ainsi que leur aménagement en installations homicides, et que le passage des Juifs par les camps de la mort, après avoir été sélectionnés aptes au travail, est plus amplement établi, l'histoire actuelle de ces [trois] camps devra être profondément remaniée [16].

Révision de Majdanek par Pressac

Sur Majdanek, l'article de Pressac est dévastateur. Certes, on y lit :

Ainsi à Majdanek, seules deux pièces du bloc d'épouillage ont servi à tuer des personnes ― juives en majorité ― avec du monoxyde de carbone durant quelques mois de l'été 1943. Le Zyklon B était réservé à l'épouillage des habits des détenus et son usage homicide est ici à exclure [17].

Mais cette affirmation, qui n'est étayée d'aucune preuve, a toute l'apparence d'une concession minimale à la thèse des gazages, concession qui permet à Pressac de dénoncer absurdités, confusion, erreurs graves et fausseté dans l'histoire officielle des gazages de Majdanek (chiffres des victimes compris). Dans ce camp, selon lui, on n'aurait, en fait, gazé qu'un nombre indéterminé de personnes durant une brève période, non délimitée, de l'été 1943.

Nous voilà déjà loin de la thèse officielle selon laquelle les Allemands auraient gazé des centaines de milliers de personnes au cours de plusieurs années.

Mensonges soviétiques, dit Pressac

Pressac met en accusation les Soviétiques qui libérèrent le camp dès le 24 juillet 1944 et le trouvèrent intact. «L'histoire de ce camp», dit-il, «fut moulée dans un cadre "antifasciste"». Les Soviétiques présentèrent un projet allemand de chambres d'épouillage comme un projet de chambres à gaz homicides [18].

Mensonges du musée de l'Holocauste, dit Pressac

Mais Pressac va beaucoup plus loin et il dénonce le musée de l'Holocauste à Washington. En particulier, il taille des croupières à l'auteur du livre-guide de ce musée, The World Must Know, qui n'est autre que Michael Berenbaum, directeur scientifique du musée. A propos de la «confusion» commise par les Soviétiques en 1944 entre chambres à gaz d'épouillage et chambres à gaz homicides, il écrit :

Cette confusion, compréhensible au moment de la libération, mais que le régime soviétique a laissé perdurer jusqu'à nos jours pour raisons politiques, conduit à de graves erreurs sur les chambres à gaz de Majdanek et qui sont actuellement diffusées massivement aux États-Unis dans, par exemple, le catalogue The World Must Know (Le monde doit savoir) du musée de l'Holocauste à Washington. Ironiquement, les historiens américains ont accepté en 1990, par manque de contrôle historique, des données communistes pipées alors qu'en 1945 l'armée américaine, ayant commis la même erreur initiale à Dachau en présentant cinq cellules d'épouillage au Zyklon B comme homicides, avait, après expertise, abandonné cette accusation infondée [19].

Mensonges des musées d'Auschwitz et de Majdanek, dit Pressac

Pressac dénonce enfin les autorités du musée d'Auschwitz et du musée de Majdanek, toutes deux responsables d'un «blocage historique entraîné par l'axiome selon lequel les chambres à gaz furent directement projetées dans un but homicide». En son patois, Pressac veut dire que ces autorités posent en principe et sans aucune preuve que les Allemands ont voulu créer des chambres à gaz homicides en tant que telles, alors qu'en réalité, selon lui, mieux vaudrait prendre en considération l'hypothèse selon laquelle les Allemands n'avaient pas l'intention de gazer les juifs mais, se décidant à le faire, ont dû bricoler des chambres froides ou des chambres d'épouillage pour en faire des chambres à gaz homicides !

Mensonges des Américains sur Dachau, dit Pressac

Sur Dachau, Pressac dénonce les «conclusions hâtives» des Américains. Ceux-ci commencèrent par prendre des chambres à gaz d'épouillage pour des chambres à gaz homicides. Puis, ils appelèrent « chambre à gaz » homicide un local qui, en fait, dans des plans retrouvés, était une «morgue» (chambre froide). Alors, les juges américains firent tout simplement disparaître ces plans de leur dossier. Pressac fait remarquer qu'ils auraient pu utiliser la commode théorie du «codage» selon laquelle, quand les Allemands voulaient cacher une réalité gênante, ils lui donnaient un nom de code ; mais, dit-il, cette théorie, qu'il dénonce, n'apparut qu'ultérieurement. Il écrit en propres termes :

Les Américains, ayant saisi intacts les dossiers de la direction des constructions SS du camp, retrouvèrent celui du crématoire. Malheureusement, sur les plans du bâtiment, le «Brausebad» [douche], avec ses fausses douches, était désigné sous le nom de morgue. Très gênés par ce fâcheux détail et ne pouvant s'appuyer sur la théorie du «codage» des mots qui apparaîtra ultérieurement, les juges américains épurèrent le dossier afin que toute trace de la fonction initiale de la pièce disparaisse [20].

Pressac pense apporter «une réponse probablement définitive» sur la «chambre à gaz» de Dachau mais, dit-il, il faudrait se méfier de «la présentation mémorielle de l'histoire du camp» et il conviendrait que les Américains daignent «communiquer au musée de Dachau les archives de la direction des constructions SS saisies en 1945 et que personne n'a exploitées». L'histoire, dit-il, est «en cours [21]».

On aura noté que, pour Pressac, les juges américains «épurèrent le dossier». Le phénomène n'aurait rien de surprenant. Le Tribunal militaire international de Nuremberg donnait alors l'exemple de ce procédé avec l'autorisation qu'il s'était généreusement accordée de « rayer du procès-verbal des débats » tout ce qui pouvait lui déplaire [22].

Conclusion

On se demande si ce n'est pas pour contrebalancer tant d'observations de nature proprement révisionniste que le magazine Historia s'achève sur un article violemment antirévisionniste, signé de Charles Le Mesnil, sous le titre : « Le révisionnisme a osé la négation des chambres à gaz » et dont voici la conclusion :

Pour conclure, le révisionnisme, qui aurait pu avoir un sens noble et constructif en précisant l'histoire du génocide afin de valoriser les témoignages des déportés, fut perverti par Faurisson. Par son refus d'accorder la moindre valeur aux récits des participants, victimes et bourreaux, il s'est voué à une exécration générale et méritée. Il est à condamner sans recours pour toutes les existences que son idée fixe a insultées, brisées, fait mourir ou fait basculer dans la déchéance [23].

S'il est des personnes habitées d'une idée fixe, ce sont celles qui, depuis un demi-siècle, ressassent, sur le mode de l'obsession, l'histoire de l'«Holocauste» et de la «Shoah» pour réclamer vengeance contre l'univers entier et pour en exiger des compensations financières ou politiques. Les révisionnistes nourrissent, eux, une idée fixe des plus normales : ils veulent un débat public. Ce débat, ils le recherchent d'autant plus que, depuis une quinzaine d'années, et ainsi que le confirme ce numéro spécial d'Historia, les tenants de « l'historiographie la plus sérieuse » se rapprochent de plus en plus de l'historiographie révisionniste. On compte cent exemples d'ouvrages orthodoxes qui vont dans le sens des découvertes révisionnistes ; en revanche, il ne s'en est pas trouvé un seul pour aller dans le sens contraire de ces découvertes. Pour les chiffres, il n'y a eu de réévaluations qu'à la baisse et, pour les faits, il n'y a eu de révisions que dans le sens indiqué par les révisionnistes.

5 avril 1995

Notes

[1] Historama-Historia, p. 10.

[2] Id., p. 17.

[3] Id., p. 29.

[4] Id., p. 33.

[5] Ibid.

[6] Ibid.

[7] Id., p. 54.

[8] S. Klarsfeld, Mémorial de la déportation des juifs de France, Paris, éd. Beate et Serge Klarsfeld, 1978, p. 10.

[9] Id., p. 10.

[10] Id., p. 56.

[11] Id., p. 58.

[12] Id., p. 66.

[13] Id., p. 71.

[14] Id., p. 90.

[15] Il est remarquable qu'ayant à fournir des illustrations Pressac ait proposé deux dessins, grotesques, de David Olère : l'un représente le « vestiaire » de la chambre à gaz et l'autre la salle des fours crématoires ; il n'y a, en revanche, aucun dessin de la chambre à gaz (p. 120).

[16] Id., p. 122 ; souligné par moi.

[17] Id., p. 123.

[18] Pressac omet de préciser que Léon Poliakov allait reprendre à son compte l'accusation des Soviétiques dans Das Dritte Reich und die Juden, Berlin, Arami, 1955, p. 137.

[19] Id., p. 122.

[20] Id., p. 124.

[21] Id., p. 125.

[22] Voy., par exemple, in R. H. Countess, «Le Sergent John Woods, bourreau de Nuremberg », Revue d'Histoire révisionniste, n° 3 novembre 1990, p. 59-64.

[23] Id., p. 137.

Labels: "Historama-Historia", Charles Le Mesnil, Holocaust Memorial Museum, Klarsfeld, Majdanek, Michael Berenbaum, Michaël Marrus, Musée d'Auschwitz, Pressac, Rudolf Höss, Zyklon B
