<!-- http://robertfaurisson.blogspot.com:80/1980/10/sur-la-pretendue-chambre-gaz-homicide.html -->

<!-- Wednesday, October 15, 1980 -->

Sur la prétendue « chambre à gaz » homicide du Struthof, les trois confessions successives et contradictoires de Josef Kramer

Josef Kramer arriva au camp de concentration du Struthof-Natzweiler en avril 1941. Il y fut d'abord l'adjoint de Hüttig, puis de Zill. En octobre 1942, il fut nommé commandant du camp. En avril 1944, il quitta le Struthof-Natzweiler pour Auschwitz. En décembre 1944, il fut nommé à Bergen-Belsen. C'est dans ce camp ravagé par le typhus qu'il fut arrêté par les Britanniques.
A deux reprises des juges militaires français interrogèrent Josef Kramer en Allemagne sur son activité passée au Struthof-Natzweiler.

Dans les archives de la Justice militaire française, on découvre trois documents qui sont censés nous rapporter ce que Josef Kramer a dit sur la « chambre à gaz » du Struthof.
Ces trois documents se présentent comme suit :

1. Document 1806-Y-14. Il s'agit d'une courte déclaration entièrement dactylographiée en français, sans signature sinon « Josef Kramer » écrit à la machine ! Cette déclaration est datée de « Celle, le 26 juillet 1945 ». Elle est adressée « au lieutenant français Paul Heiker ». Peut-être s'agit-il là du lieutenant Hecker (notez la différence d'orthographe) dont il sera question dans le document du 6 décembre 1945 (voyez ci-dessous). Dans la courte déclaration le nom de Natzweiler est à deux reprises écrit Nutzweiler.

2. Document 107 (voyez également document 1806/V/2). Il s'agit du procès-verbal d'interrogatoire mené par le juge d'instruction militaire commandant Jadin. Le texte est manuscrit ; il a été rédigé en français par le greffier et il porte entre autres signatures celle de Josef Kramer ; ce dernier n'a donc pas signé un texte rédigé dans sa propre langue, mais un texte rédigé en français et dont le greffier-interprète (?) nous garantit qu'il a donné à Kramer une interprétation en allemand. Ce procès-verbal est, comme la courte déclaration susmentionnée de « Celle, le 26 juillet 1945 ». Le texte en est assez négligé.

3. Documents 157 (texte allemand) et 158 (traduction en français) (voyez également pour 158 la curieuse reproduction qui en a été donnée dans le document 1806/V/2bis). Il s'agit du procès-verbal d'interrogatoire mené par le capitaine Paul André, officier de liaison auprès du « HQ British Army of the Rhine » agissant en vertu d'une commission rogatoire du commandant Jadin. Les deux textes ont été dactylographiés par le greffier ; le texte allemand est entaché de très nombreuses fautes et le texte français contient, en plus d'une grave erreur de traduction, de nombreuses fautes d'orthographe. Kramer a signé les deux documents. Tous deux datent de Lüneburg (en français Lunebourg) le 6 décembre 1945. Il est intéressant de comparer ainsi à quatre mois et demi de distance les « confessions » de Kramer.

A quatre mois et demi de distance, ces « confessions » divergent gravement. On s'étonne de ce que la Justice militaire ne se soit apparemment pas souciée de ces divergences. On s'étonne aussi de ce que les historiens parlent de « la confession » de Kramer comme s'il n'existait qu'une « confession ».

Une chambre à gaz homicide est un instrument qui est obligatoirement très difficile à concevoir, à construire et à faire fonctionner. Rien n'est dangereux comme de tuer un homme par le moyen d'un gaz. Il a fallu de nombreuses années aux Américains pour mettre au point leurs chambres à gaz destinées à l'exécution d'un seul condamné à la fois. Aussi voit-on mal comment Josef Kramer a pu, en l'espace de quelques jours du mois d'août 1943, concevoir et réaliser une « chambre à gaz » homicide pour l'exécution de groupes d'une quinzaine de personnes. Cet ancien libraire avait-il le génie de la chimie et de toutes sortes de technologies industrielles ? Dans une chambre à gaz américaine tout est conçu pour que le gaz cyanhydrique provoque la mort du condamné dans les délais les plus rapides. Il ne faut que quarante secondes après l'émission du gaz pour que le condamné s'endorme irrémédiablement, mais la mort, elle, ne vient qu'au bout de quelques minutes (environ une dizaine de minutes). Josef Kramer, lui, tuait ses victimes en trente secondes environ ! On se demande de quel produit magique il se servait.

Selon chacune des deux principales versions contradictoires de ses « confessions », il aurait reçu, un jour d'août 1943, soit un ordre écrit accompagné d'une lettre, soit simplement un ordre écrit. Aucune référence, sinon très vague, ne nous est fournie sur cet ordre ou cette lettre. D'après la première version, il ne s'agissait pas d'un ordre d'exécution mais seulement d'un ordre de recevoir environ quatre-vingts internés venant d'Auschwitz et la lettre lui demandait seulement de se mettre en relation avec le professeur Hirt, de Strasbourg. D'après l'autre version, un seul et même ordre écrit lui faisait obligation d'exécuter des internés envoyés d'Auschwitz et de se mettre en rapport avec le professeur Hirt pour le mode d'exécution. Selon la première version, Kramer est allé voir Hirt qui lui a dit qu'« il avait eu connaissance d'un convoi d'internés d'Auschwitz pour le Struthof » ; et Hirt « précisa que ces personnes devaient être exécutées dans la chambre à gaz du Struthof à l'aide de gaz asphyxiants ». Selon l'autre version, Kramer « fait part » à Hirt des ordres d'exécution qu'il a reçus et le professeur lui « donna le conseil [sic] d'exécuter les gens par le gaz » ; Kramer lui répondit alors que « dans le camp, il n'y avait ni une chambre à gaz, ni gaz » ; qu'importe sans doute puisque Kramer avait à sa disposition un entrepreneur de bâtiments qui lui avait été envoyé d'Oranienburg (Centrale des camps de concentration allemands) ; il faisait « alors construire la chambre à gaz par des internés ». Quand on sait que le moindre plan de construction en temps de guerre était l'objet d'une foule d'études et d'autorisations officielles, on se dit que la construction d'un engin aussi extraordinaire qu'une chambre à gaz homicide aurait dû laisser de nombreuses traces écrites ; nous possédons bien, par exemple, sous la cote NI-7961 (cotes des tribunaux alliés), une lettre du 3 septembre 1943 adressée à la Direction des constructions du camp de Natzweiler-Struthof par la firme allemande spécialisée dans la construction de chambres à gaz pour épouillage ; soit dit en passant, le contenu de cette lettre prouve très clairement qu'à cette date du 3 septembre 1943, c'est-à-dire postérieurement aux prétendues exécutions de Kramer, les autorités du camp en étaient encore à envisager la création d'une chambre à gaz pour épouillage ; elles s'y prenaient d'ailleurs si maladroitement dans le plan de leur projet qu'il faut voir comme elles se font rabrouer pour leur incompétence.

D'après la première version des aveux de Kramer, Hirt remit à ce dernier, « à la suite » de leur conversation, « un flacon de la contenance d'un quart de litre environ contenant des sels que je crois être cyanhydriques ». D'après l'autre version, « Hirt me donna alors une bouteille de verre fermée avec de la cire. Dedans il y avait un produit se constituant de petits corps blancs, semblables à de la soude ». D'après la première version, Hirt ne semble pas à première vue avoir dit à Kramer qu'il fallait ajouter de l'eau à ces sels pour en obtenir le dégagement immédiat d'un gaz létal, mais, étant donné que dans la suite du récit Kramer dit qu'il a procédé de cette manière, on peut supposer que c'est le professeur Hirt qui lui a indiqué ce curieux processus ; obtenir ainsi un gaz mortel à partir d'un mélange de sel et d'eau constitue une prouesse chimique. D'après l'autre version, il est dit en toutes lettres que Hirt déclara qu'en ajoutant de l'eau à ces sels Kramer obtiendrait un gaz toxique !

Selon les versions, la dose est « approximative » ou « exacte ». Toutefois, aucune des deux versions ne nous précise combien il fallait de sel pour chaque opération. Kramer, en effet, a dû se voir obligé d'ouvrir et de fermer à plusieurs reprises son « flacon » ou sa « bouteille de verre fermée avec de la cire » car, selon une version, il a tué d'abord « une quinzaine de femmes », puis, « quelques jours après », « une certaine quantité de femmes », « puis encore, quelques jours après, [...], en deux ou trois fois une cinquantaine d'hommes environ, peut-être cinquante-cinq », tandis que, selon l'autre version, il a d'abord tué vingt-six femmes (et non une quinzaine), puis, « à quelque temps de là », un transport d'hommes au nombre indéterminé, puis « deux ou trois semaines après, un transport de trente hommes ». En réalité d'ailleurs, si l'on tient compte non seulement de ces deux versions principales mais aussi du texte de l'« erratum » de la seconde version ainsi que de la « déclaration » au lieutenant Paul Heiker, on aboutit à un ensemble de données inextricables en ce qui concerne aussi bien le nombre des transports à exterminer que le nombre et la cadence et la date de chaque séance d'extermination. Pour ne prendre que l'exemple des dates, c'est en juillet que Kramer aurait perpétré ses crimes selon la version de la courte « déclaration » ; selon le premier procès-verbal, c'est apparemment en août, et, selon le second procès-verbal, il semblerait que ces exécutions se soient étendues sur une assez longue période de temps qui a pu s'étendre jusqu'au mois de septembre. Je rappelle ici que pour l'accusation on devait, en fin de compte, jeter son dévolu sur la version suivante (Doc. 1806-vps) : « Kramer a exécuté par le gaz quatre-vingt-sept Juifs et Juives les 11, 13, 17 et 19 août 1943. » On se demande bien comment une pareille affirmation peut s'accommoder, ainsi qu'on tend à nous le faire croire, avec « l'aveu » (sic) ou « la confession » (sic) de Josef Kramer.

Les divergences les plus graves apparaissent au moment où Kramer est censé nous relater comment il a tué ses victimes.
Selon la première version, il commence par enfermer les femmes dans la « chambre à gaz » ; il ferme la porte et, de l'extérieur, il verse à travers la paroi dans un entonnoir ses mystérieux sels et de l'eau ; sels et eau semblent se mélanger dans l'entonnoir sans provoquer de dégagement gazeux sous le nez de Kramer qui ne paraît pas porter de masque à gaz ; c'est seulement quand ces sels et cette eau parviennent dans une excavation située à l'intérieur de la « chambre à gaz » que le gaz se dégage et qu'il tue en une demi-minute la quinzaine de victimes. Selon la seconde version, Kramer entre le premier dans la « chambre à gaz » ; il dépose dans l'excavation (« le trou aménagé dans le plancher ») « une poignée de produit » ; puis il sort de la pièce et il y fait entrer les femmes (elles sont vingt-six et non pas une quinzaine) ; de dehors il verse de l'eau dans l'entonnoir ; et cette eau coule « par un tuyau muni d'une fermeture dans le trou où se trouvaient les petits grains ». Après une demi-minute les cris cessent dans la « chambre à gaz ».

Selon la première version, Kramer est censé avoir observé cette mise à mort. Selon la seconde version, il ne l'a pas observée ; il était seulement aux écoutes ! On lit en effet dans la première version :

J'allumai l'intérieur de la chambre à l'aide du commutateur placé près de l'entonnoir et j'observai par le regard extérieur ce qui se passait à l'intérieur de la chambre. ― Je constatai que ces femmes ont continué à respirer environ une demi-minute puis elles tombèrent à terre. Lorsque j'ouvris la porte après avoir fait en même temps marcher la ventilation, [etc.].
Dans la seconde version on lit en revanche :
Je déclare que je n'ai pas, par la fenêtre, observé la mort. J'étais seulement aux écoutes. Comme il n'y avait plus rien à entendre et que plus rien ne se mouvait, j'ai mis le ventilateur en marche. Pendant ce temps, je me trouvais à l'extérieur et je n'ai ni respiré, ni senti le gaz. Après un quart d'heure, j'ai ouvert la porte.

On a présenté à Kramer des photographies de la « chambre à gaz » qu'il prétendait avoir fait construire et avoir utilisée. Ces photographies sont celles de l'album du commandant Jadin. Kramer a manifestement été incapable d'expliquer la structure, l'agencement et l'emploi du local. Dans la première version il déclare : « J'ignore à quoi était destiné le tuyau de fer situé dans la porte d'entrée de la chambre à gaz. » Quant au gaz, Kramer dit dans sa seconde version : « Le professeur me nomma le gaz ; j'ai oublié son nom. Mais je pourrais reconnaître les graines si on me les présentait. » Il ne peut pas être question de granulés de Zyklon ; le produit était d'un usage courant dans l'armée allemande pour la désinfection des locaux et Kramer, qui était commandant de camp, connaissait certainement ce produit. Le professeur Hirt était un éminent spécialiste des gaz et il n'est pas étonnant que sur le carnet de Volkmar on trouve son nom à côté de la mention de « Gas Blausäure » (gaz cyanhydrique), surtout si à la date en question on cherchait à construire à Natzweiler une chambre d'épouillage en circuit fermé à acide cyanhydrique. Il est stupéfiant que Kramer ait procédé lui-même à la manipulation du poison et qu'aucun des médecins du camp ne se soit trouvé à ses côtés. Il ne cite nommément comme complice que « Zeus » (texte français) ou « Zeuss » (texte allemand) ; il s'agissait en réalité de Wolfgang Seuss, lequel, après la guerre, sera interrogé par la justice française et, à l'exemple de ses camarades SS présents au Struthof, niera toute participation à un tel crime, y compris lorsqu'il se verra confronté avec le témoin Paul Weigel le 4 novembre 1949 (pièce 1806-V-16). Il est également curieux que Kramer n'ait à aucun moment rappelé que la prétendue « chambre à gaz » homicide du Struthof avait été effectivement une chambre à gaz... pour l'essai des masques à gaz par la troupe. Ce genre de local existe dans toutes les armées du monde et son caractère rudimentaire fait qu'il ne saurait être utilisé pour un gaz foudroyant aux effets redoutables pour son utilisateur [1]. Le professeur Bickenbach devait d'ailleurs profiter de l'existence de cette chambre à gaz pour y procéder d'abord sur sa propre personne, puis sur la personne de détenus « volontaires » à des essais sur l'urotropine comme préventif des effets du gaz phosgène. Le gouvernement allemand avait appris que, dès la fin de 1942, les Alliés entreposaient en Afrique du Nord de grandes quantités de gaz phosgène ; craignant que ce gaz ne serve à bombarder les populations allemandes, le gouvernement avait chargé le professeur Bickenbach de mener des recherches en ce domaine.

Bref, « la confession de Kramer » est digne en tous points des différents éléments qui ont contribué à forger la légende de la prétendue « chambre à gaz » homicide du Struthof. Je me permets de rappeler le caractère scandaleux du recueil photographique établi et commenté par le juge d'instruction militaire Jadin avec ses grattages sur photographies ou ses grattages de légendes (quand il ne s'agit tout bonnement pas de pages arrachées) et aussi avec ses commentaires marquant à la fois les préventions du commentateur et son incapacité à expliquer le fonctionnement d'une installation que d'entrée de jeu il baptise de « chambre à gaz » homicide. Je rappelle le caractère infantile et odieusement tendancieux du rapport dit d'expertise des DrsSimonin, Piedelièvre et Fourcade ; on s'y acharne mais sans succès à prouver que les cadavres trouvés à l'Institut d'Anatomie de Strasbourg sont ceux de détenus « gazés » au Struthof. Je rappelle l'absence dans les archives de la Justice militaire du rapport du professeur René Fabre établissant qu'il n'avait trouvé de trace d'acide cyanhydrique ni dans les cadavres, ni dans les produits de raclage de la « chambre à gaz » ou dans les plâtras (bocaux W et X). Je rappelle l'absence de toute expertise de la « chambre à gaz » par un homme de l'art. Je rappelle l'embarras croissant de l'Amicale des déportés et familles de disparus de Natzweiler-Struthof dont le président François Faure me déclarait en 1975 qu'il n'avait jamais visité cette « chambre à gaz » ; curieusement, cette « chambre à gaz » n'est aujourd'hui plus visitable dans la pratique. Je rappelle le silence total des autorités locales ou nationales que je saisissais par une lettre du 23 septembre 1976 de la supercherie que constituait cette « chambre à gaz ». Pour terminer, je ne laisserai la parole ni au colonel Rémy, qui ne croit pas à la « chambre à gaz », ni à M^e^ Floriot rappelant en 1954 au tribunal militaire de Lyon qu'il ne fallait pas confondre les « chambres à gaz » homicides d'Auschwitz avec le petit local du Struthof, mais à un incrédible témoin : le député RPR de Paris, Joël Le Tac. Dans France-Soir du 25 novembre 1978, ce dernier prétendait me donner la réplique en évoquant ses souvenirs des « gazages » homicides du Struthof. Quand on connaît, d'une part, la configuration de la pièce et du bâtiment où s'inscrit cette pièce et, d'autre part, la version officielle du « gazage » de quatre-vingt-sept juifs et juives, on admirera la fausseté du témoignage et ses fantastiques confusions ; on admirera aussi combien les Allemands s'y sont pris pour installer à son aise le témoin de leurs crimes et lui permettre de tout observer. Voici le texte de ce faux témoignage :

Cette nuit-là donc, une vingtaine de Tsiganes furent amenés. On les a fait monter dans des camions en même temps que des brancards roulés. Les camions se sont arrêtés à 2 kilomètres plus loin devant une sorte de blockhaus. Alors a eu lieu le tri : 5 par 5, à raison de deux vieux, un enfant et deux jeunes, les tziganes étaient choisis. On a constitué ainsi quatre groupes. Au premier groupe on a donné une ampoule de gaz qu'il devait briser à l'intérieur du blockhaus... Dès qu'ils furent entrés, les SS et les « spécialistes » se sont précipités pour regarder par un hublot ce qui se passait à l'intérieur du blockhaus. Après dix minutes, ils ont fait sortir les tziganes. Ils avaient le visage marqué mais aucun d'entre eux n'était mort. ― Après avoir ventilé le blockhaus on a fait rentrer le deuxième groupe mais cette fois avec deux ampoules de gaz. Mais là encore il n'y eut pas de mort. Le troisième essai fut le « bon ». Pour faire entrer les cinq nouveaux cobayes, les SS durent intervenir... mais cette fois personne n'en sortit vivant. Même chose pour le quatrième groupe. Quand le blockhaus fut ventilé, ce sont des cadavres que nous avons chargés avec les brancards dans les camions. Du sang coulait de leurs narines. ― Je pourrais raconter cette nuit pendant des heures... jusqu'à ce que le jour se lève, même à Faurisson, professeur de l'université française.

- Texte des « confessions » de Josef Kramer -

On trouvera ci-dessous le texte des « confessions » de Kramer. Je reproduis ce texte d'après les notes que j'ai prises, dans de mauvaises conditions, lorsque j'ai pu consulter les archives de la Justice militaire française. Je n'étais pas autorisé à faire de photocopies. Il se peut donc que j'aie commis des fautes malgré le soin que j'ai apporté à mon travail. J'ai tenté de reproduire toutes les fautes des textes originaux français. Je ne livre pas ici le texte allemand de la seconde « confession », mais sa traduction officielle. Je n'ai retenu de ces textes que ce qui concernait la « chambre à gaz » du Struthof. Bien que Kramer ait eu de hautes responsabilités à Auschwitz, il ne semble pas que la Justice militaire française l'ait interrogé là-dessus. Dans le livre d'A. R. Butz on trouvera le texte en anglais de deux dépositions (« statements ») successives de Kramer [2]. La comparaison des deux dépositions est instructive. La première déposition est longue, détaillée et ne paraît pas avoir été faite sous la contrainte ; Kramer n'y souffle pas mot de « gazages » au Struthof ; quant aux « gazages » d'Auschwitz, il en dit ceci :

Je suis au courant des allégations d'anciens prisonniers d'Auschwitz faisant mention de l'existence d'une chambre à gaz, d'exécutions et de corrections massives, de la cruauté des gardes, tout cela en ma présence ou à ma connaissance. Tout ce que je puis répondre à tout cela, c'est que c'est faux du début à la fin.
La seconde déposition de Kramer est brève et d'un tout autre ton quand il s'agit de Natzweiler-Struthof ou d'Auschwitz. Kramer fait allusion à sa déposition devant le commandant français Jadin ; il dit qu'il avait reçu l'ordre de gazer des femmes (il ne parle pas d'hommes et de femmes), que l'ordre de Berlin était signé de Glücks sur ordre de Himmler (ce qui vient totalement en contradiction avec l'affirmation de Rudolf Höss selon laquelle Himmler lui avait dit de tout cacher à ses supérieurs hiérarchiques en matière de « gazages »), que Hirt lui avait donné un récipient contenant des cristaux avec des instructions sur le mode d'emploi. Kramer ajoute qu'il n'y avait pas au Struthof de chambre à gaz spécifique (no regular gas chamber) mais que Hirt lui décrivit (sic) comment utiliser une pièce ordinaire (he described to me how an ordinary room might be used). Quant à Auschwitz, ce qu'en dit Kramer est tout à fait vague en matière de « chambres à gaz » et, pour commencer, il ne parle que d'une « chambre à gaz » à Auschwitz-Birkenau là où, selon la légende officielle, il y avait au moins quatre « chambres à gaz ».
Je reproduis ci-dessous la « confession obtenue » à Celle le 26 juillet 1945 par le commandant français Jadin et la « confession » obtenue à Lunebourg le 6 décembre 1945 par le capitaine français André. C'est ce que j'appelle la première et la seconde « confessions » de Kramer. J'ai repoussé à la fin ce que j'appelle « une autre "confession" de Kramer » ; en fait, cette courte déclaration se situe le même jour que la « confession » recueillie par Jadin et il est probable qu'elle lui est antérieure de quelques instants. Elle est manifestement hâtive (voyez l'orthographe de Nutzwiller, à deux reprises ; elle ne porte pas même la signature de Kramer ; elle situe les « gazages » en juillet 1943 alors que la vulgate exterminationniste place ces « gazages » en août 1943).

- Première « confession » de Josef Kramer -

(Celle, 26 juillet 1945)

Au cours du mois d'août 1943 j'ai reçu du camp d'Oranienburg ou plutôt du commandement suprême SS de Berlin qui m'a fait transmettre l'ordre par le Cdt. du camp d'Oranienburg, de recevoir environ 80 internés venant d'Auschwitz. Dans la lettre qui accompagnait [p. 3] cet ordre il m'était précisé d'avoir à me mettre en relation immédiatement avec le professeur Hirt de la Faculté de médecine de Strasbourg.

Je me suis rendu à l'Institut d'anatomie de Strasbourg où se trouvait Hirt. Ce dernier me déclara qu'il avait eu connaissance d'un convoi d'internés d'Auschwitz pour le Struthof. Il me précisa que ces personnes devaient être exécutées dans la chambre à gaz du Struthof à l'aide de gaz asphyxiants et que leurs cadavres devaient être conduits à l'Institut d'anatomie pour être mis à sa disposition.
A la suite de cette conversation il me remit un flacon de la contenance d'un quart de litre environ contenant des sels que je crois être des sels cyanhydriques. [Nous présentons à] [raturé].
Nous présentons au témoin le livre de Volkmar retrouvé au camp du Struthof et placé par Nous sous scellé no II.

Le témoin : Je reconnais parfaitement dans le livre que vous me représentez l'agenda qui était la propriété de Volkmar.
Ce livre est sténographié de sa main mais [deux mots illisibles raturés] dans une sténographie que je ne comprends pas. Je constate qu'il est marqué « gaz cyanhydrique ». [p. 4].
Le professeur m'indiqua la dose approximative que je devais employer pour asphyxier moi-même les internés venant d'Auschwitz dont je viens de vous parler.

Au début d'août 1943 je reçus donc les 80 internés destinés à être supprimés à l'aide des gaz qui m'avaient été remis par Hirt, et je commençais par faire conduire dans la chambre à gaz un certain soir, vers 9 heures, à l'aide d'une camionnette une première fois une quinzaine de femmes environ. Je déclarais à ces femmes qu'elles devaient passer dans la chambre à désinfection, et je leur cachais qu'elles devaient être asphyxiées. Assisté de quelques SS je les fis complètement déshabiller et je les poussais dans la chambre à gaz alors qu'elles étaient toutes nues.

Au moment où je fermais la porte elles se mirent à hurler. J'introduisis, après avoir fermé la porte, une certaine quantité de sel dans un entonnoir placé au dessous et à droite du regard. En même temps je versai une certaine quantité d'eau qui, ainsi que [p. 5] les sels, tombèrent dans l'excavation située à l'intérieur de la chambre à gaz au bas du regard. Puis je fermai l'orifice de l'entonnoir à l'aide d'un robinet qui était adapté dans le bas de cet entonnoir, prolongé lui-même par un tube en métal. Ce tube en métal conduisit le sel et l'eau dans l'excavation intérieure de la chambre dont je viens de vous parler. J'allumai l'intérieur de la chambre à l'aide du commutateur placé près de l'entonnoir et j'observai par le regard extérieur ce qui se passait à l'intérieur de la chambre.

Je constatai que ces femmes ont continué à respirer environ une demie minute puis elle tombèrent à terre. Lorsque j'ouvris la porte après avoir fait en même temps marcher la ventilation à l'intérieur de la cheminée d'aération je constatai que ces femmes étaient étendues sans vie et qu'elles avaient laissé échapper leurs matières fécales. J'ai chargé deux SS-infirmiers de transporter ces cadavres dans une camionnette le lendemain matin vers 5 heures 1/2 pour [p. 6] qu'ils soient conduits à l'Institut d'anatomie ainsi que le professeur Hirt me l'avait demandé.
Quelques jours après, dans les mêmes conditions sus-indiquées j'ai conduit à nouveau dans la chambre à gaz une certaine quantité de femmes qui furent asphyxiées [dans] [raturé] de la même façon, puis encore, quelques jours après, j'ai fait conduire dans la chambre à gaz en deux ou trois fois une cinquantaine d'hommes environ, peut-être cinquante-cinq, qui furent supprimés, toujours à l'aide des sels que je détenais de Hirt.

S. I. (Sur interrogation) : J'ignore ce que Hirt devait faire des cadavres de ces internés, assassinés sur ses indications au Struthof. Je n'ai pas cru devoir le lui demander.
S. I. : J'ignore à quelle nationalité appartenaient les internés que j'ai asphyxiés, je pense qu'ils provenaient du Sud-est de l'Europe sans toutefois pouvoir vous préciser le pays.

Nous présentons au témoin l'album de photographies dans lequel se trouvent les vues de la chambre à gaz. [p. 7]
Le témoin : Je reconnais en ces photographies la chambre à gaz du Struthof qui fut construite vers le milieu de 1943 à l'effet d'asphyxier les internés destinés au professeur Hirt.

S. I. : La chambre à gaz a été aménagée par les internés sur mon ordre. Elle avait été construite quelque temps auparavant pour servir de frigorifique [3].
S. I. : A ma connaissance, aucune ampoule de gaz asphyxiants n'aurait été jetée dans la chambre à gaz à l'effet d'asphyxier des internés. J'ignore à quoi était destiné le tuyau de fer situé dans la porte d'entrée de la chambre à gaz. [...] [p. 9]

S. I. : Hirt s'était rendu au Struthof peut-être deux fois et Hagen une fois pour visiter le camp.
Le professeur Bickenbach s'est rendu à plusieurs reprises au Struthof conférer avec le médecin du camp Krieger ou Blanke. J'ignore s'il a procédé à des expériences mais cependant, il me dit un jour qu'il avait reçu l'ordre de procéder à certaines expériences sur les internés sans me préciser à quelles expériences, et qu'en tout cas il était lié au secret par le commandement SS. [...] [p. 10]

S. I. : A ma connaissance les professeurs de Strasbourg ne se sont pas rendus dans la chambre à gaz. Je ne pense pas que des expériences sur des gaz aient été tentées par des médecins dans la chambre à gaz. Je n'ai pas eu connaissance que des ampoules contenant des gaz aient été jetées dans cette chambre pour tenter des expériences sur des internés.

Demande : Vous m'avez, tout à l'heure, parlé des conditions dans lesquelles vous aviez exécuté les internés à l'aide des gaz asphyxiants. Au cas où les internés [p. 11] n'auraient pas été tués à la suite de l'introduction des gaz, faite par vous, les auriez-vous achevés d'une balle ?

Réponse : J'aurais tenté de les asphyxier à nouveau en projetant dans la chambre une seconde dose de gaz. Je n'ai éprouvé aucune émotion en accomplissant ces actes car j'avais reçu l'ordre d'exécuter de la façon dont je vous ai indiqué les 80 internés. J'ai d'ailleurs été élevé comme cela (sic).
Lecture et interprétation faites, persiste et signe avec nous et notre greffier en approuvant la rature de cinq mots nuls.

HERTZOG, KRAMER, JADIN

Sur un bout de feuille rattaché avec un trombone au haut de la page 3 figure un erratum qui concerne les arrivées des femmes et des hommes. Kramer parlait d'« un premier transport de 26 femmes [...] », puis, d'« un deuxième transport [...] composé seulement d'hommes » ; il parlait enfin d'une arrivée « 2 ou 3 semaines après, un transport de 30 hommes [...] »
Or l'erratum était ainsi rédigé :

Erratum : Il n'y avait qu'un seul transport de 86 personnes, parmi elles 26 femmes et soixante hommes. Tous étaient Juifs. Dans un délai de 10 jours, tous étaient exécutés de la manière ci-dessus précisée.

- Seconde confession de Josef Kramer -

(Lunebourg, 6 décembre 1945)

Au milieu de 1943, je reçus de Berlin un ordre, par écrit, d'exécuter les gens qui avaient été envoyés d'Auschwitz, et de livrer les restes à l'Institut anatomique de l'hôpital municipal de Strasbourg.
Quant au mode d'exécution, j'ai été, selon l'ordre par écrit, obligé de me mettre en rapport avec le professeur d'anatomie Hirt. Je me rendis donc auprès de ce professeur et lui faisais part des ordres que j'avais reçus. Hirt me donna le conseil d'exécuter les gens par les gaz. Je lui répondis que, dans le camp, il n'y avait pas encore de chambres à gaz [4].

Hirt me donna alors une bouteille de verre fermée avec de la cire. Dedans il y avait un produit se constituant de petits corps blancs, semblables à de la soude. Hirt me déclara que, en y ajoutant de l'eau, j'obtiendrais un gaz toxique. Il me donnait aussi une indication exacte de la dose. Je lui disais que j'avais à ma disposition l'entrepreneur de bâtiments Untersturmführer Heider qui m'avait été envoyé d'Oranienburg.

Je faisais alors construire la chambre à gaz par des internés.
A quelque temps de là, arriva un premier transport de 26 femmes âgées de 20 à 50 ans. Elles demeurèrent 8 jours au camp. Pendant ce temps elles ne furent pas maltraitées et pas mieux nourries que les autres internés. Je n'avais pas quant à ces personnes des instructions spéciales. Après 8 jours d'attente, au milieu d'août 1943, je faisais conduire ces femmes, à 9 heures du soir à la chambre à gaz. Dans l'antichambre, elles furent déshabillées.
Je plaçais alors une poignée de produits dans le trou aménagé dans le plancher. Je faisais entrer les femmes dans la chambre à gaz et fermai la porte. Alors, les femmes commencèrent à pleurer et à crier. [p. 3] Dehors, je versais de l'eau dans l'entonnoir préparé. Cette eau coula par un tuyau muni d'une fermeture dans le trou où se trouvait les petits grains. Après une demi-minute, les cris cessèrent dans la chambre.

Je déclare que je n'ai pas, par la fenêtre, observé la mort. J'étais seulement aux écoutes. Comme il n'y avait plus rien à entendre et que plus rien ne se mouvait, j'ai mis le ventilateur en marche. Pendant ce temps, je me trouvais à l'extérieur et je n'ai ni respiré, ni senti le gaz. Après un quart d'heure, j'ai ouvert la porte. Il semblait que la mort s'était déroulée d'une façon normale. Seulement 3 ou 4 n'avaient pas pu tenir leur selle. Il était à peu près 9 heures 30.

Le matin suivant, à 5h 30, je faisais conduire les corps à Strasbourg dans un camion revêtu d'une bâche. Cette façon était choisie afin que personne ne puisse être tenu au courant de ce qui s'était passé. Car j'étais contraint au secret le plus strict. Je nie avoir abattu qui que ce soit, prisonniers ou internés. A cette exécution ont assisté 4 SS dont je connais le nom d'un seul, celui de Lagerführer Zeus. Le Stabscharführer Jung Hans n'y assistait pas. Je nie avoir tenu un discours.

Hirt n'était pas présent. Il vint en tout deux ou trois fois à Struthof, en visite personnelle, sans rapport avec l'exécution. A quelques temps de là, un deuxième transport arriva à Struthof, venant d'Auschwitz, composé seulement d'hommes. Huit jours après ils étaient exécutés de la même façon. 2 ou 3 semaines après, un transport de 30 hommes qui demeurèrent 10 Jours au camp furent également asphyxiés. Je nie qu'après l'exécution les SS aient but. C'était toujours les mêmes SS qui assistaient aux exécutions.

Le professeur me nomma le gaz ; j'ai oublié son nom. Mais je pourrais reconnaître les graines si on me les présentait. [...] [p. 6] Le professeur Hirt vint seulement deux ou trois fois dans le camp. Il ne demeurait jamais plus longtemps qu'une heure. Je connaissais les médecins du camp. Je ne sais pas s'ils étaient en correspondance avec eux. [...] Les 86 corps qui ont été fournis à l'hôpital municipal de Strasbourg étaient tous juifs. Je pouvais constater ce fait selon une liste nominative. Il s'agissait d'habitants du Sud-Est de l'Europe.

Lecture faite, persiste et signe
KRAMER
Capitaine ANDRÉ
Lieutenant HECKER
Sergent PAGE

- Une autre « confession » de Kramer -

[Le même jour que la première, peut-être antérieure à cette première.]
Je fais la déclaration suivante au lieutenant français Paul Heiker :

A la suite d'une ordonnance reçue de Berlin, je fis traiter par les gaz, en juillet 1943, au camps de Nutzweiler (Alsace) 30 femmes et 50 hommes (juifs de la région Est) âgés de 20 à 55 ans. Les cadavres furent conduits au « Bürgerspital » de Strasbourg.

Je déclare aussi qu'il existait une chambre à gaz au camp de Nutzweiler.

Celle le 26 juillet 1945

Josef Kramer

***

Etude parue dans Ecrits révisionnistes (1974-1998), vol. I, p. 247-259, datée octobre 1980.

_______________
Notes
[1] Sur l'emploi de cette chambre pour l'essai des masques, voyez, par exemple, les pièces 244, 2311 ou 2318. Dans la pièce 244, Adolf Becker, qui travaillait aux cuisines, à proximité de cette pièce, déclare : « Je n'ignorais pas qu'une chambre à gaz se trouvait située dans le magasin à vivres près de l'hôtel. C'est dans cette chambre que nous devions essayer nos masques. J'ignorais que des internés aient été exécutés dans ladite chambre, notamment qu'en août 1943 on avait asphyxié 80 internés. » Dans la pièce 2311, Herbert Dillmann déclare : « Je n'ignorais pas que dans le bâtiment BW 10 [il s'agit, d'après le dessin joint, de notre fameuse « chambre à gaz »] il y avait une salle où l'on essayait les masques à gaz. Je sais aussi que dans la suite, dans la même pièce, le DrBickenbach a fait des expériences. » Dans la pièce 2318, Adolf Becker répète : « Tous les SS ont dû une fois essayer nos masques à gaz dans cette chambre à gaz. » Dans une autre pièce du carton 12, Robert Nitsch parle également de Gasmaskenprobe. Dans la pièce 1371, Wolfgang Seuss (cité par Kramer) parle d'une chambre à gaz « installée près des bâtiments économiques» et il affirme catégoriquement : « Des juifs n'ont pas été asphyxiés à Natzweiler. »
[2] A. R. Butz, The Hoax of the Twentieth Century, Newport (Californie), Noontide Press, 1979, p. 264-277.
[3] NdA : le local plus tard devenu une chambre à gaz avait été, à l'origine, une chambre frigorifique. C'est sans doute pour punir Kramer d'avoir rappelé cette vérité que les Britanniques qui l'interrogeaient l'enfermèrent pendant toute une nuit dans une chambre frigorifique en mai 1945 (Dr J. L. Fréjapon, Bergen-Belsen, Paris, Librairie Valois, 1947, p. 22).

[4] La traduction est gravement fautive. Le tapuscrit rédigé en allemand par un Français en principe sous la dictée de Kramer, porte : « Ich antwortete, im Lager wäre weder eine Gaskammer noch Gaz [pour : Gas] vorhanden. » « Je répondis que dans le camp il n'y avait ni une chambre à gaz ni gaz. »

Labels: Bickenbach, Butz, chambre à gaz, François Faure, Jadin, Joël Le Tac, Josef Kramer, Paul André, Paul Heiker, professeur Hirt, René Fabre, Struthof-Natzweiler
