<!-- http://robertfaurisson.blogspot.com/1998/12/sur-la-preface-dalbert-paraz-au.html -->

<!-- Monday, December 7, 1998 -->

Avant-propos à la préface d'Albert Paraz au "Mensonge d'Ulysse" de Paul Rassinier (1950) *

[]

Relue à près d'un demi-siècle de distance, la préface qu'Albert Paraz a donnée en 1950 au Mensonge d'Ulysse, de Paul Rassinier, nous saisit par l'audace de la pensée et la liberté du ton.

Ni cette audace ni cette liberté ne sont plus aujourd'hui de mise. En 1972, la loi Pleven a proscrit la liberté du ton pour parler de certaines personnes et, en 1990, la loi Fabius-Gayssot a interdit qu'on pousse l'audace jusqu'à penser par soi-même sur certains points de l'histoire de la seconde guerre mondiale.

On voit par là que l'intolérable intolérance qui régnait à l'époque de la « Libération » et de l'« Epuration » permettait tout de même parfois une audace et une liberté qui, en 1998, ne sont plus tolérées le moins du monde.

Encore en 1950 on fusillait en France pour délit d'opinion. Le Parti communiste de Roger Garaudy régnait en maître dans le monde intellectuel. Communistes et Résistants paradaient, réclamant toujours plus de sang. D'abjects personnages du monde politique ou de la presse, à droite comme à gauche, s'érigeaient en censeurs et en procureurs. Pourtant, on pouvait encore se permettre quelques observations de bon sens ou quelques sarcasmes sur la version que les vainqueurs cherchaient alors à imposer de l'histoire de la guerre. Aujourd'hui, les vainqueurs sont parvenus à leurs fins. Dans l'une de ses parties les plus suspectes, celle portant sur les « crimes contre l'humanité » ― entendez : les crimes contre les juifs -, le jugement du Tribunal de Nuremberg ne peut plus aujourd'hui être contesté. Là, le bâillon est posé et bien posé. Sur le sujet du sort des juifs européens pendant la guerre et sur le problème des chambres à gaz, nos juges sont devenus intraitables. Des propos comme ceux que tient Paraz en la matière lui vaudraient de nos jours amendes, prison et pléthore de tribulations.

Aujourd'hui, Paraz aurait probablement le droit de répéter ses considérations sur Sartre, sur la Résistance et le Résistantialisme, sur la réunion de Caluire et même sur les kapos des camps de concentration. Mais sur les chambres à gaz, niet : l'oukase du 13 juillet 1990 est là ; les ligues de vertu montent bonne garde contre les révi­sionnistes : elles interviennent par l'attentat, le vitriolage, l'incendie criminel ou… par cette loi crapuleuse dont elles ont obtenu le vote.

Avec un flair comparable à celui de Céline, Paraz avait su, dès 1950, déceler en Jean-Paul Sartre l'une de ces fausses valeurs, à la Gide, à la Malraux, dont on imposait la lecture aux jeunes générations de l'époque. Faux résistant, vrai septembriseur, « le Ténia » ou « l'Agité du bocal » ― d'autres, en 1980, l'appelleront plus uniment « le Roi des cons » ― restera jusqu'au bout de sa vie un calamiteux professeur tout crotté de philosophie ; naïf, délateur, flagornant les puissants du jour jusqu'à les mettre dans l'embarras (voyez l'accueil reçu par ses Réflexions sur la question juive), toujours à prendre le vent de l'histoire et à n'assumer que des risques sans réelles conséquences sur sa vie, sa liberté personnelle ou son portefeuille, Sartre est devenu aujourd'hui illisible sinon pour un roman et quelques nouvelles où, personnellement, je lui trouve de la vigueur.

Sur le chapitre de la Résistance ou du Résistantialisme, en ces temps où des vieux et des vieilles font la tournée des écoles pour débiter aux potaches leurs souvenirs d'anciens (grands) résistants ou d'anciennes (grandes) résistantes, je suggérerais volontiers qu'on soumette à la réflexion des élèves ainsi mis en condition quelques « morceaux choisis d'Albert Paraz » sur le sujet et en particulier les deux courts extraits suivants qui, on le verra, illustrent une seule et même idée :

Poignarder une sentinelle et faire fusiller des otages, ça pour moi, c'est le comble (p. 50),

Tuer dans le dos et laisser fusiller des otages, pas besoin de génie pour faire comprendre aux enfants […] que c'est mal (p. 53).

Quant aux kapos de la Häftlingsführung, c'est-à-dire de l'encadrement constitué par des internés qui pouvaient être communistes ou juifs, Paraz et Rassinier ont vu si clair et le temps, sur ce point d'histoire, a tellement fait son office que leurs propos n'auraient aujourd'hui probablement plus rien de contestable, même pour un tribunal (voy. l'affaire Laurent Wetzel-Marcel Paul).

Mais venons-en au sujet le plus épineux : celui des chambres à gaz homicides dans certains camps de concentration allemands. A vrai dire, il s'agit là du point central à la fois du livre et de sa préface.

Comme le disait Céline, autre membre du « gang des basculeurs de légendes », abordons le sujet « avec d'infinies mitaines ».

Et, pour commencer, laissons encore une fois la parole à notre préfacier :

Après les oubliettes, Torquemada, les jésuites et les francs-maçons, le masque de fer, il est une autre histoire à laquelle il ne faut absolument pas toucher : c'est celle des cham­bres à gaz. La croûte terrestre en est à vif pour des siècles. J'ai failli me faire assassiner trois fois, hier, rien que pour avoir soumis le texte de Rassinier à des voisins, le tout en marchant à peu près à cent mètres de chez moi (p. 30).

Le 16 septembre 1989, « tout en marchant à peu près à cent mètres de chez moi », j'ai personnellement failli me faire assassiner par trois voyous juifs ; le rapport de police, lui, évoquera de « jeunes activistes juifs parisiens ». Tel un Palestinien, je subissais ce jour-là un traitement qui consiste à achever la victime à coups de pieds dans la tête. Un jeune homme survint, mit en fuite mes agresseurs et, le lendemain, apprenant mon nom, confessa à la police qu'il regrettait de m'avoir sauvé la vie.

Je ne cite cette anecdote que parce qu'elle ressemble d'assez près à celle que nous rapporte Paraz. Je pourrais tout aussi bien évoquer ici les neuf autres agressions qu'il m'a fallu subir de 1978 à 1993 ainsi que plusieurs dizaines d'attentats perpétrés contre d'autres révisionnistes qui, parfois, en ont été mutilés ou en ont perdu la vie. Comme le diraient Serge et Beate Klarsfeld, rien là que de « naturel » et de « normal » car il faut savoir éviter, n'est-ce pas, de susciter la colère de certains.

Par prudence, je m'abstiendrai de commenter d'autres passages de cette préface sur le sujet et, toutes affaires cessantes, je renverrai mon lecteur au Monde du 3 décembre 1998. Un Gérard Wacjman, « écrivain et psychanalyste », y signe un article où l'expression de « chambres à gaz » apparaît à neuf reprises. Certes, nous sommes loin du style de Paraz, de son alacrité, de sa naturelle verdeur, de sa finesse populaire ; chez ce Wacjman, la pensée est quelque peu obscure et le style alambiqué mais le fond se devine.

Dans cet article ténébreusement intitulé : « "Saint Paul" Godard contre "Moïse" Lanzmann ? » notre écrivain et psychanalyste s'en prend au cinéaste Jean-Luc Godard qu'il oppose à Claude Lanzmann, auteur du film Shoah. Le débat me semble inspiré par un défi que j'avais, en 1992, ainsi formulé : « Montrez-moi ou dessinez-moi une chambre à gaz nazie ! » Toujours est-il que J.-L. Godard est, par G. Wacjman, accusé d'avoir récemment déclaré :

Je pense que, si je m'y mettais avec un bon journaliste d'investigation, je trouverais des images des chambres à gaz au bout de vingt ans.

A quoi G. Wacjman répond, pour une fois clairement :

Sous ses dehors lisses et sans malice, cette idée empoisonne. Je ne l'aime pas. Pour tout dire, elle m'inquiète. Une phrase pas juste. ― Evidemment je ne discute pas la question de savoir s'il y a ou non des images des chambres à gaz. Je n'en sais rien.

Et, laborieusement, l'écrivain psychanalyste essaiera ensuite de nous faire com­prendre qu'il ne faut pas vouloir prouver l'existence des chambres à gaz. Qu'a-t-on besoin d'une image ? Au bout de cinquante ans on n'a rien trouvé, pas même « un petit bout de quelque chose » : la belle affaire ! Peu importe ! D'ailleurs, si l'on découvrait quelque indice que ce fût, qu'est-ce que cela prouverait ?

Les chambres à gaz ont existé. Je le sais. Pourtant, je ne les ai jamais vues. Je ne les ai pas vu fonctionner. J'ai vu des traces, j'ai vu des lieux, j'ai vu des images des crématoires ouverts, j'ai vu des reconstitutions des chambres à gaz, mais les hommes, les enfants, les femmes courant nus dans les couloirs, poussés dans les douches, mourant asphyxiés en grimpant les uns sur les autres, je ne les ai jamais vus. Pourtant, je sais que cela a eu lieu. Je le sais comme tout le monde le sait ― hors ceux qui ne veulent pas le savoir ― comme nous savons qu'il y a des milliards de galaxies dans un univers infini, sans les avoir jamais vues. ― Je sais que les chambres à gaz ont eu lieu [sic] parce qu'il y a des témoins, des preuves aussi. Pas d'images mais une infinité de paroles accumulées, privées ou publiques, des victimes ou des bourreaux.

La partie lisible de l'article se termine sur l'expression d'un atroce soupçon :

Si après vingt ans, vingt siècles de recherches, on constate qu'il n'y a décidément aucune image de ce qui doit forcément avoir une image, est-ce que cela ne suffit pas pour faire droit, raisonnablement, au soupçon qu'après tout cela pourrait bien ne pas avoir existé ?

Après cette pathétique interrogation, la suite de l'article de G. Wacjman devient incompréhensible.

Paraz, si clairvoyant, si pessimiste, si convaincu qu'il y en aurait « pour des siècles » avec cette « histoire » des chambres à gaz, eût-il imaginé que, quarante-huit ans après le jour de juin 1950 où il achevait sa préface, le brûlot lancé par Rassinier brûlerait encore de tous ses feux ?

Comme bien des pamphlétaires, Paraz, au fond, croyait en l'homme. Il préconisait la paix et même le pacifisme, la réconciliation européenne, la résistance à toutes les propagandes, aussi bien l'antiboche que l'antisoviétique. Il croyait en l'honnêteté possible et en l'indépendance possible de l'historien, allant jusqu'à écrire qu' « un groupe d'historiens doit être réuni d'urgence » pour connaître la vérité des faits et des chiffres : un groupe impartial sans Allemands, sans juifs et composé, par exemple, d'Hindous, de Chinois, de Noirs, de Japonais (p. 39).

Jusque dans ses derniers jours, on vit Paraz, malade à en mourir mais oublieux de soi-même, se porter au secours des véritables réprouvés de son temps : l'anarchiste ou libertaire Louis Lecoin, le socialiste Paul Rassinier, le fasciste (?) Maurice Bardèche et l'inclassable Louis-Ferdinand Céline.

Pour moi, tout au long de cette préface, c'est un cœur français que j'entends battre. Par sa générosité, son panache, son style, mais aussi par une certaine forme d'inconscience, Paraz le pacifiste y ressemble, comme un frère d'armes, au cavalier, au cuirassier Destouches qui, on le sait, partit d'un si bon pas pour son voyage au bout de la nuit.

7 décembre 1998

__________

* Editions Akribeia, Saint-Genis-Laval, 1999 [janvier], 71 p. ; la préface même occupe les p. 21-57 de l'opuscule ; elle est suivie de notes de l'éditeur [Jean Plantin]. Elle n'est parue que dans la première édition de l'ouvrage de P. Rassinier. Sur les raisons pour lesquelles P. Rassinier et A. Paraz ont été conduits à retirer cette préface, on lira l'avant-propos de P. Rassinier pour la deuxième et la troisième édition. A cette lecture il conviendra d'ajouter celle d'une introduction qui figure en tête de la quatrième édition dont l'achevé d'imprimer date du 25 mai 1955.

Attraits en justice, P. Rassinier, A. Paraz et l'éditeur ont d'abord été relaxés le 9 mai 1951 par le Tribunal correctionnel de Bourg-en-Bresse ; puis, en appel, la Cour de Lyon les a condamnés, le 2 novembre 1951, pour injures et diffamation à une légère peine d'emprisonnement avec sursis, à 100 000 F d'amende et à 800 000 F de dommages et intérêts tandis que la saisie et la destruction de tous les exemplaires du livre ont été ordonnées ; enfin, la Chambre criminelle de la Cour de cassation, en décembre 1954 a cassé l'arrêt de la Cour de Lyon. L'affaire a ensuite été jugée par la Cour d'appel de Grenoble qui, en mai 1955, a définitivement acquitté P. Rassinier, A. Paraz et l'éditeur.

Labels: Céline, Gérard Wacjman, J.-L. Godard, kapos, Lanzmann, Le Mensonge d'Ulysse, Le Monde, Paraz, Rassinier, Répression, résistance, Résistantialisme, Revisionism, Sartre, Wetzel-Marcel Paul
